/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchema;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperModelFactory;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.ItemConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardAnnotationMaps;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardBeanProperties;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@SdkInternalApi
final class StandardModelFactories {
    StandardModelFactories() {
    }

    static final DynamoDBMapperModelFactory.Factory of(ConversionSchema.Dependencies depends) {
        return new SchemaFactoryFactory(depends);
    }

    private static final class Converter<T, V>
    implements DynamoDBTypeConverter<AttributeValue, V> {
        private final ItemConverter converter;
        private final StandardBeanProperties.Bean<T, Object> bean;

        private Converter(StandardBeanProperties.Bean<T, Object> bean, ItemConverter converter) {
            this.converter = converter;
            this.bean = bean;
        }

        @Override
        public AttributeValue convert(V object) {
            return this.converter.convert(this.bean.getter(), object);
        }

        @Override
        public V unconvert(AttributeValue object) {
            return (V)this.converter.unconvert(this.bean.getter(), this.bean.setter(), object);
        }
    }

    private static final class SchemaFactory
    implements DynamoDBMapperModelFactory {
        private final ConcurrentMap<Class<?>, DynamoDBMapperTableModel<?>> cache = new ConcurrentHashMap();
        private final DynamoDBMapperConfig config;
        private final ItemConverter converter;

        private SchemaFactory(DynamoDBMapperModelFactory.Schema schema, DynamoDBMapperConfig config, ConversionSchema.Dependencies depends) {
            this.converter = config.getConversionSchema().getConverter(depends);
            this.config = config;
        }

        @Override
        public <T> DynamoDBMapperTableModel<T> getTableModel(Class<T> targetType) {
            if (!this.cache.containsKey(targetType)) {
                this.cache.putIfAbsent(targetType, this.newTableModel(targetType));
            }
            return (DynamoDBMapperTableModel)this.cache.get(targetType);
        }

        private <T> DynamoDBMapperTableModel<T> newTableModel(Class<T> targetType) {
            StandardAnnotationMaps.TableMap<T> annotations = StandardAnnotationMaps.of(targetType);
            DynamoDBMapperTableModel.Builder<T> builder = new DynamoDBMapperTableModel.Builder<T>(annotations);
            if (annotations.tableName() != null) {
                if (this.config.getTableNameResolver() == null) {
                    builder.withTableName(DynamoDBMapperConfig.DefaultTableNameResolver.INSTANCE.getTableName(targetType, this.config));
                } else {
                    builder.withTableName(this.config.getTableNameResolver().getTableName(targetType, this.config));
                }
            }
            Map beans = StandardBeanProperties.of(targetType);
            for (String name : beans.keySet()) {
                StandardBeanProperties.Bean bean = beans.get(name);
                DynamoDBMapperFieldModel.Builder field = new DynamoDBMapperFieldModel.Builder(bean.id(), bean.annotations());
                field.with(bean.reflect());
                try {
                    field.with(this.converter.getFieldModel(bean.getter()).getDynamoDBAttributeType());
                }
                catch (DynamoDBMappingException dynamoDBMappingException) {
                    // empty catch block
                }
                field.with(new Converter(bean, this.converter));
                builder.with(field.build());
            }
            return builder.build();
        }
    }

    private static final class SchemaFactoryFactory
    implements DynamoDBMapperModelFactory.Factory {
        private final ConcurrentMap<DynamoDBMapperModelFactory.Schema, DynamoDBMapperModelFactory> cache = new ConcurrentHashMap<DynamoDBMapperModelFactory.Schema, DynamoDBMapperModelFactory>();
        private final ConversionSchema.Dependencies depends;

        private SchemaFactoryFactory(ConversionSchema.Dependencies depends) {
            this.depends = depends;
        }

        @Override
        public DynamoDBMapperModelFactory getModelFactory(DynamoDBMapperConfig config) {
            DynamoDBMapperModelFactory.Schema schema = DynamoDBMapperModelFactory.Schema.of(config);
            if (schema == null) {
                return new SchemaFactory(schema, config, this.depends);
            }
            if (!this.cache.containsKey((Object)schema)) {
                this.cache.putIfAbsent(schema, new SchemaFactory(schema, config, this.depends));
            }
            return (DynamoDBMapperModelFactory)this.cache.get((Object)schema);
        }
    }
}

