/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lambda.model.FunctionConfiguration;
import java.util.List;

@SdkInternalApi
public class FunctionConfigurationMarshaller {
    private static final MarshallingInfo<String> FUNCTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionName").build();
    private static final MarshallingInfo<String> FUNCTIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionArn").build();
    private static final MarshallingInfo<String> RUNTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Runtime").build();
    private static final MarshallingInfo<String> ROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Role").build();
    private static final MarshallingInfo<String> HANDLER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Handler").build();
    private static final MarshallingInfo<Long> CODESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeSize").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<Integer> TIMEOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timeout").build();
    private static final MarshallingInfo<Integer> MEMORYSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MemorySize").build();
    private static final MarshallingInfo<String> LASTMODIFIED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModified").build();
    private static final MarshallingInfo<String> CODESHA256_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeSha256").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").build();
    private static final MarshallingInfo<StructuredPojo> VPCCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcConfig").build();
    private static final MarshallingInfo<StructuredPojo> DEADLETTERCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeadLetterConfig").build();
    private static final MarshallingInfo<StructuredPojo> ENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Environment").build();
    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KMSKeyArn").build();
    private static final MarshallingInfo<StructuredPojo> TRACINGCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TracingConfig").build();
    private static final MarshallingInfo<String> MASTERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MasterArn").build();
    private static final MarshallingInfo<String> REVISIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RevisionId").build();
    private static final MarshallingInfo<List> LAYERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Layers").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<String> STATEREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateReason").build();
    private static final MarshallingInfo<String> STATEREASONCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateReasonCode").build();
    private static final MarshallingInfo<String> LASTUPDATESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateStatus").build();
    private static final MarshallingInfo<String> LASTUPDATESTATUSREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateStatusReason").build();
    private static final MarshallingInfo<String> LASTUPDATESTATUSREASONCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateStatusReasonCode").build();
    private static final MarshallingInfo<List> FILESYSTEMCONFIGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileSystemConfigs").build();
    private static final MarshallingInfo<String> PACKAGETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PackageType").build();
    private static final MarshallingInfo<StructuredPojo> IMAGECONFIGRESPONSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageConfigResponse").build();
    private static final MarshallingInfo<String> SIGNINGPROFILEVERSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SigningProfileVersionArn").build();
    private static final MarshallingInfo<String> SIGNINGJOBARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SigningJobArn").build();
    private static final FunctionConfigurationMarshaller instance = new FunctionConfigurationMarshaller();

    public static FunctionConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(FunctionConfiguration functionConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (functionConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)functionConfiguration.getFunctionName(), FUNCTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getFunctionArn(), FUNCTIONARN_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getRuntime(), RUNTIME_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getRole(), ROLE_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getHandler(), HANDLER_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getCodeSize(), CODESIZE_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getTimeout(), TIMEOUT_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getMemorySize(), MEMORYSIZE_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getLastModified(), LASTMODIFIED_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getCodeSha256(), CODESHA256_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getVpcConfig(), VPCCONFIG_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getDeadLetterConfig(), DEADLETTERCONFIG_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getEnvironment(), ENVIRONMENT_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getKMSKeyArn(), KMSKEYARN_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getTracingConfig(), TRACINGCONFIG_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getMasterArn(), MASTERARN_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getRevisionId(), REVISIONID_BINDING);
            protocolMarshaller.marshall(functionConfiguration.getLayers(), LAYERS_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getStateReason(), STATEREASON_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getStateReasonCode(), STATEREASONCODE_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getLastUpdateStatus(), LASTUPDATESTATUS_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getLastUpdateStatusReason(), LASTUPDATESTATUSREASON_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getLastUpdateStatusReasonCode(), LASTUPDATESTATUSREASONCODE_BINDING);
            protocolMarshaller.marshall(functionConfiguration.getFileSystemConfigs(), FILESYSTEMCONFIGS_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getPackageType(), PACKAGETYPE_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getImageConfigResponse(), IMAGECONFIGRESPONSE_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getSigningProfileVersionArn(), SIGNINGPROFILEVERSIONARN_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.getSigningJobArn(), SIGNINGJOBARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

