/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mobile;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.mobile.AWSMobile;
import com.amazonaws.services.mobile.AWSMobileClientBuilder;
import com.amazonaws.services.mobile.model.AWSMobileException;
import com.amazonaws.services.mobile.model.CreateProjectRequest;
import com.amazonaws.services.mobile.model.CreateProjectResult;
import com.amazonaws.services.mobile.model.DeleteProjectRequest;
import com.amazonaws.services.mobile.model.DeleteProjectResult;
import com.amazonaws.services.mobile.model.DescribeBundleRequest;
import com.amazonaws.services.mobile.model.DescribeBundleResult;
import com.amazonaws.services.mobile.model.DescribeProjectRequest;
import com.amazonaws.services.mobile.model.DescribeProjectResult;
import com.amazonaws.services.mobile.model.ExportBundleRequest;
import com.amazonaws.services.mobile.model.ExportBundleResult;
import com.amazonaws.services.mobile.model.ExportProjectRequest;
import com.amazonaws.services.mobile.model.ExportProjectResult;
import com.amazonaws.services.mobile.model.ListBundlesRequest;
import com.amazonaws.services.mobile.model.ListBundlesResult;
import com.amazonaws.services.mobile.model.ListProjectsRequest;
import com.amazonaws.services.mobile.model.ListProjectsResult;
import com.amazonaws.services.mobile.model.UpdateProjectRequest;
import com.amazonaws.services.mobile.model.UpdateProjectResult;
import com.amazonaws.services.mobile.model.transform.AccountActionRequiredExceptionUnmarshaller;
import com.amazonaws.services.mobile.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.mobile.model.transform.CreateProjectRequestProtocolMarshaller;
import com.amazonaws.services.mobile.model.transform.CreateProjectResultJsonUnmarshaller;
import com.amazonaws.services.mobile.model.transform.DeleteProjectRequestProtocolMarshaller;
import com.amazonaws.services.mobile.model.transform.DeleteProjectResultJsonUnmarshaller;
import com.amazonaws.services.mobile.model.transform.DescribeBundleRequestProtocolMarshaller;
import com.amazonaws.services.mobile.model.transform.DescribeBundleResultJsonUnmarshaller;
import com.amazonaws.services.mobile.model.transform.DescribeProjectRequestProtocolMarshaller;
import com.amazonaws.services.mobile.model.transform.DescribeProjectResultJsonUnmarshaller;
import com.amazonaws.services.mobile.model.transform.ExportBundleRequestProtocolMarshaller;
import com.amazonaws.services.mobile.model.transform.ExportBundleResultJsonUnmarshaller;
import com.amazonaws.services.mobile.model.transform.ExportProjectRequestProtocolMarshaller;
import com.amazonaws.services.mobile.model.transform.ExportProjectResultJsonUnmarshaller;
import com.amazonaws.services.mobile.model.transform.InternalFailureExceptionUnmarshaller;
import com.amazonaws.services.mobile.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.mobile.model.transform.ListBundlesRequestProtocolMarshaller;
import com.amazonaws.services.mobile.model.transform.ListBundlesResultJsonUnmarshaller;
import com.amazonaws.services.mobile.model.transform.ListProjectsRequestProtocolMarshaller;
import com.amazonaws.services.mobile.model.transform.ListProjectsResultJsonUnmarshaller;
import com.amazonaws.services.mobile.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.mobile.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.mobile.model.transform.TooManyRequestsExceptionUnmarshaller;
import com.amazonaws.services.mobile.model.transform.UnauthorizedExceptionUnmarshaller;
import com.amazonaws.services.mobile.model.transform.UpdateProjectRequestProtocolMarshaller;
import com.amazonaws.services.mobile.model.transform.UpdateProjectResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSMobileClient
extends AmazonWebServiceClient
implements AWSMobile {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSMobile.class);
    private static final String DEFAULT_SIGNING_NAME = "AWSMobileHubService";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccountActionRequiredException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccountActionRequiredExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalFailureException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalFailureExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnauthorizedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TooManyRequestsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSMobileException.class));

    public static AWSMobileClientBuilder builder() {
        return AWSMobileClientBuilder.standard();
    }

    AWSMobileClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSMobileClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("mobile");
        this.setEndpoint("mobile.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/mobile/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/mobile/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateProjectResult createProject(CreateProjectRequest request) {
        request = (CreateProjectRequest)this.beforeClientExecution(request);
        return this.executeCreateProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateProjectResult executeCreateProject(CreateProjectRequest createProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateProjectRequestProtocolMarshaller(protocolFactory).marshall((CreateProjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)createProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Mobile");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateProject");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateProjectResult createProjectResult = (CreateProjectResult)response.getAwsResponse();
            return createProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteProjectResult deleteProject(DeleteProjectRequest request) {
        request = (DeleteProjectRequest)this.beforeClientExecution(request);
        return this.executeDeleteProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteProjectResult executeDeleteProject(DeleteProjectRequest deleteProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteProjectRequestProtocolMarshaller(protocolFactory).marshall((DeleteProjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Mobile");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteProject");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteProjectResult deleteProjectResult = (DeleteProjectResult)response.getAwsResponse();
            return deleteProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeBundleResult describeBundle(DescribeBundleRequest request) {
        request = (DescribeBundleRequest)this.beforeClientExecution(request);
        return this.executeDescribeBundle(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeBundleResult executeDescribeBundle(DescribeBundleRequest describeBundleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBundleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBundleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBundleRequestProtocolMarshaller(protocolFactory).marshall((DescribeBundleRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeBundleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Mobile");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeBundle");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeBundleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeBundleResult describeBundleResult = (DescribeBundleResult)response.getAwsResponse();
            return describeBundleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeProjectResult describeProject(DescribeProjectRequest request) {
        request = (DescribeProjectRequest)this.beforeClientExecution(request);
        return this.executeDescribeProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeProjectResult executeDescribeProject(DescribeProjectRequest describeProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeProjectRequestProtocolMarshaller(protocolFactory).marshall((DescribeProjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Mobile");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeProject");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeProjectResult describeProjectResult = (DescribeProjectResult)response.getAwsResponse();
            return describeProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExportBundleResult exportBundle(ExportBundleRequest request) {
        request = (ExportBundleRequest)this.beforeClientExecution(request);
        return this.executeExportBundle(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExportBundleResult executeExportBundle(ExportBundleRequest exportBundleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(exportBundleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExportBundleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExportBundleRequestProtocolMarshaller(protocolFactory).marshall((ExportBundleRequest)super.beforeMarshalling((AmazonWebServiceRequest)exportBundleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Mobile");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ExportBundle");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ExportBundleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExportBundleResult exportBundleResult = (ExportBundleResult)response.getAwsResponse();
            return exportBundleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExportProjectResult exportProject(ExportProjectRequest request) {
        request = (ExportProjectRequest)this.beforeClientExecution(request);
        return this.executeExportProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExportProjectResult executeExportProject(ExportProjectRequest exportProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(exportProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExportProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExportProjectRequestProtocolMarshaller(protocolFactory).marshall((ExportProjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)exportProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Mobile");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ExportProject");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ExportProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExportProjectResult exportProjectResult = (ExportProjectResult)response.getAwsResponse();
            return exportProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListBundlesResult listBundles(ListBundlesRequest request) {
        request = (ListBundlesRequest)this.beforeClientExecution(request);
        return this.executeListBundles(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListBundlesResult executeListBundles(ListBundlesRequest listBundlesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBundlesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBundlesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBundlesRequestProtocolMarshaller(protocolFactory).marshall((ListBundlesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listBundlesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Mobile");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListBundles");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListBundlesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListBundlesResult listBundlesResult = (ListBundlesResult)response.getAwsResponse();
            return listBundlesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListProjectsResult listProjects(ListProjectsRequest request) {
        request = (ListProjectsRequest)this.beforeClientExecution(request);
        return this.executeListProjects(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListProjectsResult executeListProjects(ListProjectsRequest listProjectsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProjectsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProjectsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProjectsRequestProtocolMarshaller(protocolFactory).marshall((ListProjectsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listProjectsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Mobile");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListProjects");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListProjectsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProjectsResult listProjectsResult = (ListProjectsResult)response.getAwsResponse();
            return listProjectsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateProjectResult updateProject(UpdateProjectRequest request) {
        request = (UpdateProjectRequest)this.beforeClientExecution(request);
        return this.executeUpdateProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateProjectResult executeUpdateProject(UpdateProjectRequest updateProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateProjectRequestProtocolMarshaller(protocolFactory).marshall((UpdateProjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Mobile");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateProject");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateProjectResult updateProjectResult = (UpdateProjectResult)response.getAwsResponse();
            return updateProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

