/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.ConfigDefaults;
import datadog.trace.api.IdGenerationStrategy;
import datadog.trace.api.Platform;
import datadog.trace.api.PropagationStyle;
import datadog.trace.api.WellKnownTags;
import datadog.trace.bootstrap.config.provider.CapturedEnvironmentConfigSource;
import datadog.trace.bootstrap.config.provider.ConfigProvider;
import datadog.trace.bootstrap.config.provider.SystemPropertiesConfigSource;
import datadog.trace.util.Strings;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

@Deprecated
public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static final String TRACE_AGENT_URL_TEMPLATE = "http://%s:%d";
    private static final String PROFILING_REMOTE_URL_TEMPLATE = "https://intake.profile.%s/v1/input";
    private static final String PROFILING_LOCAL_URL_TEMPLATE = "http://%s:%d/profiling/v1/input";
    private static final Pattern ENV_REPLACEMENT = Pattern.compile("[^a-zA-Z0-9_]");
    private static final String SPLIT_BY_SPACE_OR_COMMA_REGEX = "[,\\s]+";
    private final String runtimeId;
    private final String apiKey;
    private final String site;
    private final String serviceName;
    private final boolean serviceNameSetByUser;
    private final boolean traceEnabled;
    private final boolean integrationsEnabled;
    private final String writerType;
    private final boolean agentConfiguredUsingDefault;
    private final String agentUrl;
    private final String agentHost;
    private final int agentPort;
    private final String agentUnixDomainSocket;
    private final int agentTimeout;
    private final Set<String> noProxyHosts;
    private final boolean prioritySamplingEnabled;
    private final String prioritySamplingForce;
    private final boolean traceResolverEnabled;
    private final Map<String, String> serviceMapping;
    private final Map<String, String> tags;
    private final Map<String, String> spanTags;
    private final Map<String, String> jmxTags;
    private final List<String> excludedClasses;
    private final Map<String, String> headerTags;
    private final BitSet httpServerErrorStatuses;
    private final BitSet httpClientErrorStatuses;
    private final boolean httpServerTagQueryString;
    private final boolean httpClientTagQueryString;
    private final boolean httpClientSplitByDomain;
    private final boolean dbClientSplitByInstance;
    private final Set<String> splitByTags;
    private final int scopeDepthLimit;
    private final boolean scopeStrictMode;
    private final boolean scopeInheritAsyncPropagation;
    private final int partialFlushMinSpans;
    private final boolean traceStrictWritesEnabled;
    private final boolean runtimeContextFieldInjection;
    private final boolean serialVersionUIDFieldInjection;
    private final Set<PropagationStyle> propagationStylesToExtract;
    private final Set<PropagationStyle> propagationStylesToInject;
    private final boolean jmxFetchEnabled;
    private final String jmxFetchConfigDir;
    private final List<String> jmxFetchConfigs;
    @Deprecated
    private final List<String> jmxFetchMetricsConfigs;
    private final Integer jmxFetchCheckPeriod;
    private final Integer jmxFetchRefreshBeansPeriod;
    private final String jmxFetchStatsdHost;
    private final Integer jmxFetchStatsdPort;
    private final boolean healthMetricsEnabled;
    private final String healthMetricsStatsdHost;
    private final Integer healthMetricsStatsdPort;
    private final boolean perfMetricsEnabled;
    private final boolean tracerMetricsEnabled;
    private final boolean tracerMetricsBufferingEnabled;
    private final int tracerMetricsMaxAggregates;
    private final int tracerMetricsMaxPending;
    private final boolean logsInjectionEnabled;
    private final boolean logsMDCTagsInjectionEnabled;
    private final boolean reportHostName;
    private final String traceAnnotations;
    private final String traceMethods;
    private final boolean traceExecutorsAll;
    private final List<String> traceExecutors;
    private final boolean traceAnalyticsEnabled;
    private final Map<String, String> traceSamplingServiceRules;
    private final Map<String, String> traceSamplingOperationRules;
    private final Double traceSampleRate;
    private final int traceRateLimit;
    private final boolean profilingEnabled;
    private final boolean profilingAgentless;
    @Deprecated
    private final String profilingUrl;
    private final Map<String, String> profilingTags;
    private final int profilingStartDelay;
    private final boolean profilingStartForceFirst;
    private final int profilingUploadPeriod;
    private final String profilingTemplateOverrideFile;
    private final int profilingUploadTimeout;
    private final String profilingUploadCompression;
    private final String profilingProxyHost;
    private final int profilingProxyPort;
    private final String profilingProxyUsername;
    private final String profilingProxyPassword;
    private final int profilingExceptionSampleLimit;
    private final int profilingExceptionHistogramTopItems;
    private final int profilingExceptionHistogramMaxCollectionSize;
    private final boolean profilingExcludeAgentThreads;
    private final boolean kafkaClientPropagationEnabled;
    private final boolean kafkaClientBase64DecodingEnabled;
    private final boolean hystrixTagsEnabled;
    private final int osgiSearchDepth;
    private final boolean servletPrincipalEnabled;
    private final boolean servletAsyncTimeoutError;
    private final boolean tempJarsCleanOnBoot;
    private final boolean traceAgentV05Enabled;
    private final boolean debugEnabled;
    private final String configFile;
    private final IdGenerationStrategy idGenerationStrategy;
    private final boolean internalExitOnFailure;
    private final boolean resolverUseLoadClassEnabled;
    private final String jdbcPreparedStatementClassName;
    private final String jdbcConnectionClassName;
    private final Set<String> grpcIgnoredOutboundMethods;
    private String env;
    private String version;
    private final ConfigProvider configProvider;
    private static final String PREFIX = "dd.";
    @SuppressFBWarnings(value={"SI_INSTANCE_BEFORE_FINALS_ASSIGNED"})
    private static final Config INSTANCE = new Config();

    private Config() {
        this(INSTANCE != null ? Config.INSTANCE.runtimeId : UUID.randomUUID().toString(), ConfigProvider.createDefault());
    }

    private Config(String runtimeId, ConfigProvider configProvider) {
        boolean socketConfiguredUsingDefault;
        boolean agentHostConfiguredUsingDefault;
        this.configProvider = configProvider;
        this.configFile = Config.findConfigurationFile();
        this.runtimeId = runtimeId;
        String apiKeyFile = configProvider.getString("api-key-file");
        String tmpApiKey = configProvider.getStringExcludingSource("api-key", null, SystemPropertiesConfigSource.class, new String[0]);
        if (apiKeyFile != null) {
            try {
                tmpApiKey = new String(Files.readAllBytes(Paths.get(apiKeyFile, new String[0])), StandardCharsets.UTF_8).trim();
            }
            catch (IOException e) {
                log.error("Cannot read API key from file {}, skipping", (Object)apiKeyFile, (Object)e);
            }
        }
        this.site = configProvider.getString("site", "datadoghq.com", new String[0]);
        String userProvidedServiceName = configProvider.getStringExcludingSource("service", null, CapturedEnvironmentConfigSource.class, "service.name");
        if (userProvidedServiceName == null) {
            this.serviceNameSetByUser = false;
            this.serviceName = configProvider.getString("service", "unnamed-java-app", "service.name");
        } else {
            this.serviceNameSetByUser = true;
            this.serviceName = userProvidedServiceName;
        }
        this.traceEnabled = configProvider.getBoolean("trace.enabled", true, new String[0]);
        this.integrationsEnabled = configProvider.getBoolean("integrations.enabled", true, new String[0]);
        this.writerType = configProvider.getString("writer.type", "DDAgentWriter", new String[0]);
        this.idGenerationStrategy = configProvider.getEnum("id.generation.strategy", IdGenerationStrategy.class, IdGenerationStrategy.RANDOM);
        if (this.idGenerationStrategy != IdGenerationStrategy.RANDOM) {
            log.warn("*** you are using an unsupported id generation strategy {} - this can impact correctness of traces", (Object)this.idGenerationStrategy);
        }
        String agentHostFromEnvironment = null;
        int agentPortFromEnvironment = -1;
        String unixDomainFromEnvironment = null;
        boolean rebuildAgentUrl = false;
        String agentUrlFromEnvironment = configProvider.getString("trace.agent.url");
        if (agentUrlFromEnvironment != null) {
            try {
                URI parsedAgentUrl = new URI(agentUrlFromEnvironment);
                agentHostFromEnvironment = parsedAgentUrl.getHost();
                agentPortFromEnvironment = parsedAgentUrl.getPort();
                if ("unix".equals(parsedAgentUrl.getScheme())) {
                    unixDomainFromEnvironment = parsedAgentUrl.getPath();
                }
            }
            catch (URISyntaxException e) {
                log.warn("{} not configured correctly: {}. Ignoring", (Object)"trace.agent.url", (Object)e.getMessage());
            }
        }
        if (agentHostFromEnvironment == null) {
            agentHostFromEnvironment = configProvider.getString("agent.host");
            rebuildAgentUrl = true;
        }
        if (agentHostFromEnvironment == null) {
            this.agentHost = "localhost";
            agentHostConfiguredUsingDefault = true;
        } else {
            this.agentHost = agentHostFromEnvironment;
            agentHostConfiguredUsingDefault = false;
        }
        if (agentPortFromEnvironment < 0) {
            this.agentPort = configProvider.getInteger("trace.agent.port", 8126, "agent.port");
            rebuildAgentUrl = true;
        } else {
            this.agentPort = agentPortFromEnvironment;
        }
        this.agentUrl = rebuildAgentUrl ? String.format(TRACE_AGENT_URL_TEMPLATE, this.agentHost, this.agentPort) : agentUrlFromEnvironment;
        if (unixDomainFromEnvironment == null) {
            unixDomainFromEnvironment = configProvider.getString("trace.agent.unix.domain.socket");
        }
        if (unixDomainFromEnvironment == null) {
            this.agentUnixDomainSocket = ConfigDefaults.DEFAULT_AGENT_UNIX_DOMAIN_SOCKET;
            socketConfiguredUsingDefault = true;
        } else {
            this.agentUnixDomainSocket = unixDomainFromEnvironment;
            socketConfiguredUsingDefault = false;
        }
        this.agentConfiguredUsingDefault = agentHostConfiguredUsingDefault && socketConfiguredUsingDefault && this.agentPort == 8126;
        this.agentTimeout = configProvider.getInteger("trace.agent.timeout", 10, new String[0]);
        this.noProxyHosts = new HashSet<String>(configProvider.getSpacedList("proxy.no_proxy"));
        this.prioritySamplingEnabled = configProvider.getBoolean("priority.sampling", true, new String[0]);
        this.prioritySamplingForce = configProvider.getString("priority.sampling.force", ConfigDefaults.DEFAULT_PRIORITY_SAMPLING_FORCE, new String[0]);
        this.traceResolverEnabled = configProvider.getBoolean("trace.resolver.enabled", true, new String[0]);
        this.serviceMapping = configProvider.getMergedMap("service.mapping");
        HashMap<String, String> tags = new HashMap<String, String>(configProvider.getMergedMap("trace.global.tags"));
        tags.putAll(configProvider.getMergedMap("tags"));
        this.tags = this.getMapWithPropertiesDefinedByEnvironment(tags, "env", "version");
        this.spanTags = configProvider.getMergedMap("trace.span.tags");
        this.jmxTags = configProvider.getMergedMap("trace.jmx.tags");
        this.excludedClasses = configProvider.getList("trace.classes.exclude");
        this.headerTags = configProvider.getMergedMap("trace.header.tags");
        this.httpServerErrorStatuses = configProvider.getIntegerRange("http.server.error.statuses", ConfigDefaults.DEFAULT_HTTP_SERVER_ERROR_STATUSES);
        this.httpClientErrorStatuses = configProvider.getIntegerRange("http.client.error.statuses", ConfigDefaults.DEFAULT_HTTP_CLIENT_ERROR_STATUSES);
        this.httpServerTagQueryString = configProvider.getBoolean("http.server.tag.query-string", false, new String[0]);
        this.httpClientTagQueryString = configProvider.getBoolean("http.client.tag.query-string", false, new String[0]);
        this.httpClientSplitByDomain = configProvider.getBoolean("trace.http.client.split-by-domain", false, new String[0]);
        this.dbClientSplitByInstance = configProvider.getBoolean("trace.db.client.split-by-instance", false, new String[0]);
        this.splitByTags = Collections.unmodifiableSet(new LinkedHashSet<String>(configProvider.getList("trace.split-by-tags")));
        this.scopeDepthLimit = configProvider.getInteger("trace.scope.depth.limit", 100, new String[0]);
        this.scopeStrictMode = configProvider.getBoolean("trace.scope.strict.mode", false, new String[0]);
        this.scopeInheritAsyncPropagation = configProvider.getBoolean("trace.scope.inherit.async.propagation", true, new String[0]);
        this.partialFlushMinSpans = configProvider.getInteger("trace.partial.flush.min.spans", 1000, new String[0]);
        this.traceStrictWritesEnabled = configProvider.getBoolean("trace.strict.writes.enabled", false, new String[0]);
        this.runtimeContextFieldInjection = configProvider.getBoolean("trace.runtime.context.field.injection", true, new String[0]);
        this.serialVersionUIDFieldInjection = configProvider.getBoolean("trace.serialversionuid.field.injection", true, new String[0]);
        this.propagationStylesToExtract = this.getPropagationStyleSetSettingFromEnvironmentOrDefault("propagation.style.extract", ConfigDefaults.DEFAULT_PROPAGATION_STYLE_EXTRACT);
        this.propagationStylesToInject = this.getPropagationStyleSetSettingFromEnvironmentOrDefault("propagation.style.inject", ConfigDefaults.DEFAULT_PROPAGATION_STYLE_INJECT);
        boolean runtimeMetricsEnabled = configProvider.getBoolean("runtime.metrics.enabled", true, new String[0]);
        this.jmxFetchEnabled = runtimeMetricsEnabled && configProvider.getBoolean("jmxfetch.enabled", true, new String[0]);
        this.jmxFetchConfigDir = configProvider.getString("jmxfetch.config.dir");
        this.jmxFetchConfigs = configProvider.getList("jmxfetch.config");
        this.jmxFetchMetricsConfigs = configProvider.getList("jmxfetch.metrics-configs");
        this.jmxFetchCheckPeriod = configProvider.getInteger("jmxfetch.check-period");
        this.jmxFetchRefreshBeansPeriod = configProvider.getInteger("jmxfetch.refresh-beans-period");
        this.jmxFetchStatsdHost = configProvider.getString("jmxfetch.statsd.host");
        this.jmxFetchStatsdPort = configProvider.getInteger("jmxfetch.statsd.port", 8125, new String[0]);
        this.healthMetricsEnabled = runtimeMetricsEnabled && configProvider.getBoolean("trace.health.metrics.enabled", true, new String[0]);
        this.healthMetricsStatsdHost = configProvider.getString("trace.health.metrics.statsd.host");
        this.healthMetricsStatsdPort = configProvider.getInteger("trace.health.metrics.statsd.port");
        this.perfMetricsEnabled = runtimeMetricsEnabled && Platform.isJavaVersionAtLeast(8) && configProvider.getBoolean("trace.perf.metrics.enabled", false, new String[0]);
        this.tracerMetricsEnabled = Platform.isJavaVersionAtLeast(8) && configProvider.getBoolean("trace.tracer.metrics.enabled", false, new String[0]);
        this.tracerMetricsBufferingEnabled = configProvider.getBoolean("trace.tracer.metrics.buffering.enabled", false, new String[0]);
        this.tracerMetricsMaxAggregates = configProvider.getInteger("trace.tracer.metrics.max.aggregates", 2048, new String[0]);
        this.tracerMetricsMaxPending = configProvider.getInteger("trace.tracer.metrics.max.pending", 2048, new String[0]);
        this.logsInjectionEnabled = configProvider.getBoolean("logs.injection", true, new String[0]);
        this.logsMDCTagsInjectionEnabled = configProvider.getBoolean("logs.mdc.tags.injection", true, new String[0]);
        this.reportHostName = configProvider.getBoolean("trace.report-hostname", false, new String[0]);
        this.traceAgentV05Enabled = configProvider.getBoolean("trace.agent.v0.5.enabled", false, new String[0]);
        this.traceAnnotations = configProvider.getString("trace.annotations", ConfigDefaults.DEFAULT_TRACE_ANNOTATIONS, new String[0]);
        this.traceMethods = configProvider.getString("trace.methods", ConfigDefaults.DEFAULT_TRACE_METHODS, new String[0]);
        this.traceExecutorsAll = configProvider.getBoolean("trace.executors.all", false, new String[0]);
        this.traceExecutors = configProvider.getList("trace.executors");
        this.traceAnalyticsEnabled = configProvider.getBoolean("trace.analytics.enabled", false, new String[0]);
        this.traceSamplingServiceRules = configProvider.getMergedMap("trace.sampling.service.rules");
        this.traceSamplingOperationRules = configProvider.getMergedMap("trace.sampling.operation.rules");
        this.traceSampleRate = configProvider.getDouble("trace.sample.rate");
        this.traceRateLimit = configProvider.getInteger("trace.rate.limit", 100, new String[0]);
        this.profilingEnabled = configProvider.getBoolean("profiling.enabled", false, new String[0]);
        this.profilingAgentless = configProvider.getBoolean("profiling.agentless", false, new String[0]);
        this.profilingUrl = configProvider.getString("profiling.url");
        if (tmpApiKey == null) {
            String oldProfilingApiKeyFile = configProvider.getString("profiling.api-key-file");
            tmpApiKey = System.getenv(Config.propertyNameToEnvironmentVariableName("profiling.api-key"));
            if (oldProfilingApiKeyFile != null) {
                try {
                    tmpApiKey = new String(Files.readAllBytes(Paths.get(oldProfilingApiKeyFile, new String[0])), StandardCharsets.UTF_8).trim();
                }
                catch (IOException e) {
                    log.error("Cannot read API key from file {}, skipping", (Object)oldProfilingApiKeyFile, (Object)e);
                }
            }
        }
        if (tmpApiKey == null) {
            String veryOldProfilingApiKeyFile = configProvider.getString("profiling.apikey.file");
            tmpApiKey = System.getenv(Config.propertyNameToEnvironmentVariableName("profiling.apikey"));
            if (veryOldProfilingApiKeyFile != null) {
                try {
                    tmpApiKey = new String(Files.readAllBytes(Paths.get(veryOldProfilingApiKeyFile, new String[0])), StandardCharsets.UTF_8).trim();
                }
                catch (IOException e) {
                    log.error("Cannot read API key from file {}, skipping", (Object)veryOldProfilingApiKeyFile, (Object)e);
                }
            }
        }
        this.profilingTags = configProvider.getMergedMap("profiling.tags");
        this.profilingStartDelay = configProvider.getInteger("profiling.start-delay", 10, new String[0]);
        this.profilingStartForceFirst = configProvider.getBoolean("profiling.experimental.start-force-first", false, new String[0]);
        this.profilingUploadPeriod = configProvider.getInteger("profiling.upload.period", 60, new String[0]);
        this.profilingTemplateOverrideFile = configProvider.getString("profiling.jfr-template-override-file");
        this.profilingUploadTimeout = configProvider.getInteger("profiling.upload.timeout", 30, new String[0]);
        this.profilingUploadCompression = configProvider.getString("profiling.upload.compression", "on", new String[0]);
        this.profilingProxyHost = configProvider.getString("profiling.proxy.host");
        this.profilingProxyPort = configProvider.getInteger("profiling.proxy.port", 8080, new String[0]);
        this.profilingProxyUsername = configProvider.getString("profiling.proxy.username");
        this.profilingProxyPassword = configProvider.getString("profiling.proxy.password");
        this.profilingExceptionSampleLimit = configProvider.getInteger("profiling.exception.sample.limit", 10000, new String[0]);
        this.profilingExceptionHistogramTopItems = configProvider.getInteger("profiling.exception.histogram.top-items", 50, new String[0]);
        this.profilingExceptionHistogramMaxCollectionSize = configProvider.getInteger("profiling.exception.histogram.max-collection-size", 10000, new String[0]);
        this.profilingExcludeAgentThreads = configProvider.getBoolean("profiling.exclude.agent-threads", true, new String[0]);
        this.jdbcPreparedStatementClassName = configProvider.getString("trace.jdbc.prepared.statement.class.name", "", new String[0]);
        this.jdbcConnectionClassName = configProvider.getString("trace.jdbc.connection.class.name", "", new String[0]);
        this.kafkaClientPropagationEnabled = configProvider.getBoolean("kafka.client.propagation.enabled", true, new String[0]);
        this.kafkaClientBase64DecodingEnabled = configProvider.getBoolean("kafka.client.base64.decoding.enabled", false, new String[0]);
        this.grpcIgnoredOutboundMethods = new HashSet<String>(configProvider.getList("trace.grpc.ignored.outbound.methods"));
        this.hystrixTagsEnabled = configProvider.getBoolean("hystrix.tags.enabled", false, new String[0]);
        this.osgiSearchDepth = configProvider.getInteger("osgi.search.depth", 1, new String[0]);
        this.servletPrincipalEnabled = configProvider.getBoolean("trace.servlet.principal.enabled", false, new String[0]);
        this.servletAsyncTimeoutError = configProvider.getBoolean("trace.servlet.async-timeout.error", true, new String[0]);
        this.tempJarsCleanOnBoot = configProvider.getBoolean("temp.jars.clean.on.boot", false, new String[0]) && Config.isWindowsOS();
        this.debugEnabled = Config.isDebugMode();
        this.internalExitOnFailure = configProvider.getBoolean("trace.internal.exit.on.failure", false, new String[0]);
        this.resolverUseLoadClassEnabled = configProvider.getBoolean("resolver.use.loadclass", true, new String[0]);
        this.apiKey = tmpApiKey;
        if (this.profilingAgentless && this.apiKey == null) {
            log.warn("Agentless profiling activated but no api key provided. Profile uploading will likely fail");
        }
        log.debug("New instance: {}", (Object)this);
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getSite() {
        return this.site;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isServiceNameSetByUser() {
        return this.serviceNameSetByUser;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public boolean isIntegrationsEnabled() {
        return this.integrationsEnabled;
    }

    public String getWriterType() {
        return this.writerType;
    }

    public boolean isAgentConfiguredUsingDefault() {
        return this.agentConfiguredUsingDefault;
    }

    public String getAgentUrl() {
        return this.agentUrl;
    }

    public String getAgentHost() {
        return this.agentHost;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public String getAgentUnixDomainSocket() {
        return this.agentUnixDomainSocket;
    }

    public int getAgentTimeout() {
        return this.agentTimeout;
    }

    public Set<String> getNoProxyHosts() {
        return this.noProxyHosts;
    }

    public boolean isPrioritySamplingEnabled() {
        return this.prioritySamplingEnabled;
    }

    public String getPrioritySamplingForce() {
        return this.prioritySamplingForce;
    }

    public boolean isTraceResolverEnabled() {
        return this.traceResolverEnabled;
    }

    public Map<String, String> getServiceMapping() {
        return this.serviceMapping;
    }

    public List<String> getExcludedClasses() {
        return this.excludedClasses;
    }

    public Map<String, String> getHeaderTags() {
        return this.headerTags;
    }

    public BitSet getHttpServerErrorStatuses() {
        return this.httpServerErrorStatuses;
    }

    public BitSet getHttpClientErrorStatuses() {
        return this.httpClientErrorStatuses;
    }

    public boolean isHttpServerTagQueryString() {
        return this.httpServerTagQueryString;
    }

    public boolean isHttpClientTagQueryString() {
        return this.httpClientTagQueryString;
    }

    public boolean isHttpClientSplitByDomain() {
        return this.httpClientSplitByDomain;
    }

    public boolean isDbClientSplitByInstance() {
        return this.dbClientSplitByInstance;
    }

    public Set<String> getSplitByTags() {
        return this.splitByTags;
    }

    public int getScopeDepthLimit() {
        return this.scopeDepthLimit;
    }

    public boolean isScopeStrictMode() {
        return this.scopeStrictMode;
    }

    public boolean isScopeInheritAsyncPropagation() {
        return this.scopeInheritAsyncPropagation;
    }

    public int getPartialFlushMinSpans() {
        return this.partialFlushMinSpans;
    }

    public boolean isTraceStrictWritesEnabled() {
        return this.traceStrictWritesEnabled;
    }

    public boolean isRuntimeContextFieldInjection() {
        return this.runtimeContextFieldInjection;
    }

    public boolean isSerialVersionUIDFieldInjection() {
        return this.serialVersionUIDFieldInjection;
    }

    public Set<PropagationStyle> getPropagationStylesToExtract() {
        return this.propagationStylesToExtract;
    }

    public Set<PropagationStyle> getPropagationStylesToInject() {
        return this.propagationStylesToInject;
    }

    public boolean isJmxFetchEnabled() {
        return this.jmxFetchEnabled;
    }

    public String getJmxFetchConfigDir() {
        return this.jmxFetchConfigDir;
    }

    public List<String> getJmxFetchConfigs() {
        return this.jmxFetchConfigs;
    }

    public List<String> getJmxFetchMetricsConfigs() {
        return this.jmxFetchMetricsConfigs;
    }

    public Integer getJmxFetchCheckPeriod() {
        return this.jmxFetchCheckPeriod;
    }

    public Integer getJmxFetchRefreshBeansPeriod() {
        return this.jmxFetchRefreshBeansPeriod;
    }

    public String getJmxFetchStatsdHost() {
        return this.jmxFetchStatsdHost;
    }

    public Integer getJmxFetchStatsdPort() {
        return this.jmxFetchStatsdPort;
    }

    public boolean isHealthMetricsEnabled() {
        return this.healthMetricsEnabled;
    }

    public String getHealthMetricsStatsdHost() {
        return this.healthMetricsStatsdHost;
    }

    public Integer getHealthMetricsStatsdPort() {
        return this.healthMetricsStatsdPort;
    }

    public boolean isPerfMetricsEnabled() {
        return this.perfMetricsEnabled;
    }

    public boolean isTracerMetricsEnabled() {
        return this.tracerMetricsEnabled;
    }

    public boolean isTracerMetricsBufferingEnabled() {
        return this.tracerMetricsBufferingEnabled;
    }

    public int getTracerMetricsMaxAggregates() {
        return this.tracerMetricsMaxAggregates;
    }

    public int getTracerMetricsMaxPending() {
        return this.tracerMetricsMaxPending;
    }

    public boolean isLogsInjectionEnabled() {
        return this.logsInjectionEnabled;
    }

    public boolean isLogsMDCTagsInjectionEnabled() {
        return this.logsMDCTagsInjectionEnabled;
    }

    public boolean isReportHostName() {
        return this.reportHostName;
    }

    public String getTraceAnnotations() {
        return this.traceAnnotations;
    }

    public String getTraceMethods() {
        return this.traceMethods;
    }

    public boolean isTraceExecutorsAll() {
        return this.traceExecutorsAll;
    }

    public List<String> getTraceExecutors() {
        return this.traceExecutors;
    }

    public boolean isTraceAnalyticsEnabled() {
        return this.traceAnalyticsEnabled;
    }

    public Map<String, String> getTraceSamplingServiceRules() {
        return this.traceSamplingServiceRules;
    }

    public Map<String, String> getTraceSamplingOperationRules() {
        return this.traceSamplingOperationRules;
    }

    public Double getTraceSampleRate() {
        return this.traceSampleRate;
    }

    public int getTraceRateLimit() {
        return this.traceRateLimit;
    }

    public boolean isProfilingEnabled() {
        return this.profilingEnabled;
    }

    public boolean isProfilingAgentless() {
        return this.profilingAgentless;
    }

    public int getProfilingStartDelay() {
        return this.profilingStartDelay;
    }

    public boolean isProfilingStartForceFirst() {
        return this.profilingStartForceFirst;
    }

    public int getProfilingUploadPeriod() {
        return this.profilingUploadPeriod;
    }

    public String getProfilingTemplateOverrideFile() {
        return this.profilingTemplateOverrideFile;
    }

    public int getProfilingUploadTimeout() {
        return this.profilingUploadTimeout;
    }

    public String getProfilingUploadCompression() {
        return this.profilingUploadCompression;
    }

    public String getProfilingProxyHost() {
        return this.profilingProxyHost;
    }

    public int getProfilingProxyPort() {
        return this.profilingProxyPort;
    }

    public String getProfilingProxyUsername() {
        return this.profilingProxyUsername;
    }

    public String getProfilingProxyPassword() {
        return this.profilingProxyPassword;
    }

    public int getProfilingExceptionSampleLimit() {
        return this.profilingExceptionSampleLimit;
    }

    public int getProfilingExceptionHistogramTopItems() {
        return this.profilingExceptionHistogramTopItems;
    }

    public int getProfilingExceptionHistogramMaxCollectionSize() {
        return this.profilingExceptionHistogramMaxCollectionSize;
    }

    public boolean isProfilingExcludeAgentThreads() {
        return this.profilingExcludeAgentThreads;
    }

    public boolean isKafkaClientPropagationEnabled() {
        return this.kafkaClientPropagationEnabled;
    }

    public boolean isKafkaClientBase64DecodingEnabled() {
        return this.kafkaClientBase64DecodingEnabled;
    }

    public boolean isHystrixTagsEnabled() {
        return this.hystrixTagsEnabled;
    }

    public int getOsgiSearchDepth() {
        return this.osgiSearchDepth;
    }

    public boolean isServletPrincipalEnabled() {
        return this.servletPrincipalEnabled;
    }

    public boolean isServletAsyncTimeoutError() {
        return this.servletAsyncTimeoutError;
    }

    public boolean isTempJarsCleanOnBoot() {
        return this.tempJarsCleanOnBoot;
    }

    public boolean isTraceAgentV05Enabled() {
        return this.traceAgentV05Enabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public IdGenerationStrategy getIdGenerationStrategy() {
        return this.idGenerationStrategy;
    }

    public boolean isInternalExitOnFailure() {
        return this.internalExitOnFailure;
    }

    public boolean isResolverUseLoadClassEnabled() {
        return this.resolverUseLoadClassEnabled;
    }

    public String getJdbcPreparedStatementClassName() {
        return this.jdbcPreparedStatementClassName;
    }

    public String getJdbcConnectionClassName() {
        return this.jdbcConnectionClassName;
    }

    public Set<String> getGrpcIgnoredOutboundMethods() {
        return this.grpcIgnoredOutboundMethods;
    }

    public Map<String, String> getLocalRootSpanTags() {
        String hostName;
        Map<String, String> runtimeTags = this.getRuntimeTags();
        HashMap<String, String> result = new HashMap<String, String>(runtimeTags);
        result.put("language", "jvm");
        if (this.reportHostName && null != (hostName = Config.getHostName()) && !hostName.isEmpty()) {
            result.put("_dd.hostname", hostName);
        }
        return Collections.unmodifiableMap(result);
    }

    public WellKnownTags getWellKnownTags() {
        return new WellKnownTags(Config.getHostName(), this.getEnv(), this.serviceName, this.getVersion());
    }

    public String getEnv() {
        if (this.env == null) {
            this.env = this.getMergedSpanTags().get("env");
            if (this.env == null) {
                this.env = "";
            }
        }
        return this.env;
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = this.getMergedSpanTags().get("version");
            if (this.version == null) {
                this.version = "";
            }
        }
        return this.version;
    }

    public Map<String, String> getMergedSpanTags() {
        Map<String, String> result = Config.newHashMap(this.getGlobalTags().size() + this.spanTags.size());
        result.putAll(this.getGlobalTags());
        result.putAll(this.spanTags);
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getMergedJmxTags() {
        Map<String, String> runtimeTags = this.getRuntimeTags();
        Map<String, String> result = Config.newHashMap(this.getGlobalTags().size() + this.jmxTags.size() + runtimeTags.size() + 1);
        result.putAll(this.getGlobalTags());
        result.putAll(this.jmxTags);
        result.putAll(runtimeTags);
        result.put("service", this.serviceName);
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getMergedProfilingTags() {
        Map<String, String> runtimeTags = this.getRuntimeTags();
        String host = Config.getHostName();
        Map<String, String> result = Config.newHashMap(this.getGlobalTags().size() + this.profilingTags.size() + runtimeTags.size() + 3);
        result.put("host", host);
        result.putAll(this.getGlobalTags());
        result.putAll(this.profilingTags);
        result.putAll(runtimeTags);
        result.put("service", this.serviceName);
        result.put("language", "jvm");
        return Collections.unmodifiableMap(result);
    }

    public float getInstrumentationAnalyticsSampleRate(String ... aliases) {
        for (String alias : aliases) {
            String configKey = alias + ".analytics.sample-rate";
            Float rate = this.configProvider.getFloat("trace." + configKey, configKey);
            if (null == rate) continue;
            return rate.floatValue();
        }
        return 1.0f;
    }

    private Map<String, String> getGlobalTags() {
        return this.tags;
    }

    private Map<String, String> getRuntimeTags() {
        Map<String, String> result = Config.newHashMap(2);
        result.put("runtime-id", this.runtimeId);
        return Collections.unmodifiableMap(result);
    }

    public String getFinalProfilingUrl() {
        if (this.profilingUrl != null) {
            return this.profilingUrl;
        }
        if (this.profilingAgentless) {
            return String.format(PROFILING_REMOTE_URL_TEMPLATE, this.site);
        }
        return String.format(PROFILING_LOCAL_URL_TEMPLATE, this.agentHost, this.agentPort);
    }

    public boolean isIntegrationEnabled(Iterable<String> integrationNames, boolean defaultEnabled) {
        return this.isEnabled(integrationNames, "integration.", ".enabled", defaultEnabled);
    }

    public boolean isJmxFetchIntegrationEnabled(Iterable<String> integrationNames, boolean defaultEnabled) {
        return this.isEnabled(integrationNames, "jmxfetch.", ".enabled", defaultEnabled);
    }

    public boolean isRuleEnabled(String name) {
        return this.configProvider.getBoolean("trace." + name + ".enabled", true, new String[0]) && this.configProvider.getBoolean("trace." + name.toLowerCase() + ".enabled", true, new String[0]);
    }

    public static boolean jmxFetchIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return Config.get().isJmxFetchIntegrationEnabled(integrationNames, defaultEnabled);
    }

    public boolean isEndToEndDurationEnabled(boolean defaultEnabled, String ... integrationNames) {
        return this.isEnabled(Arrays.asList(integrationNames), "", ".e2e.duration.enabled", defaultEnabled);
    }

    public boolean isTraceAnalyticsIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return this.isEnabled(integrationNames, "", ".analytics.enabled", defaultEnabled);
    }

    public boolean isTraceAnalyticsIntegrationEnabled(boolean defaultEnabled, String ... integrationNames) {
        return this.isEnabled(Arrays.asList(integrationNames), "", ".analytics.enabled", defaultEnabled);
    }

    public <T extends Enum<T>> T getEnumValue(String name, Class<T> type, T defaultValue) {
        return this.configProvider.getEnum(PREFIX + name, type, defaultValue);
    }

    private static boolean isDebugMode() {
        String tracerDebugLevelSysprop = "dd.trace.debug";
        String tracerDebugLevelProp = System.getProperty("dd.trace.debug");
        if (tracerDebugLevelProp != null) {
            return Boolean.parseBoolean(tracerDebugLevelProp);
        }
        String tracerDebugLevelEnv = System.getenv(Strings.toEnvVar("dd.trace.debug"));
        if (tracerDebugLevelEnv != null) {
            return Boolean.parseBoolean(tracerDebugLevelEnv);
        }
        return false;
    }

    public static boolean traceAnalyticsIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return Config.get().isTraceAnalyticsIntegrationEnabled(integrationNames, defaultEnabled);
    }

    private boolean isEnabled(Iterable<String> integrationNames, String settingPrefix, String settingSuffix, boolean defaultEnabled) {
        boolean anyEnabled = defaultEnabled;
        for (String name : integrationNames) {
            String configKey = settingPrefix + name + settingSuffix;
            boolean configEnabled = this.configProvider.getBoolean("trace." + configKey, defaultEnabled, configKey);
            if (defaultEnabled) {
                anyEnabled &= configEnabled;
                continue;
            }
            anyEnabled |= configEnabled;
        }
        return anyEnabled;
    }

    private Set<PropagationStyle> getPropagationStyleSetSettingFromEnvironmentOrDefault(String name, String defaultValue) {
        String value = this.configProvider.getString(name, defaultValue, new String[0]);
        Set<PropagationStyle> result = Config.convertStringSetToPropagationStyleSet(Config.parseStringIntoSetOfNonEmptyStrings(value));
        if (result.isEmpty()) {
            result = Config.convertStringSetToPropagationStyleSet(Config.parseStringIntoSetOfNonEmptyStrings(defaultValue));
        }
        return result;
    }

    @Nonnull
    private static String propertyNameToEnvironmentVariableName(String setting) {
        return ENV_REPLACEMENT.matcher(Config.propertyNameToSystemPropertyName(setting).toUpperCase()).replaceAll("_");
    }

    @Nonnull
    private static String propertyNameToSystemPropertyName(String setting) {
        return PREFIX + setting;
    }

    @Nonnull
    private static Map<String, String> newHashMap(int size) {
        return new HashMap<String, String>(size + 1, 1.0f);
    }

    @Nonnull
    private Map<String, String> getMapWithPropertiesDefinedByEnvironment(@Nonnull Map<String, String> map, String ... propNames) {
        HashMap<String, String> res = new HashMap<String, String>(map);
        for (String propName : propNames) {
            String val = this.configProvider.getString(propName);
            if (val == null) continue;
            res.put(propName, val);
        }
        return Collections.unmodifiableMap(res);
    }

    @Nonnull
    @SuppressForbidden
    private static Set<String> parseStringIntoSetOfNonEmptyStrings(String str) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String value : str.split(SPLIT_BY_SPACE_OR_COMMA_REGEX)) {
            if (value.isEmpty()) continue;
            result.add(value);
        }
        return Collections.unmodifiableSet(result);
    }

    @Nonnull
    private static Set<PropagationStyle> convertStringSetToPropagationStyleSet(Set<String> input) {
        LinkedHashSet<PropagationStyle> result = new LinkedHashSet<PropagationStyle>();
        for (String value : input) {
            try {
                result.add(PropagationStyle.valueOf(value.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                log.debug("Cannot recognize config string value: {}, {}", (Object)value, (Object)PropagationStyle.class);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    @SuppressForbidden
    private static String findConfigurationFile() {
        File configurationFile;
        String configurationFilePath = System.getProperty(Config.propertyNameToSystemPropertyName("trace.config"));
        if (null == configurationFilePath) {
            configurationFilePath = System.getenv(Config.propertyNameToEnvironmentVariableName("trace.config"));
        }
        if (null != configurationFilePath && !(configurationFile = new File(configurationFilePath = configurationFilePath.replaceFirst("^~", System.getProperty("user.home")))).exists()) {
            return configurationFilePath;
        }
        return "no config file present";
    }

    private static String getHostName() {
        String possibleHostname = Config.isWindowsOS() ? System.getenv("COMPUTERNAME") : System.getenv("HOSTNAME");
        if (possibleHostname != null && !possibleHostname.isEmpty()) {
            log.debug("Determined hostname from environment variable");
            return possibleHostname.trim();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec("hostname").getInputStream()));){
            possibleHostname = reader.readLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (possibleHostname != null && !possibleHostname.isEmpty()) {
            log.debug("Determined hostname from hostname command");
            return possibleHostname.trim();
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    private static boolean isWindowsOS() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static Config get() {
        return INSTANCE;
    }

    @Deprecated
    public static Config get(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return INSTANCE;
        }
        return new Config(Config.INSTANCE.runtimeId, ConfigProvider.withPropertiesOverride(properties));
    }

    public String toString() {
        return "Config{runtimeId='" + this.runtimeId + '\'' + ", apiKey=" + (this.apiKey == null ? "null" : "****") + ", site='" + this.site + '\'' + ", serviceName='" + this.serviceName + '\'' + ", serviceNameSetByUser=" + this.serviceNameSetByUser + ", traceEnabled=" + this.traceEnabled + ", integrationsEnabled=" + this.integrationsEnabled + ", writerType='" + this.writerType + '\'' + ", agentConfiguredUsingDefault=" + this.agentConfiguredUsingDefault + ", agentUrl='" + this.agentUrl + '\'' + ", agentHost='" + this.agentHost + '\'' + ", agentPort=" + this.agentPort + ", agentUnixDomainSocket='" + this.agentUnixDomainSocket + '\'' + ", agentTimeout=" + this.agentTimeout + ", noProxyHosts=" + this.noProxyHosts + ", prioritySamplingEnabled=" + this.prioritySamplingEnabled + ", prioritySamplingForce='" + this.prioritySamplingForce + '\'' + ", traceResolverEnabled=" + this.traceResolverEnabled + ", serviceMapping=" + this.serviceMapping + ", tags=" + this.tags + ", spanTags=" + this.spanTags + ", jmxTags=" + this.jmxTags + ", excludedClasses=" + this.excludedClasses + ", headerTags=" + this.headerTags + ", httpServerErrorStatuses=" + this.httpServerErrorStatuses + ", httpClientErrorStatuses=" + this.httpClientErrorStatuses + ", httpServerTagQueryString=" + this.httpServerTagQueryString + ", httpClientTagQueryString=" + this.httpClientTagQueryString + ", httpClientSplitByDomain=" + this.httpClientSplitByDomain + ", dbClientSplitByInstance=" + this.dbClientSplitByInstance + ", splitByTags=" + this.splitByTags + ", scopeDepthLimit=" + this.scopeDepthLimit + ", scopeStrictMode=" + this.scopeStrictMode + ", scopeInheritAsyncPropagation=" + this.scopeInheritAsyncPropagation + ", partialFlushMinSpans=" + this.partialFlushMinSpans + ", traceStrictWritesEnabled=" + this.traceStrictWritesEnabled + ", runtimeContextFieldInjection=" + this.runtimeContextFieldInjection + ", serialVersionUIDFieldInjection=" + this.serialVersionUIDFieldInjection + ", propagationStylesToExtract=" + this.propagationStylesToExtract + ", propagationStylesToInject=" + this.propagationStylesToInject + ", jmxFetchEnabled=" + this.jmxFetchEnabled + ", jmxFetchConfigDir='" + this.jmxFetchConfigDir + '\'' + ", jmxFetchConfigs=" + this.jmxFetchConfigs + ", jmxFetchMetricsConfigs=" + this.jmxFetchMetricsConfigs + ", jmxFetchCheckPeriod=" + this.jmxFetchCheckPeriod + ", jmxFetchRefreshBeansPeriod=" + this.jmxFetchRefreshBeansPeriod + ", jmxFetchStatsdHost='" + this.jmxFetchStatsdHost + '\'' + ", jmxFetchStatsdPort=" + this.jmxFetchStatsdPort + ", healthMetricsEnabled=" + this.healthMetricsEnabled + ", healthMetricsStatsdHost='" + this.healthMetricsStatsdHost + '\'' + ", healthMetricsStatsdPort=" + this.healthMetricsStatsdPort + ", perfMetricsEnabled=" + this.perfMetricsEnabled + ", tracerMetricsEnabled=" + this.tracerMetricsEnabled + ", tracerMetricsBufferingEnabled=" + this.tracerMetricsBufferingEnabled + ", tracerMetricsMaxAggregates=" + this.tracerMetricsMaxAggregates + ", tracerMetricsMaxPending=" + this.tracerMetricsMaxPending + ", logsInjectionEnabled=" + this.logsInjectionEnabled + ", logsMDCTagsInjectionEnabled=" + this.logsMDCTagsInjectionEnabled + ", reportHostName=" + this.reportHostName + ", traceAnnotations='" + this.traceAnnotations + '\'' + ", traceMethods='" + this.traceMethods + '\'' + ", traceExecutorsAll=" + this.traceExecutorsAll + ", traceExecutors=" + this.traceExecutors + ", traceAnalyticsEnabled=" + this.traceAnalyticsEnabled + ", traceSamplingServiceRules=" + this.traceSamplingServiceRules + ", traceSamplingOperationRules=" + this.traceSamplingOperationRules + ", traceSampleRate=" + this.traceSampleRate + ", traceRateLimit=" + this.traceRateLimit + ", profilingEnabled=" + this.profilingEnabled + ", profilingAgentless=" + this.profilingAgentless + ", profilingUrl='" + this.profilingUrl + '\'' + ", profilingTags=" + this.profilingTags + ", profilingStartDelay=" + this.profilingStartDelay + ", profilingStartForceFirst=" + this.profilingStartForceFirst + ", profilingUploadPeriod=" + this.profilingUploadPeriod + ", profilingTemplateOverrideFile='" + this.profilingTemplateOverrideFile + '\'' + ", profilingUploadTimeout=" + this.profilingUploadTimeout + ", profilingUploadCompression='" + this.profilingUploadCompression + '\'' + ", profilingProxyHost='" + this.profilingProxyHost + '\'' + ", profilingProxyPort=" + this.profilingProxyPort + ", profilingProxyUsername='" + this.profilingProxyUsername + '\'' + ", profilingProxyPassword=" + (this.profilingProxyPassword == null ? "null" : "****") + ", profilingExceptionSampleLimit=" + this.profilingExceptionSampleLimit + ", profilingExceptionHistogramTopItems=" + this.profilingExceptionHistogramTopItems + ", profilingExceptionHistogramMaxCollectionSize=" + this.profilingExceptionHistogramMaxCollectionSize + ", profilingExcludeAgentThreads=" + this.profilingExcludeAgentThreads + ", kafkaClientPropagationEnabled=" + this.kafkaClientPropagationEnabled + ", kafkaClientBase64DecodingEnabled=" + this.kafkaClientBase64DecodingEnabled + ", hystrixTagsEnabled=" + this.hystrixTagsEnabled + ", osgiSearchDepth=" + this.osgiSearchDepth + ", servletPrincipalEnabled=" + this.servletPrincipalEnabled + ", servletAsyncTimeoutError=" + this.servletAsyncTimeoutError + ", tempJarsCleanOnBoot=" + this.tempJarsCleanOnBoot + ", traceAgentV05Enabled=" + this.traceAgentV05Enabled + ", debugEnabled=" + this.debugEnabled + ", configFile='" + this.configFile + '\'' + ", idGenerationStrategy=" + (Object)((Object)this.idGenerationStrategy) + ", internalExitOnFailure=" + this.internalExitOnFailure + ", resolverUseLoadClassEnabled=" + this.resolverUseLoadClassEnabled + ", jdbcPreparedStatementClassName='" + this.jdbcPreparedStatementClassName + '\'' + ", jdbcConnectionClassName='" + this.jdbcConnectionClassName + '\'' + ", grpcIgnoredOutboundMethods=" + this.grpcIgnoredOutboundMethods + ", configProvider=" + this.configProvider + '}';
    }
}

