/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.java.concurrent;

import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.context.TraceScope;

public class Wrapper<T extends Runnable>
implements Runnable {
    protected final T delegate;
    private final TraceScope.Continuation continuation;

    public Wrapper(T delegate) {
        this.delegate = delegate;
        TraceScope.Continuation continuation = null;
        TraceScope scope = AgentTracer.activeScope();
        if (null != scope) {
            continuation = scope.capture();
        }
        this.continuation = continuation;
    }

    @Override
    public void run() {
        try (TraceScope scope = this.activate();){
            this.delegate.run();
        }
    }

    public void cancel() {
        if (null != this.continuation) {
            this.continuation.cancel();
        }
    }

    public T unwrap() {
        return this.delegate;
    }

    private TraceScope activate() {
        return null == this.continuation ? null : this.continuation.activate();
    }
}

