/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.kdoc;

import com.facebook.ktfmt.kdoc.CommentType;
import com.facebook.ktfmt.kdoc.CommentTypeKt;
import com.facebook.ktfmt.kdoc.FormattingTask;
import com.facebook.ktfmt.kdoc.KDocFormattingOptions;
import com.facebook.ktfmt.kdoc.Paragraph;
import com.facebook.ktfmt.kdoc.ParagraphList;
import com.facebook.ktfmt.kdoc.ParagraphListBuilder;
import com.facebook.ktfmt.kdoc.ParagraphListBuilderKt;
import com.facebook.ktfmt.kdoc.Table;
import com.facebook.ktfmt.kdoc.UtilitiesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J~\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u000b2 \b\u0002\u0010\u001d\u001a\u001a\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u001e2\u001a\b\u0002\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020!0 2\u001a\b\u0002\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0 2\b\b\u0002\u0010#\u001a\u00020\u0003H\u0002J`\u0010$\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010%\u001a\u00020\u000b2\b\b\u0002\u0010\u001c\u001a\u00020\u000b2\b\b\u0002\u0010&\u001a\u00020\u000b2\u001a\b\u0002\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020!0 2\u0014\b\u0002\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0'H\u0002J\b\u0010(\u001a\u00020!H\u0002J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001aJ\u0010\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u0003H\u0002J\u0010\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003H\u0002J\"\u00100\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u00032\b\b\u0002\u00101\u001a\u00020\u001aH\u0002J\u0010\u00102\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u0003H\u0002J\u0018\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u000bH\u0002J\u0010\u00107\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u0003H\u0002J\b\u00108\u001a\u00020!H\u0002J\b\u00109\u001a\u00020!H\u0002J\b\u0010:\u001a\u00020!H\u0002J\b\u0010;\u001a\u00020!H\u0002J\b\u0010<\u001a\u00020!H\u0002J\b\u0010=\u001a\u00020!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/facebook/ktfmt/kdoc/ParagraphListBuilder;", "", "comment", "", "options", "Lcom/facebook/ktfmt/kdoc/KDocFormattingOptions;", "task", "Lcom/facebook/ktfmt/kdoc/FormattingTask;", "<init>", "(Ljava/lang/String;Lcom/facebook/ktfmt/kdoc/KDocFormattingOptions;Lcom/facebook/ktfmt/kdoc/FormattingTask;)V", "lineComment", "", "commentPrefix", "paragraphs", "", "Lcom/facebook/ktfmt/kdoc/Paragraph;", "lines", "", "lineContent", "line", "closeParagraph", "newParagraph", "paragraph", "appendText", "s", "addLines", "", "i", "includeEnd", "until", "Lkotlin/Function3;", "customize", "Lkotlin/Function2;", "", "shouldBreak", "separator", "addPreformatted", "includeStart", "expectClose", "Lkotlin/Function1;", "stripTrailingBlankLines", "scan", "Lcom/facebook/ktfmt/kdoc/ParagraphList;", "indentSize", "convertPrefix", "text", "convertSuffix", "trimmedPrefix", "addPlainText", "braceBalance", "breakOutOfTag", "next", "docTagRank", "tag", "isPriority", "docTagIsPriority", "arrange", "sortDocTags", "adjustParagraphSeparators", "adjustIndentation", "removeBlankParagraphs", "punctuate", "ktfmt"})
@SourceDebugExtension(value={"SMAP\nParagraphListBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParagraphListBuilder.kt\ncom/facebook/ktfmt/kdoc/ParagraphListBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,914:1\n1563#2:915\n1634#2,3:916\n1761#2,3:922\n1573#2:925\n1604#2,4:926\n360#2,7:930\n130#3,2:919\n1#4:921\n*S KotlinDebug\n*F\n+ 1 ParagraphListBuilder.kt\ncom/facebook/ktfmt/kdoc/ParagraphListBuilder\n*L\n46#1:915\n46#1:916,3\n670#1:922,3\n671#1:925\n671#1:926,4\n672#1:930,7\n286#1:919,2\n*E\n"})
public final class ParagraphListBuilder {
    @NotNull
    private final KDocFormattingOptions options;
    @NotNull
    private final FormattingTask task;
    private final boolean lineComment;
    @NotNull
    private final String commentPrefix;
    @NotNull
    private final List<Paragraph> paragraphs;
    @NotNull
    private final List<String> lines;
    @NotNull
    private Paragraph paragraph;

    /*
     * WARNING - void declaration
     */
    public ParagraphListBuilder(@NotNull String comment, @NotNull KDocFormattingOptions options, @NotNull FormattingTask task) {
        List list;
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.options = options;
        this.task = task;
        this.lineComment = CommentTypeKt.isLineComment(comment);
        this.commentPrefix = this.lineComment ? "//" : (CommentTypeKt.isKDocComment(comment) ? "/**" : "/*");
        this.paragraphs = new ArrayList();
        ParagraphListBuilder paragraphListBuilder = this;
        if (this.lineComment) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object = new String[]{"\n"};
            object = StringsKt.split$default((CharSequence)comment, (String[])object, (boolean)false, (int)0, (int)6, null);
            ParagraphListBuilder paragraphListBuilder2 = paragraphListBuilder;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trimStart((CharSequence)((CharSequence)it))).toString());
            }
            list = (List)destination$iv$iv;
            paragraphListBuilder = paragraphListBuilder2;
        } else if (!StringsKt.contains$default((CharSequence)comment, (CharSequence)"\n", (boolean)false, (int)2, null)) {
            list = CollectionsKt.listOf((Object)("* " + ((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)comment, (CharSequence)this.commentPrefix), (CharSequence)"*/"))).toString()));
        } else {
            String[] stringArray = new String[]{"\n"};
            list = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)comment, (CharSequence)this.commentPrefix), (CharSequence)"*/"))).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        }
        paragraphListBuilder.lines = list;
        this.paragraph = new Paragraph(this.task);
    }

    private final String lineContent(String line2) {
        String string;
        String trimmed = ((Object)StringsKt.trim((CharSequence)line2)).toString();
        if (this.lineComment && StringsKt.startsWith$default((String)trimmed, (String)"// ", (boolean)false, (int)2, null)) {
            String string2 = trimmed.substring(3);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else if (this.lineComment && StringsKt.startsWith$default((String)trimmed, (String)"//", (boolean)false, (int)2, null)) {
            String string3 = trimmed.substring(2);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else if (StringsKt.startsWith$default((String)trimmed, (String)"* ", (boolean)false, (int)2, null)) {
            String string4 = trimmed.substring(2);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        } else if (StringsKt.startsWith$default((String)trimmed, (String)"*", (boolean)false, (int)2, null)) {
            String string5 = trimmed.substring(1);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        } else {
            string = trimmed;
        }
        return string;
    }

    private final Paragraph closeParagraph() {
        String text = this.paragraph.getText();
        if (!this.paragraph.getPreformatted()) {
            if (UtilitiesKt.isKDocTag(text)) {
                this.paragraph.setDoc(true);
                this.paragraph.setHanging(true);
            } else if (UtilitiesKt.isTodo(text)) {
                this.paragraph.setHanging(true);
            } else if (UtilitiesKt.isListItem(text)) {
                this.paragraph.setHanging(true);
            } else if (UtilitiesKt.isDirectiveMarker(text)) {
                this.paragraph.setBlock(true);
                this.paragraph.setPreformatted(true);
            }
        }
        if (!this.paragraph.isEmpty() || this.paragraph.getAllowEmpty()) {
            this.paragraphs.add(this.paragraph);
        }
        return this.paragraph;
    }

    private final Paragraph newParagraph() {
        this.closeParagraph();
        Paragraph prev = this.paragraph;
        this.paragraph = new Paragraph(this.task);
        prev.setNext(this.paragraph);
        this.paragraph.setPrev(prev);
        return this.paragraph;
    }

    private final ParagraphListBuilder appendText(String s) {
        this.paragraph.getContent().append(s);
        return this;
    }

    private final int addLines(int i, boolean includeEnd, Function3<? super Integer, ? super String, ? super String, Boolean> until, Function2<? super Integer, ? super Paragraph, Unit> customize, Function2<? super String, ? super String, Boolean> shouldBreak, String separator) {
        int j;
        for (j = i; j < this.lines.size(); ++j) {
            String l = this.lines.get(j);
            String lineWithIndentation = this.lineContent(l);
            String lineWithoutIndentation = ((Object)StringsKt.trim((CharSequence)lineWithIndentation)).toString();
            if (!includeEnd && j > i && ((Boolean)until.invoke((Object)j, (Object)lineWithoutIndentation, (Object)lineWithIndentation)).booleanValue()) {
                this.stripTrailingBlankLines();
                return j;
            }
            if (((Boolean)shouldBreak.invoke((Object)lineWithoutIndentation, (Object)lineWithIndentation)).booleanValue()) {
                this.newParagraph();
            }
            if (UtilitiesKt.isQuoted(lineWithIndentation)) {
                String string = lineWithoutIndentation.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                v1 = this.appendText(UtilitiesKt.collapseSpaces(string));
            } else {
                v1 = this.appendText(UtilitiesKt.collapseSpaces(lineWithoutIndentation));
            }
            this.appendText(separator);
            customize.invoke((Object)j, (Object)this.paragraph);
            if (!includeEnd || j <= i || !((Boolean)until.invoke((Object)j, (Object)lineWithoutIndentation, (Object)lineWithIndentation)).booleanValue()) continue;
            this.stripTrailingBlankLines();
            return j + 1;
        }
        this.stripTrailingBlankLines();
        this.newParagraph();
        return j;
    }

    static /* synthetic */ int addLines$default(ParagraphListBuilder paragraphListBuilder, int n, boolean bl, Function3 function3, Function2 function2, Function2 function22, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            function3 = ParagraphListBuilder::addLines$lambda$1;
        }
        if ((n2 & 8) != 0) {
            function2 = ParagraphListBuilder::addLines$lambda$2;
        }
        if ((n2 & 0x10) != 0) {
            function22 = ParagraphListBuilder::addLines$lambda$3;
        }
        if ((n2 & 0x20) != 0) {
            string = " ";
        }
        return paragraphListBuilder.addLines(n, bl, (Function3<? super Integer, ? super String, ? super String, Boolean>)function3, (Function2<? super Integer, ? super Paragraph, Unit>)function2, (Function2<? super String, ? super String, Boolean>)function22, string);
    }

    private final int addPreformatted(int i, boolean includeStart, boolean includeEnd, boolean expectClose, Function2<? super Integer, ? super Paragraph, Unit> customize, Function1<? super String, Boolean> until) {
        int j;
        this.newParagraph();
        boolean foundClose = false;
        boolean allowCustomize = true;
        for (j = i; j < this.lines.size(); ++j) {
            boolean done;
            String l = this.lines.get(j);
            String lineWithIndentation = this.lineContent(l);
            if (StringsKt.contains$default((CharSequence)lineWithIndentation, (CharSequence)"```", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)lineWithIndentation)).toString(), (String)"```", (boolean)false, (int)2, null)) {
                allowCustomize = false;
            }
            boolean bl = done = (includeStart || j > i) && (Boolean)until.invoke((Object)lineWithIndentation) != false;
            if (includeEnd || !done) continue;
            foundClose = true;
            break;
        }
        if (!foundClose && expectClose) {
            allowCustomize = false;
            j = this.lines.size();
        }
        int n = j;
        for (int index = i; index < n; ++index) {
            String l = this.lines.get(index);
            String lineWithIndentation = this.lineContent(l);
            this.appendText(lineWithIndentation);
            this.paragraph.setPreformatted(true);
            this.paragraph.setAllowEmpty(true);
            if (allowCustomize) {
                customize.invoke((Object)index, (Object)this.paragraph);
            }
            this.newParagraph();
        }
        this.stripTrailingBlankLines();
        this.newParagraph();
        return j;
    }

    static /* synthetic */ int addPreformatted$default(ParagraphListBuilder paragraphListBuilder, int n, boolean bl, boolean bl2, boolean bl3, Function2 function2, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            bl2 = true;
        }
        if ((n2 & 8) != 0) {
            bl3 = false;
        }
        if ((n2 & 0x10) != 0) {
            function2 = ParagraphListBuilder::addPreformatted$lambda$4;
        }
        if ((n2 & 0x20) != 0) {
            function1 = ParagraphListBuilder::addPreformatted$lambda$5;
        }
        return paragraphListBuilder.addPreformatted(n, bl, bl2, bl3, (Function2<? super Integer, ? super Paragraph, Unit>)function2, (Function1<? super String, Boolean>)function1);
    }

    private final void stripTrailingBlankLines() {
        Paragraph paragraph;
        for (int p = this.paragraphs.size() - 1; -1 < p && (paragraph = this.paragraphs.get(p)).isEmpty(); --p) {
            this.paragraphs.remove(p);
        }
    }

    @NotNull
    public final ParagraphList scan(int indentSize) {
        int i = 0;
        while (i < this.lines.size()) {
            Pair<Table, Integer> result2;
            Object paragraph;
            char[] cArray;
            String lineWithoutIndentation;
            String lineWithIndentation;
            String l;
            block30: {
                block31: {
                    l = this.lines.get(i++);
                    lineWithIndentation = this.lineContent(l);
                    lineWithoutIndentation = ((Object)StringsKt.trim((CharSequence)lineWithIndentation)).toString();
                    if (!StringsKt.startsWith$default((String)lineWithIndentation, (String)"    ", (boolean)false, (int)2, null) || i != 1 && !StringsKt.isBlank((CharSequence)this.lineContent(this.lines.get(i - 2)))) break block30;
                    if (this.paragraph.getPrev() == null) break block31;
                    Paragraph paragraph2 = this.paragraph.getPrev();
                    if (paragraph2 == null) {
                        String string = "Required value was null.";
                        throw new IllegalStateException(string.toString());
                    }
                    if (lineWithIndentation.length() - lineWithoutIndentation.length() < paragraph2.getOriginalIndent() + 4) break block30;
                }
                i = ParagraphListBuilder.addPreformatted$default(this, i - 1, false, false, false, null, ParagraphListBuilder::scan$lambda$6, 18, null);
                continue;
            }
            if (StringsKt.startsWith$default((String)lineWithoutIndentation, (String)"-", (boolean)false, (int)2, null) && ParagraphListBuilderKt.containsOnly(lineWithoutIndentation, cArray = new char[]{'-', '|', ' '})) {
                paragraph = ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, i - 1);
                this.appendText(lineWithoutIndentation);
                ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, i).setBlock(true);
                if (!UtilitiesKt.isLine$default(lineWithIndentation, 0, 1, null) || i >= 2 && !StringsKt.isBlank((CharSequence)this.lineContent(this.lines.get(i - 2))) || i <= this.lines.size() - 1 && !StringsKt.isBlank((CharSequence)this.lineContent(this.lines.get(i)))) continue;
                paragraph.setSeparator(true);
                continue;
            }
            if (StringsKt.startsWith$default((String)lineWithoutIndentation, (String)"=", (boolean)false, (int)2, null) && ParagraphListBuilderKt.containsOnly(lineWithoutIndentation, paragraph = (Object)new char[]{'=', ' '})) {
                ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, i - 1).setBlock(true);
                this.appendText(lineWithoutIndentation);
                ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, i).setBlock(true);
                continue;
            }
            if (StringsKt.startsWith$default((String)lineWithoutIndentation, (String)"#", (boolean)false, (int)2, null)) {
                Object object;
                block29: {
                    CharSequence $this$firstOrNull$iv = lineWithoutIndentation;
                    boolean $i$f$firstOrNull = false;
                    for (int j = 0; j < $this$firstOrNull$iv.length(); ++j) {
                        char element$iv;
                        char it = element$iv = $this$firstOrNull$iv.charAt(j);
                        boolean bl = false;
                        if (!(it != '#')) continue;
                        object = Character.valueOf(element$iv);
                        break block29;
                    }
                    object = null;
                }
                boolean bl = object != null ? object.equals(Character.valueOf(' ')) : false;
                if (bl) {
                    ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, i - 1).setBlock(true);
                    this.appendText(lineWithoutIndentation);
                    ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, i).setBlock(true);
                    continue;
                }
            }
            if (StringsKt.startsWith$default((String)lineWithoutIndentation, (String)"*", (boolean)false, (int)2, null) && ParagraphListBuilderKt.containsOnly(lineWithoutIndentation, paragraph = new char[]{'*', ' '})) {
                ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, i - 1).setBlock(true);
                this.appendText(lineWithoutIndentation);
                ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, i).setBlock(true);
                continue;
            }
            if (StringsKt.startsWith$default((String)lineWithoutIndentation, (String)"```", (boolean)false, (int)2, null)) {
                i = ParagraphListBuilder.addPreformatted$default(this, i - 1, false, false, true, null, ParagraphListBuilder::scan$lambda$8, 22, null);
                continue;
            }
            if (StringsKt.startsWith((String)lineWithoutIndentation, (String)"<pre>", (boolean)true)) {
                i = ParagraphListBuilder.addPreformatted$default(this, i - 1, true, false, true, (arg_0, arg_1) -> ParagraphListBuilder.scan$lambda$9(this, arg_0, arg_1), ParagraphListBuilder::scan$lambda$10, 4, null);
                continue;
            }
            if (UtilitiesKt.isQuoted(lineWithoutIndentation)) {
                paragraph = ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, --i);
                paragraph.setQuoted(true);
                paragraph.setBlock(false);
                i = ParagraphListBuilder.addLines$default(this, i, false, ParagraphListBuilder::scan$lambda$11, ParagraphListBuilder::scan$lambda$12, null, null, 48, null);
                ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, i);
                continue;
            }
            if (StringsKt.equals((String)lineWithoutIndentation, (String)"<ul>", (boolean)true) || StringsKt.equals((String)lineWithoutIndentation, (String)"<ol>", (boolean)true)) {
                ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, i - 1).setBlock(true);
                this.appendText(lineWithoutIndentation);
                ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, i).setHanging(true);
                i = ParagraphListBuilder.addLines$default(this, i, true, ParagraphListBuilder::scan$lambda$13, ParagraphListBuilder::scan$lambda$14, ParagraphListBuilder::scan$lambda$15, null, 32, null);
                ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, i);
                continue;
            }
            if (UtilitiesKt.isListItem(lineWithoutIndentation) || UtilitiesKt.isKDocTag(lineWithoutIndentation) && this.task.getType() == CommentType.KDOC || UtilitiesKt.isTodo(lineWithoutIndentation)) {
                ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, --i).setHanging(true);
                int start = i;
                i = ParagraphListBuilder.addLines$default(this, i, false, (arg_0, arg_1, arg_2) -> ParagraphListBuilder.scan$lambda$16(this, arg_0, arg_1, arg_2), (arg_0, arg_1) -> ParagraphListBuilder.scan$lambda$17(this, start, arg_0, arg_1), ParagraphListBuilder::scan$lambda$18, null, 32, null);
                ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, i);
                continue;
            }
            if (((CharSequence)lineWithoutIndentation).length() == 0) {
                ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, i).setSeparate(true);
                continue;
            }
            if (UtilitiesKt.isDirectiveMarker(lineWithoutIndentation)) {
                ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, i - 1);
                this.appendText(lineWithoutIndentation);
                ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, i).setBlock(true);
                continue;
            }
            if (StringsKt.indexOf$default((CharSequence)lineWithoutIndentation, (char)'|', (int)0, (boolean)false, (int)6, null) != -1 && this.paragraph.isEmpty() && (i < 2 || !StringsKt.contains$default((CharSequence)this.lines.get(i - 2), (CharSequence)"---", (boolean)false, (int)2, null)) && (result2 = Table.Companion.getTable(this.lines, i - 1, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)this){

                public final String invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ParagraphListBuilder.access$lineContent((ParagraphListBuilder)this.receiver, p0);
                }
            }))) != null) {
                Table table = (Table)result2.component1();
                int nextRow = ((Number)result2.component2()).intValue();
                List<String> content = this.options.getAlignTableColumns() ? table.format(this.options.getMaxLineWidth() - indentSize - 3) : table.original();
                int n = ((Collection)content).size();
                for (int index = 0; index < n; ++index) {
                    String line2 = content.get(index);
                    this.appendText(line2);
                    this.paragraph.setSeparate(index == 0);
                    this.paragraph.setBlock(true);
                    this.paragraph.setTable(true);
                    ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, -1);
                }
                i = nextRow;
                ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, i);
                continue;
            }
            if (StringsKt.startsWith$default((String)lineWithoutIndentation, (String)"<", (boolean)false, (int)2, null) && (StringsKt.startsWith((String)lineWithoutIndentation, (String)"<p>", (boolean)true) || StringsKt.startsWith((String)lineWithoutIndentation, (String)"<p/>", (boolean)true) || StringsKt.startsWith((String)lineWithoutIndentation, (String)"<h1", (boolean)true) || StringsKt.startsWith((String)lineWithoutIndentation, (String)"<h2", (boolean)true) || StringsKt.startsWith((String)lineWithoutIndentation, (String)"<h3", (boolean)true) || StringsKt.startsWith((String)lineWithoutIndentation, (String)"<h4", (boolean)true) || StringsKt.startsWith((String)lineWithoutIndentation, (String)"<table", (boolean)true) || StringsKt.startsWith((String)lineWithoutIndentation, (String)"<tr", (boolean)true) || StringsKt.startsWith((String)lineWithoutIndentation, (String)"<caption", (boolean)true) || StringsKt.startsWith((String)lineWithoutIndentation, (String)"<td", (boolean)true) || StringsKt.startsWith((String)lineWithoutIndentation, (String)"<div", (boolean)true))) {
                ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, i - 1).setBlock(true);
                if (StringsKt.equals((String)lineWithoutIndentation, (String)"<p>", (boolean)true) || StringsKt.equals((String)lineWithoutIndentation, (String)"<p/>", (boolean)true) || this.options.getConvertMarkup() && StringsKt.equals((String)lineWithoutIndentation, (String)"</p>", (boolean)true)) {
                    if (this.options.getConvertMarkup()) {
                        this.paragraph.setSeparate(true);
                        continue;
                    }
                    this.appendText(lineWithoutIndentation);
                    ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, i).setBlock(true);
                    continue;
                }
                if (StringsKt.endsWith((String)lineWithoutIndentation, (String)"</h1>", (boolean)true) || StringsKt.endsWith((String)lineWithoutIndentation, (String)"</h2>", (boolean)true) || StringsKt.endsWith((String)lineWithoutIndentation, (String)"</h3>", (boolean)true) || StringsKt.endsWith((String)lineWithoutIndentation, (String)"</h4>", (boolean)true)) {
                    if (StringsKt.startsWith((String)lineWithoutIndentation, (String)"<h", (boolean)true) && this.options.getConvertMarkup() && this.paragraph.isEmpty()) {
                        this.paragraph.setSeparate(true);
                        int count = lineWithoutIndentation.charAt(lineWithoutIndentation.length() - 2) - 48;
                        int n = RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)count, (int)0), (int)8);
                        for (int j = 0; j < n; ++j) {
                            this.appendText("#");
                        }
                        this.appendText(" ");
                        String string = lineWithoutIndentation.substring(4, lineWithoutIndentation.length() - 5);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        v4 = this.appendText(string);
                    } else {
                        v4 = this.options.getCollapseSpaces() ? this.appendText(UtilitiesKt.collapseSpaces(lineWithoutIndentation)) : this.appendText(lineWithoutIndentation);
                    }
                    ParagraphListBuilder.scan$newParagraph(this, l, lineWithIndentation, lineWithoutIndentation, i).setBlock(true);
                    continue;
                }
            }
            i = ParagraphListBuilder.addPlainText$default(this, i, lineWithoutIndentation, 0, 4, null);
        }
        this.closeParagraph();
        this.arrange();
        if (!this.lineComment) {
            this.punctuate();
        }
        return new ParagraphList(this.paragraphs);
    }

    private final String convertPrefix(String text) {
        String string;
        if (this.options.getConvertMarkup() && (StringsKt.startsWith((String)text, (String)"<p>", (boolean)true) || StringsKt.startsWith((String)text, (String)"<p/>", (boolean)true))) {
            this.paragraph.setSeparate(true);
            String string2 = text.substring(StringsKt.indexOf$default((CharSequence)text, (char)'>', (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        } else {
            string = text;
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String convertSuffix(String trimmedPrefix) {
        String string;
        block2: {
            block3: {
                if (!this.options.getConvertMarkup()) break block2;
                if (StringsKt.endsWith((String)trimmedPrefix, (String)"<p/>", (boolean)true)) break block3;
                if (!StringsKt.endsWith((String)trimmedPrefix, (String)"</p>", (boolean)true)) break block2;
            }
            String string2 = trimmedPrefix.substring(0, trimmedPrefix.length() - 4);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = ((Object)StringsKt.trimEnd((CharSequence)StringsKt.removeSuffix((String)((Object)StringsKt.trimEnd((CharSequence)string2)).toString(), (CharSequence)"*"))).toString();
            return string;
        }
        string = trimmedPrefix;
        return string;
    }

    private final int addPlainText(int i, String text, int braceBalance) {
        int end;
        int end2;
        String trimmed;
        String it = trimmed = this.convertSuffix(this.convertPrefix(text));
        boolean bl = false;
        String s = this.options.getCollapseSpaces() ? UtilitiesKt.collapseSpaces(it) : it;
        this.appendText(s);
        this.appendText(" ");
        if (braceBalance > 0 && (end2 = StringsKt.indexOf$default((CharSequence)s, (char)'}', (int)0, (boolean)false, (int)6, null)) == -1 && i < this.lines.size()) {
            String next = ((Object)StringsKt.trim((CharSequence)this.lineContent(this.lines.get(i)))).toString();
            if (this.breakOutOfTag(next)) {
                return i;
            }
            return this.addPlainText(i + 1, next, 1);
        }
        int index = StringsKt.indexOf$default((CharSequence)s, (String)"{@", (int)0, (boolean)false, (int)6, null);
        if (index != -1 && (end = StringsKt.indexOf$default((CharSequence)s, (char)'}', (int)index, (boolean)false, (int)4, null)) == -1 && i < this.lines.size()) {
            String next = ((Object)StringsKt.trim((CharSequence)this.lineContent(this.lines.get(i)))).toString();
            if (this.breakOutOfTag(next)) {
                return i;
            }
            return this.addPlainText(i + 1, next, 1);
        }
        return i;
    }

    static /* synthetic */ int addPlainText$default(ParagraphListBuilder paragraphListBuilder, int n, String string, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return paragraphListBuilder.addPlainText(n, string, n2);
    }

    private final boolean breakOutOfTag(String next) {
        return StringsKt.isBlank((CharSequence)next) || StringsKt.startsWith$default((String)next, (String)"```", (boolean)false, (int)2, null);
    }

    private final int docTagRank(String tag, boolean isPriority) {
        return isPriority ? -1 : (StringsKt.startsWith$default((String)tag, (String)"@param", (boolean)false, (int)2, null) ? 0 : (StringsKt.startsWith$default((String)tag, (String)"@property", (boolean)false, (int)2, null) ? 0 : (StringsKt.startsWith$default((String)tag, (String)"@return", (boolean)false, (int)2, null) ? 1 : (StringsKt.startsWith$default((String)tag, (String)"@constructor", (boolean)false, (int)2, null) ? 2 : (StringsKt.startsWith$default((String)tag, (String)"@receiver", (boolean)false, (int)2, null) ? 3 : (StringsKt.startsWith$default((String)tag, (String)"@throws", (boolean)false, (int)2, null) ? 4 : (StringsKt.startsWith$default((String)tag, (String)"@exception", (boolean)false, (int)2, null) ? 5 : (StringsKt.startsWith$default((String)tag, (String)"@sample", (boolean)false, (int)2, null) ? 6 : (StringsKt.startsWith$default((String)tag, (String)"@see", (boolean)false, (int)2, null) ? 7 : (StringsKt.startsWith$default((String)tag, (String)"@author", (boolean)false, (int)2, null) ? 8 : (StringsKt.startsWith$default((String)tag, (String)"@since", (boolean)false, (int)2, null) ? 9 : (StringsKt.startsWith$default((String)tag, (String)"@suppress", (boolean)false, (int)2, null) ? 10 : (StringsKt.startsWith$default((String)tag, (String)"@deprecated", (boolean)false, (int)2, null) ? 11 : 100)))))))))))));
    }

    private final boolean docTagIsPriority(String tag) {
        return StringsKt.startsWith$default((String)tag, (String)"@sample", (boolean)false, (int)2, null);
    }

    private final void arrange() {
        if (this.paragraphs.isEmpty()) {
            return;
        }
        this.sortDocTags();
        this.adjustParagraphSeparators();
        this.adjustIndentation();
        this.removeBlankParagraphs();
        this.stripTrailingBlankLines();
    }

    /*
     * WARNING - void declaration
     */
    private final void sortDocTags() {
        if (this.options.getOrderDocTags()) {
            boolean bl;
            block13: {
                Iterable $this$any$iv = this.paragraphs;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Paragraph it = (Paragraph)element$iv;
                        boolean bl2 = false;
                        if (!it.getDoc()) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl) {
                int n;
                Map order;
                block14: {
                    void $this$mapIndexedTo$iv$iv;
                    Object element$iv;
                    Iterable $this$mapIndexed$iv = this.paragraphs;
                    boolean $i$f$mapIndexed = false;
                    element$iv = $this$mapIndexed$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                    boolean $i$f$mapIndexedTo22 = false;
                    int index$iv$iv = 0;
                    for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                        void index;
                        void paragraph;
                        int n2;
                        if ((n2 = index$iv$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        Paragraph paragraph2 = (Paragraph)item$iv$iv;
                        int n3 = n2;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add(TuplesKt.to((Object)paragraph, (Object)((int)index)));
                    }
                    order = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                    List<Paragraph> $this$indexOfFirst$iv = this.paragraphs;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<Paragraph> $i$f$mapIndexedTo22 = $this$indexOfFirst$iv.iterator();
                    while ($i$f$mapIndexedTo22.hasNext()) {
                        Paragraph item$iv;
                        Paragraph it = item$iv = $i$f$mapIndexedTo22.next();
                        boolean bl4 = false;
                        if (it.getDoc() && !this.docTagIsPriority(it.getText())) {
                            n = index$iv;
                            break block14;
                        }
                        ++index$iv;
                    }
                    n = -1;
                }
                int firstNonPriorityDocTag = n;
                Comparator<List<? extends Paragraph>> comparator2 = new Comparator<List<? extends Paragraph>>((Map<Paragraph, Integer>)order, this, firstNonPriorityDocTag){
                    final /* synthetic */ Map<Paragraph, Integer> $order;
                    final /* synthetic */ ParagraphListBuilder this$0;
                    final /* synthetic */ int $firstNonPriorityDocTag;
                    {
                        this.$order = $order;
                        this.this$0 = $receiver;
                        this.$firstNonPriorityDocTag = $firstNonPriorityDocTag;
                    }

                    public int compare(List<Paragraph> l1, List<Paragraph> l2) {
                        boolean isPriority2;
                        Intrinsics.checkNotNullParameter(l1, (String)"l1");
                        Intrinsics.checkNotNullParameter(l2, (String)"l2");
                        Paragraph p1 = (Paragraph)CollectionsKt.first(l1);
                        Paragraph p2 = (Paragraph)CollectionsKt.first(l2);
                        Integer n = this.$order.get(p1);
                        if (n == null) {
                            String string = "Required value was null.";
                            throw new IllegalStateException(string.toString());
                        }
                        int o1 = ((Number)n).intValue();
                        Integer n2 = this.$order.get(p2);
                        if (n2 == null) {
                            String string = "Required value was null.";
                            throw new IllegalStateException(string.toString());
                        }
                        int o2 = ((Number)n2).intValue();
                        boolean isPriority1 = p1.getDoc() && ParagraphListBuilder.access$docTagIsPriority(this.this$0, p1.getText()) && o1 < this.$firstNonPriorityDocTag;
                        boolean bl = isPriority2 = p2.getDoc() && ParagraphListBuilder.access$docTagIsPriority(this.this$0, p2.getText()) && o2 < this.$firstNonPriorityDocTag;
                        if (UtilitiesKt.isTodo(p1.getText()) != UtilitiesKt.isTodo(p2.getText())) {
                            return UtilitiesKt.isTodo(p1.getText()) ? 1 : -1;
                        }
                        if (p1.getDoc() == p2.getDoc()) {
                            if (p1.getDoc()) {
                                int i2;
                                int i1;
                                int r2;
                                int r1 = ParagraphListBuilder.access$docTagRank(this.this$0, p1.getText(), isPriority1);
                                if (r1 != (r2 = ParagraphListBuilder.access$docTagRank(this.this$0, p2.getText(), isPriority2))) {
                                    return r1 - r2;
                                }
                                List<String> orderedParameterNames = ParagraphListBuilder.access$getTask$p(this.this$0).getOrderedParameterNames();
                                if (!((Collection)orderedParameterNames).isEmpty() && (i1 = sortDocTags.comparator.1.compare$parameterRank(p1, orderedParameterNames)) != (i2 = sortDocTags.comparator.1.compare$parameterRank(p2, orderedParameterNames))) {
                                    return i1 - i2;
                                }
                            }
                            return o1 - o2;
                        }
                        return p1.getDoc() ? 1 : -1;
                    }

                    private static final int compare$parameterRank(Paragraph $this$compare_u24parameterRank, List<String> orderedParameterNames) {
                        int index;
                        String name = UtilitiesKt.getParamName($this$compare_u24parameterRank.getText());
                        if (name != null && (index = orderedParameterNames.indexOf(name)) != -1) {
                            return index;
                        }
                        return 1000;
                    }
                };
                List units = new ArrayList();
                List tag = null;
                for (Paragraph paragraph : this.paragraphs) {
                    if (paragraph.getDoc()) {
                        tag = new ArrayList();
                        units.add(tag);
                    }
                    boolean bl5 = tag != null && !UtilitiesKt.isTodo(paragraph.getText()) ? tag.add(paragraph) : units.add(CollectionsKt.listOf((Object)paragraph));
                }
                CollectionsKt.sortWith((List)units, (Comparator)comparator2);
                Paragraph prev = null;
                this.paragraphs.clear();
                for (Paragraph paragraph : CollectionsKt.flatten((Iterable)units)) {
                    this.paragraphs.add(paragraph);
                    Paragraph paragraph3 = prev;
                    if (paragraph3 != null) {
                        paragraph3.setNext(paragraph);
                    }
                    paragraph.setPrev(prev);
                    prev = paragraph;
                }
            }
        }
    }

    private final void adjustParagraphSeparators() {
        Paragraph prev = null;
        for (Paragraph paragraph : this.paragraphs) {
            paragraph.cleanup();
            String text = paragraph.getText();
            paragraph.setSeparate(prev == null ? false : (paragraph.getPreformatted() && prev.getPreformatted() ? false : (paragraph.getTable() ? paragraph.getSeparate() && (!prev.getBlock() || UtilitiesKt.isKDocTag(prev.getText()) || prev.getTable()) : (paragraph.getSeparator() || prev.getSeparator() ? true : (UtilitiesKt.isLine(text, 1) || UtilitiesKt.isLine(prev.getText(), 1) ? false : (paragraph.getSeparate() && UtilitiesKt.isListItem(paragraph.getText()) ? false : (paragraph.getSeparate() ? true : (paragraph.getDoc() ? !prev.getDoc() : (UtilitiesKt.isDirectiveMarker(text) ? false : (UtilitiesKt.isTodo(text) && !UtilitiesKt.isTodo(prev.getText()) ? true : (UtilitiesKt.isHeader(text) ? true : (paragraph.getPreformatted() ? !(prev.getPreformatted() || StringsKt.startsWith((String)text, (String)"<pre", (boolean)true) || StringsKt.startsWith$default((String)text, (String)"```", (boolean)false, (int)2, null) && UtilitiesKt.isExpectingMore(prev.getText())) : (prev.getPreformatted() && StringsKt.startsWith((String)prev.getText(), (String)"</pre>", (boolean)true) ? false : (paragraph.getContinuation() ? true : (paragraph.getHanging() ? false : (paragraph.getQuoted() ? prev.getQuoted() : (UtilitiesKt.isHeader(text) ? true : (StringsKt.startsWith((String)text, (String)"<p>", (boolean)true) || StringsKt.startsWith((String)text, (String)"<p/>", (boolean)true) ? true : !paragraph.getBlock() && !paragraph.isEmpty()))))))))))))))))));
            if (paragraph.getHanging()) {
                if (paragraph.getDoc() || StringsKt.startsWith((String)text, (String)"<li>", (boolean)true) || UtilitiesKt.isTodo(text)) {
                    paragraph.setHangingIndent(UtilitiesKt.getIndent(this.options.getHangingIndent()));
                } else if (paragraph.getContinuation() && paragraph.getPrev() != null) {
                    Paragraph paragraph2 = paragraph.getPrev();
                    if (paragraph2 == null) {
                        String string = "Required value was null.";
                        throw new IllegalStateException(string.toString());
                    }
                    paragraph.setHangingIndent(paragraph2.getHangingIndent());
                    String s = ((Object)StringsKt.trimStart((CharSequence)paragraph.getText())).toString();
                    StringsKt.clear((StringBuilder)paragraph.getContent());
                    paragraph.getContent().append(s);
                } else {
                    paragraph.setHangingIndent(UtilitiesKt.getIndent(StringsKt.indexOf$default((CharSequence)text, (char)' ', (int)0, (boolean)false, (int)6, null) + 1));
                }
            }
            prev = paragraph;
        }
    }

    private final void adjustIndentation() {
        block10: {
            int firstIndent = this.paragraphs.get(0).getOriginalIndent();
            if (firstIndent > 0) {
                for (Paragraph paragraph : this.paragraphs) {
                    if (paragraph.getOriginalIndent() > firstIndent) continue;
                    paragraph.setOriginalIndent(0);
                }
            }
            Paragraph paragraph = (Paragraph)CollectionsKt.firstOrNull(this.paragraphs);
            boolean inList = paragraph != null ? paragraph.getHanging() : false;
            int startIndent = 0;
            Collection levels = null;
            int n = this.paragraphs.size();
            for (int i = 1; i < n; ++i) {
                Paragraph paragraph2 = this.paragraphs.get(i);
                if (!inList) {
                    if (!paragraph2.getHanging()) continue;
                    inList = true;
                    startIndent = paragraph2.getOriginalIndent();
                    continue;
                }
                if (!paragraph2.getHanging()) {
                    inList = false;
                    continue;
                }
                if (paragraph2.getOriginalIndent() == startIndent) {
                    paragraph2.setOriginalIndent(0);
                    continue;
                }
                if (paragraph2.getOriginalIndent() <= 0) continue;
                Collection collection = levels;
                if (collection == null) {
                    Set set;
                    Set it = set = (Set)new LinkedHashSet();
                    boolean bl = false;
                    levels = it;
                    collection = set;
                }
                collection.add(paragraph2.getOriginalIndent());
            }
            List list = levels;
            if (list == null || (list = CollectionsKt.sorted((Iterable)list)) == null) break block10;
            List sorted = list;
            boolean bl = false;
            Map assignments = new LinkedHashMap();
            int n2 = ((Collection)sorted).size();
            for (int i = 0; i < n2; ++i) {
                assignments.put(sorted.get(i), (i + 1) * this.options.getNestedListIndent());
            }
            for (Paragraph paragraph3 : this.paragraphs) {
                if (paragraph3.getOriginalIndent() <= 0) continue;
                Integer n3 = (Integer)assignments.get(paragraph3.getOriginalIndent());
                if (n3 == null) {
                    continue;
                }
                int assigned = n3;
                paragraph3.setOriginalIndent(assigned);
                paragraph3.setIndent(UtilitiesKt.getIndent(paragraph3.getOriginalIndent()));
            }
        }
    }

    private final void removeBlankParagraphs() {
        for (int i = this.paragraphs.size() - 2; -1 < i; --i) {
            if (!this.paragraphs.get(i).isEmpty() || this.paragraphs.get(i).getPreformatted() && i != this.paragraphs.size() - 1) continue;
            this.paragraphs.remove(i);
            if (i <= 0) continue;
            this.paragraphs.get(i - 1).setNext(null);
        }
    }

    private final void punctuate() {
        if (!this.options.getAddPunctuation() || this.paragraphs.isEmpty()) {
            return;
        }
        Paragraph last = (Paragraph)CollectionsKt.last(this.paragraphs);
        if (last.getPreformatted() || last.getDoc() || last.getHanging() && !last.getContinuation() || last.isEmpty()) {
            return;
        }
        StringBuilder text = last.getContent();
        if (!ParagraphListBuilderKt.startsWithUpperCaseLetter(text)) {
            return;
        }
        for (int i = text.length() - 1; -1 < i; --i) {
            char c = text.charAt(i);
            if (CharsKt.isWhitespace((char)c)) continue;
            if (!Character.isLetterOrDigit(c) && !ParagraphListBuilderKt.isCloseSquareBracket(c)) break;
            text.setLength(i + 1);
            text.append('.');
            break;
        }
    }

    private static final boolean addLines$lambda$1(int n, String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<unused var>");
        return true;
    }

    private static final Unit addLines$lambda$2(int n, Paragraph paragraph) {
        Intrinsics.checkNotNullParameter((Object)paragraph, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final boolean addLines$lambda$3(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<unused var>");
        return false;
    }

    private static final Unit addPreformatted$lambda$4(int n, Paragraph paragraph) {
        Intrinsics.checkNotNullParameter((Object)paragraph, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final boolean addPreformatted$lambda$5(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Paragraph scan$newParagraph(ParagraphListBuilder this$0, String l, String lineWithIndentation, String lineWithoutIndentation, int i) {
        Paragraph paragraph = this$0.newParagraph();
        if (i >= 0 && i < this$0.lines.size()) {
            if (Intrinsics.areEqual((Object)this$0.lines.get(i), (Object)l)) {
                paragraph.setOriginalIndent(lineWithIndentation.length() - lineWithoutIndentation.length());
            } else {
                String line2 = this$0.lineContent(this$0.lines.get(i));
                String trimmed = ((Object)StringsKt.trim((CharSequence)line2)).toString();
                paragraph.setOriginalIndent(line2.length() - trimmed.length());
            }
        }
        return paragraph;
    }

    private static final boolean scan$lambda$6(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.startsWith$default((String)it, (String)" ", (boolean)false, (int)2, null);
    }

    private static final boolean scan$lambda$8(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)it)).toString(), (String)"```", (boolean)false, (int)2, null);
    }

    private static final void scan$lambda$9$handleTag(ParagraphListBuilder this$0, String tag) {
        String text = this$0.paragraph.getText();
        String trimmed = ((Object)StringsKt.trim((CharSequence)text)).toString();
        int index = StringsKt.indexOf$default((CharSequence)text, (String)tag, (int)0, (boolean)true, (int)2, null);
        if (index == -1) {
            return;
        }
        StringsKt.clear((StringBuilder)this$0.paragraph.getContent());
        if (StringsKt.equals((String)trimmed, (String)tag, (boolean)true)) {
            this$0.paragraph.getContent().append("```");
            return;
        }
        String string = text.substring(0, index);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String before = ((Object)StringsKt.trim((CharSequence)StringsKt.replace((String)string, (String)"</code>", (String)"", (boolean)true))).toString();
        if (!StringsKt.isBlank((CharSequence)before)) {
            this$0.paragraph.getContent().append(before);
            this$0.newParagraph();
            this$0.paragraph.setPreformatted(true);
            this$0.paragraph.setAllowEmpty(true);
        }
        this$0.appendText("```");
        String string2 = text.substring(index + tag.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String after = ((Object)StringsKt.trim((CharSequence)StringsKt.replace((String)string2, (String)"<code>", (String)"", (boolean)true))).toString();
        if (!StringsKt.isBlank((CharSequence)after)) {
            this$0.newParagraph();
            this$0.appendText(after);
            this$0.paragraph.setPreformatted(true);
            this$0.paragraph.setAllowEmpty(true);
        }
    }

    private static final Unit scan$lambda$9(ParagraphListBuilder this$0, int n, Paragraph paragraph) {
        Intrinsics.checkNotNullParameter((Object)paragraph, (String)"<unused var>");
        if (this$0.options.getConvertMarkup()) {
            ParagraphListBuilder.scan$lambda$9$handleTag(this$0, "<pre>");
            ParagraphListBuilder.scan$lambda$9$handleTag(this$0, "</pre>");
        }
        return Unit.INSTANCE;
    }

    private static final boolean scan$lambda$10(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.contains((CharSequence)it, (CharSequence)"</pre>", (boolean)true);
    }

    private static final boolean scan$lambda$11(int n, String w, String string) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        return StringsKt.isBlank((CharSequence)w) || UtilitiesKt.isListItem(w) || UtilitiesKt.isKDocTag(w) || UtilitiesKt.isTodo(w) || UtilitiesKt.isDirectiveMarker(w) || UtilitiesKt.isHeader(w);
    }

    private static final Unit scan$lambda$12(int n, Paragraph p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        p.setQuoted(true);
        return Unit.INSTANCE;
    }

    private static final boolean scan$lambda$13(int n, String w, String string) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        return StringsKt.equals((String)w, (String)"</ul>", (boolean)true) || StringsKt.equals((String)w, (String)"</ol>", (boolean)true);
    }

    private static final Unit scan$lambda$14(int n, Paragraph p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        p.setBlock(true);
        return Unit.INSTANCE;
    }

    private static final boolean scan$lambda$15(String w, String string) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        return StringsKt.startsWith((String)w, (String)"<li>", (boolean)true) || StringsKt.startsWith((String)w, (String)"</ul>", (boolean)true) || StringsKt.startsWith((String)w, (String)"</ol>", (boolean)true);
    }

    private static final boolean scan$lambda$16(ParagraphListBuilder this$0, int j, String w, String s) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return StringsKt.isBlank((CharSequence)s) && j < this$0.lines.size() - 1 && StringsKt.startsWith$default((String)this$0.lineContent(this$0.lines.get(j + 1)), (String)" ", (boolean)false, (int)2, null) ? false : StringsKt.isBlank((CharSequence)s) || UtilitiesKt.isListItem(w) || UtilitiesKt.isQuoted(w) || UtilitiesKt.isKDocTag(w) || UtilitiesKt.isTodo(w) || StringsKt.startsWith$default((String)s, (String)"```", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)w, (String)"<pre>", (boolean)false, (int)2, null) || UtilitiesKt.isDirectiveMarker(w) || UtilitiesKt.isLine$default(w, 0, 1, null) || UtilitiesKt.isHeader(w) || s.length() > 2 && (!CharsKt.isWhitespace((char)s.charAt(0)) || !CharsKt.isWhitespace((char)s.charAt(1))) && j < this$0.lines.size() - 1 && StringsKt.isBlank((CharSequence)this$0.lineContent(this$0.lines.get(j - 1)));
    }

    private static final Unit scan$lambda$17(ParagraphListBuilder this$0, int $start, int j, Paragraph p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (StringsKt.isBlank((CharSequence)this$0.lineContent(this$0.lines.get(j))) && j >= $start) {
            p.setHanging(true);
            p.setContinuation(true);
        }
        return Unit.INSTANCE;
    }

    private static final boolean scan$lambda$18(String w, String string) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        return StringsKt.isBlank((CharSequence)w);
    }

    public static final /* synthetic */ String access$lineContent(ParagraphListBuilder $this, String line2) {
        return $this.lineContent(line2);
    }

    public static final /* synthetic */ boolean access$docTagIsPriority(ParagraphListBuilder $this, String tag) {
        return $this.docTagIsPriority(tag);
    }

    public static final /* synthetic */ int access$docTagRank(ParagraphListBuilder $this, String tag, boolean isPriority) {
        return $this.docTagRank(tag, isPriority);
    }

    public static final /* synthetic */ FormattingTask access$getTask$p(ParagraphListBuilder $this) {
        return $this.task;
    }
}

