/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.AtlassianDevMetricsReporter;
import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.github.eirslett.maven.plugins.frontend.mojo.AbstractFrontendMojo;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import java.io.File;
import java.util.Collections;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="pnpm", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public final class PnpmMojo
extends AbstractFrontendMojo {
    private static final String PNPM_REGISTRY_URL = "npmRegistryURL";
    @Parameter(defaultValue="install", property="frontend.pnpm.arguments", required=false)
    private String arguments;
    @Parameter(property="frontend.pnpm.pnpmInheritsProxyConfigFromMaven", required=false, defaultValue="true")
    private boolean pnpmInheritsProxyConfigFromMaven;
    @Parameter(property="npmRegistryURL", required=false, defaultValue="")
    private String pnpmRegistryURL;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private BuildContext buildContext;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;
    @Parameter(property="skip.pnpm", defaultValue="${skip.pnpm}")
    private boolean skip;

    @Override
    protected boolean skipExecution() {
        return this.skip;
    }

    @Override
    public synchronized void execute(FrontendPluginFactory factory) throws Exception {
        File packageJson = new File(this.workingDirectory, "package.json");
        boolean incrementalEnabled = MojoUtils.incrementalBuildEnabled(this.buildContext);
        boolean willBeIncremental = incrementalEnabled && this.buildContext.hasDelta(packageJson);
        AtlassianDevMetricsReporter.incrementExecutionCount((String)this.project.getArtifactId(), (String)this.arguments, (AtlassianDevMetricsReporter.Goal)AtlassianDevMetricsReporter.Goal.PNPM, (String)this.getFrontendMavenPluginVersion(), (boolean)incrementalEnabled, (boolean)willBeIncremental, () -> {
            if (!willBeIncremental) {
                ProxyConfig proxyConfig = this.getProxyConfig();
                factory.getPnpmRunner(proxyConfig, this.getRegistryUrl()).execute(this.arguments, this.environmentVariables);
            } else {
                this.getLog().info((CharSequence)"Skipping pnpm install as package.json unchanged");
            }
        });
    }

    private ProxyConfig getProxyConfig() {
        if (this.pnpmInheritsProxyConfigFromMaven) {
            return MojoUtils.getProxyConfig(this.session, this.decrypter);
        }
        this.getLog().info((CharSequence)"pnpm not inheriting proxy config from Maven");
        return new ProxyConfig(Collections.emptyList());
    }

    private String getRegistryUrl() {
        return System.getProperty(PNPM_REGISTRY_URL, this.pnpmRegistryURL);
    }
}

