/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.reporting;

import com.itextpdf.commons.utils.DateTimeUtil;
import com.itextpdf.commons.utils.EncodingUtil;
import com.itextpdf.commons.utils.FileUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.reporting.DataWithHash;
import com.itextpdf.licensing.base.reporting.ILocalFileServerHelper;
import com.itextpdf.licensing.base.reporting.LicenseKeyReportingConfigurer;
import com.itextpdf.licensing.base.reporting.LocalFileServerHelperKeeper;
import com.itextpdf.licensing.base.reporting.ReportFileData;
import com.itextpdf.licensing.base.reporting.ReportMetadata;
import com.itextpdf.licensing.base.util.JsonMapperUtil;
import com.itextpdf.licensing.base.util.PortingUtils;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.LoggerFactory;

public abstract class AbstractLocalFileServer<T> {
    static final String ERROR_DURING_MD5_HASH_FUNCTION_CREATING = "Exception during MD5 hash function creating: {0}.";
    static final String INVALID_LOCAL_FILE_REPORTING_FILE_SIZE_THRESHOLD = "Invalid file size threshold value. Min: {0}, Max: {1}";
    static final String INVALID_LOCAL_FILE_REPORTING_FILES_AMOUNT_TO_ARCHIVE = "Invalid files amount to archive value. Min: {0}, Max: {1}";
    static final String UUID_PATTERN_GROUP = "([\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12})";
    static final String ARCHIVE_EXTENSION = "zip";
    static final long DEFAULT_FILE_SIZE_THRESHOLD = 0xA00000L;
    static final int DEFAULT_FILES_AMOUNT_TO_ARCHIVE = 10;
    static final long FILE_SIZE_THRESHOLD_MIN = 524288L;
    static final long FILE_SIZE_THRESHOLD_MAX = 0x3200000L;
    static final int FILES_AMOUNT_TO_ARCHIVE_MIN = 1;
    static final int FILES_AMOUNT_TO_ARCHIVE_MAX = 50;
    private final Pattern COMMON_REPORT_FILE_NAME_PATTERN = Pattern.compile(this.constructFileNamePattern("([\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12})"));
    private final Object syncLock = new Object();
    private long fileSizeThreshold = 0xA00000L;
    private int filesAmountToArchive = 10;
    private String currentDirectory = null;
    private String prevHash = null;
    private String sequenceId = null;
    private int fileIndex = 0;
    private String currentFilePath = null;
    private String currentFileNamePattern = null;
    private boolean wroteAfterFileUpdate = false;
    private final String disclaimerReadyToWrite;
    private final String disclaimerWithWarningReadyToWrite;

    protected AbstractLocalFileServer() {
        this.updateConfig();
        this.disclaimerReadyToWrite = "\"" + this.getDisclaimer() + "\"\n";
        this.disclaimerWithWarningReadyToWrite = this.disclaimerReadyToWrite + "\"WARNING: " + "Current file to write has been removed during runtime." + "\"\n";
    }

    public static String calculateHash(String data) {
        byte[] hash;
        if (data == null || data.isEmpty()) {
            return null;
        }
        byte[] encoded = AbstractLocalFileServer.encode(data);
        try {
            hash = PortingUtils.createMd5HashAlgorithm().digest(encoded);
        }
        catch (Exception e) {
            throw new LicenseKeyException(MessageFormatUtil.format((String)ERROR_DURING_MD5_HASH_FUNCTION_CREATING, (Object[])new Object[]{e.getMessage()}));
        }
        return EncodingUtil.toBase64((byte[])hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeData(List<T> dataList) {
        Object object = this.syncLock;
        synchronized (object) {
            String localHash;
            String disclaimer = this.updateCurrentFileBeforeWrite();
            String reportPrefix = null;
            if (disclaimer != null) {
                String reportMetadata = this.createMetadataAsString();
                reportPrefix = reportMetadata + "\n" + disclaimer;
                localHash = AbstractLocalFileServer.calculateHash(reportMetadata);
            } else {
                localHash = this.prevHash;
            }
            DataWithHash<T> usagesWithHash = new DataWithHash<T>(dataList, localHash);
            String rawJson = JsonMapperUtil.serializeToMinimalString(usagesWithHash);
            if (rawJson == null) {
                return false;
            }
            localHash = AbstractLocalFileServer.calculateHash(rawJson);
            String rawString = reportPrefix == null ? rawJson + "\n" : reportPrefix + rawJson + "\n";
            byte[] bytesToWrite = AbstractLocalFileServer.encode(rawString);
            boolean writingSucceed = this.writeBytes(this.currentFilePath, bytesToWrite);
            if (writingSucceed) {
                this.wroteAfterFileUpdate = true;
                this.prevHash = localHash;
            }
            return writingSucceed;
        }
    }

    protected abstract String getDisclaimer();

    protected abstract String getReportFilePrefix();

    protected abstract String getReportFileExtension();

    protected abstract Map<String, Object> calculateSequenceData();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateConfig() {
        Object object = this.syncLock;
        synchronized (object) {
            String localFileRootDir = LicenseKeyReportingConfigurer.getLocalFileRootDir();
            localFileRootDir = PortingUtils.getDirectoryFullPath(localFileRootDir);
            if (!localFileRootDir.equals(this.currentDirectory)) {
                this.currentDirectory = localFileRootDir;
                this.resetSequenceData();
            }
            LoggerFactory.getLogger(this.getClass()).info(MessageFormatUtil.format((String)"License Key Volume reports starts saving into {0}.", (Object[])new Object[]{this.currentDirectory}));
        }
    }

    protected void processMetadata(ReportMetadata metadata) {
    }

    protected void processLine(String json) {
    }

    protected void resetSequenceData() {
        this.setInitialFileData(null, 0, null);
    }

    protected void setNewFileSequenceData() {
        this.setInitialFileData(UUID.randomUUID().toString(), 0, null);
    }

    protected void setContinueSequenceData(String sequenceId, int fileIndex, String prevHash) {
        this.setInitialFileData(sequenceId, fileIndex, prevHash);
    }

    void updateFileRotationConfiguration(long fileSizeThreshold, int filesAmountToArchive) {
        if (fileSizeThreshold < 524288L || fileSizeThreshold > 0x3200000L) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)INVALID_LOCAL_FILE_REPORTING_FILE_SIZE_THRESHOLD, (Object[])new Object[]{524288L, 0x3200000L}));
        }
        if (filesAmountToArchive < 1 || filesAmountToArchive > 50) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)INVALID_LOCAL_FILE_REPORTING_FILES_AMOUNT_TO_ARCHIVE, (Object[])new Object[]{1, 50}));
        }
        this.fileSizeThreshold = fileSizeThreshold;
        this.filesAmountToArchive = filesAmountToArchive;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ReportFileData parseLastReportFile(String filePath) {
        if (filePath == null) {
            return null;
        }
        try (Scanner reader = PortingUtils.createLineReader(filePath, StandardCharsets.UTF_8);){
            ReportMetadata metadata = null;
            String lastLine = null;
            if (!reader.hasNextLine()) throw new LicenseKeyException("Unable to parse empty report file.");
            String firstLine = reader.nextLine();
            metadata = JsonMapperUtil.deserializeReportMetadataFromString(firstLine);
            if (metadata == null) {
                throw new LicenseKeyException("Unable to deserialize metadata from report file.");
            }
            this.processMetadata(metadata);
            lastLine = firstLine;
            boolean isFirstFailProcess = true;
            while (reader.hasNextLine()) {
                String nextLine = reader.nextLine();
                if (nextLine.isEmpty()) continue;
                lastLine = nextLine;
                try {
                    this.processLine(nextLine);
                }
                catch (Exception e) {
                    if (!isFirstFailProcess) continue;
                    isFirstFailProcess = false;
                    LoggerFactory.getLogger(this.getClass()).error(MessageFormatUtil.format((String)"Reading from last file failed. Exception message: \"{0}\".", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                }
            }
            ReportFileData reportFileData = new ReportFileData(metadata, AbstractLocalFileServer.calculateHash(lastLine));
            return reportFileData;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error(MessageFormatUtil.format((String)"Reading from last file failed. Exception message: \"{0}\".", (Object[])new Object[]{e.getMessage()}));
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeBytes(String filePath, byte[] bytesToWrite) {
        try (OutputStream os = PortingUtils.createFileAppendOutputStream(filePath);){
            os.write(bytesToWrite);
            os.flush();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error(MessageFormatUtil.format((String)"Writing to file failed. Exception message: {0}.", (Object[])new Object[]{e.getMessage()}));
            return false;
        }
    }

    private String updateCurrentFileBeforeWrite() {
        if (this.sequenceId == null) {
            boolean isNewFile = this.initSequenceData();
            return isNewFile ? this.disclaimerReadyToWrite : null;
        }
        if (FileUtil.fileExists((String)this.currentFilePath)) {
            if (new File(this.currentFilePath).length() >= this.fileSizeThreshold) {
                this.compressIfRequired();
                while (FileUtil.fileExists((String)this.currentFilePath)) {
                    this.incrementFileIndex();
                }
                return this.disclaimerReadyToWrite;
            }
            return null;
        }
        if (!FileUtil.directoryExists((String)this.currentDirectory)) {
            FileUtil.createDirectories((String)this.currentDirectory);
        }
        if (this.wroteAfterFileUpdate) {
            LoggerFactory.getLogger(this.getClass()).warn("Current file to write has been removed during runtime.");
            return this.disclaimerWithWarningReadyToWrite;
        }
        return this.disclaimerReadyToWrite;
    }

    private String createMetadataAsString() {
        ILocalFileServerHelper helper = LocalFileServerHelperKeeper.getHelper();
        ReportMetadata reportMetadata = new ReportMetadata(helper.getLicenseKeyVersion(), helper.getCurrentTime(), this.calculateSequenceData(), "");
        String localHash = this.prevHash;
        if (localHash == null) {
            String reportMetadataStr = JsonMapperUtil.serializeToMinimalString(reportMetadata);
            if (reportMetadataStr == null) {
                return null;
            }
            localHash = AbstractLocalFileServer.calculateHash(reportMetadataStr + this.sequenceId);
        }
        reportMetadata.setHash(localHash);
        return JsonMapperUtil.serializeToMinimalString(reportMetadata);
    }

    private void compressIfRequired() {
        ArrayList<String> toCompress = new ArrayList<String>(this.filesAmountToArchive);
        String[] files = FileUtil.listFilesInDirectory((String)this.currentDirectory, (boolean)false);
        if (files != null && files.length != 0) {
            for (String file : files) {
                String fileName = new File(file).getName();
                if (!fileName.matches(this.currentFileNamePattern) || file.equals(this.currentFilePath)) continue;
                toCompress.add(file);
            }
        }
        if (toCompress.size() >= this.filesAmountToArchive) {
            String archivePath;
            while (FileUtil.fileExists((String)(archivePath = PortingUtils.constructFileByDirectoryAndName(this.currentDirectory, this.getReportFilePrefix() + this.sequenceId + "_" + DateTimeUtil.getRelativeTime((Date)DateTimeUtil.getCurrentTimeDate()) + "." + ARCHIVE_EXTENSION).getAbsolutePath()))) {
            }
            PortingUtils.compressFiles(toCompress, archivePath);
        }
    }

    private void setInitialFileData(String sequenceId, int fileIndex, String prevHash) {
        this.sequenceId = sequenceId;
        this.fileIndex = fileIndex;
        this.prevHash = prevHash;
        this.updateCurrentFilePath();
        this.currentFileNamePattern = this.constructFileNamePattern(sequenceId);
    }

    private void incrementFileIndex() {
        ++this.fileIndex;
        this.updateCurrentFilePath();
    }

    private void updateCurrentFilePath() {
        this.currentFilePath = this.sequenceId != null ? PortingUtils.constructFileByDirectoryAndName(this.currentDirectory, this.getReportFilePrefix() + this.sequenceId + "_" + this.fileIndex + "." + this.getReportFileExtension()).getAbsolutePath() : null;
        this.wroteAfterFileUpdate = false;
    }

    private boolean initSequenceData() {
        try {
            String[] files = FileUtil.listFilesInDirectory((String)this.currentDirectory, (boolean)false);
            if (files == null || files.length == 0) {
                this.setNewFileSequenceData();
                return true;
            }
            int lastIndex = -1;
            String lastId = null;
            String filePath = null;
            for (String file : files) {
                int currentIndex;
                String fileName = new File(file).getName();
                Matcher matcher = this.COMMON_REPORT_FILE_NAME_PATTERN.matcher(fileName);
                if (!matcher.matches() || lastIndex >= (currentIndex = Integer.parseInt(matcher.group(2)))) continue;
                lastIndex = currentIndex;
                filePath = file;
                lastId = matcher.group(1);
            }
            ReportFileData reportFileData = this.parseLastReportFile(filePath);
            if (reportFileData != null) {
                this.setContinueSequenceData(lastId, lastIndex, reportFileData.getLastHash());
                String licenseKeyVersion = reportFileData.getMetadata().getLicensekeyVersion();
                if (LocalFileServerHelperKeeper.getHelper().getLicenseKeyVersion().equals(licenseKeyVersion)) {
                    return false;
                }
                this.incrementFileIndex();
                return true;
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error(MessageFormatUtil.format((String)"Sequence initialization failed. Exception message: {0}.", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
        }
        this.setNewFileSequenceData();
        return true;
    }

    private String constructFileNamePattern(String idPart) {
        if (idPart == null) {
            return null;
        }
        return "^" + this.getReportFilePrefix() + idPart + "_(\\d+)\\." + this.getReportFileExtension() + "$";
    }

    private static byte[] encode(String toEncode) {
        return toEncode == null ? null : toEncode.getBytes(StandardCharsets.UTF_8);
    }
}

