/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.util;

import java.util.function.Supplier;
import org.slf4j.LoggerFactory;

public class InterruptibleThread
extends Thread {
    private final InterruptibleTask task;

    public InterruptibleThread(InterruptibleTask task) {
        super(task);
        this.task = task;
    }

    @Override
    public void interrupt() {
        this.task.isRunning = false;
    }

    public static class InterruptibleTask
    implements Runnable {
        private volatile boolean isRunning = true;
        private final Runnable task;
        private final Supplier<Long> interval;

        public InterruptibleTask(Runnable task, Supplier<Long> interval) {
            this.task = task;
            this.interval = interval;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Thread.sleep(this.interval.get());
                    if (this.isRunning) {
                        this.task.run();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception any) {
                LoggerFactory.getLogger(this.task.getClass()).error("Unexpected exception encountered in service thread. Shutting it down.", (Throwable)any);
            }
        }
    }
}

