/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.remote.auth;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.cognitoidentity.model.Credentials;
import com.itextpdf.licensing.remote.PortingUtil;
import com.itextpdf.licensing.remote.apigateway.ApiGatewayClient;
import com.itextpdf.licensing.remote.apigateway.ApiGatewayResponse;
import com.itextpdf.licensing.remote.auth.AuthData;
import com.itextpdf.licensing.remote.auth.AuthHelper;
import com.itextpdf.licensing.remote.auth.AwsCredentialsData;
import com.itextpdf.licensing.remote.exceptions.LicenseKeyRemoteException;

public class AwsSdkCredentialsProvider {
    private static final String COGNITO_JWT_PROVIDER = "cognito-identity.amazonaws.com";
    private final Object syncLock = new Object();
    private final ApiGatewayClient apiGatewayClient;
    private final AuthHelper authHelper;
    private volatile AuthData lastObtainedAuthData;
    private volatile AwsCredentialsData lastObtainedCredentials;

    public AwsSdkCredentialsProvider(ApiGatewayClient apiGatewayClient, AuthHelper authHelper) {
        this.apiGatewayClient = apiGatewayClient;
        this.authHelper = authHelper;
    }

    public AwsCredentialsData getCredentialsData() {
        if (this.lastObtainedCredentials == null) {
            this.refresh();
        }
        return this.lastObtainedCredentials;
    }

    public AWSCredentials getCredentials() {
        return this.getCredentialsData().getAwsCredentials();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.syncLock;
        synchronized (object) {
            if (this.lastObtainedAuthData == null) {
                this.refreshAuthData();
            }
            try {
                this.refreshSessionCredentials();
            }
            catch (Exception e) {
                this.refreshAuthData();
                this.refreshSessionCredentials();
            }
        }
    }

    private void refreshAuthData() {
        ApiGatewayResponse response = this.apiGatewayClient.makePostRequest(this.authHelper.getBodyForAuthRequest());
        if (response.getStatus() != 200) {
            throw new LicenseKeyRemoteException("Cannot get authentication data.");
        }
        this.lastObtainedAuthData = this.authHelper.parseAuthData(response.getBody());
    }

    private void refreshSessionCredentials() {
        Credentials credentials = PortingUtil.getAwsCognitoCredentials(this.lastObtainedAuthData, COGNITO_JWT_PROVIDER);
        this.lastObtainedCredentials = new AwsCredentialsData(credentials.getAccessKeyId(), credentials.getSecretKey(), credentials.getSessionToken(), this.lastObtainedAuthData.getRegion());
    }
}

