/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.apply;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.FontSizeTranslator;
import com.itextpdf.tool.xml.css.apply.ChunkCssApplier;
import com.itextpdf.tool.xml.css.apply.MarginMemory;
import com.itextpdf.tool.xml.css.apply.PageSizeContainable;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.Map;

public class XFAChunkCssApplier
extends ChunkCssApplier {
    public XFAChunkCssApplier() {
    }

    public XFAChunkCssApplier(FontProvider fontProvider) {
        super(fontProvider);
    }

    @Override
    public Chunk apply(Chunk c, Tag t, MarginMemory configuration, PageSizeContainable psc, HtmlPipelineContext ctx) {
        String value;
        super.apply(c, t, configuration, psc, ctx);
        if (t.getCSS() != null && "none".equalsIgnoreCase(value = t.getCSS().get("text-decoration"))) {
            c.setUnderline(Float.NaN, Float.NaN);
            c.getAttributes().put("UNDERLINE", null);
        }
        return c;
    }

    @Override
    public Font applyFontStyles(Tag t) {
        String fontName = null;
        String encoding = "Cp1252";
        float size = new FontSizeTranslator().getFontSize(t);
        int style = -1;
        BaseColor color = null;
        Map<String, String> rules = t.getCSS();
        block0: for (Map.Entry<String, String> entry : rules.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("font-weight".equalsIgnoreCase(key)) {
                if (this.isBoldValue(value)) {
                    style = style != -1 ? (style |= 1) : 1;
                    style &= 0xFFFFFF7F;
                    continue;
                }
                style = style != -1 ? (style &= 0xFFFFFFFE) : 0;
                style |= 0x80;
                continue;
            }
            if ("font-style".equalsIgnoreCase(key)) {
                if (value.equalsIgnoreCase("italic")) {
                    style = style != -1 ? (style |= 2) : 2;
                    style &= 0xFFFFFFBF;
                    continue;
                }
                style = style != -1 ? (style &= 0xFFFFFFFD) : 0;
                style |= 0x40;
                continue;
            }
            if ("font-family".equalsIgnoreCase(key)) {
                if (value.contains(",")) {
                    String[] fonts;
                    for (String s : fonts = value.split(",")) {
                        if (this.fontProvider.getFont(s = s.trim(), "Cp1252", false, -1.0f, -1, null).getFamilyname().equalsIgnoreCase("unknown")) continue;
                        fontName = s;
                        continue block0;
                    }
                    continue;
                }
                fontName = value;
                continue;
            }
            if (!"color".equalsIgnoreCase(key)) continue;
            color = HtmlUtilities.decodeColor(value);
        }
        Font f = this.fontProvider.getFont(fontName, encoding, true, size, style, color);
        return f;
    }
}

