/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa;

import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.xtra.xfa.positioner.DrawPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.FieldPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.Positioner;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.tags.XFATemplateTag;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

class XFAFormStateApplier {
    private static final Set<String> TAG_WHITE_LIST = new HashSet<String>(Arrays.asList("subform", "subformSet", "pageSet", "field", "area", "exclGroup", "draw", "pageArea"));
    private Positioner formDomPositioner;
    private XFATemplateTag formDom;

    XFAFormStateApplier(Positioner formDomPositioner, XFATemplateTag formDom) {
        this.formDomPositioner = formDomPositioner;
        this.formDom = formDom;
    }

    void applyFormState() {
        this.applyFormState(this.formDomPositioner, (XFATemplateTag)this.formDom.retrieveChildren().get(0));
    }

    private void applyFormState(Positioner currentPositioner, XFATemplateTag formStateTag) {
        if ("field".equals(formStateTag.getName()) && currentPositioner instanceof FieldPositioner || "draw".equals(formStateTag.getName()) && currentPositioner instanceof DrawPositioner) {
            FormNode floatValueNode;
            FormNode textValueNode;
            FormNode integerValueNode = formStateTag.retrieveChild("value", "integer");
            if (integerValueNode != null && integerValueNode.retrieveValue() != null) {
                currentPositioner.setRawValue(integerValueNode.retrieveValue());
            }
            if ((textValueNode = formStateTag.retrieveChild("value", "text")) != null && textValueNode.retrieveValue() != null) {
                currentPositioner.setRawValue(textValueNode.retrieveValue());
            }
            if ((floatValueNode = formStateTag.retrieveChild("value", "float")) != null && floatValueNode.retrieveValue() != null) {
                currentPositioner.setRawValue(floatValueNode.retrieveValue());
            }
        }
        for (Map.Entry<String, String> attr : formStateTag.retrieveAttributes().entrySet()) {
            if ("presence".equals(attr.getKey())) {
                boolean wasHidden = currentPositioner.isHidden();
                currentPositioner.defineProperty(attr.getKey(), attr.getValue());
                boolean isHidden = currentPositioner.isHidden();
                if (isHidden == wasHidden) continue;
                this.formDomPositioner.setLayoutOutOfDate(true);
                continue;
            }
            if (!"h".equals(attr.getKey())) continue;
            currentPositioner.defineProperty(attr.getKey(), attr.getValue());
        }
        HashMap positionerChildren = new HashMap();
        for (Positioner childPositioner : currentPositioner.getChildren()) {
            TemplateElementDescriptor childDescriptor = new TemplateElementDescriptor(childPositioner);
            if (!positionerChildren.containsKey(childDescriptor)) {
                positionerChildren.put(childDescriptor, new LinkedList());
            }
            ((Queue)positionerChildren.get(childDescriptor)).add(childPositioner);
        }
        for (Tag childStateTag : formStateTag.getChildren()) {
            Queue namePositionerQueue;
            TemplateElementDescriptor childDescriptor;
            if (!(childStateTag instanceof XFATemplateTag) || !TAG_WHITE_LIST.contains((childDescriptor = new TemplateElementDescriptor((XFATemplateTag)childStateTag)).getTagName()) || (namePositionerQueue = (Queue)positionerChildren.get(childDescriptor)) == null || namePositionerQueue.size() <= 0) continue;
            Positioner nextPositioner = (Positioner)namePositionerQueue.poll();
            this.applyFormState(nextPositioner, (XFATemplateTag)childStateTag);
        }
    }

    private static class TemplateElementDescriptor {
        private String tagName;
        private String xfaName;

        public TemplateElementDescriptor(FormNode formNode) {
            String childPositionerTagName;
            String childPositionerName = formNode.retrieveAttribute("name");
            if (childPositionerName == null) {
                childPositionerName = "";
            }
            if ((childPositionerTagName = formNode.retrieveTagName()) == null) {
                childPositionerTagName = "";
            }
            this.tagName = childPositionerTagName;
            this.xfaName = childPositionerName;
        }

        public String getTagName() {
            return this.tagName;
        }

        public String getXfaName() {
            return this.xfaName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplateElementDescriptor that = (TemplateElementDescriptor)o;
            if (this.tagName != null ? !this.tagName.equals(that.tagName) : that.tagName != null) {
                return false;
            }
            return this.xfaName != null ? this.xfaName.equals(that.xfaName) : that.xfaName == null;
        }

        public int hashCode() {
            int result = this.tagName != null ? this.tagName.hashCode() : 0;
            result = 31 * result + (this.xfaName != null ? this.xfaName.hashCode() : 0);
            return result;
        }
    }
}

