/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.tool.xml.xtra.xfa.element.BorderDrawer;
import com.itextpdf.tool.xml.xtra.xfa.element.PositionResult;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class Element {
    protected FormNode elementTag;
    protected XFARectangle elementRec;
    protected final Document document;
    protected Map<String, String> para = new HashMap<String, String>();
    protected Map<String, String> attributes = new HashMap<String, String>();
    protected BorderDrawer borderDrawer;
    protected boolean isDrawElement = false;

    public Element(FormNode elementTag, XFARectangle elementRec, Document document) {
        FormNode para;
        FormNode parentContainer;
        FormNode parent;
        this.elementTag = elementTag;
        this.elementRec = elementRec;
        this.document = document;
        FormNode border = elementTag.retrieveChild("border");
        if (border != null) {
            this.borderDrawer = new BorderDrawer(border);
            if (this.borderDrawer.isEmpty()) {
                this.borderDrawer = null;
            }
        }
        if ((parent = elementTag.retrieveParent()) != null && (parentContainer = parent.retrieveParent()) != null && (para = parentContainer.retrieveChild("para")) != null) {
            this.para = para.retrieveAttributes();
        }
        if (elementTag.retrieveAttributes() != null) {
            this.attributes = elementTag.retrieveAttributes();
        }
    }

    public PositionResult.State draw(PdfContentByte canvas, XFARectangle parentBoundingBox) throws DocumentException, IOException {
        this.drawBorder(canvas, parentBoundingBox);
        return PositionResult.State.FULL_CONTENT;
    }

    public void drawBorder(PdfContentByte canvas, XFARectangle parentBoundingBox) {
        if (this.borderDrawer != null && !this.isDrawElement) {
            XFARectangle rec = this.elementRec.clone();
            this.drawBorder(canvas, rec, parentBoundingBox);
        }
    }

    public void drawBorder(PdfContentByte canvas, XFARectangle rec, XFARectangle parentBoundingBox) {
        if (this.borderDrawer != null && !this.isDrawElement) {
            if (parentBoundingBox != null) {
                float ury = rec.getUry().floatValue();
                ury = Math.min(ury, parentBoundingBox.getUry().floatValue());
                float lly = rec.getUry().floatValue() - rec.getHeight().floatValue();
                lly = Math.max(lly, parentBoundingBox.getUry().floatValue() - parentBoundingBox.getHeight().floatValue());
                float height = ury - lly;
                rec.setUry(Float.valueOf(ury));
                rec.setHeight(Float.valueOf(height));
            }
            this.borderDrawer.draw(canvas, rec);
        }
    }

    public boolean isEmpty() {
        return this.borderDrawer == null || this.borderDrawer.isEmpty();
    }

    public boolean isTagged() {
        return !this.isEmpty();
    }

    public XFARectangle getElementRec() {
        return this.elementRec;
    }

    public PositionResult simulatePosition(XFARectangle parentBoundingBox) throws DocumentException, IOException {
        if (parentBoundingBox != null && this.elementRec.getUry() != null && this.elementRec.getHeight() != null && XFAUtil.lt(this.elementRec.getUry().floatValue() - this.elementRec.getHeight().floatValue(), parentBoundingBox.getUry().floatValue() - parentBoundingBox.getHeight().floatValue())) {
            return new PositionResult(PositionResult.State.NO_CONTENT, this.elementRec);
        }
        return new PositionResult(PositionResult.State.FULL_CONTENT, this.elementRec);
    }

    public void setIsDrawElement(boolean isDrawElement) {
        this.isDrawElement = isDrawElement;
    }

    public void move(float dx, float dy) {
        if (this.elementRec != null) {
            this.elementRec.setLlx(Float.valueOf(this.elementRec.getLlx().floatValue() + dx));
            this.elementRec.setUry(Float.valueOf(this.elementRec.getUry().floatValue() + dy));
        }
    }
}

