/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.tool.xml.xtra.xfa.element.ContentElement;
import com.itextpdf.tool.xml.xtra.xfa.element.Element;
import com.itextpdf.tool.xml.xtra.xfa.element.PositionResult;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import java.io.IOException;
import java.util.Map;

public abstract class UiElement
extends Element {
    protected ContentElement contentElement;
    private float topMargin = 0.0f;
    private float rightMargin = 0.0f;
    private float bottomMargin = 0.0f;
    private float leftMargin = 0.0f;
    protected PositionResult.State positionState = PositionResult.State.NO_CONTENT;
    protected Integer independentRotateAngle;

    public UiElement(FormNode elementTag, XFARectangle elementRec, Document document) {
        super(elementTag, elementRec, document);
        FormNode marginTag = elementTag.retrieveChild("margin");
        if (marginTag != null) {
            float[] borderWidths;
            Map<String, String> margins = marginTag.retrieveAttributes();
            Float topIndent = null;
            Float rightIndent = null;
            Float leftIndent = null;
            Float bottomIndent = null;
            if (null != margins) {
                topIndent = XFAUtil.parseFloatToPt(marginTag.retrieveAttribute("topInset"));
                rightIndent = XFAUtil.parseFloatToPt(marginTag.retrieveAttribute("rightInset"));
                leftIndent = XFAUtil.parseFloatToPt(marginTag.retrieveAttribute("leftInset"));
                bottomIndent = XFAUtil.parseFloatToPt(marginTag.retrieveAttribute("bottomInset"));
            }
            if (this.borderDrawer != null && this.isTextWidget() && (borderWidths = this.borderDrawer.getBorderThicknesses()) != null && borderWidths.length == 4) {
                this.topMargin = borderWidths[0];
                this.rightMargin = borderWidths[1];
                this.bottomMargin = borderWidths[2];
                this.leftMargin = borderWidths[3];
            }
            this.topMargin = null == topIndent ? this.topMargin : topIndent.floatValue();
            this.rightMargin = null == rightIndent ? this.rightMargin : rightIndent.floatValue();
            this.leftMargin = null == leftIndent ? this.leftMargin : leftIndent.floatValue();
            this.bottomMargin = null == bottomIndent ? this.bottomMargin : bottomIndent.floatValue();
        }
    }

    public UiElement(FormNode elementTag, XFARectangle elementRec, Document document, ContentElement contentElement) {
        this(elementTag, elementRec, document);
        this.contentElement = contentElement;
    }

    @Override
    public PositionResult.State draw(PdfContentByte canvas, XFARectangle parentBoundingBox) throws DocumentException, IOException {
        PositionResult.State state = super.draw(canvas, parentBoundingBox);
        if (this.contentElement != null) {
            if (this.independentRotateAngle != null) {
                canvas.saveState();
                canvas.transform(AffineTransform.getRotateInstance(Math.toRadians(this.independentRotateAngle.intValue()), this.elementRec.getLlx().floatValue(), this.elementRec.getUry().floatValue()));
            }
            this.applyMargins(this.elementRec);
            state = this.contentElement.draw(canvas, parentBoundingBox);
            this.unapplyMargins(this.elementRec);
            if (this.independentRotateAngle != null) {
                canvas.restoreState();
            }
        }
        this.positionState = state;
        return this.positionState;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && (this.contentElement == null || this.contentElement.isEmpty());
    }

    @Override
    public boolean isTagged() {
        return this.contentElement != null && this.contentElement.isTagged();
    }

    @Override
    public PositionResult simulatePosition(XFARectangle parentBoundingBox) throws DocumentException, IOException {
        if (this.contentElement != null) {
            return this.contentElement.simulatePosition(parentBoundingBox);
        }
        return super.simulatePosition(parentBoundingBox);
    }

    public void applyMargins(XFARectangle rectangle) {
        if (this.elementTag.retrieveChild("margin") != null) {
            boolean ignoreTopIndent = this.positionState == PositionResult.State.CONTENT_PART || this.positionState == PositionResult.State.FULL_CONTENT;
            XFARectangle.applyMargins(rectangle, ignoreTopIndent ? 0.0f : this.topMargin, this.rightMargin, this.bottomMargin, this.leftMargin, false);
        }
    }

    public void unapplyMargins(XFARectangle rectangle) {
        if (this.elementTag.retrieveChild("margin") != null) {
            boolean ignoreTopIndent = this.positionState == PositionResult.State.CONTENT_PART || this.positionState == PositionResult.State.FULL_CONTENT;
            XFARectangle.applyMargins(rectangle, ignoreTopIndent ? 0.0f : this.topMargin, this.rightMargin, this.bottomMargin, this.leftMargin, true);
        }
    }

    public ContentElement getContentElement() {
        return this.contentElement;
    }

    protected abstract boolean isTextWidget();

    public Integer getIndependentRotateAngle() {
        return this.independentRotateAngle;
    }

    public void setIndependentRotateAngle(Integer independentRotateAngle) {
        this.independentRotateAngle = independentRotateAngle;
    }

    @Override
    public void move(float dx, float dy) {
        super.move(dx, dy);
        if (this.contentElement != null) {
            this.contentElement.move(dx, dy);
        }
    }
}

