/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.pipe;

import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.xtra.xfa.element.PageArea;
import com.itextpdf.tool.xml.xtra.xfa.element.PageSet;
import com.itextpdf.tool.xml.xtra.xfa.js.JsDataGroup;
import com.itextpdf.tool.xml.xtra.xfa.js.JsInstanceManager;
import com.itextpdf.tool.xml.xtra.xfa.js.JsNode;
import com.itextpdf.tool.xml.xtra.xfa.positioner.AreaPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.ContentPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.DrawPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.ExclGroupPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.FieldPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.Positioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.SubFormPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.SubformSetPositioner;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FlattenerContext;
import com.itextpdf.tool.xml.xtra.xfa.tags.DataTag;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.tags.XFATemplateTag;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Scriptable;

public class FormBuilder {
    private XFATemplateTag templateDom;
    private DataTag dataDom;
    private JsNode formNode;
    private JsNode formDom;
    private FlattenerContext flattenerContext;
    private LinkedHashMap<String, String[]> splittedDataRefItems = new LinkedHashMap();
    private LinkedHashMap<XFATemplateTag, XFATemplateTag> bindedParentTags = new LinkedHashMap();
    private LinkedHashMap<String, String> truncatedDataRefs = new LinkedHashMap();
    private List<DataTag> fictiveDataTags = new ArrayList<DataTag>();

    public FormBuilder(XFATemplateTag templateDom, DataTag dataDom, JsNode formNode, FlattenerContext flattenerContext) {
        Tag d;
        this.templateDom = templateDom;
        this.dataDom = dataDom;
        this.formNode = formNode;
        this.flattenerContext = flattenerContext;
        String templateDomName = this.templateDom.getDataRef();
        if (dataDom != null && templateDomName != null && templateDomName.length() > 0 && !templateDomName.equals(dataDom.getName()) && (d = dataDom.getChild(templateDomName, "", true)) != null) {
            this.dataDom = (DataTag)d;
        }
    }

    private String truncDataRef(String dataRef) {
        if (dataRef.endsWith("[*]")) {
            String trunc = this.truncatedDataRefs.get(dataRef);
            if (trunc == null) {
                trunc = dataRef.replace("[*]", "");
                this.truncatedDataRefs.put(dataRef, trunc);
            }
            return trunc;
        }
        return dataRef;
    }

    private DataTag findDataTagInParents(DataTag dataTag, String dataRef) {
        if (dataRef.equals(dataTag.getName())) {
            return dataTag;
        }
        Tag t = dataTag.getParent();
        if (t != null) {
            return this.findDataTagInParents((DataTag)t, dataRef);
        }
        return null;
    }

    private XFATemplateTag getBindedParentTag(XFATemplateTag templateTag, DataTag dataTag) {
        XFATemplateTag bindedParentTag = this.bindedParentTags.get(templateTag);
        if (bindedParentTag == null) {
            DataTag d;
            String dataRef;
            XFATemplateTag tag = templateTag.getParent();
            if (tag == null || "template".equals(tag.getName())) {
                return this.templateDom;
            }
            while (tag != this.templateDom && ((dataRef = tag.getDataRef()) == null || dataRef.length() <= 0 || (d = this.findDataTagInParents(dataTag, dataRef = this.truncDataRef(dataRef))) == null)) {
                tag = tag.getParent();
            }
            bindedParentTag = tag;
            this.bindedParentTags.put(templateTag, bindedParentTag);
        }
        return bindedParentTag;
    }

    private void markDataTagAsUsed(DataTag dataTag, XFATemplateTag templateTag, XFATemplateTag parentTag) {
        if (parentTag == null) {
            parentTag = this.getBindedParentTag(templateTag, dataTag);
        }
        dataTag.addUsedBy(parentTag);
        if (parentTag != templateTag) {
            dataTag.addUsedBy(templateTag);
        }
    }

    private void undoMarkDataTagAsUsed(DataTag dataTag, XFATemplateTag templateTag, XFATemplateTag parentTag) {
        if (parentTag == null) {
            parentTag = this.getBindedParentTag(templateTag, dataTag);
        }
        dataTag.removeUsedBy(parentTag);
        if (parentTag != templateTag) {
            dataTag.removeUsedBy(templateTag);
        }
    }

    private void undoMarkDataTagAsUsed(Positioner positioner) {
        if (positioner.getData() != null) {
            this.undoMarkDataTagAsUsed(this.getFirstNonFicitveParent(positioner.getData()), positioner.getTemplate(), null);
        }
        for (Positioner child : positioner.getChildren()) {
            this.undoMarkDataTagAsUsed(child);
        }
    }

    private int matchFieldsByFullDataRefRecursively(XFATemplateTag templateTag, String fullDataRef) {
        int fieldsCount = 0;
        for (Tag t : templateTag) {
            if (("field".equals(t.getName()) || "exclGroup".equals(t.getName())) && fullDataRef.equals(((XFATemplateTag)t).getFullDataRef())) {
                ++fieldsCount;
                continue;
            }
            if ("subform".equals(t.getName()) || "exclGroup".equals(t.getName())) {
                Tag bindTag = ((XFATemplateTag)t).getBind();
                if (bindTag != null) {
                    Map<String, String> bindTagAttrs = bindTag.getAttributes();
                    String match = bindTagAttrs.get("match");
                    if (!"none".equals(match)) continue;
                    fieldsCount += this.matchFieldsByFullDataRefRecursively((XFATemplateTag)t, fullDataRef);
                    continue;
                }
                if (t.getAttributes().get("name") != null) continue;
                fieldsCount += this.matchFieldsByFullDataRefRecursively((XFATemplateTag)t, fullDataRef);
                continue;
            }
            if (!"subformSet".equals(t.getName()) && !"area".equals(t.getName())) continue;
            fieldsCount += this.matchFieldsByFullDataRefRecursively((XFATemplateTag)t, fullDataRef);
        }
        return fieldsCount;
    }

    public JsNode buildSubForm(XFATemplateTag templateTag, DataTag dataTag, JsNode parentForm) {
        return this.buildSubForm(templateTag, dataTag, parentForm, true);
    }

    public JsNode buildSubForm(XFATemplateTag templateTag, DataTag dataTag, JsNode parentForm, boolean lastSubformInSeries) {
        JsNode formTag;
        String tagName;
        String dataRef = templateTag.getDataRef();
        JsInstanceManager instanceManager = null;
        if (parentForm != null && (instanceManager = parentForm.getInstanceManagerByTemplate(templateTag)) == null) {
            instanceManager = new JsInstanceManager(templateTag, parentForm, this.flattenerContext);
            parentForm.addChild(instanceManager);
            parentForm.addInstanceManagerForTemplate(templateTag, instanceManager);
        }
        if ("subform".equals(templateTag.getName()) || "pageArea".equals(templateTag.getName()) || FormBuilder.isOrderedSubformSet(templateTag)) {
            if (instanceManager != null && instanceManager.getCount() >= instanceManager.getMax() || templateTag.getMinOccur() > templateTag.getMaxOccur()) {
                boolean canSiblingsBeBound = false;
                List<Tag> allSiblingTags = templateTag.getParent().getChildren();
                int indexOfMe = allSiblingTags.indexOf(templateTag);
                if (indexOfMe != -1) {
                    ArrayList<Tag> dList = new ArrayList<Tag>();
                    for (int ind = indexOfMe + 1; ind < allSiblingTags.size(); ++ind) {
                        if (templateTag.getFullDataRef() == null || !templateTag.getFullDataRef().equals(((XFATemplateTag)allSiblingTags.get(ind)).getFullDataRef())) continue;
                        this.getDataList((XFATemplateTag)allSiblingTags.get(ind), (DataTag)dataTag.getParent(), dList);
                        if (dList.size() == 0) continue;
                        canSiblingsBeBound = true;
                        break;
                    }
                }
                if (!canSiblingsBeBound && parentForm instanceof Positioner) {
                    Positioner positioner = (Positioner)parentForm;
                    if (parentForm.getParent() instanceof SubFormPositioner) {
                        instanceManager = ((SubFormPositioner)parentForm.getParent()).getInstanceManagerByTemplate(positioner.getTemplate());
                    }
                    if ((!parentForm.has("name", (Scriptable)parentForm) || positioner.getData() == null || positioner.getData().isFictive()) && instanceManager.getCount() < instanceManager.getMax()) {
                        ArrayList<Tag> dList = new ArrayList<Tag>();
                        this.getDataList(templateTag, (DataTag)dataTag.getParent(), dList);
                        if (dList.size() != 0) {
                            positioner.buildNextInstance = true;
                        }
                    }
                }
                return null;
            }
            if (instanceManager != null) {
                instanceManager.incCount();
            }
        }
        if ((tagName = templateTag.getName()).equalsIgnoreCase("exclGroup")) {
            formTag = new ExclGroupPositioner(templateTag, null, this.flattenerContext, parentForm);
        } else if (tagName.equalsIgnoreCase("area")) {
            formTag = new AreaPositioner(templateTag, null, this.flattenerContext, parentForm);
        } else if (tagName.equalsIgnoreCase("subform")) {
            formTag = new SubFormPositioner(templateTag, null, this.flattenerContext, parentForm);
        } else if (tagName.equalsIgnoreCase("subformSet")) {
            formTag = new SubformSetPositioner(templateTag, null, this.flattenerContext, parentForm);
        } else if (tagName.equals("pageSet")) {
            formTag = new PageSet(templateTag, parentForm, this.flattenerContext);
        } else if (tagName.equals("pageArea")) {
            formTag = new PageArea(templateTag, parentForm, null, this.flattenerContext);
        } else {
            parentForm.addChild(templateTag);
            return null;
        }
        if (formTag instanceof Positioner) {
            if (dataRef == null) {
                ((Positioner)formTag).setData(dataTag);
            } else {
                dataRef = this.truncDataRef(dataRef);
                if (dataTag != null && dataRef.equals(dataTag.getName())) {
                    ((Positioner)formTag).setData(dataTag);
                    this.markDataTagAsUsed(this.getFirstNonFicitveParent(dataTag), templateTag, null);
                }
            }
        }
        if (tagName.equals("subformSet") && ("choice".equals(templateTag.getAttributes().get("relation")) || "unordered".equals(templateTag.getAttributes().get("relation")))) {
            HashSet addedSubforms = new HashSet();
            boolean choiceRelationship = "choice".equals(templateTag.getAttributes().get("relation"));
            if (dataTag != null) {
                block1: for (Tag childDataTag : dataTag) {
                    if (instanceManager.getCount() >= instanceManager.getMax()) break;
                    for (Tag t : templateTag) {
                        if (!"subform".equals(t.getName()) && !"subformSet".equals(t.getName())) continue;
                        JsInstanceManager childInstanceManager = formTag.getInstanceManagerByTemplate(t);
                        if (childInstanceManager != null) {
                            childInstanceManager.resetCount();
                        }
                        ArrayList<Tag> dList = new ArrayList<Tag>();
                        this.getDataList((XFATemplateTag)t, dataTag, dList);
                        if (dList.size() <= 0 || dList.get(0) != childDataTag) continue;
                        this.buildSubformInstance((XFATemplateTag)t, formTag, dataTag, choiceRelationship);
                        addedSubforms.add(t);
                        instanceManager.incCount();
                        continue block1;
                    }
                }
            }
            if ("unordered".equals(templateTag.getAttributes().get("relation"))) {
                for (Tag t : templateTag) {
                    if (!"subform".equals(t.getName()) && !"subformSet".equals(t.getName()) || addedSubforms.contains(t)) continue;
                    addedSubforms.add(t);
                    this.buildSubformInstance((XFATemplateTag)t, formTag, dataTag, false);
                    instanceManager.incCount();
                }
            }
            if (instanceManager.getCount() == 0 && templateTag.getMinOccur() > 0) {
                for (Tag t : templateTag) {
                    JsInstanceManager childInstanceManager = formTag.getInstanceManagerByTemplate(t);
                    if (childInstanceManager != null) {
                        childInstanceManager.resetCount();
                    }
                    if (!"subform".equals(t.getName()) && !"subformSet".equals(t.getName())) continue;
                    this.buildSubformInstance((XFATemplateTag)t, formTag, dataTag, false);
                    instanceManager.incCount();
                    break;
                }
            }
        } else {
            for (Tag t : templateTag) {
                JsInstanceManager childInstanceManager = formTag.getInstanceManagerByTemplate(t);
                if (childInstanceManager != null) {
                    childInstanceManager.resetCount();
                }
                if ("subform".equals(t.getName()) || "subformSet".equals(t.getName()) || "area".equals(t.getName()) || "exclGroup".equals(t.getName()) || "pageSet".equals(t.getName()) || "pageArea".equals(t.getName())) {
                    this.buildSubformInstance((XFATemplateTag)t, formTag, dataTag, false);
                    continue;
                }
                if ("field".equals(t.getName()) || "draw".equals(t.getName())) {
                    FormNode uiElementTag;
                    String uiElementName;
                    FormNode uiTag;
                    XFATemplateTag pTag;
                    ArrayList<Tag> dList = new ArrayList<Tag>();
                    boolean isCheckButtonInsideRadioButtonList = false;
                    XFATemplateTag xFATemplateTag = pTag = dataTag != null ? this.getBindedParentTag((XFATemplateTag)t, dataTag) : null;
                    if (pTag != null && "exclGroup".equals(pTag.getName()) && (uiTag = ((FormNode)((Object)t)).retrieveChild("ui")) != null && uiTag.retrieveChildren() != null && uiTag.retrieveChildren().size() > 0 && (uiElementName = (uiElementTag = uiTag.retrieveChildren().get(0)).retrieveName()).equalsIgnoreCase("checkButton")) {
                        isCheckButtonInsideRadioButtonList = true;
                    }
                    this.getDataList((XFATemplateTag)t, dataTag, dList);
                    if ("field".equals(t.getName()) && dList.size() == 0 && ((XFATemplateTag)t).getMinOccur() > 0) {
                        this.getDataList((XFATemplateTag)t, dataTag, dList, true);
                    }
                    if (!isCheckButtonInsideRadioButtonList && dList.size() > 0) {
                        String tFullDataRef = ((XFATemplateTag)t).getFullDataRef();
                        DataTag d = (DataTag)dList.get(0);
                        String fieldDataRef = ((XFATemplateTag)t).getDataRef();
                        if (((XFATemplateTag)t).getMinOccur() == 0 && (d == null || !this.truncDataRef(fieldDataRef).equals(d.getName()))) continue;
                        JsNode field = this.buildField((XFATemplateTag)t, d, formTag, this.flattenerContext);
                        this.markDataTagAsUsed(this.getFirstNonFicitveParent(d), (XFATemplateTag)t, pTag);
                        formTag.addChild(field);
                        if (dList.size() <= 1 || this.matchFieldsByFullDataRefRecursively(pTag, tFullDataRef) > 1 || !(formTag instanceof Positioner)) continue;
                        ((Positioner)formTag).buildNextInstance = true;
                        continue;
                    }
                    if (((XFATemplateTag)t).getMinOccur() == 0) continue;
                    formTag.addChild(this.buildField((XFATemplateTag)t, null, formTag, this.flattenerContext));
                    continue;
                }
                if (((XFATemplateTag)t).getMinOccur() == 0) continue;
                formTag.addChild(t);
            }
        }
        if (formTag instanceof Positioner && ((Positioner)formTag).buildNextInstance) {
            if (lastSubformInSeries) {
                JsNode newForm = this.buildSubForm(templateTag, dataTag, parentForm);
                if (newForm != null) {
                    formTag.addAfterMe(newForm);
                } else if (parentForm instanceof SubFormPositioner && FormBuilder.isNoneDataRef(((SubFormPositioner)parentForm).getTemplate())) {
                    ((Positioner)parentForm).buildNextInstance = true;
                }
            }
            ((Positioner)formTag).buildNextInstance = false;
        }
        return formTag;
    }

    private DataTag getFirstNonFicitveParent(DataTag tag) {
        while (tag instanceof DataTag && tag.isFictive()) {
            tag = (DataTag)tag.getParent();
        }
        return tag;
    }

    public JsNode addSubformInstance(XFATemplateTag subformTag, JsNode parent, DataTag parentDataTag) {
        JsNode subform = this.buildSubformInstance(subformTag, parent, parentDataTag, true);
        this.splittedDataRefItems.clear();
        this.bindedParentTags.clear();
        return subform;
    }

    public JsNode buildSubformInstance(XFATemplateTag subformTag, JsNode parent, DataTag parentDataTag, boolean onlyOneInstance) {
        int i;
        boolean zeroOccurance = !onlyOneInstance && this.isZeroOccurrance(subformTag);
        ArrayList<Tag> dList = new ArrayList<Tag>();
        boolean continueBinding = this.getDataList(subformTag, parentDataTag, dList);
        int counter = 0;
        int maxOccur = subformTag.getMaxOccur();
        JsNode newForm = null;
        if (dList.size() > 0) {
            for (i = 0; i < dList.size(); ++i) {
                Tag d = (Tag)dList.get(i);
                String tFullDataRef = subformTag.getFullDataRef();
                XFATemplateTag pTag = this.getBindedParentTag(subformTag, parentDataTag);
                newForm = this.buildSubForm(subformTag, (DataTag)d, parent, i == dList.size() - 1);
                if (zeroOccurance && newForm instanceof Positioner && !this.hasNonEmptyDataTag((Positioner)newForm) || newForm == null) continue;
                if (parent != null) {
                    parent.addChild(newForm);
                }
                ++counter;
                if (!(onlyOneInstance || dList.size() > 1 && this.matchFieldsByFullDataRefRecursively(pTag, tFullDataRef) > 1)) {
                    continue;
                }
                break;
            }
        } else {
            DataTag dt;
            DataTag dataTag = dt = continueBinding ? parentDataTag : DataTag.createEmpty();
            if (dList.size() == 0 && !zeroOccurance && !"subformSet".equals(subformTag.getName())) {
                this.getDataList(subformTag, parentDataTag, dList, true);
                if (dList.size() > 0) {
                    dt = (DataTag)dList.get(0);
                }
            }
            int fictiveId = this.fictiveDataTags.size();
            newForm = this.buildSubForm(subformTag, dt, parent);
            if (zeroOccurance && newForm instanceof SubFormPositioner && !this.hasNonEmptyDataTag((Positioner)newForm)) {
                JsInstanceManager instanceManager = (JsInstanceManager)((SubFormPositioner)newForm).getInstanceManager();
                instanceManager.decCount();
                this.undoMarkDataTagAsUsed((SubFormPositioner)newForm);
                int curSize = this.fictiveDataTags.size();
                for (int i2 = fictiveId; i2 < curSize; ++i2) {
                    DataTag fictiveTag = this.fictiveDataTags.get(i2);
                    if (fictiveTag.getParent() != null) {
                        fictiveTag.getParent().getChildren().remove(fictiveTag);
                    }
                    if (fictiveTag.getNode() == null || fictiveTag.getNode().getParent() == null) continue;
                    fictiveTag.getNode().getParent().delete(fictiveTag.getName());
                    int index = fictiveTag.getNode().getParent().getNodes().indexOfCompareReferences(fictiveTag.getNode());
                    if (index == -1) continue;
                    fictiveTag.getNode().getParent().getNodes().delete(index);
                }
            } else if (newForm != null) {
                if (parent != null) {
                    parent.addChild(newForm);
                }
                ++counter;
            }
        }
        for (i = counter; !(i >= Math.max(subformTag.getMinOccur(), subformTag.getInitialOccur()) || counter >= subformTag.getMinOccur() && newForm instanceof Positioner && this.hasNonEmptyDataTag((Positioner)newForm)); ++i) {
            newForm = this.buildSubForm(subformTag, DataTag.createEmpty(), parent);
            if (newForm != null) {
                ++counter;
                if (parent != null) {
                    parent.addChild(newForm);
                }
            }
            if (onlyOneInstance) break;
        }
        if (newForm instanceof PageArea && maxOccur < Integer.MAX_VALUE) {
            ((PageArea)newForm).setMaxOccur(maxOccur);
        }
        return newForm;
    }

    private void removeFictiveDataRecursively(DataTag dataTag) {
        ArrayList<Tag> newChildren = new ArrayList<Tag>();
        for (Tag t : dataTag) {
            if (((DataTag)t).isFictive()) {
                if (dataTag.getNode() == null) continue;
                dataTag.getNode().delete(t.getName());
                continue;
            }
            this.removeFictiveDataRecursively((DataTag)t);
            newChildren.add(t);
        }
        if (newChildren.size() != dataTag.getChildren().size()) {
            dataTag.getChildren().clear();
            dataTag.getChildren().addAll(newChildren);
        }
    }

    private boolean isZeroOccurrance(XFATemplateTag subformTag) {
        String dataRef = subformTag.getDataRef();
        Integer minOccur = subformTag.getMinOccur();
        return dataRef != null && minOccur == 0;
    }

    private boolean isZeroOccurranceRecursively(XFATemplateTag subformTag) {
        if (this.isZeroOccurrance(subformTag)) {
            return true;
        }
        XFATemplateTag parent = subformTag.getParent();
        return parent != null && this.isZeroOccurrance(parent);
    }

    public static boolean isNoneDataRef(XFATemplateTag tag) {
        FormNode bindNode = tag.retrieveChild("bind");
        return bindNode != null && "none".equals(bindNode.retrieveAttribute("match"));
    }

    private boolean hasNonEmptyDataTag(Positioner formTag) {
        FormNode bind;
        boolean isGlobalData;
        boolean bl = isGlobalData = formTag.getData() != null && !formTag.getData().isFictive() && formTag.getTemplate() != null && (bind = formTag.getTemplate().retrieveChild("bind")) != null && "global".equals(bind.retrieveAttribute("match"));
        if (!isGlobalData && formTag.getData() != null && !formTag.getData().isFictive() && formTag.getTemplate() != null && formTag instanceof FieldPositioner) {
            DataTag dataTag = formTag.getData();
            XFATemplateTag template = formTag.getTemplate();
            return !formTag.getData().isUsedByAnyoneExcept(template, this.getBindedParentTag(template, dataTag)) || !this.isZeroOccurranceRecursively(formTag.getTemplate());
        }
        if (!isGlobalData && formTag.getData() != null && !formTag.getData().isFictive() && formTag.getTemplate() != null && formTag.getTemplate().getDataRef() != null && !FormBuilder.isNoneDataRef(formTag.getTemplate()) && this.truncDataRef(formTag.getTemplate().getDataRef()).equals(formTag.getData().getName())) {
            return true;
        }
        for (Positioner t : formTag.getChildren()) {
            if (!this.hasNonEmptyDataTag(t)) continue;
            return true;
        }
        return false;
    }

    private JsNode buildField(XFATemplateTag templateTag, DataTag dataTag, JsNode parentForm, FlattenerContext flattenerContext) {
        String canonizationPattern;
        List<String> content;
        Tag pictureTag;
        Tag bindTag = templateTag.getBind();
        if (bindTag != null && dataTag != null && (pictureTag = bindTag.getChild("picture", "")) instanceof XFATemplateTag && (content = ((XFATemplateTag)pictureTag).getContent()) != null && (canonizationPattern = ((XFATemplateTag)pictureTag).getContent().get(0)) != null && !canonizationPattern.isEmpty() && dataTag.getCanonizationPattern() == null) {
            dataTag.setCanonizationPattern(canonizationPattern);
        }
        ContentPositioner formTag = "field".equals(templateTag.getName()) ? new FieldPositioner(templateTag, dataTag, parentForm, flattenerContext) : new DrawPositioner(templateTag, null, flattenerContext, parentForm);
        for (Tag childTag : templateTag) {
            formTag.addChild(childTag);
        }
        return formTag;
    }

    public JsNode getFormDom() {
        if (this.formDom == null) {
            this.formDom = this.buildSubForm(this.templateDom, this.dataDom, this.formNode);
            this.splittedDataRefItems.clear();
            this.bindedParentTags.clear();
        }
        return this.formDom;
    }

    private boolean getDataList(XFATemplateTag templateTag, DataTag dataTag, List<Tag> returnDataList) {
        return this.getDataList(templateTag, dataTag, returnDataList, false);
    }

    private boolean getDataList(XFATemplateTag templateTag, DataTag dataTag, List<Tag> returnDataList, boolean createIfNotExist) {
        String[] dataStructure = null;
        ArrayList<Tag> dList = new ArrayList<Tag>();
        String dataRef = null;
        boolean bindByName = true;
        boolean skipBinding = "area".equals(templateTag.getName());
        boolean globalReference = false;
        if (dataTag != null && !skipBinding) {
            Tag bindTag;
            boolean somExpression = false;
            String templateTagName = templateTag.retrieveAttribute("name");
            if (templateTagName != null && templateTagName.length() > 0) {
                dataRef = templateTagName;
            }
            if ((bindTag = templateTag.getBind()) != null) {
                bindByName = false;
                Map<String, String> bindTagAttrs = bindTag.getAttributes();
                String match = bindTagAttrs.get("match");
                if ("dataRef".equals(match)) {
                    String ref = bindTagAttrs.get("ref");
                    if (ref != null && ref.length() > 0) {
                        somExpression = true;
                        dataRef = ref;
                        if (dataRef.startsWith("$record")) {
                            dataRef = dataRef.substring(1 + "record".length());
                            while (dataTag.getParent() != null) {
                                dataTag = (DataTag)dataTag.getParent();
                            }
                        } else if (dataRef.startsWith("$data")) {
                            if (templateTag.getParent() != null && templateTag.getParent().getFullDataRef() != null && dataRef.startsWith(templateTag.getParent().getFullDataRef())) {
                                dataRef = dataRef.substring(templateTag.getParent().getFullDataRef().length());
                            } else {
                                dataRef = dataRef.substring(1 + "data".length());
                                dataTag = this.dataDom;
                            }
                        } else if (dataRef.startsWith("$")) {
                            dataRef = dataRef.substring(1);
                        } else if (dataRef.startsWith("!")) {
                            dataRef = dataRef.substring(1);
                        } else if (dataRef.startsWith(String.format("%s.%s.", "xfa", "datasets"))) {
                            dataRef = dataRef.substring("xfa".length() + 1 + "datasets".length() + 1);
                        }
                    }
                } else if ("global".equals(match)) {
                    globalReference = true;
                } else if ("none".equals(match)) {
                    dataRef = null;
                    skipBinding = true;
                } else if (dataRef != null && dataRef.length() > 0) {
                    dataRef = dataRef + "[*]";
                }
            } else if (dataRef != null && dataRef.length() > 0) {
                dataRef = dataRef + "[*]";
            }
            if (globalReference) {
                Tag d = null;
                if (this.dataDom != null) {
                    d = this.dataDom.getChild(dataRef, "", true);
                }
                if (d != null) {
                    dList.add(d);
                }
            } else if (dataRef != null && dataRef.length() > 0) {
                if (dataRef.startsWith(".")) {
                    dataRef = dataRef.replaceFirst(".", "");
                }
                dataStructure = somExpression ? dataRef.split("\\.") : new String[]{dataRef};
                this.fillDataList(dList, dataStructure, 0, dataTag, createIfNotExist);
            }
        }
        if (dataRef != null) {
            XFATemplateTag pTag = this.getBindedParentTag(templateTag, dataTag);
            int dListSize = dList.size();
            for (int i = 0; i < dListSize; ++i) {
                Tag initialTag = (Tag)dList.get(i);
                DataTag d = this.getFirstNonFicitveParent((DataTag)initialTag);
                if (!d.isUsedBy(pTag)) {
                    returnDataList.add(initialTag);
                    continue;
                }
                if (!dataRef.contains("[*]")) {
                    returnDataList.add(initialTag);
                    continue;
                }
                if (d.isUsedBy(templateTag) || dataRef.endsWith("[*]")) continue;
                boolean usedByNeighbor = false;
                for (Tag neighborTag : templateTag.getParent().getChildren()) {
                    if (!d.isUsedBy((XFATemplateTag)neighborTag)) continue;
                    usedByNeighbor = true;
                    break;
                }
                if (usedByNeighbor) continue;
                returnDataList.add(initialTag);
            }
        }
        return returnDataList.size() != 0 || bindByName || skipBinding;
    }

    private DataTag getChildDataTag(DataTag dataTag, String name, int index, boolean recursively) {
        if (dataTag == null) {
            return null;
        }
        Tag d1 = null;
        List<Tag> children = dataTag.getChildren(name);
        if (children != null && children.size() > index) {
            d1 = children.get(index);
        }
        if (d1 == null && recursively) {
            if (name.equals(dataTag.getName()) || dataTag.isFictive()) {
                return null;
            }
            return this.getChildDataTag((DataTag)dataTag.getParent(), name, index, true);
        }
        return (DataTag)d1;
    }

    private void fillDataList(List<Tag> dataList, String[] dataStructure, int dataStructureIndex, DataTag dataTag) {
        this.fillDataList(dataList, dataStructure, dataStructureIndex, dataTag, false);
    }

    private void fillDataList(List<Tag> dataList, String[] dataStructure, int dataStructureIndex, DataTag dataTag, boolean createIfNotExist) {
        if (dataStructureIndex < dataStructure.length) {
            DataTag d1;
            String dataRefItem = dataStructure[dataStructureIndex];
            String[] splittedDataRefItem = this.getSplittedDataRefItem(dataRefItem);
            int index = 0;
            if (!"*".equals(splittedDataRefItem[1])) {
                try {
                    index = Integer.parseInt(splittedDataRefItem[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((d1 = this.getChildDataTag(dataTag, dataRefItem = splittedDataRefItem[0], index, false)) == null && dataStructureIndex < 2 && !dataRefItem.equals(dataTag.getName())) {
                d1 = this.getChildDataTag((DataTag)dataTag.getParent(), dataRefItem, index, true);
            }
            if (d1 == null) {
                int dataListSize = dataList.size();
                this.fillDataList(dataList, dataStructure, dataStructureIndex + 1, dataTag, createIfNotExist);
                if (dataList.size() == dataListSize && createIfNotExist && this.isValidToCreateDataNode(dataTag, dataRefItem)) {
                    DataTag newDataTag = new DataTag(dataRefItem);
                    newDataTag.setFictive();
                    this.fictiveDataTags.add(newDataTag);
                    dataTag.addChild(newDataTag);
                    if (dataTag.getNode() != null) {
                        JsDataGroup newDataGroup = new JsDataGroup(newDataTag, dataTag.getNode());
                        newDataTag.setNode(newDataGroup);
                        newDataGroup.defineProperty("value", null);
                        dataTag.getNode().addChild(newDataGroup);
                    }
                    if ((d1 = this.getChildDataTag(dataTag, dataRefItem, index, false)) != null) {
                        if (dataStructureIndex == dataStructure.length - 1) {
                            dataList.add(d1);
                            return;
                        }
                        this.fillDataList(dataList, dataStructure, dataStructureIndex + 1, d1, createIfNotExist);
                        return;
                    }
                }
            } else {
                Tag d2 = d1.getParent();
                List<Tag> dl = d2.getChildren(splittedDataRefItem[0]);
                int dlSize = dl.size();
                if (dlSize > 0) {
                    if ("*".equals(splittedDataRefItem[1])) {
                        if (dataStructureIndex == dataStructure.length - 1) {
                            for (Tag d : dl) {
                                dataList.add(d);
                            }
                        } else {
                            for (Tag d : dl) {
                                this.fillDataList(dataList, dataStructure, dataStructureIndex + 1, (DataTag)d);
                            }
                        }
                    } else {
                        DataTag d = dlSize > index ? (DataTag)dl.get(index) : (DataTag)dl.get(dlSize - 1);
                        if (dataStructureIndex == dataStructure.length - 1) {
                            dataList.add(d);
                        } else {
                            this.fillDataList(dataList, dataStructure, dataStructureIndex + 1, d, createIfNotExist);
                        }
                    }
                }
            }
        }
    }

    private boolean isValidToCreateDataNode(DataTag dataTag, String dataRefItem) {
        if (dataTag.getNode() != null && dataTag.getNode().getProtoTemplate() != null) {
            LinkedList<Tag> search = new LinkedList<Tag>();
            search.addAll(dataTag.getNode().getProtoTemplate().getChildren());
            while (!search.isEmpty()) {
                Tag currentTag = (Tag)search.poll();
                if (currentTag.getName().equals(dataRefItem)) {
                    if (currentTag.getParent().getName().equals("group") && currentTag.getParent().getNameSpace().equals("dd") && "choice".equals(currentTag.getParent().getAttributes().get("dd:model"))) {
                        boolean anythingOccurred = false;
                        for (Tag sibling : currentTag.getParent().getChildren()) {
                            if (dataTag.getChild(sibling.getName(), "") == null) continue;
                            anythingOccurred = true;
                        }
                        return !anythingOccurred;
                    }
                    return true;
                }
                if (!currentTag.getName().equals("group") || !currentTag.getNameSpace().equals("dd")) continue;
                search.addAll(currentTag.getChildren());
            }
            return false;
        }
        return true;
    }

    private String[] getSplittedDataRefItem(String dataRefItem) {
        String[] splittedDataRefItem = this.splittedDataRefItems.get(dataRefItem);
        if (splittedDataRefItem == null) {
            splittedDataRefItem = FormBuilder.splitDataRefItem(dataRefItem);
            this.splittedDataRefItems.put(dataRefItem, splittedDataRefItem);
        }
        return splittedDataRefItem;
    }

    public static String[] splitDataRefItem(String dataRefItem) {
        String[] result = new String[]{"", ""};
        boolean parseIndex = false;
        for (int i = 0; i < dataRefItem.length(); ++i) {
            char c = dataRefItem.charAt(i);
            if (c == '[') {
                parseIndex = true;
                continue;
            }
            if (c == ']') {
                parseIndex = false;
                continue;
            }
            if (parseIndex) {
                result[1] = result[1] + c;
                continue;
            }
            result[0] = result[0] + c;
        }
        if (result[1].length() == 0) {
            result[1] = "0";
        }
        return result;
    }

    private static boolean isOrderedSubformSet(XFATemplateTag tag) {
        String relation = tag.getAttributes().get("relation");
        return (relation == null || "ordered".equals(relation)) && "subformSet".equals(tag.getName());
    }
}

