/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.positioner;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.codec.Base64;
import com.itextpdf.text.pdf.interfaces.IAccessibleElement;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.xtra.xfa.XFALocale;
import com.itextpdf.tool.xml.xtra.xfa.element.ArcElement;
import com.itextpdf.tool.xml.xtra.xfa.element.BarcodeElement;
import com.itextpdf.tool.xml.xtra.xfa.element.ButtonElement;
import com.itextpdf.tool.xml.xtra.xfa.element.CaptionElement;
import com.itextpdf.tool.xml.xtra.xfa.element.CheckButtonElement;
import com.itextpdf.tool.xml.xtra.xfa.element.ChoiceListElement;
import com.itextpdf.tool.xml.xtra.xfa.element.CombElement;
import com.itextpdf.tool.xml.xtra.xfa.element.ContentElement;
import com.itextpdf.tool.xml.xtra.xfa.element.ImageEditElement;
import com.itextpdf.tool.xml.xtra.xfa.element.ImageElement;
import com.itextpdf.tool.xml.xtra.xfa.element.LineElement;
import com.itextpdf.tool.xml.xtra.xfa.element.PageArea;
import com.itextpdf.tool.xml.xtra.xfa.element.PositionResult;
import com.itextpdf.tool.xml.xtra.xfa.element.RectangleElement;
import com.itextpdf.tool.xml.xtra.xfa.element.SignatureElement;
import com.itextpdf.tool.xml.xtra.xfa.element.TextEditElement;
import com.itextpdf.tool.xml.xtra.xfa.element.TextElement;
import com.itextpdf.tool.xml.xtra.xfa.element.UiElement;
import com.itextpdf.tool.xml.xtra.xfa.js.JsDataValue;
import com.itextpdf.tool.xml.xtra.xfa.js.JsNode;
import com.itextpdf.tool.xml.xtra.xfa.positioner.FieldPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.Positioner;
import com.itextpdf.tool.xml.xtra.xfa.resolver.ConfigResolver;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FlattenerContext;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FormatResolver;
import com.itextpdf.tool.xml.xtra.xfa.tags.DataTag;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.tags.XFATemplateTag;
import com.itextpdf.tool.xml.xtra.xfa.util.PdfCanvasForInvisibleElements;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ContentPositioner
extends Positioner {
    private static final Set<String> ALLOWED_UI_ELEMENTS = new HashSet<String>(Arrays.asList("textEdit", "numericEdit", "dateTimeEdit", "passwordEdit", "imageEdit", "checkButton", "choiceList", "button", "signature", "barcode"));
    protected final Document document;
    protected UiElement uiElement;
    protected List<UiElement> uiElements;
    protected ContentElement contentElement;
    protected CaptionElement captionElement;
    protected String inputParsingPattern = null;
    protected Integer originalNumberOfFractionalDigitsInRawValue;

    public ContentPositioner(XFATemplateTag templateTag, DataTag dataTag, FlattenerContext flattenerContext, JsNode parent) {
        super(templateTag, dataTag, flattenerContext, parent);
        this.document = flattenerContext.getDocument();
        this.initValues();
    }

    @Override
    public Positioner checkOverflowing(XFARectangle parentBoundingBox, PageArea currentPageArea, boolean breakableStatus, float bottomMargin) {
        return this.checkOverflowing(parentBoundingBox, currentPageArea, breakableStatus, true);
    }

    public Positioner checkOverflowing(XFARectangle parentBoundingBox, PageArea currentPageArea, boolean breakableStatus, boolean checkBreakable) {
        if (!this.isVisible() && !this.isInvisible()) {
            return null;
        }
        if (breakableStatus && !this.isCurrentPageContentAreaOverflowed(currentPageArea) && parentBoundingBox != null) {
            float height;
            float contentAreaBottom = parentBoundingBox.getUry().floatValue() - parentBoundingBox.getHeight().floatValue();
            Positioner nextBreakablePositioner = this.findNextBreakableElement();
            XFARectangle rec = nextBreakablePositioner.getBBox();
            float f = height = rec.getHeight() != null ? rec.getHeight().floatValue() : 0.0f;
            if (rec.getUry().floatValue() - height - contentAreaBottom < -0.1f) {
                if (nextBreakablePositioner == this) {
                    if (!checkBreakable || !this.isBreakable() || rec.getUry().floatValue() - contentAreaBottom < -0.1f) {
                        return this;
                    }
                    XFARectangle childBoundingBox = parentBoundingBox.clone();
                    this.applyMargins(childBoundingBox);
                    this.applyTransformationToRectangle(childBoundingBox, true);
                    if (this.simulatePosition(childBoundingBox).getState() == PositionResult.State.NO_CONTENT) {
                        return this;
                    }
                } else {
                    Positioner overflowPositioner = nextBreakablePositioner.checkOverflowing(parentBoundingBox, currentPageArea, breakableStatus, 0.0f);
                    if (overflowPositioner != null) {
                        return this;
                    }
                    if (!checkBreakable) {
                        rec = this.getBBox();
                        float f2 = height = rec.getHeight() != null ? rec.getHeight().floatValue() : 0.0f;
                        if (rec.getUry().floatValue() - height - contentAreaBottom < -0.1f) {
                            return this;
                        }
                    }
                }
            }
            if (!this.isBreakable() && this.contentArea != null && this.contentArea.getHeight() != null && this.contentArea.getUry().floatValue() - this.contentArea.getHeight().floatValue() - contentAreaBottom < -0.1f) {
                return this;
            }
        }
        return null;
    }

    @Override
    protected Positioner findNextBreakableElement(int startFrom) {
        Positioner nextPositioner = super.findNextBreakableElement(startFrom);
        if (nextPositioner == this && this.parent != null) {
            int childrenNumber;
            int nextIndex;
            String parentLayout = this.parent.getLayout();
            if ("position".equals(parentLayout) && (nextIndex = startFrom) < (childrenNumber = this.parent.getChildren().size())) {
                nextPositioner = this.parent.getChildren().get(nextIndex);
                while (nextPositioner.isHidden() || nextPositioner.isInactive()) {
                    if (++nextIndex < childrenNumber) {
                        nextPositioner = this.parent.getChildren().get(nextIndex);
                        continue;
                    }
                    nextPositioner = null;
                    break;
                }
                if (nextPositioner instanceof ContentPositioner) {
                    XFARectangle bbox = this.getBBox();
                    XFARectangle neighborBbox = nextPositioner.getBBox();
                    float lly = bbox.getUry().floatValue() - bbox.getHeight().floatValue();
                    float neighborLly = neighborBbox.getUry().floatValue() - neighborBbox.getHeight().floatValue();
                    if (XFAUtil.gte(bbox.getUry().floatValue(), neighborLly) && XFAUtil.lte(lly, neighborBbox.getUry().floatValue())) {
                        return nextPositioner.findNextBreakableElement();
                    }
                }
            }
            return this;
        }
        return nextPositioner;
    }

    @Override
    public Positioner position(PdfContentByte canvas, XFARectangle parentBoundingBox, PageArea currentPageArea, boolean breakableStatus, float bottomMargin) throws DocumentException, IOException {
        Positioner oveflowPositioner;
        if (this.isInvisible() && !(canvas instanceof PdfCanvasForInvisibleElements)) {
            canvas = new PdfCanvasForInvisibleElements(this.flattenerContext);
        }
        if ((oveflowPositioner = this.checkOverflowing(parentBoundingBox, currentPageArea, breakableStatus, false)) != null) {
            if (oveflowPositioner == this && this.isBreakable() && !this.isEmpty()) {
                Positioner nextBreakableElement = this.findNextBreakableElement();
                float contentAreaBottom = parentBoundingBox.getUry().floatValue() - parentBoundingBox.getHeight().floatValue();
                if (nextBreakableElement != this && PositionResult.State.FULL_CONTENT == this.simulatePosition(parentBoundingBox.clone()).getState() && !nextBreakableElement.isBreakable() && nextBreakableElement.doesNotFitContentArea(bottomMargin, contentAreaBottom)) {
                    this.addOverflowedPageContentArea(currentPageArea);
                } else {
                    PositionResult.State state = this.position(canvas, parentBoundingBox);
                    if (state == PositionResult.State.NO_CONTENT) {
                        this.addOverflowedPageContentArea(currentPageArea);
                    }
                }
            } else {
                oveflowPositioner.addOverflowedPageContentArea(currentPageArea);
            }
            return this;
        }
        if (this.isEmpty()) {
            return null;
        }
        this.flattenerContext.setCurrentNode(this);
        this.drawBorder(canvas, parentBoundingBox);
        this.savePosState(canvas);
        if (this.captionElement != null) {
            this.captionElement.draw(canvas, null);
        }
        if (this.uiElement != null) {
            if (canvas.isTagged() && this.uiElement instanceof CheckButtonElement && canvas.getPdfWriter().getCurrentPageNumber() == this.flattenerContext.getCurrentPageNumber().intValue()) {
                ((CheckButtonElement)this.uiElement).drawAsField(canvas, null, this.captionElement != null && this.captionElement.getCaptionText() != null ? this.captionElement.getCaptionText() : this.retrieveName(), ((String)this.getSomExpression()).replaceFirst("xfa\\[0\\]\\.form\\[0\\]\\.", ""));
            } else {
                this.uiElement.draw(canvas, null);
            }
        }
        if (this.uiElements != null) {
            for (UiElement uiEl : this.uiElements) {
                uiEl.draw(canvas, null);
            }
        }
        if (this.contentElement != null) {
            this.contentElement.draw(canvas, null);
        }
        this.restorePosState(canvas);
        this.flattenerContext.setCurrentNode(this.parent);
        this.positionState = PositionResult.State.FULL_CONTENT;
        this.updatePageNumbers();
        return null;
    }

    @Override
    protected void adjustContentArea() {
        ArrayList<XFARectangle> rectangles = new ArrayList<XFARectangle>();
        XFARectangle contentRect = this.getContentRect();
        if (contentRect != null) {
            XFARectangle.setUndefinedSizes(contentRect);
            rectangles.add(contentRect);
            if (this.captionElement != null) {
                this.captionElement.fixCaptionAreaByContentArea(contentRect);
            }
        } else {
            XFARectangle.setUndefinedSizes(this.contentArea);
            rectangles.add(this.contentArea);
            if (this.captionElement != null) {
                this.captionElement.fixCaptionAreaByParentArea(this.contentArea);
            }
        }
        CaptionElement caption = this.getCaption();
        XFARectangle captionRec = null;
        if (caption != null) {
            captionRec = caption.getElementRec();
        }
        if (captionRec != null) {
            rectangles.add(captionRec);
        }
        this.contentArea = XFARectangle.getCommonRectangle(rectangles);
    }

    @Override
    public boolean isEmpty() {
        return !this.isBackgroundOrBorderExist() && this.isEmpty;
    }

    @Override
    protected void initLayout() {
        super.initLayout();
        this.flattenerContext.setCurrentNode(this);
        this.createCaptionElement();
        this.createContentElement();
        this.isEmpty = !(this.isBackgroundOrBorderExist() || this.captionElement != null && !this.captionElement.isEmpty() || this.uiElement != null && (this.uiElement instanceof ImageEditElement || !this.uiElement.isEmpty()) || this.uiElements != null || this.contentElement != null && !this.contentElement.isEmpty());
        this.isContentTagged = this.captionElement != null && this.captionElement.isTagged() || this.uiElement != null && this.uiElement.isTagged() || this.uiElements != null || this.contentElement != null && this.contentElement.isTagged();
        this.isTagged = this.isContentTagged && (this.role != PdfName.DIV || this.captionElement != null && this.captionElement.isTagged());
        this.flattenerContext.setCurrentNode(this.parent);
    }

    public PositionResult.State position(PdfContentByte canvas, XFARectangle parentBoundingBox) throws DocumentException, IOException {
        XFARectangle childBoundingBox = null;
        Float bottomBorder = null;
        if (parentBoundingBox != null) {
            childBoundingBox = parentBoundingBox.clone();
            this.applyTransformationToRectangle(childBoundingBox, true);
            bottomBorder = Float.valueOf(childBoundingBox.getUry().floatValue() - childBoundingBox.getHeight().floatValue());
            this.applyMargins(childBoundingBox);
            if (this.simulatePosition(childBoundingBox).getState() == PositionResult.State.NO_CONTENT) {
                return PositionResult.State.NO_CONTENT;
            }
        }
        this.drawBorder(canvas, parentBoundingBox);
        this.savePosState(canvas);
        if (this.captionElement != null) {
            this.captionElement.draw(canvas, null);
        }
        this.captionElement = null;
        XFARectangle elementRect = null;
        this.positionState = PositionResult.State.FULL_CONTENT;
        if (this.uiElement != null) {
            this.positionState = canvas.isTagged() && this.uiElement instanceof CheckButtonElement && canvas.getPdfWriter().getCurrentPageNumber() == this.flattenerContext.getCurrentPageNumber().intValue() ? ((CheckButtonElement)this.uiElement).drawAsField(canvas, null, this.captionElement != null && this.captionElement.getCaptionText() != null ? this.captionElement.getCaptionText() : this.retrieveName(), ((String)this.getSomExpression()).replaceFirst("xfa\\[0\\]\\.form\\[0\\]\\.", "")) : this.uiElement.draw(canvas, childBoundingBox);
            elementRect = this.uiElement.getElementRec();
        } else if (this.contentElement != null) {
            this.positionState = this.contentElement.draw(canvas, childBoundingBox);
            elementRect = this.contentElement.getElementRec();
        }
        this.restorePosState(canvas);
        if (elementRect != null && childBoundingBox != null && (this.positionState == PositionResult.State.CONTENT_PART || this.positionState == PositionResult.State.FULL_CONTENT)) {
            if (this.positionState == PositionResult.State.FULL_CONTENT) {
                float ury = elementRect.getUry().floatValue();
                elementRect.setUry(bottomBorder);
                elementRect.setHeight(Float.valueOf(elementRect.getHeight().floatValue() - (ury - elementRect.getUry().floatValue())));
            }
            this.adjustContentArea();
        }
        this.updatePageNumbers();
        return this.positionState;
    }

    protected PositionResult simulatePosition(XFARectangle childBoundingBox) {
        PositionResult simulatePositionResult = new PositionResult(PositionResult.State.FULL_CONTENT);
        try {
            if (this.captionElement != null) {
                simulatePositionResult = this.captionElement.simulatePosition(childBoundingBox);
            }
            if (simulatePositionResult.getState() == PositionResult.State.FULL_CONTENT) {
                if (this.uiElement != null) {
                    simulatePositionResult = this.uiElement.simulatePosition(childBoundingBox);
                } else if (this.contentElement != null) {
                    simulatePositionResult = this.contentElement.simulatePosition(childBoundingBox);
                }
                if (simulatePositionResult.getState() == PositionResult.State.CONTENT_PART) {
                    if (simulatePositionResult.getRectangle() != null) {
                        if (XFAUtil.lt(childBoundingBox.getUry().floatValue() - childBoundingBox.getHeight().floatValue() - simulatePositionResult.getRectangle().getUry().floatValue() + simulatePositionResult.getRectangle().getHeight().floatValue(), simulatePositionResult.getCurrentLeading())) {
                            childBoundingBox.setHeight(Float.valueOf(childBoundingBox.getHeight().floatValue() - simulatePositionResult.getCurrentLeading()));
                        }
                        if (XFAUtil.lte(simulatePositionResult.getRectangle().getUry().floatValue(), childBoundingBox.getUry().floatValue() - childBoundingBox.getHeight().floatValue())) {
                            simulatePositionResult.setState(PositionResult.State.NO_CONTENT);
                        }
                    }
                } else if (simulatePositionResult.getState() == PositionResult.State.FULL_CONTENT && XFAUtil.gt(childBoundingBox.getUry().floatValue() - childBoundingBox.getHeight().floatValue(), simulatePositionResult.getRectangle().getUry().floatValue() - simulatePositionResult.getRectangle().getHeight().floatValue()) && XFAUtil.lt(childBoundingBox.getUry().floatValue() - childBoundingBox.getHeight().floatValue() - simulatePositionResult.getRectangle().getUry().floatValue() + simulatePositionResult.getRectangle().getHeight().floatValue(), simulatePositionResult.getCurrentLeading()) && XFAUtil.lte(simulatePositionResult.getRectangle().getHeight().floatValue(), 2.0f * simulatePositionResult.getCurrentLeading())) {
                    simulatePositionResult.setState(PositionResult.State.NO_CONTENT);
                }
            } else {
                simulatePositionResult.setState(PositionResult.State.NO_CONTENT);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return simulatePositionResult;
    }

    public CaptionElement getCaption() {
        return this.captionElement;
    }

    protected XFARectangle getContentRect() {
        if (this.uiElement != null) {
            return this.uiElement.getElementRec();
        }
        if (this.uiElements != null) {
            ArrayList<XFARectangle> rectangles = new ArrayList<XFARectangle>();
            for (UiElement uiEl : this.uiElements) {
                rectangles.add(uiEl.getElementRec());
            }
            return XFARectangle.getCommonRectangle(rectangles);
        }
        if (this.contentElement != null) {
            return this.contentElement.getElementRec();
        }
        return null;
    }

    public XFARectangle getElementArea(XFARectangle originalRec) {
        XFARectangle elementRec = originalRec.clone();
        if (this.captionElement != null) {
            if ("left".equalsIgnoreCase(this.captionElement.getPlacement()) || "right".equalsIgnoreCase(this.captionElement.getPlacement())) {
                if ("left".equalsIgnoreCase(this.captionElement.getPlacement())) {
                    elementRec.setLlx(Float.valueOf(elementRec.getLlx().floatValue() + this.captionElement.getElementRec().getWidth().floatValue()));
                }
                if (elementRec.getWidth() != null) {
                    elementRec.setWidth(Float.valueOf(elementRec.getWidth().floatValue() - this.captionElement.getElementRec().getWidth().floatValue()));
                }
                if (elementRec.getMinW() != null) {
                    elementRec.setMinW(Float.valueOf(elementRec.getMinW().floatValue() - this.captionElement.getElementRec().getWidth().floatValue()));
                }
                if (elementRec.getMaxW() != null) {
                    elementRec.setMaxW(Float.valueOf(elementRec.getMaxW().floatValue() - this.captionElement.getElementRec().getWidth().floatValue()));
                }
            } else if ("top".equalsIgnoreCase(this.captionElement.getPlacement()) || "bottom".equalsIgnoreCase(this.captionElement.getPlacement())) {
                if ("top".equalsIgnoreCase(this.captionElement.getPlacement())) {
                    elementRec.setUry(Float.valueOf(elementRec.getUry().floatValue() - this.captionElement.getElementRec().getHeight().floatValue()));
                }
                if (elementRec.getHeight() != null) {
                    elementRec.setHeight(Float.valueOf(elementRec.getHeight().floatValue() - this.captionElement.getElementRec().getHeight().floatValue()));
                }
                if (elementRec.getMinH() != null) {
                    elementRec.setMinH(Float.valueOf(elementRec.getMinH().floatValue() - this.captionElement.getElementRec().getHeight().floatValue()));
                }
                if (elementRec.getMaxH() != null) {
                    elementRec.setMaxH(Float.valueOf(elementRec.getMaxH().floatValue() - this.captionElement.getElementRec().getHeight().floatValue()));
                }
            }
        }
        return elementRec;
    }

    protected void createContentElement() {
        String contentElementName;
        List<FormNode> valueTagChildren;
        FormNode valueTag;
        FormNode uiTag = this.retrieveChild("ui");
        FormNode uiElementTag = this.getUiElement(uiTag);
        if (uiElementTag != null) {
            String uiElementName = uiElementTag.retrieveName();
            if (uiElementName.equalsIgnoreCase("textEdit") || uiElementName.equalsIgnoreCase("numericEdit") || uiElementName.equalsIgnoreCase("dateTimeEdit")) {
                String strNCells;
                FormNode combTag;
                if (this instanceof FieldPositioner && (combTag = uiElementTag.retrieveChild("comb")) != null && (strNCells = combTag.retrieveAttribute("numberOfCells")) != null && strNCells.length() > 0) {
                    Map<String, String> attributes;
                    Tag paraTag;
                    int nbCells = Integer.parseInt(strNCells);
                    Object formatRawValue = this.getFormattedValue();
                    String strValue = formatRawValue instanceof String ? (String)formatRawValue : "";
                    XFARectangle rec = this.getElementArea(this.contentArea);
                    this.uiElements = new ArrayList<UiElement>();
                    this.uiElements.add(new CombElement(uiElementTag, rec.clone(), this.document, nbCells));
                    if (rec.getWidth() != null) {
                        rec.setWidth(Float.valueOf(rec.getWidth().floatValue() / (float)nbCells));
                    }
                    int currentCell = 0;
                    int strValueLength = strValue.length();
                    if (strValueLength < nbCells && (paraTag = this.template.getChild("para", "", false)) != null && (attributes = paraTag.getAttributes()) != null) {
                        String hAlignValue = attributes.get("hAlign");
                        if ("center".equals(hAlignValue)) {
                            currentCell = (nbCells - strValueLength) / 2;
                        } else if ("right".equals(hAlignValue) || "justify".equals(hAlignValue) || "justifyAll".equals(hAlignValue)) {
                            currentCell = nbCells - strValueLength;
                        }
                    }
                    for (int i = 0; i < nbCells; ++i) {
                        TextElement textElement = null;
                        if (i >= currentCell && strValueLength > i - currentCell) {
                            Paragraph p = new Paragraph(strValue.substring(i - currentCell, i - currentCell + 1));
                            ArrayList<Element> richText = new ArrayList<Element>();
                            richText.add(p);
                            p.setAlignment(1);
                            textElement = new TextElement((FormNode)this.template, (JsNode)this, rec, this.document, richText, this.flattenerContext);
                            textElement.createColumnText(rec);
                        }
                        if (textElement != null) {
                            TextEditElement cellElement = new TextEditElement(uiElementTag, rec, this.document, textElement);
                            cellElement.setBorderDrawn(false);
                            this.uiElements.add(cellElement);
                        }
                        float width = (rec = rec.clone()).getWidth() != null ? rec.getWidth().floatValue() : 0.0f;
                        rec.setLlx(Float.valueOf(rec.getLlx().floatValue() + width));
                    }
                }
                if (this.uiElements == null) {
                    this.uiElement = new TextEditElement(uiElementTag, this.getElementArea(this.contentArea), this.document, this.createTextContentElement(), this.getIndependentRotation());
                }
            } else if (uiElementName.equalsIgnoreCase("passwordEdit")) {
                this.uiElement = new TextEditElement(uiElementTag, this.getElementArea(this.contentArea), this.document, this.createTextContentElement());
            } else if (uiElementName.equalsIgnoreCase("imageEdit")) {
                valueTag = this.retrieveChild("value");
                FormNode contentElementTag = null;
                if (valueTag != null && (valueTagChildren = valueTag.retrieveChildren()) != null && valueTagChildren.size() > 0 && !(contentElementName = (contentElementTag = valueTagChildren.get(0)).retrieveName()).equalsIgnoreCase("image")) {
                    contentElementTag = null;
                }
                ImageElement imageElement = contentElementTag == null ? this.createImageContentElement(uiElementTag) : this.createImageContentElement(contentElementTag);
                this.adjustContentAreaIfImageElementSizeCalculated(imageElement);
                this.uiElement = new ImageEditElement(uiElementTag, this.getElementArea(this.contentArea), this.document, imageElement);
            } else if (uiElementName.equalsIgnoreCase("checkButton")) {
                String hAlign = this.captionElement != null ? null : "right";
                this.uiElement = new CheckButtonElement(uiElementTag, this.getElementArea(this.contentArea), this.document, this.createTextContentElement(), hAlign, this.captionElement);
            } else if (uiElementName.equalsIgnoreCase("choiceList")) {
                this.uiElement = new ChoiceListElement(uiElementTag, this.getElementArea(this.contentArea), this.document);
                XFARectangle textElementRect = this.uiElement.getElementRec().clone();
                this.uiElement.applyMargins(textElementRect);
                TextElement element = this.createChoiceListTextContentElement(uiElementTag, textElementRect);
                ((ChoiceListElement)this.uiElement).setContentElement(element);
            } else if (uiElementName.equalsIgnoreCase("button")) {
                this.uiElement = new ButtonElement(uiElementTag, this.getElementArea(this.contentArea), this.document, this.createTextContentElement());
            } else if (uiElementName.equalsIgnoreCase("signature")) {
                this.uiElement = new SignatureElement(uiElementTag, this.getElementArea(this.contentArea), this.document, this.createTextContentElement(), this.flattenerContext);
            } else if (uiElementName.equalsIgnoreCase("barcode")) {
                this.uiElement = new BarcodeElement(uiElementTag, this.contentArea.clone(), this.document, this.createTextContentElement());
            }
        }
        Integer independentRotation = this.getIndependentRotation();
        if (this.uiElement != null && independentRotation != null) {
            this.uiElement.setIndependentRotateAngle(independentRotation);
        }
        if (this.uiElement == null && this.uiElements == null && this.contentElement == null) {
            valueTag = this.retrieveChild("value");
            if (valueTag != null && (valueTagChildren = valueTag.retrieveChildren()) != null && valueTagChildren.size() > 0) {
                FormNode contentElementTag = valueTagChildren.get(0);
                contentElementName = contentElementTag.retrieveName();
                if (contentElementName.equalsIgnoreCase("rectangle")) {
                    this.contentElement = new RectangleElement(contentElementTag, this.getElementArea(this.contentArea), this.document);
                } else if (contentElementName.equalsIgnoreCase("line")) {
                    this.contentElement = new LineElement(contentElementTag, this.getElementArea(this.contentArea), this.document);
                } else if (contentElementName.equalsIgnoreCase("image")) {
                    this.contentElement = this.createImageContentElement(contentElementTag);
                }
                if (contentElementName.equalsIgnoreCase("arc")) {
                    this.contentElement = new ArcElement(contentElementTag, this.getElementArea(this.contentArea), this.document);
                }
            }
            if (this.contentElement == null) {
                this.contentElement = this.createTextContentElement();
                if (this.contentElement != null) {
                    XFARectangle textArea = this.getTextArea();
                    ((TextElement)this.contentElement).createColumnText(textArea);
                }
            }
        }
    }

    private FormNode getUiElement(FormNode uiParent) {
        List<FormNode> uiTagChildren;
        FormNode uiElementTag = null;
        if (uiParent != null && (uiTagChildren = uiParent.retrieveChildren()) != null && uiTagChildren.size() > 0) {
            for (FormNode child : uiTagChildren) {
                if (!ALLOWED_UI_ELEMENTS.contains(child.retrieveName())) continue;
                uiElementTag = child;
                break;
            }
        }
        return uiElementTag;
    }

    protected void createCaptionElement() {
        JsNode caption = this.getChild("caption");
        if (caption instanceof CaptionElement) {
            this.captionElement = (CaptionElement)caption;
            this.captionElement.place(this.contentArea, this.flattenerContext);
        }
    }

    protected TextElement createTextContentElement() {
        ArrayList<Element> content;
        Object formatRawValue = this.getFormattedValue();
        TextElement textElement = null;
        if (formatRawValue instanceof String && !((String)formatRawValue).isEmpty()) {
            textElement = new TextElement((FormNode)this.template, (JsNode)this, this.getElementArea(this.contentArea), this.document, (String)formatRawValue, this.flattenerContext);
        } else if (formatRawValue instanceof List) {
            ArrayList<Element> richText = new ArrayList<Element>();
            for (int i = 0; i < ((List)formatRawValue).size(); ++i) {
                Object curElement = ((List)formatRawValue).get(i);
                if (!(curElement instanceof Element)) continue;
                richText.add((Element)curElement);
            }
            textElement = new TextElement((FormNode)this.template, (JsNode)this, this.getElementArea(this.contentArea), this.document, richText, this.flattenerContext);
        }
        if (textElement != null && this.role != null && this.role.toString().matches("/H[1-6]") && (content = textElement.getContent()).size() > 0 && content.get(0) instanceof IAccessibleElement) {
            ((IAccessibleElement)((Object)content.get(0))).setRole(this.role);
            this.role = PdfName.DIV;
        }
        return textElement;
    }

    protected TextElement createChoiceListTextContentElement(FormNode uiElementTag, XFARectangle textElementRect) {
        Object formatRawValue = this.getFormattedValue();
        if (!(formatRawValue instanceof String) || ((String)formatRawValue).isEmpty() || this.template == null) {
            return this.createTextContentElement();
        }
        String displayValue = (String)formatRawValue;
        return new TextElement((FormNode)this.template, (JsNode)this, this.getElementArea(this.contentArea), this.document, displayValue, this.flattenerContext);
    }

    protected ImageElement createImageContentElement(FormNode elementTag) {
        Object rawValue = this.getRawValue();
        Image img = null;
        if (rawValue instanceof String) {
            String imageData = (String)rawValue;
            String transferEncoding = "base64";
            String transferEncodingFromTag = elementTag.retrieveAttribute("transferEncoding");
            if (transferEncodingFromTag != null) {
                transferEncoding = transferEncodingFromTag;
            }
            try {
                if ("base64".equalsIgnoreCase(transferEncoding)) {
                    byte[] buf = Base64.decode(imageData);
                    if (buf != null) {
                        img = Image.getInstance(buf);
                    }
                } else {
                    img = Image.getInstance(imageData.getBytes());
                }
            }
            catch (IOException iOException) {
            }
            catch (BadElementException badElementException) {
                // empty catch block
            }
        }
        if (img != null) {
            String alternateText = this.getAlternateText();
            if (!(alternateText != null && alternateText.length() != 0 || alternateText != null && alternateText.length() != 0)) {
                alternateText = "image";
            }
            img.setAccessibleAttribute(PdfName.ALT, new PdfString(alternateText));
        }
        return new ImageElement(elementTag, this.getElementArea(this.contentArea), this.document, img);
    }

    protected void adjustContentAreaIfImageElementSizeCalculated(ImageElement imageElement) {
        if (this.contentArea.getHeight() == null && imageElement.getElementRec().getHeight() != null) {
            this.contentArea.setHeight(imageElement.getElementRec().getHeight());
        }
        if (this.contentArea.getWidth() == null && imageElement.getElementRec().getWidth() != null) {
            this.contentArea.setWidth(imageElement.getElementRec().getWidth());
        }
    }

    public void initValues() {
        Object value = null;
        FormNode valueNode = this.retrieveChild("value");
        if (valueNode != null) {
            List<String> content;
            FormNode textNode;
            FormNode exDataNode = valueNode.retrieveChild("exData");
            if (exDataNode != null) {
                String contentTypeValue = exDataNode.retrieveAttribute("contentType");
                if ("text/html".equals(contentTypeValue)) {
                    value = exDataNode.retrieveRichText();
                }
            } else {
                PdfObject imgStream;
                String imgHref;
                FormNode imageNode = valueNode.retrieveChild("image");
                if (imageNode != null && (imgHref = imageNode.retrieveAttribute("href")) != null && (imgStream = PdfReader.getPdfObject(this.flattenerContext.getImage(imgHref))) instanceof PRStream) {
                    try {
                        value = Base64.encodeBytes(PdfReader.getStreamBytes((PRStream)imgStream));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (value == null && valueNode.retrieveChildren().size() != 0 && (textNode = valueNode.retrieveChildren().get(0)) != null && (content = textNode.retrieveContent()) != null && content.size() > 0) {
                value = content.get(0);
            }
        }
        this.setRawValue(value);
    }

    @Override
    public void setRawValue(Object rawValue) {
        if (rawValue != null && rawValue instanceof String) {
            rawValue = this.normalizeRawValueString((String)rawValue, this.template.getChild("value", "", false));
        }
        if (this.data != null && this.data.getNode() instanceof JsDataValue) {
            this.data.getNode().defineProperty("value", rawValue);
        }
        this.defineProperty("rawValue", rawValue);
    }

    protected Object normalizeRawValueString(String value, Tag valueTag) {
        Tag uiElementTag;
        String uiElementName;
        Tag uiTag;
        String valueTagName;
        Tag valueContentTag;
        Object valueObj = value;
        String localeName = this.template.getAttributes().get("locale");
        XFALocale locale = this.flattenerContext.getLocaleResolver().getLocale(localeName);
        boolean numberShouldBeNormalized = false;
        Map<String, String> valueContentTagAttributes = null;
        if (valueTag != null && valueTag.hasChildren() && (valueContentTag = valueTag.getChildren().get(0)) != null && ("integer".equals(valueTagName = valueContentTag.getName()) || "decimal".equals(valueTagName) || "float".equals(valueTagName))) {
            numberShouldBeNormalized = true;
            valueContentTagAttributes = valueContentTag.getAttributes();
        }
        if ((uiTag = this.template.getChild("ui", "", false)) != null && uiTag.getChildren() != null && uiTag.getChildren().size() > 0 && (uiElementName = (uiElementTag = uiTag.getChildren().get(0)).getName()).equalsIgnoreCase("numericEdit")) {
            numberShouldBeNormalized = true;
        }
        if (numberShouldBeNormalized) {
            FormatResolver.NumberParseResult numberParseResult = this.flattenerContext.getFormatResolver().parseNumber(value, this.inputParsingPattern, locale);
            if (valueContentTagAttributes != null && "-1".equals(valueContentTagAttributes.get("fracDigits")) && numberParseResult != null) {
                this.originalNumberOfFractionalDigitsInRawValue = numberParseResult.getNumberOfFractionalDigits();
            }
            valueObj = numberParseResult != null ? (Number)numberParseResult.getNumber() : (Number)null;
        }
        return valueObj;
    }

    protected abstract XFARectangle getTextArea();

    @Override
    protected void adjustContentAreaHeight(float newHeight) {
        super.adjustContentAreaHeight(newHeight);
        this.captionElement = null;
        this.contentElement = null;
        this.uiElement = null;
        this.uiElements = null;
        this.transformation = new AffineTransform();
        this.initLayout();
        this.adjustLayout();
    }

    @Override
    public void relayout(boolean forceLayout) {
        if (!this.layoutOutOfDate && !forceLayout) {
            return;
        }
        this.initContentArea(null, null);
        this.applyMargins(this.contentArea);
        this.captionElement = null;
        this.contentElement = null;
        this.uiElement = null;
        this.uiElements = null;
        this.transformation = new AffineTransform();
        this.initLayout();
        this.adjustLayout();
        this.layoutOutOfDate = false;
    }

    @Override
    protected void move(float dx, float dy) {
        super.move(dx, dy);
        if (this.uiElement != null) {
            this.uiElement.move(dx, dy);
        }
        if (this.uiElements != null) {
            for (UiElement element : this.uiElements) {
                element.move(dx, dy);
            }
        }
        if (this.contentElement != null) {
            this.contentElement.move(dx, dy);
        }
        if (this.captionElement != null) {
            this.captionElement.move(dx, dy);
        }
    }

    @Override
    protected void adjustContentAreaUry(float ury) {
        XFARectangle elementRect = null;
        if (this.uiElement != null) {
            elementRect = this.uiElement.getElementRec();
        } else if (this.contentElement != null) {
            elementRect = this.contentElement.getElementRec();
        }
        if (elementRect != null) {
            float prevHeight = elementRect.getHeight().floatValue();
            float currentUry = elementRect.getUry().floatValue();
            elementRect.setUry(Float.valueOf(ury));
            elementRect.setHeight(Float.valueOf(prevHeight - (currentUry - ury)));
        }
        this.adjustContentArea();
    }

    @Override
    protected boolean isPositionedPartially() {
        return this.positionState == PositionResult.State.CONTENT_PART || this.positionState == PositionResult.State.FULL_CONTENT;
    }

    @Override
    public Object getFormattedValue() {
        String rawValue;
        List<String> pictureClause;
        FormNode picture;
        FormNode uiTag;
        Object rawValueObj = this.getRawValue();
        if (rawValueObj instanceof List) {
            return rawValueObj;
        }
        FormatResolver.FormatType formatType = null;
        Tag valueTag = this.template.getChild("value", "", false);
        Tag textTag = null;
        Tag contentElementTag = null;
        if (valueTag != null && valueTag.getChildren() != null && valueTag.getChildren().size() > 0) {
            contentElementTag = valueTag.getChildren().get(0);
            String contentElementName = contentElementTag.getName();
            if (contentElementName.equalsIgnoreCase("float")) {
                formatType = FormatResolver.FormatType.FLOAT;
            } else if (contentElementName.equalsIgnoreCase("integer")) {
                formatType = FormatResolver.FormatType.INTEGER;
            } else if (contentElementName.equalsIgnoreCase("date")) {
                formatType = FormatResolver.FormatType.DATE;
            } else if (contentElementName.equalsIgnoreCase("dateTime")) {
                formatType = FormatResolver.FormatType.DATE_TIME;
            } else if (contentElementName.equalsIgnoreCase("time")) {
                formatType = FormatResolver.FormatType.TIME;
            } else if (contentElementName.equals("text") && rawValueObj instanceof String) {
                String maxCharsValue;
                String rawValue2 = (String)rawValueObj;
                textTag = valueTag.getChildren().get(0);
                Map<String, String> attributes = textTag.getAttributes();
                if (attributes != null && (maxCharsValue = attributes.get("maxChars")) != null) {
                    int maxChars = Integer.parseInt(maxCharsValue);
                    maxChars = Math.min(maxChars, rawValue2.length());
                    rawValueObj = rawValue2.substring(0, maxChars);
                }
            }
        }
        if ((uiTag = this.retrieveChild("ui")) != null && uiTag.retrieveChildren() != null && uiTag.retrieveChildren().size() > 0) {
            FormNode uiElementTag = uiTag.retrieveChildren().get(0);
            String uiElementName = uiElementTag.retrieveName();
            if (uiElementName.equalsIgnoreCase("numericEdit")) {
                formatType = FormatResolver.FormatType.FLOAT;
            } else if (uiElementName.equalsIgnoreCase("dateTimeEdit")) {
                formatType = FormatResolver.FormatType.DATE_TIME;
                FormNode valueNode = this.retrieveChild("value");
                if (valueNode != null) {
                    if (valueNode.retrieveChild("date") != null) {
                        formatType = FormatResolver.FormatType.DATE;
                    } else if (valueNode.retrieveChild("time") != null) {
                        formatType = FormatResolver.FormatType.TIME;
                    }
                }
            }
        }
        String pattern = null;
        FormNode format = this.retrieveChild("format");
        if (format != null && (picture = format.retrieveChild("picture")) != null && (pictureClause = picture.retrieveContent()) != null && pictureClause.size() > 0) {
            pattern = pictureClause.get(0);
        }
        if (rawValueObj != null || pattern != null) {
            String localeName = this.template.getAttributes().get("locale");
            ConfigResolver configResolver = this.flattenerContext.getConfigResolver();
            if (configResolver != null && configResolver.getDefaultAcrobatLocale() != null) {
                localeName = configResolver.getDefaultAcrobatLocale();
            }
            HashMap<String, String> attributes = null;
            if (contentElementTag != null && contentElementTag.getAttributes() != null && contentElementTag.getAttributes().size() > 0 && "-1".equals((attributes = new HashMap<String, String>(contentElementTag.getAttributes())).get("fracDigits")) && this.originalNumberOfFractionalDigitsInRawValue != null) {
                attributes.put("fracDigits", this.originalNumberOfFractionalDigitsInRawValue.toString());
            }
            rawValue = this.flattenerContext.getFormatResolver().resolve(rawValueObj, pattern, this.inputParsingPattern, formatType, localeName, attributes);
        } else {
            rawValue = null;
        }
        return rawValue != null ? rawValue : "";
    }

    @Override
    public Object execCalculate() {
        Object result = super.execCalculate();
        if (result != null) {
            this.setRawValue(result);
        }
        return this.getRawValue();
    }

    @Override
    protected String getCaptionText() {
        if (this.captionElement == null) {
            return "";
        }
        return this.captionElement.getCaptionText();
    }
}

