/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.positioner;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.text.AccessibleElementId;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.interfaces.IAccessibleElement;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.xtra.xfa.XFAFlattener;
import com.itextpdf.tool.xml.xtra.xfa.element.BorderDrawer;
import com.itextpdf.tool.xml.xtra.xfa.element.BreakConditions;
import com.itextpdf.tool.xml.xtra.xfa.element.ContentArea;
import com.itextpdf.tool.xml.xtra.xfa.element.KeepConditions;
import com.itextpdf.tool.xml.xtra.xfa.element.OverflowConditions;
import com.itextpdf.tool.xml.xtra.xfa.element.PageArea;
import com.itextpdf.tool.xml.xtra.xfa.element.PositionResult;
import com.itextpdf.tool.xml.xtra.xfa.js.JsContainer;
import com.itextpdf.tool.xml.xtra.xfa.js.JsDataGroup;
import com.itextpdf.tool.xml.xtra.xfa.js.JsDataValue;
import com.itextpdf.tool.xml.xtra.xfa.js.JsNode;
import com.itextpdf.tool.xml.xtra.xfa.js.JsTree;
import com.itextpdf.tool.xml.xtra.xfa.js.ScriptString;
import com.itextpdf.tool.xml.xtra.xfa.positioner.ContentPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.DrawPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.FieldPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.SubFormPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.SubformSetPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.TableLayoutManager;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FlattenerContext;
import com.itextpdf.tool.xml.xtra.xfa.tags.DataTag;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.tags.XFATemplateTag;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Scriptable;

public abstract class Positioner
extends JsContainer
implements IAccessibleElement {
    protected XFATemplateTag template;
    protected DataTag data;
    public XFARectangle contentArea;
    protected Positioner parent;
    protected List<Positioner> childElements = new ArrayList<Positioner>();
    protected BreakConditions breakConditions = null;
    protected KeepConditions keepConditions = null;
    protected OverflowConditions overflowConditions;
    protected AffineTransform transformation = new AffineTransform();
    protected PdfName role;
    protected AccessibleElementId id;
    protected HashMap<PdfName, PdfObject> accessibleAttributes;
    protected PdfContentByte canvas;
    protected boolean isEmpty = true;
    protected boolean isContentTagged = false;
    protected boolean isTagged = false;
    protected Integer startPageNumber = null;
    protected Integer startSheetNumber = null;
    protected Integer startAbsPageNumber = null;
    protected Integer endPageNumber = null;
    protected Integer endAbsPageNumber = null;
    protected FormNode assistTag = null;
    protected boolean layoutOutOfDate = false;
    protected HashSet<Tag> overflowedContentAreas;
    protected Map<String, Positioner> immediateChildren = new HashMap<String, Positioner>();
    protected PositionResult.State positionState = PositionResult.State.NO_CONTENT;
    public boolean buildNextInstance;

    public Positioner(XFATemplateTag templateTag, DataTag dataTag, FlattenerContext flattenerContext, JsNode parentNode) {
        super(templateTag, parentNode);
        Tag keepTag;
        this.template = templateTag;
        this.flattenerContext = flattenerContext;
        this.parent = parentNode instanceof Positioner ? (Positioner)parentNode : null;
        this.data = dataTag;
        this.protoTemplate = UNIVERSAL_PROTOTYPE_ROOT.getChild(templateTag.getName(), "");
        if (this.parent != null) {
            this.startPageNumber = this.parent.getStartPageNumber();
            this.startSheetNumber = this.parent.getStartSheetNumber();
            this.startAbsPageNumber = this.parent.getStartAbsPageNumber();
        }
        if ((keepTag = this.template.getChild("keep", "")) != null) {
            this.keepConditions = new KeepConditions(keepTag);
        }
    }

    public Integer getIndependentRotation() {
        Integer independentRotation = null;
        String rotate = null;
        if (this.parent != null && "row".equals(this.parent.getLayout()) && (rotate = this.retrieveAttribute("rotate")) != null) {
            independentRotation = Integer.valueOf(rotate);
        }
        return independentRotation;
    }

    public void place(Float x, Float y) {
        if (this.parent != null) {
            Tag overflowTag = null;
            String parentLayout = this.parent.getLayout();
            if (("tb".equals(parentLayout) || "lr-tb".equals(parentLayout)) && (overflowTag = this.template.getChild("overflow", "")) == null) {
                overflowTag = this.template.getChild("break", "");
            }
            if (overflowTag != null || this.parent.getOverflowConditions() != null) {
                this.overflowConditions = new OverflowConditions(overflowTag, this.flattenerContext, this.parent.getOverflowConditions(), this);
            }
        }
        this.initContentArea(x, y);
        boolean dynamicTableLayout = false;
        TableLayoutManager tableLayoutManager = null;
        if ("table".equals(this.getLayout())) {
            tableLayoutManager = new TableLayoutManager(this);
            if (TableLayoutManager.isDynamicTableLayout(this.retrieveAttribute("columnWidths"))) {
                dynamicTableLayout = true;
            } else {
                tableLayoutManager.preprocessHorizontalCellLayout();
            }
        }
        this.applyMargins(this.contentArea);
        this.initLayout();
        if (dynamicTableLayout) {
            tableLayoutManager.preprocessHorizontalCellLayout();
            this.relayout(true);
        }
        this.adjustLayout();
        this.layoutOutOfDate = false;
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if ((value == null || value instanceof String) && this.immediateChildren != null && this.immediateChildren.containsKey(name)) {
            Positioner child = this.immediateChildren.get(name);
            if (child instanceof DrawPositioner && child.getRawValue() instanceof String && !child.getRawValue().equals(value)) {
                child.setRawValue(value);
            }
            child.put(name, (Scriptable)child, value);
        } else {
            super.put(name, start, value);
        }
    }

    public void place() {
        this.place(null, null);
    }

    public void initContentArea(Float parentLlx, Float parentUry) {
        Float llxOffset;
        Float uryOffset;
        XFARectangle previuosBBox;
        Float y;
        Float x = Float.valueOf(0.0f);
        if (!"row".equals(this.getLayout()) && (x = XFAUtil.parsePxInCmMmPcToPt(this.retrieveAttribute("x"))) == null) {
            x = Float.valueOf(0.0f);
        }
        if ((y = XFAUtil.parsePxInCmMmPcToPt(this.retrieveAttribute("y"))) == null) {
            y = Float.valueOf(0.0f);
        }
        Float w = XFAUtil.parsePxInCmMmPcToPt(this.retrieveAttribute("w"));
        Float h = XFAUtil.parsePxInCmMmPcToPt(this.retrieveAttribute("h"));
        String layout = this.getLayout();
        if ("position".equals(layout) && h != null && this.parent == this.flattenerContext.getDomPositioner() && h.floatValue() > this.flattenerContext.getDocument().getPageSize().getHeight()) {
            h = null;
        }
        this.contentArea = new XFARectangle(x, y, w, h);
        if (w == null) {
            this.initMinWContentAreaProperty();
            Float maxW = XFAUtil.parsePxInCmMmPcToPt(this.retrieveAttribute("maxW"));
            this.contentArea.setMaxW(maxW);
        }
        if (h == null) {
            Float minH = XFAUtil.parsePxInCmMmPcToPt(this.retrieveAttribute("minH"));
            this.contentArea.setMinH(minH);
            Float maxH = XFAUtil.parsePxInCmMmPcToPt(this.retrieveAttribute("maxH"));
            this.contentArea.setMaxH(maxH);
        }
        String parentLayout = null;
        XFARectangle parentContentArea = null;
        Positioner previousPositionerInLayout = null;
        if (this.parent != null) {
            parentLayout = this.parent.getLayout();
            previousPositionerInLayout = this.parent.getPreviousPositionerInLayout(this, layout);
            parentContentArea = this.parent.getContentArea();
            parentLlx = parentContentArea.getLlx();
            parentUry = parentContentArea.getUry();
        }
        if ("tb".equals(parentLayout)) {
            if (previousPositionerInLayout != null) {
                previuosBBox = previousPositionerInLayout.getBBox();
                this.contentArea.setUry(Float.valueOf(previuosBBox.getUry().floatValue() - previuosBBox.getHeight().floatValue()));
            } else {
                this.contentArea.setUry(parentContentArea.getUry());
            }
            this.contentArea.setLlx(Float.valueOf(0.0f));
        } else if ("table".equals(parentLayout) || "row".equals(layout)) {
            if (previousPositionerInLayout != null) {
                previuosBBox = previousPositionerInLayout.getBBox();
                this.contentArea.setUry(Float.valueOf(previuosBBox.getUry().floatValue() - previuosBBox.getHeight().floatValue()));
                this.contentArea.setLlx(Float.valueOf(0.0f));
            } else {
                this.contentArea.setUry(parentUry);
            }
        } else if ("row".equals(parentLayout)) {
            this.contentArea.setUry(parentContentArea.getUry());
            if (this instanceof SubFormPositioner && this.childElements.size() > 1) {
                if ("tb".equals(layout)) {
                    FormNode tableNode;
                    Float originalWidth = XFAUtil.parsePxInCmMmPcToPt(this.template.retrieveAttribute("w"));
                    FormNode formNode = tableNode = this.parent.parent != null ? this.parent.parent : this.parent.template.retrieveParent();
                    if (tableNode != null) {
                        Float columnWidthAllegedWidth = TableLayoutManager.getNthColumnWidth(tableNode.retrieveAttribute("columnWidths"), this.parent.childElements.indexOf(this));
                        if (originalWidth == null || columnWidthAllegedWidth != null && (double)Math.abs(originalWidth.floatValue() - columnWidthAllegedWidth.floatValue()) > 0.001) {
                            int nullWidths = 0;
                            int differentThanColumnWidths = 0;
                            for (Positioner p : this.childElements) {
                                if (p.retrieveAttribute("w") == null) {
                                    ++nullWidths;
                                    continue;
                                }
                                if (XFAUtil.parsePxInCmMmPcToPt(p.retrieveAttribute("w")).equals(TableLayoutManager.getNthColumnWidth(tableNode.retrieveAttribute("columnWidths"), this.parent.childElements.indexOf(this)))) continue;
                                ++differentThanColumnWidths;
                            }
                            if (nullWidths == this.childElements.size() || differentThanColumnWidths != 0) {
                                this.contentArea.setHeight(null);
                            }
                        }
                    }
                } else if (!"position".equals(layout)) {
                    this.contentArea.setHeight(null);
                }
            }
        } else if ("lr-tb".equalsIgnoreCase(parentLayout)) {
            if (previousPositionerInLayout != null) {
                ArrayList<Float> colWidths;
                previuosBBox = previousPositionerInLayout.getBBox();
                Float contentAreaWidth = this.contentArea.getWidth();
                if (contentAreaWidth == null && this.retrieveAttribute("columnWidths") != null && (colWidths = XFAUtil.parseNumArray(this.retrieveAttribute("columnWidths"))) != null) {
                    for (Float colW : colWidths) {
                        if (colW == null) continue;
                        if (contentAreaWidth == null) {
                            contentAreaWidth = colW;
                            continue;
                        }
                        contentAreaWidth = Float.valueOf(contentAreaWidth.floatValue() + colW.floatValue());
                    }
                }
                if (parentContentArea.getWidth() == null || contentAreaWidth == null || (double)(previuosBBox.getLlx().floatValue() + previuosBBox.getWidth().floatValue() + contentAreaWidth.floatValue() - parentContentArea.getLlx().floatValue() - parentContentArea.getWidth().floatValue()) < 0.01) {
                    this.contentArea.setUry(previuosBBox.getUry());
                    this.contentArea.setLlx(Float.valueOf(previuosBBox.getLlx().floatValue() + previuosBBox.getWidth().floatValue() - parentLlx.floatValue()));
                } else {
                    float lly = previuosBBox.getUry().floatValue() - previuosBBox.getHeight().floatValue();
                    for (int i = this.parent.getChildren().indexOf(this) - 2; i >= 0; --i) {
                        XFARectangle neighborBBox;
                        float neighborsLly;
                        Positioner neighborPositioner = this.parent.getChildren().get(i);
                        if (neighborPositioner.isHidden() || neighborPositioner.isInactive() || !(lly > (neighborsLly = (neighborBBox = neighborPositioner.getBBox()).getUry().floatValue() - neighborBBox.getHeight().floatValue()))) continue;
                        lly = neighborsLly;
                    }
                    this.contentArea.setUry(Float.valueOf(lly));
                    this.contentArea.setLlx(Float.valueOf(0.0f));
                }
            } else {
                this.contentArea.setUry(parentContentArea.getUry());
                this.contentArea.setLlx(Float.valueOf(0.0f));
            }
        } else if (parentUry != null && (uryOffset = this.contentArea.getUry()) != null) {
            this.contentArea.setUry(Float.valueOf(parentUry.floatValue() - uryOffset.floatValue()));
        }
        if (parentLlx != null && (llxOffset = this.contentArea.getLlx()) != null) {
            this.contentArea.setLlx(Float.valueOf(parentLlx.floatValue() + llxOffset.floatValue()));
        }
    }

    protected void initMinWContentAreaProperty() {
        Float minW = XFAUtil.parsePxInCmMmPcToPt(this.retrieveAttribute("minW"));
        this.contentArea.setMinW(minW);
    }

    protected void move(float dx, float dy) {
        for (Positioner p : this.childElements) {
            p.move(dx, dy);
        }
        if (this.contentArea != null) {
            this.contentArea.setLlx(Float.valueOf(this.contentArea.getLlx().floatValue() + dx));
            this.contentArea.setUry(Float.valueOf(this.contentArea.getUry().floatValue() + dy));
        }
    }

    private List<Positioner> getChildPositionersInScriptExecutionOrder(String activity, String ref) {
        ArrayList<Positioner> executionOrder = new ArrayList<Positioner>(this.childElements);
        return executionOrder;
    }

    private void collectPositionersInStraightExecutionOrderRecursively(List<Positioner> executionOrder) {
        for (Positioner child : this.childElements) {
            child.collectPositionersInStraightExecutionOrderRecursively(executionOrder);
        }
        executionOrder.add(this);
    }

    @Override
    public void execEvent(String activity, String ref) {
        Positioner previousNode = this.flattenerContext.getCurrentNode();
        this.flattenerContext.setCurrentNode(this);
        if ("ready".equals(activity) && "$form".equals(ref)) {
            ArrayList<Positioner> executionOrder = new ArrayList<Positioner>();
            this.collectPositionersInStraightExecutionOrderRecursively(executionOrder);
            for (int pos = 0; pos < executionOrder.size(); ++pos) {
                Positioner currentPositioner = executionOrder.get(pos);
                if (currentPositioner.getScriptsByActivity(activity, ref) == null) continue;
                int l = pos + 1;
                for (int r = executionOrder.size() - 1; l < r; ++l, --r) {
                    Positioner swap = executionOrder.get(l);
                    executionOrder.set(l, executionOrder.get(r));
                    executionOrder.set(r, swap);
                }
                break;
            }
            for (Positioner currentPositioner : executionOrder) {
                Positioner prev = this.flattenerContext.getCurrentNode();
                this.flattenerContext.setCurrentNode(currentPositioner);
                currentPositioner.execOwnEvent(activity, ref);
                this.flattenerContext.setCurrentNode(prev);
            }
        } else {
            List<Positioner> childExecutionOrder = this.getChildPositionersInScriptExecutionOrder(activity, ref);
            for (Positioner child : childExecutionOrder) {
                child.execEvent(activity, ref);
            }
            super.execEvent(activity, ref);
        }
        this.flattenerContext.setCurrentNode(previousNode);
    }

    @Override
    public Object execCalculate() {
        Positioner previousNode = this.flattenerContext.getCurrentNode();
        this.flattenerContext.setCurrentNode(this);
        List<Positioner> childExecutionOrder = this.getChildPositionersInScriptExecutionOrder(null, null);
        for (Positioner child : childExecutionOrder) {
            child.execCalculate();
        }
        Object result = super.execCalculate();
        this.flattenerContext.setCurrentNode(previousNode);
        return result;
    }

    @Override
    public void execValidate() {
        Positioner previousNode = this.flattenerContext.getCurrentNode();
        this.flattenerContext.setCurrentNode(this);
        List<Positioner> childExecutionOrder = this.getChildPositionersInScriptExecutionOrder(null, null);
        for (Positioner child : childExecutionOrder) {
            child.execValidate();
        }
        super.execValidate();
        this.flattenerContext.setCurrentNode(previousNode);
    }

    public FlattenerContext getFlattenerContext() {
        return this.flattenerContext;
    }

    @Override
    public List<ScriptString> getScriptsByActivity(String activity, String ref) {
        ArrayList<ScriptString> scripts = null;
        List<Tag> events = this.template.getChildren("event");
        for (Tag currentEvent : events) {
            String currentActivity = currentEvent.getAttributes().get("activity");
            String currentRef = currentEvent.getAttributes().get("ref");
            if (currentActivity != null && !currentActivity.equalsIgnoreCase(activity) || ref != null && !"undefined".equals(ref) && !ref.equals(currentRef)) continue;
            List<Tag> scriptTags = currentEvent.getChildren("script");
            for (Tag script : scriptTags) {
                String contentType = script.getAttributes().get("contentType");
                String js = "";
                List<String> content = ((XFATemplateTag)script).getContent();
                if (content != null) {
                    for (String js_part : content) {
                        js = js + js_part;
                    }
                }
                if (scripts == null) {
                    scripts = new ArrayList<ScriptString>();
                }
                scripts.add(new ScriptString(js, contentType));
            }
        }
        return scripts;
    }

    @Override
    protected List<ScriptString> getCalculationScripts() {
        ArrayList<ScriptString> scripts = null;
        Tag calculate = this.template.getChild("calculate", "");
        if (calculate != null) {
            List<Tag> scriptTags = calculate.getChildren("script");
            for (Tag script : scriptTags) {
                String contentType = script.getAttributes().get("contentType");
                String js = "";
                List<String> content = ((XFATemplateTag)script).getContent();
                if (content != null) {
                    for (String js_part : content) {
                        js = js + js_part;
                    }
                }
                if (scripts == null) {
                    scripts = new ArrayList<ScriptString>();
                }
                scripts.add(new ScriptString(js, contentType));
            }
        }
        return scripts;
    }

    @Override
    protected List<ScriptString> getValidateScripts() {
        ArrayList<ScriptString> scripts = null;
        Tag validate = this.template.getChild("validate", "");
        if (validate != null) {
            List<Tag> scriptTags = validate.getChildren("script");
            for (Tag script : scriptTags) {
                String contentType = script.getAttributes().get("contentType");
                String js = "";
                List<String> content = ((XFATemplateTag)script).getContent();
                if (content != null) {
                    for (String js_part : content) {
                        js = js + js_part;
                    }
                }
                if (scripts == null) {
                    scripts = new ArrayList<ScriptString>();
                }
                scripts.add(new ScriptString(js, contentType));
            }
        }
        return scripts;
    }

    protected void initLayout() {
        String roleName;
        this.assistTag = this.retrieveChild("assist");
        if (this.assistTag != null && (roleName = this.assistTag.retrieveAttributes().get("role")) != null) {
            PdfName parentRole;
            PdfName pdfName = parentRole = this.parent != null ? this.parent.role : null;
            if (roleName.equals("Table")) {
                this.role = PdfName.TABLE;
            } else if (roleName.equals("TR")) {
                if (parentRole == PdfName.TABLE) {
                    this.role = PdfName.TR;
                }
            } else if (roleName.equals("TF")) {
                if (parentRole == PdfName.TABLE) {
                    this.role = PdfName.TFOOT;
                }
            } else if (roleName.equals("TH")) {
                if (parentRole == PdfName.TABLE) {
                    this.role = PdfName.THEAD;
                }
            } else if (roleName.equals("TD")) {
                if (parentRole == PdfName.TR || parentRole == PdfName.THEAD || parentRole == PdfName.TFOOT) {
                    this.role = PdfName.TD;
                }
            } else {
                this.role = roleName.equals("UL") ? PdfName.DIV : new PdfName(roleName);
            }
        }
        Object layout = this.getOwnProperty("layout");
        if (this.role == null) {
            if ("table".equals(layout)) {
                this.role = PdfName.TABLE;
            } else if ("row".equals(layout)) {
                this.role = PdfName.TR;
            } else {
                String parentLayout = this.parent != null ? this.parent.getLayout() : null;
                this.role = "row".equals(parentLayout) ? PdfName.TD : PdfName.DIV;
            }
        }
    }

    public abstract Positioner checkOverflowing(XFARectangle var1, PageArea var2, boolean var3, float var4);

    public abstract Positioner position(PdfContentByte var1, XFARectangle var2, PageArea var3, boolean var4, float var5) throws DocumentException, IOException;

    public void drawBorder(PdfContentByte canvas, XFARectangle parentBoundingBox) {
        if (this.isBackgroundOrBorderExist()) {
            XFARectangle rec = this.contentArea.clone();
            this.unapplyMargins(rec);
            this.drawBorder(canvas, rec, parentBoundingBox);
        }
    }

    public void drawBorder(PdfContentByte canvas, XFARectangle rec, XFARectangle parentBoundingBox) {
        BorderDrawer borderDrawer = new BorderDrawer(this.getBorder());
        if (parentBoundingBox != null) {
            float ury;
            boolean yIntersects;
            XFARectangle parentBBox = parentBoundingBox;
            if (!this.transformation.isIdentity()) {
                float[] rectPoints = new float[]{parentBBox.getLlx().floatValue(), parentBBox.getUry().floatValue() - parentBBox.getHeight().floatValue(), parentBBox.getLlx().floatValue() + parentBBox.getWidth().floatValue(), parentBBox.getUry().floatValue()};
                try {
                    this.transformation.inverseTransform(rectPoints, 0, rectPoints, 0, 2);
                    parentBBox = new XFARectangle(Float.valueOf(rectPoints[0] < rectPoints[2] ? rectPoints[0] : rectPoints[2]), Float.valueOf(rectPoints[3] > rectPoints[1] ? rectPoints[3] : rectPoints[1]), Float.valueOf(Math.abs(rectPoints[2] - rectPoints[0])), Float.valueOf(Math.abs(rectPoints[3] - rectPoints[1])));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            float parentLly = parentBBox.getUry().floatValue() - parentBBox.getHeight().floatValue();
            float lly = rec.getUry().floatValue() - rec.getHeight().floatValue();
            boolean bl = yIntersects = XFAUtil.gte(rec.getUry().floatValue(), parentLly) && XFAUtil.lte(lly, parentBBox.getUry().floatValue());
            if (yIntersects && XFAUtil.gte(ury = this.isPositionedPartially() ? Math.max(rec.getUry().floatValue(), parentBBox.getUry().floatValue()) : Math.min(rec.getUry().floatValue(), parentBBox.getUry().floatValue()), lly = Math.max(lly, parentLly))) {
                float height = ury - lly;
                rec.setUry(Float.valueOf(ury));
                rec.setHeight(Float.valueOf(height));
            }
        }
        rec = rec.applyTransformation(this.transformation);
        borderDrawer.draw(canvas, rec);
    }

    @Override
    public Object fetchDataNode(boolean createNewIfNotExists) {
        if (this.data != null && this.data.getNode() != null) {
            return this.data.getNode();
        }
        Object rawValue = this.getRawValue();
        if (createNewIfNotExists && (!(rawValue instanceof CharSequence) || ((CharSequence)rawValue).length() != 0)) {
            DataTag newDataTag = this.fetchDataTagRecursively();
            return newDataTag != null ? newDataTag.getNode() : null;
        }
        return null;
    }

    public DataTag fetchDataTagRecursively() {
        DataTag parentDataTag;
        if (this.data != null) {
            return this.data;
        }
        if (this.parent != null && (parentDataTag = this.parent.fetchDataTagRecursively()) != null) {
            String ref;
            String bindTagName = this.retrieveName();
            FormNode bindNode = this.retrieveChild("bind");
            if (bindNode != null && (ref = bindNode.retrieveAttribute("ref")) != null) {
                bindTagName = ref.replaceFirst("^\\$", "").replaceFirst("^\\.", "");
            }
            if (bindTagName == null) {
                return parentDataTag;
            }
            this.data = new DataTag(bindTagName);
            this.data.setParent(parentDataTag);
            parentDataTag.addChild(this.data);
            JsNode dataNode = this instanceof FieldPositioner ? new JsDataValue(this.data, parentDataTag.getNode()) : new JsDataGroup(this.data, parentDataTag.getNode());
            dataNode.defineProperty("value", this.getRawValue());
            this.data.setNode(dataNode);
            parentDataTag.getNode().addChild(dataNode);
            return this.data;
        }
        return null;
    }

    public Object getRawValue() {
        Object rawValue = this.getOwnProperty("rawValue");
        if (!(rawValue == null || this.isUndefined(rawValue) || rawValue instanceof Double && Double.isNaN((Double)rawValue))) {
            return rawValue;
        }
        return null;
    }

    public void setRawValue(Object rawValue) {
        this.defineProperty("rawValue", rawValue);
    }

    public String getLayout() {
        Object layout = this.getProperty("layout");
        if (layout != null) {
            return layout.toString();
        }
        return null;
    }

    public XFARectangle getContentArea() {
        return this.contentArea;
    }

    @Override
    public void addChild(JsTree child) {
        if (child instanceof Positioner) {
            this.childElements.add((Positioner)child);
            if (!this.immediateChildren.containsKey(child.retrieveName())) {
                this.immediateChildren.put(child.retrieveName(), (Positioner)child);
            }
        }
        super.addChild(child);
    }

    public List<Positioner> getChildren() {
        return this.childElements;
    }

    public void removeChild(int index) {
        Positioner removedChild = this.childElements.remove(index);
        if (this.immediateChildren.get(removedChild.retrieveName()) == removedChild) {
            this.immediateChildren.remove(removedChild.retrieveName());
        }
    }

    public XFARectangle getBBox() {
        XFARectangle bBox = this.contentArea.clone();
        this.unapplyMargins(bBox);
        if (this.transformation.getType() != 0) {
            float[] rectPoints = new float[]{bBox.getLlx().floatValue(), bBox.getUry().floatValue() - bBox.getHeight().floatValue(), bBox.getLlx().floatValue() + bBox.getWidth().floatValue(), bBox.getUry().floatValue()};
            this.transformation.transform(rectPoints, 0, rectPoints, 0, 2);
            return new XFARectangle(Float.valueOf(rectPoints[0] < rectPoints[2] ? rectPoints[0] : rectPoints[2]), Float.valueOf(rectPoints[3] > rectPoints[1] ? rectPoints[3] : rectPoints[1]), Float.valueOf(Math.abs(rectPoints[2] - rectPoints[0])), Float.valueOf(Math.abs(rectPoints[3] - rectPoints[1])));
        }
        return bBox;
    }

    @Override
    public Positioner getParent() {
        return this.parent;
    }

    public void setParent(Positioner parent) {
        this.parent = parent;
    }

    public BreakConditions getBreakConditions() {
        return this.breakConditions;
    }

    public void setBreakConditions(BreakConditions breakConditions) {
        this.breakConditions = breakConditions;
    }

    public KeepConditions getKeepConditions() {
        return this.keepConditions;
    }

    public abstract boolean isBreakable();

    public XFATemplateTag getTemplate() {
        return this.template;
    }

    public DataTag getData() {
        return this.data;
    }

    public void setData(DataTag data) {
        this.data = data;
    }

    public PdfContentByte getCanvas() {
        return this.canvas;
    }

    public void setCanvas(PdfContentByte canvas) {
        this.canvas = canvas;
    }

    public Integer getStartSheetNumber() {
        return this.startSheetNumber;
    }

    public Integer getStartPageNumber() {
        return this.startPageNumber;
    }

    public void setStartPageNumber(Integer startPageNumber) {
        this.startPageNumber = startPageNumber;
    }

    public Integer getStartAbsPageNumber() {
        return this.startAbsPageNumber;
    }

    public void setStartAbsPageNumber(Integer startAbsPageNumber) {
        this.startAbsPageNumber = startAbsPageNumber;
    }

    public Integer getEndPageNumber() {
        return this.endPageNumber;
    }

    public void setEndPageNumber(Integer endPageNumber) {
        this.endPageNumber = endPageNumber;
    }

    public Integer getEndAbsPageNumber() {
        return this.endAbsPageNumber;
    }

    public void setEndAbsPageNumber(Integer endAbsPageNumber) {
        this.endAbsPageNumber = endAbsPageNumber;
    }

    public String getName() {
        return this.retrieveName();
    }

    public PositionResult.State getPositionState() {
        return this.positionState;
    }

    public void setPositionState(PositionResult.State positionState) {
        this.positionState = positionState;
    }

    public String getTemplateId() {
        Object property = this.getOwnProperty("id");
        if (property != null) {
            return property.toString();
        }
        return null;
    }

    public OverflowConditions getOverflowConditions() {
        return this.overflowConditions;
    }

    public boolean isCurrentPageContentAreaOverflowed(PageArea pageArea) {
        if (this.overflowedContentAreas != null && pageArea != null) {
            ContentArea currContentArea = pageArea.getCurrentContentArea();
            return currContentArea != null && this.overflowedContentAreas.contains(currContentArea.getTemplate());
        }
        return false;
    }

    public void addOverflowedPageContentArea(PageArea pageArea) {
        if (pageArea == null) {
            return;
        }
        ContentArea currContentArea = pageArea.getCurrentContentArea();
        if (currContentArea != null) {
            if (this.overflowedContentAreas == null) {
                this.overflowedContentAreas = new HashSet(1);
            }
            this.overflowedContentAreas.add(currContentArea.getTemplate());
        }
    }

    public AffineTransform getTransformation() {
        return this.transformation;
    }

    public void setTransformation(AffineTransform transform) {
        this.transformation = transform;
    }

    protected boolean supportLegacyPlusPrint() {
        return false;
    }

    public boolean isLayoutOutOfDate() {
        return this.layoutOutOfDate;
    }

    public void setLayoutOutOfDate(boolean layoutOutOfDate) {
        this.layoutOutOfDate = layoutOutOfDate;
    }

    public boolean isVisible() {
        Object presence;
        if (this.flattenerContext.getViewMode() != XFAFlattener.ViewMode.ALL) {
            String relevantViewName;
            Object relevant = this.getOwnProperty("relevant");
            boolean legacyPlusPrint = this.flattenerContext.isLegacyPlusPrint();
            if (relevant != null && (!legacyPlusPrint || legacyPlusPrint && this.supportLegacyPlusPrint()) && (relevantViewName = relevant.toString()).contains("print")) {
                if (this.flattenerContext.getViewMode() == XFAFlattener.ViewMode.PRINT && relevantViewName.contains("-print")) {
                    return false;
                }
                if (this.flattenerContext.getViewMode() == XFAFlattener.ViewMode.SCREEN && !relevantViewName.contains("-print")) {
                    return false;
                }
            }
        }
        return (presence = this.getProperty("presence")) == null || presence.toString().equals("visible");
    }

    public boolean isInvisible() {
        Object presence = this.getProperty("presence");
        return "invisible".equals(presence);
    }

    public void adjustLayout() {
        this.adjustContentArea();
        for (Positioner child : this.childElements) {
            if (!(child instanceof SubFormPositioner) || child.isHidden() || child.isInactive()) continue;
            ((SubFormPositioner)child).applyAlignment();
        }
        this.applyRotation();
        if (this.parent != null) {
            Positioner previousPositionerInLayout = this.parent.getPreviousPositionerInLayout(this, this.getLayout());
            XFARectangle bbox = this.getBBox();
            XFARectangle parentContentArea = this.parent.getContentArea();
            String parentLayout = this.parent.getLayout();
            if (this.template.getParent() == null || this.template.getParent().getParent() != null) {
                if ("tb".equals(parentLayout)) {
                    float ury;
                    if (previousPositionerInLayout != null) {
                        XFARectangle previousBBox = previousPositionerInLayout.getBBox();
                        ury = previousBBox.getUry().floatValue() - previousBBox.getHeight().floatValue();
                    } else {
                        ury = parentContentArea.getUry().floatValue();
                    }
                    this.applyTranslation(0.0f, ury - bbox.getUry().floatValue());
                } else if (!"row".equals(parentLayout) && "lr-tb".equalsIgnoreCase(parentLayout)) {
                    if (previousPositionerInLayout != null) {
                        XFARectangle previousBBox = previousPositionerInLayout.getBBox();
                        if (parentContentArea.getWidth() != null && !((double)(previousBBox.getLlx().floatValue() + previousBBox.getWidth().floatValue() + bbox.getWidth().floatValue() - parentContentArea.getLlx().floatValue() - parentContentArea.getWidth().floatValue()) < 0.01)) {
                            float lly = previousBBox.getUry().floatValue() - previousBBox.getHeight().floatValue();
                            for (int i = this.parent.getChildren().indexOf(this) - 2; i >= 0; --i) {
                                XFARectangle neighbourBBox;
                                float neighborsLly;
                                Positioner neighborPositioner = this.parent.getChildren().get(i);
                                if (neighborPositioner.isHidden() || neighborPositioner.isInactive() || !(lly > (neighborsLly = (neighbourBBox = neighborPositioner.getBBox()).getUry().floatValue() - neighbourBBox.getHeight().floatValue()))) continue;
                                lly = neighborsLly;
                            }
                            this.applyTranslation(parentContentArea.getLlx().floatValue() - bbox.getLlx().floatValue(), lly - bbox.getUry().floatValue());
                        }
                    } else {
                        this.applyTranslation(parentContentArea.getLlx().floatValue() - bbox.getLlx().floatValue(), parentContentArea.getUry().floatValue() - bbox.getUry().floatValue());
                    }
                }
            }
        }
    }

    protected void applyRotation() {
        Map<String, String> attrs = this.template.getAttributes();
        if (attrs != null) {
            Float rotation;
            String parentLayout = "position";
            if (this.parent != null) {
                parentLayout = this.parent.getLayout();
            }
            XFARectangle unmarginedRec = this.contentArea.clone();
            this.unapplyMargins(unmarginedRec);
            float anchorX = unmarginedRec.getLlx().floatValue();
            float anchorY = unmarginedRec.getUry().floatValue();
            String anchorType = attrs.get("anchorType");
            if (!(anchorType == null || parentLayout.equals("tb") || parentLayout.equals("lr-tb") || parentLayout.equals("row"))) {
                if (this.contentArea.getWidth() != null) {
                    if (anchorType.contains("center".replace('c', 'C'))) {
                        anchorX = unmarginedRec.getLlx().floatValue() + unmarginedRec.getWidth().floatValue() / 2.0f;
                    } else if (anchorType.contains("right".replace('r', 'R'))) {
                        anchorX = unmarginedRec.getLlx().floatValue() + unmarginedRec.getWidth().floatValue();
                    }
                }
                if (this.contentArea.getHeight() != null) {
                    if (anchorType.contains("middle")) {
                        anchorY = unmarginedRec.getUry().floatValue() - unmarginedRec.getHeight().floatValue() / 2.0f;
                    } else if (anchorType.contains("bottom")) {
                        anchorY = unmarginedRec.getUry().floatValue() - unmarginedRec.getHeight().floatValue();
                    }
                }
                float transX = unmarginedRec.getLlx().floatValue() - anchorX;
                float transY = unmarginedRec.getUry().floatValue() - anchorY;
                if (!this.template.getAttributes().containsKey("x")) {
                    transX = 0.0f;
                }
                if (!this.template.getAttributes().containsKey("y")) {
                    transY = 0.0f;
                }
                this.applyTranslation(transX, transY);
            }
            if (!((rotation = XFAUtil.parseFloat(attrs.get("rotate"))) == null || this.parent != null && "row".equals(this.parent.getLayout()))) {
                this.transformation.concatenate(AffineTransform.getRotateInstance(Math.toRadians(rotation.floatValue()), anchorX, anchorY));
            }
        }
    }

    public void applyTranslation(float xtr, float ytr) {
        xtr = (float)Math.round(xtr * 1000.0f) / 1000.0f;
        ytr = (float)Math.round(ytr * 1000.0f) / 1000.0f;
        if (xtr != 0.0f || ytr != 0.0f) {
            AffineTransform commonTransformation = AffineTransform.getTranslateInstance(xtr, ytr);
            commonTransformation.concatenate(this.transformation);
            this.transformation = commonTransformation;
        }
    }

    public void applyTransformationToRectangle(XFARectangle bbox) {
        this.applyTransformationToRectangle(bbox, false);
    }

    public void applyTransformationToRectangle(XFARectangle bbox, boolean inverse) {
        if (!this.transformation.isIdentity()) {
            float[] rectPoints = new float[]{bbox.getLlx().floatValue(), bbox.getUry().floatValue() - bbox.getHeight().floatValue(), bbox.getLlx().floatValue() + bbox.getWidth().floatValue(), bbox.getUry().floatValue()};
            try {
                if (inverse) {
                    this.transformation.inverseTransform(rectPoints, 0, rectPoints, 0, 2);
                } else {
                    this.transformation.transform(rectPoints, 0, rectPoints, 0, 2);
                }
                bbox.setLlx(Float.valueOf(rectPoints[0] < rectPoints[2] ? rectPoints[0] : rectPoints[2]));
                bbox.setUry(Float.valueOf(rectPoints[3] > rectPoints[1] ? rectPoints[3] : rectPoints[1]));
                bbox.setWidth(Float.valueOf(Math.abs(rectPoints[2] - rectPoints[0])));
                bbox.setHeight(Float.valueOf(Math.abs(rectPoints[3] - rectPoints[1])));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected Positioner findNextBreakableElement(int startFrom) {
        String parentLayout;
        int nextIndex = startFrom;
        int childrenNumber = this.parent.getChildren().size();
        if (nextIndex < childrenNumber && ("tb".equals(parentLayout = this.parent.getLayout()) || "lr-tb".equals(parentLayout) || "row".equals(parentLayout) || "table".equals(parentLayout))) {
            Positioner nextPositioner = this.parent.getChildren().get(nextIndex);
            while (nextPositioner.isHidden() || nextPositioner.isInactive()) {
                if (++nextIndex < childrenNumber) {
                    nextPositioner = this.parent.getChildren().get(nextIndex);
                    continue;
                }
                nextPositioner = null;
                break;
            }
            if (nextPositioner != null) {
                if (this.keepConditions != null && !this.keepConditions.getNext().equals("none")) {
                    return nextPositioner.findNextBreakableElement(nextIndex + 1);
                }
                if (nextPositioner.getKeepConditions() != null && !nextPositioner.getKeepConditions().getPrevious().equals("none")) {
                    return nextPositioner.findNextBreakableElement();
                }
                XFARectangle bbox = this.getBBox();
                XFARectangle neighborBbox = nextPositioner.getBBox();
                float lly = bbox.getUry().floatValue() - bbox.getHeight().floatValue();
                float neighborLly = neighborBbox.getUry().floatValue() - neighborBbox.getHeight().floatValue();
                if (XFAUtil.equal(bbox.getUry().floatValue(), neighborBbox.getUry().floatValue()) && XFAUtil.lte(neighborLly, lly)) {
                    return nextPositioner.findNextBreakableElement();
                }
            }
        }
        return this;
    }

    protected boolean doesNotFitContentArea(float bottomMargin, float contentAreaBottom) {
        XFARectangle rec = this.getAbsoluteBbox(true);
        float height = rec.getHeight() != null ? rec.getHeight().floatValue() : 0.0f;
        return rec.getUry().floatValue() - height - contentAreaBottom < -0.1f - bottomMargin;
    }

    protected Positioner findNextBreakableElement() {
        if (this.parent != null) {
            return this.findNextBreakableElement(this.parent.getChildren().indexOf(this) + 1);
        }
        return this;
    }

    protected abstract void adjustContentArea();

    protected void adjustContentAreaHeight(float newHeight) {
        if (this.contentArea.getHeight() != null) {
            this.unapplyMargins(this.contentArea);
            this.contentArea.setHeight(Float.valueOf(newHeight));
            this.applyMargins(this.contentArea);
        } else {
            this.contentArea.setHeight(Float.valueOf(newHeight));
        }
    }

    public abstract void relayout(boolean var1);

    protected void adjustContentAreaUry(float ury) {
        if (this.contentArea.getUry() != null) {
            this.unapplyMargins(this.contentArea);
            float currentUry = this.contentArea.getUry().floatValue();
            this.contentArea.setUry(Float.valueOf(ury));
            this.contentArea.setHeight(Float.valueOf(this.contentArea.getHeight().floatValue() - (currentUry - ury)));
            this.applyMargins(this.contentArea);
        } else {
            this.contentArea.setUry(Float.valueOf(ury));
        }
    }

    protected boolean isPositionedPartially() {
        return false;
    }

    public Positioner getPreviousPositionerInLayout(Positioner childPositioner, String layout) {
        return this.getLastPositionerBeforeInd(this.childElements.indexOf(childPositioner), layout);
    }

    public Positioner getLastPositionerInLayout(String layout) {
        return this.getLastPositionerBeforeInd(this.childElements.size(), layout);
    }

    public XFARectangle getAbsoluteBbox() {
        return this.getAbsoluteBbox(false);
    }

    public XFARectangle getAbsoluteBbox(boolean ignorePagenationTransformation) {
        AffineTransform finalTransformation = this.getFinalTransformation(ignorePagenationTransformation);
        if (!finalTransformation.isIdentity()) {
            XFARectangle bBox = this.contentArea.clone();
            this.unapplyMargins(bBox);
            float[] rectPoints = new float[]{bBox.getLlx().floatValue(), bBox.getUry().floatValue() - bBox.getHeight().floatValue(), bBox.getLlx().floatValue() + bBox.getWidth().floatValue(), bBox.getUry().floatValue()};
            finalTransformation.transform(rectPoints, 0, rectPoints, 0, 2);
            return new XFARectangle(Float.valueOf(rectPoints[0] < rectPoints[2] ? rectPoints[0] : rectPoints[2]), Float.valueOf(rectPoints[3] > rectPoints[1] ? rectPoints[3] : rectPoints[1]), Float.valueOf(Math.abs(rectPoints[2] - rectPoints[0])), Float.valueOf(Math.abs(rectPoints[3] - rectPoints[1])));
        }
        return this.getBBox();
    }

    public AffineTransform getFinalTransformation(boolean ignorePagenationTransformation) {
        Positioner parent = this.parent;
        AffineTransform finalTransformation = new AffineTransform(this.transformation);
        while (!(parent == null || ignorePagenationTransformation && parent.parent == null)) {
            finalTransformation.preConcatenate(parent.getTransformation());
            parent = parent.parent;
        }
        return finalTransformation;
    }

    protected Positioner getLastPositionerBeforeInd(int childIndex, String childLayout) {
        Positioner previousPositionerInLayout = null;
        for (int i = childIndex - 1; i >= 0; --i) {
            Positioner positioner = this.childElements.get(i);
            if (positioner.isHidden() || positioner.isInactive() || positioner instanceof SubformSetPositioner && "row".equals(childLayout) && (positioner = positioner.getLastPositionerInLayout(childLayout)) == null) continue;
            previousPositionerInLayout = positioner;
            break;
        }
        if (previousPositionerInLayout == null && this instanceof SubformSetPositioner && this.parent != null) {
            previousPositionerInLayout = this.parent.getPreviousPositionerInLayout(this, childLayout);
        }
        return previousPositionerInLayout;
    }

    protected void savePosState(PdfContentByte canvas) {
        if (canvas.isTagged() && this.isTagged) {
            canvas.openMCBlock(this);
        }
        if (this.transformation.getType() != 0) {
            canvas.saveState();
            canvas.transform(this.transformation);
        }
    }

    protected void restorePosState(PdfContentByte canvas) {
        if (this.transformation.getType() != 0) {
            canvas.restoreState();
        }
        if (canvas.isTagged() && this.isTagged) {
            canvas.closeMCBlock(this);
        }
    }

    private FormNode getBorder() {
        return this.retrieveChild("border");
    }

    @Override
    public Object getFormattedValue() {
        return this.getRawValue();
    }

    protected String getAlternateText() {
        FormNode speakTag;
        String altText = "";
        if (this.assistTag != null && (speakTag = this.assistTag.retrieveChild("speak")) != null) {
            Map<String, String> speakAttrs = speakTag.retrieveAttributes();
            if (speakAttrs == null) {
                List<String> speakContent = ((XFATemplateTag)speakTag).getContent();
                if (speakContent != null && speakContent.size() > 0) {
                    altText = speakContent.get(0);
                }
            } else {
                String disable = speakAttrs.get("disable");
                if (!"1".equals(disable)) {
                    String toolTip = this.getToolTipText(this.assistTag);
                    String speak = this.getSpeakText(this.assistTag);
                    String name = this.template.retrieveAttribute("name");
                    if (name == null) {
                        name = "";
                    }
                    String caption = this.getCaptionText();
                    String priority = speakAttrs.get("priority");
                    altText = "caption".equals(priority) ? this.getAltText(caption, speak, toolTip, name) : ("name".equals(priority) ? this.getAltText(name, speak, toolTip, caption) : ("toolTip".equals(priority) ? this.getAltText(toolTip, speak, caption, name) : this.getAltText(speak, toolTip, caption, name)));
                }
            }
        }
        return altText;
    }

    public float getBottomInset() {
        FormNode marginTag = this.retrieveChild("margin");
        if (marginTag != null) {
            return CssUtils.getInstance().parsePxInCmMmPcToPt(marginTag.retrieveAttribute("bottomInset"), "pt");
        }
        return 0.0f;
    }

    public void applyMargins(XFARectangle rectangle) {
        FormNode marginTag = this.retrieveChild("margin");
        if (marginTag != null) {
            float topIndent = CssUtils.getInstance().parsePxInCmMmPcToPt(marginTag.retrieveAttribute("topInset"), "pt");
            float rightIndent = CssUtils.getInstance().parsePxInCmMmPcToPt(marginTag.retrieveAttribute("rightInset"), "pt");
            float leftIndent = CssUtils.getInstance().parsePxInCmMmPcToPt(marginTag.retrieveAttribute("leftInset"), "pt");
            float bottomIndent = CssUtils.getInstance().parsePxInCmMmPcToPt(marginTag.retrieveAttribute("bottomInset"), "pt");
            float[] marginsArray = new float[]{topIndent, rightIndent, bottomIndent, leftIndent};
            Integer independentRotation = this.getIndependentRotation();
            if (independentRotation != null && independentRotation % 180 == 90) {
                for (int i = 0; i < independentRotation / 90; ++i) {
                    marginsArray = new float[]{marginsArray[3], marginsArray[0], marginsArray[1], marginsArray[2]};
                }
            }
            XFARectangle.applyMargins(rectangle, this.isPositionedPartially() ? 0.0f : marginsArray[0], marginsArray[1], marginsArray[2], marginsArray[3], false);
        }
    }

    public XFARectangle unapplyMargins(XFARectangle rectangle) {
        FormNode marginTag = this.retrieveChild("margin");
        if (marginTag != null) {
            float topIndent = CssUtils.getInstance().parsePxInCmMmPcToPt(marginTag.retrieveAttribute("topInset"), "pt");
            float rightIndent = CssUtils.getInstance().parsePxInCmMmPcToPt(marginTag.retrieveAttribute("rightInset"), "pt");
            float leftIndent = CssUtils.getInstance().parsePxInCmMmPcToPt(marginTag.retrieveAttribute("leftInset"), "pt");
            float bottomIndent = CssUtils.getInstance().parsePxInCmMmPcToPt(marginTag.retrieveAttribute("bottomInset"), "pt");
            float[] marginsArray = new float[]{topIndent, rightIndent, bottomIndent, leftIndent};
            Integer independentRotation = this.getIndependentRotation();
            if (independentRotation != null && independentRotation % 180 == 90) {
                for (int i = 0; i < independentRotation / 90; ++i) {
                    marginsArray = new float[]{marginsArray[3], marginsArray[0], marginsArray[1], marginsArray[2]};
                }
            }
            XFARectangle.applyMargins(rectangle, this.isPositionedPartially() ? 0.0f : marginsArray[0], marginsArray[1], marginsArray[2], marginsArray[3], true);
        }
        return rectangle;
    }

    @Override
    public PdfObject getAccessibleAttribute(PdfName key) {
        if (this.accessibleAttributes != null) {
            return this.accessibleAttributes.get(key);
        }
        return null;
    }

    @Override
    public void setAccessibleAttribute(PdfName key, PdfObject value) {
        if (this.accessibleAttributes == null) {
            this.accessibleAttributes = new HashMap();
        }
        this.accessibleAttributes.put(key, value);
    }

    @Override
    public HashMap<PdfName, PdfObject> getAccessibleAttributes() {
        return this.accessibleAttributes;
    }

    @Override
    public PdfName getRole() {
        return this.role;
    }

    @Override
    public void setRole(PdfName role) {
        this.role = role;
    }

    @Override
    public AccessibleElementId getId() {
        if (this.id == null) {
            this.id = new AccessibleElementId();
        }
        return this.id;
    }

    @Override
    public void setId(AccessibleElementId id) {
        this.id = id;
    }

    @Override
    public boolean isInline() {
        return PdfName.ARTIFACT.equals(this.role);
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean isContentTagged() {
        return this.isContentTagged;
    }

    protected String getCaptionText() {
        return "";
    }

    private String getTagContent(FormNode parentTag, String tagName) {
        FormNode tag = parentTag.retrieveChild(tagName);
        if (tag == null) {
            return "";
        }
        List<String> content = tag.retrieveContent();
        if (content == null || content.size() == 0) {
            return "";
        }
        return content.get(0);
    }

    private String getToolTipText(FormNode assistTag) {
        return this.getTagContent(assistTag, "toolTip");
    }

    private String getSpeakText(FormNode assistTag) {
        return this.getTagContent(assistTag, "speak");
    }

    private String getAltText(String s1, String s2, String s3, String s4) {
        String[] array;
        for (String elem : array = new String[]{s1, s2, s3, s4}) {
            if (elem == null || elem.isEmpty()) continue;
            return elem;
        }
        return "";
    }

    protected boolean isBackgroundOrBorderExist() {
        FormNode border = this.getBorder();
        return border != null && !BorderDrawer.isEmpty(border);
    }

    public void setX(Float x) {
        if (this.contentArea != null) {
            this.contentArea.setLlx(x);
        }
        this.defineProperty("x", String.valueOf(x) + "pt");
    }

    public void setWidth(Float w) {
        if (this.contentArea != null) {
            this.contentArea.setWidth(w);
        }
        this.defineProperty("w", String.valueOf(w) + "pt");
    }

    protected void updatePageNumbers() {
        if (this.startPageNumber == null) {
            this.startPageNumber = this.flattenerContext.getCurrentPageNumber();
        }
        if (this.startAbsPageNumber == null) {
            this.startAbsPageNumber = this.flattenerContext.getCurrentAbsPageNumber();
        }
        if (this.startSheetNumber == null) {
            this.startSheetNumber = this.flattenerContext.getCurrentSheetNumber();
        }
        this.endPageNumber = this.flattenerContext.getCurrentPageNumber();
        this.endAbsPageNumber = this.flattenerContext.getCurrentAbsPageNumber();
    }

    public class RowLayoutComparator
    implements Comparator<Positioner> {
        @Override
        public int compare(Positioner o1, Positioner o2) {
            if (o1 instanceof ContentPositioner) {
                if (o2 instanceof SubFormPositioner) {
                    return 1;
                }
            } else if (o2 instanceof ContentPositioner) {
                return -1;
            }
            return 0;
        }
    }

    public class PositionedLayoutComparator
    implements Comparator<Positioner> {
        @Override
        public int compare(Positioner o1, Positioner o2) {
            boolean neighborVisible;
            if (o1.isHidden() || o1.isInactive()) {
                if (o2.isHidden() || o2.isInactive()) {
                    return 0;
                }
                return 1;
            }
            if (o2.isHidden() || o2.isInactive()) {
                return -1;
            }
            XFARectangle bbox = o1.getBBox();
            XFARectangle neighborBbox = o2.getBBox();
            boolean visible = o1.isVisible() && XFAUtil.gt(bbox.getHeight().floatValue(), 0.0f) && XFAUtil.gt(bbox.getWidth().floatValue(), 0.0f);
            boolean bl = neighborVisible = o2.isVisible() && XFAUtil.gt(neighborBbox.getHeight().floatValue(), 0.0f) && XFAUtil.gt(neighborBbox.getWidth().floatValue(), 0.0f);
            if (visible && neighborVisible) {
                boolean xIntersects;
                boolean yIntersects;
                float yDeviation = Math.min(bbox.getHeight().floatValue() / 2.2f, neighborBbox.getHeight().floatValue() / 2.2f);
                float lly = bbox.getUry().floatValue() - bbox.getHeight().floatValue();
                float neighborLly = neighborBbox.getUry().floatValue() - neighborBbox.getHeight().floatValue();
                boolean bl2 = yIntersects = XFAUtil.gte(bbox.getUry().floatValue(), neighborLly) && XFAUtil.lte(lly, neighborBbox.getUry().floatValue());
                if (!yIntersects) {
                    if (XFAUtil.gt(bbox.getUry().floatValue(), neighborBbox.getUry().floatValue())) {
                        return -1;
                    }
                    return 1;
                }
                if (XFAUtil.gt(Math.abs(lly - neighborLly), yDeviation)) {
                    if (lly > neighborLly) {
                        return -1;
                    }
                    return 1;
                }
                if (XFAUtil.gt(Math.abs(bbox.getUry().floatValue() - neighborBbox.getUry().floatValue()), yDeviation)) {
                    if (bbox.getUry().floatValue() > neighborBbox.getUry().floatValue()) {
                        return -1;
                    }
                    return 1;
                }
                float urx = bbox.getLlx().floatValue() + bbox.getWidth().floatValue();
                float neighborUrx = neighborBbox.getLlx().floatValue() + neighborBbox.getWidth().floatValue();
                boolean bl3 = xIntersects = XFAUtil.gte(urx, neighborBbox.getLlx().floatValue()) && XFAUtil.lte(bbox.getLlx().floatValue(), neighborUrx);
                if (!xIntersects) {
                    if (XFAUtil.lt(bbox.getLlx().floatValue(), neighborBbox.getLlx().floatValue())) {
                        return -1;
                    }
                    return 1;
                }
                if (!XFAUtil.equal(urx, neighborUrx)) {
                    if (urx < neighborUrx) {
                        return -1;
                    }
                    return 1;
                }
                if (!XFAUtil.equal(bbox.getLlx().floatValue(), neighborBbox.getLlx().floatValue())) {
                    if (bbox.getLlx().floatValue() < neighborBbox.getLlx().floatValue()) {
                        return -1;
                    }
                    return 1;
                }
                if (!XFAUtil.equal(lly, neighborLly)) {
                    if (lly > neighborLly) {
                        return -1;
                    }
                    return 1;
                }
                if (!XFAUtil.equal(bbox.getUry().floatValue(), neighborBbox.getUry().floatValue())) {
                    if (bbox.getUry().floatValue() > neighborBbox.getUry().floatValue()) {
                        return -1;
                    }
                    return 1;
                }
                return 0;
            }
            if (visible) {
                return -1;
            }
            if (neighborVisible) {
                return 1;
            }
            return 0;
        }
    }
}

