/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.positioner;

import com.itextpdf.tool.xml.xtra.xfa.positioner.LayoutManager;
import com.itextpdf.tool.xml.xtra.xfa.positioner.Positioner;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import java.util.ArrayList;
import java.util.List;

public class TableLayoutManager
extends LayoutManager {
    private ArrayList<Positioner> rows = new ArrayList();
    private ArrayList<Float> colWidths = new ArrayList();
    Positioner tableNode;

    public TableLayoutManager(Positioner tag) {
        this.tableNode = tag;
        String layout = tag.retrieveAttribute("layout");
        if ("table".equals(layout)) {
            this.readRowsRecursively(tag.getChildren());
            String colWidthsStr = this.tableNode.retrieveAttribute("columnWidths");
            if (colWidthsStr != null) {
                this.colWidths = XFAUtil.parseNumArray(colWidthsStr);
            }
        }
    }

    public void preprocessHorizontalCellLayout() {
        this.preprocessHorizontalCellLayout(null);
    }

    public void preprocessHorizontalCellLayout(Positioner extraRow) {
        boolean isDynamicLayout = TableLayoutManager.isDynamicTableLayout(this.tableNode.retrieveAttribute("columnWidths"));
        if (isDynamicLayout) {
            this.colWidths = new ArrayList();
            if (this.rows.size() > 0) {
                int maxRowSize = 0;
                for (Positioner row : this.rows) {
                    if (row.getChildren().size() <= maxRowSize) continue;
                    maxRowSize = row.size();
                }
                for (int i = 0; i < maxRowSize; ++i) {
                    boolean allCellInColumnAreHidden = true;
                    float maxColWidth = 0.0f;
                    for (Positioner row : this.rows) {
                        Positioner cell;
                        List<Positioner> cells = row.getChildren();
                        if (i >= cells.size() || (cell = cells.get(i)).isHidden() || cell.isInactive()) continue;
                        allCellInColumnAreHidden = false;
                        XFARectangle contentArea = cell.getContentArea();
                        if (contentArea.getWidth() == null || !(contentArea.getWidth().floatValue() > maxColWidth)) continue;
                        maxColWidth = contentArea.getWidth().floatValue();
                    }
                    if (allCellInColumnAreHidden) continue;
                    this.colWidths.add(Float.valueOf(maxColWidth));
                }
            }
        }
        if (this.colWidths.size() > 0) {
            if (extraRow != null) {
                this.rows = new ArrayList();
                this.readRowsRecursively(extraRow);
            }
            for (Positioner row : this.rows) {
                int curColSpan = 0;
                float curX = 0.0f;
                List<Positioner> children = row.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    int j;
                    Positioner cell = children.get(i);
                    if (cell.isHidden() || cell.isInactive()) continue;
                    String colSpanS = cell.retrieveAttribute("colSpan");
                    if (colSpanS == null || colSpanS.length() == 0) {
                        colSpanS = "1";
                    }
                    Integer colSpanValue = Integer.parseInt(colSpanS);
                    float cellWidth = 0.0f;
                    if (colSpanValue == -1) {
                        colSpanValue = this.colWidths.size() - curColSpan;
                        for (j = i + 1; j < children.size(); ++j) {
                            children.get(j).defineProperty("presence", "hidden");
                        }
                    }
                    for (j = curColSpan; j < (colSpanValue >= 0 ? curColSpan + colSpanValue : this.colWidths.size()); ++j) {
                        if (j >= this.colWidths.size()) continue;
                        cellWidth += this.colWidths.get(j).floatValue();
                    }
                    cell.setX(Float.valueOf(curX));
                    cell.setWidth(Float.valueOf(cellWidth));
                    curX += cellWidth;
                    curColSpan += colSpanValue.intValue();
                }
            }
        }
    }

    private void readRowsRecursively(Positioner node) {
        String layout = node.retrieveAttribute("layout");
        if (!"table".equals(layout)) {
            if ("row".equals(layout)) {
                this.rows.add(node);
            } else {
                this.readRowsRecursively(node.getChildren());
            }
        }
    }

    private void readRowsRecursively(List<Positioner> tagList) {
        for (Positioner tag : tagList) {
            this.readRowsRecursively(tag);
        }
    }

    public static Positioner getParentTable(Positioner node) {
        Positioner parent = node.getParent();
        if (parent != null && !"table".equals(parent.retrieveAttribute("layout"))) {
            return TableLayoutManager.getParentTable(parent);
        }
        return parent;
    }

    public static boolean isDynamicTableLayout(String columnWidthsParameter) {
        if (columnWidthsParameter == null) {
            return true;
        }
        ArrayList<Float> colWidth = XFAUtil.parseNumArray(columnWidthsParameter);
        boolean allZeros = true;
        for (Float aColWidth : colWidth) {
            if (aColWidth.floatValue() == 0.0f) continue;
            allZeros = false;
            break;
        }
        return allZeros;
    }

    public static Float getNthColumnWidth(String columnWidthsParameter, int n) {
        if (columnWidthsParameter == null) {
            return null;
        }
        ArrayList<Float> colWidth = XFAUtil.parseNumArray(columnWidthsParameter);
        return Float.valueOf(colWidth.size() > n ? ((Float)colWidth.get(n)).floatValue() : -1.0f);
    }
}

