/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.LineSegment;
import com.itextpdf.text.pdf.parser.Matrix;
import com.itextpdf.text.pdf.parser.TextExtractionStrategy;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import com.itextpdf.text.pdf.parser.Vector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Deprecated
public class LocationTextExtractionStrategy
implements TextExtractionStrategy {
    static boolean DUMP_STATE = false;
    private final List<TextChunk> locationalResult = new ArrayList<TextChunk>();
    private final TextChunkLocationStrategy tclStrat;

    public LocationTextExtractionStrategy() {
        this(new TextChunkLocationStrategy(){

            @Override
            public TextChunkLocation createLocation(TextRenderInfo renderInfo, LineSegment baseline) {
                return new TextChunkLocationDefaultImp(baseline.getStartPoint(), baseline.getEndPoint(), renderInfo.getSingleSpaceWidth());
            }
        });
    }

    public LocationTextExtractionStrategy(TextChunkLocationStrategy strat) {
        this.tclStrat = strat;
    }

    @Override
    public void beginTextBlock() {
    }

    @Override
    public void endTextBlock() {
    }

    private boolean startsWithSpace(String str) {
        if (str.length() == 0) {
            return false;
        }
        return str.charAt(0) == ' ';
    }

    private boolean endsWithSpace(String str) {
        if (str.length() == 0) {
            return false;
        }
        return str.charAt(str.length() - 1) == ' ';
    }

    private List<TextChunk> filterTextChunks(List<TextChunk> textChunks, TextChunkFilter filter) {
        if (filter == null) {
            return textChunks;
        }
        ArrayList<TextChunk> filtered = new ArrayList<TextChunk>();
        for (TextChunk textChunk : textChunks) {
            if (!filter.accept(textChunk)) continue;
            filtered.add(textChunk);
        }
        return filtered;
    }

    protected boolean isChunkAtWordBoundary(TextChunk chunk, TextChunk previousChunk) {
        return chunk.getLocation().isAtWordBoundary(previousChunk.getLocation());
    }

    public String getResultantText(TextChunkFilter chunkFilter) {
        if (DUMP_STATE) {
            this.dumpState();
        }
        List<TextChunk> filteredTextChunks = this.filterTextChunks(this.locationalResult, chunkFilter);
        Collections.sort(filteredTextChunks);
        StringBuilder sb = new StringBuilder();
        TextChunk lastChunk = null;
        for (TextChunk chunk : filteredTextChunks) {
            if (lastChunk == null) {
                sb.append(chunk.text);
            } else if (chunk.sameLine(lastChunk)) {
                if (this.isChunkAtWordBoundary(chunk, lastChunk) && !this.startsWithSpace(chunk.text) && !this.endsWithSpace(lastChunk.text)) {
                    sb.append(' ');
                }
                sb.append(chunk.text);
            } else {
                sb.append('\n');
                sb.append(chunk.text);
            }
            lastChunk = chunk;
        }
        return sb.toString();
    }

    @Override
    public String getResultantText() {
        return this.getResultantText(null);
    }

    private void dumpState() {
        for (TextChunk location : this.locationalResult) {
            location.printDiagnostics();
            System.out.println();
        }
    }

    @Override
    public void renderText(TextRenderInfo renderInfo) {
        LineSegment segment = renderInfo.getBaseline();
        if (renderInfo.getRise() != 0.0f) {
            Matrix riseOffsetTransform = new Matrix(0.0f, -renderInfo.getRise());
            segment = segment.transformBy(riseOffsetTransform);
        }
        TextChunk tc = new TextChunk(renderInfo.getText(), this.tclStrat.createLocation(renderInfo, segment));
        this.locationalResult.add(tc);
    }

    private static int compareInts(int int1, int int2) {
        return int1 == int2 ? 0 : (int1 < int2 ? -1 : 1);
    }

    @Override
    public void renderImage(ImageRenderInfo renderInfo) {
    }

    public static interface TextChunkFilter {
        public boolean accept(TextChunk var1);
    }

    public static class TextChunk
    implements Comparable<TextChunk> {
        private final String text;
        private final TextChunkLocation location;

        public TextChunk(String string, Vector startLocation, Vector endLocation, float charSpaceWidth) {
            this(string, new TextChunkLocationDefaultImp(startLocation, endLocation, charSpaceWidth));
        }

        public TextChunk(String string, TextChunkLocation loc) {
            this.text = string;
            this.location = loc;
        }

        public String getText() {
            return this.text;
        }

        public TextChunkLocation getLocation() {
            return this.location;
        }

        public Vector getStartLocation() {
            return this.location.getStartLocation();
        }

        public Vector getEndLocation() {
            return this.location.getEndLocation();
        }

        public float getCharSpaceWidth() {
            return this.location.getCharSpaceWidth();
        }

        public float distanceFromEndOf(TextChunk other) {
            return this.location.distanceFromEndOf(other.location);
        }

        private void printDiagnostics() {
            System.out.println("Text (@" + this.location.getStartLocation() + " -> " + this.location.getEndLocation() + "): " + this.text);
            System.out.println("orientationMagnitude: " + this.location.orientationMagnitude());
            System.out.println("distPerpendicular: " + this.location.distPerpendicular());
            System.out.println("distParallel: " + this.location.distParallelStart());
        }

        @Override
        public int compareTo(TextChunk rhs) {
            return this.location.compareTo(rhs.location);
        }

        private boolean sameLine(TextChunk lastChunk) {
            return this.getLocation().sameLine(lastChunk.getLocation());
        }
    }

    public static class TextChunkLocationDefaultImp
    implements TextChunkLocation {
        private final Vector startLocation;
        private final Vector endLocation;
        private final Vector orientationVector;
        private final int orientationMagnitude;
        private final int distPerpendicular;
        private final float distParallelStart;
        private final float distParallelEnd;
        private final float charSpaceWidth;

        public TextChunkLocationDefaultImp(Vector startLocation, Vector endLocation, float charSpaceWidth) {
            this.startLocation = startLocation;
            this.endLocation = endLocation;
            this.charSpaceWidth = charSpaceWidth;
            Vector oVector = endLocation.subtract(startLocation);
            if (oVector.length() == 0.0f) {
                oVector = new Vector(1.0f, 0.0f, 0.0f);
            }
            this.orientationVector = oVector.normalize();
            this.orientationMagnitude = (int)(Math.atan2(this.orientationVector.get(1), this.orientationVector.get(0)) * 1000.0);
            Vector origin = new Vector(0.0f, 0.0f, 1.0f);
            this.distPerpendicular = (int)startLocation.subtract(origin).cross(this.orientationVector).get(2);
            this.distParallelStart = this.orientationVector.dot(startLocation);
            this.distParallelEnd = this.orientationVector.dot(endLocation);
        }

        @Override
        public int orientationMagnitude() {
            return this.orientationMagnitude;
        }

        @Override
        public int distPerpendicular() {
            return this.distPerpendicular;
        }

        @Override
        public float distParallelStart() {
            return this.distParallelStart;
        }

        @Override
        public float distParallelEnd() {
            return this.distParallelEnd;
        }

        @Override
        public Vector getStartLocation() {
            return this.startLocation;
        }

        @Override
        public Vector getEndLocation() {
            return this.endLocation;
        }

        @Override
        public float getCharSpaceWidth() {
            return this.charSpaceWidth;
        }

        @Override
        public boolean sameLine(TextChunkLocation as) {
            return this.orientationMagnitude() == as.orientationMagnitude() && this.distPerpendicular() == as.distPerpendicular();
        }

        @Override
        public float distanceFromEndOf(TextChunkLocation other) {
            float distance = this.distParallelStart() - other.distParallelEnd();
            return distance;
        }

        @Override
        public boolean isAtWordBoundary(TextChunkLocation previous) {
            float dist = this.distanceFromEndOf(previous);
            if (dist < 0.0f && (dist = previous.distanceFromEndOf(this)) < 0.0f) {
                return false;
            }
            return dist > this.getCharSpaceWidth() / 2.0f;
        }

        @Override
        public int compareTo(TextChunkLocation other) {
            if (this == other) {
                return 0;
            }
            int rslt = LocationTextExtractionStrategy.compareInts(this.orientationMagnitude(), other.orientationMagnitude());
            if (rslt != 0) {
                return rslt;
            }
            rslt = LocationTextExtractionStrategy.compareInts(this.distPerpendicular(), other.distPerpendicular());
            if (rslt != 0) {
                return rslt;
            }
            return Float.compare(this.distParallelStart(), other.distParallelStart());
        }
    }

    public static interface TextChunkLocation
    extends Comparable<TextChunkLocation> {
        public float distParallelEnd();

        public float distParallelStart();

        public int distPerpendicular();

        public float getCharSpaceWidth();

        public Vector getEndLocation();

        public Vector getStartLocation();

        public int orientationMagnitude();

        public boolean sameLine(TextChunkLocation var1);

        public float distanceFromEndOf(TextChunkLocation var1);

        public boolean isAtWordBoundary(TextChunkLocation var1);
    }

    public static interface TextChunkLocationStrategy {
        public TextChunkLocation createLocation(TextRenderInfo var1, LineSegment var2);
    }
}

