/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa;

import java.text.DateFormatSymbols;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class XFALocale {
    private final DateFormatSymbols dateFormatSymbols;
    private final DecimalFormatSymbols decimalFormatSymbols;
    private final Map<String, String> datePattern = new HashMap<String, String>();
    private final Map<String, String> timePattern = new HashMap<String, String>();
    private final Map<String, String> numberPattern = new HashMap<String, String>();
    private final String name;
    private Locale locale;

    public XFALocale(String name, Locale defaultLocale) {
        this.name = name;
        this.locale = defaultLocale;
        if (name != null && !"ambient".equals(name) && name.contains("_")) {
            String lang = name.substring(0, name.indexOf(95));
            String cont = name.substring(name.indexOf(95) + 1);
            this.locale = new Locale(lang, cont);
        }
        this.dateFormatSymbols = new DateFormatSymbols(this.locale);
        this.decimalFormatSymbols = new DecimalFormatSymbols(this.locale);
        this.datePattern.put("full", "EEEE D MMMM YYYY");
        this.datePattern.put("long", "D MMMM YYYY");
        this.datePattern.put("med", "D MMM YYYY");
        this.datePattern.put("short", "DD/MM/YY");
        this.timePattern.put("full", "h:MM:SS A Z");
        this.timePattern.put("long", "h:MM:SS A Z");
        this.timePattern.put("med", "h:MM:SS A");
        this.timePattern.put("short", "h:MM A");
        this.numberPattern.put("numeric", "z,zz9.zzz");
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return this.dateFormatSymbols;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return this.decimalFormatSymbols;
    }

    public Map<String, String> getDatePattern() {
        return this.datePattern;
    }

    public Map<String, String> getTimePattern() {
        return this.timePattern;
    }

    public Map<String, String> getNumberPattern() {
        return this.numberPattern;
    }

    public String getName() {
        return this.name;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

