/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.xtra.xfa.element.PositionResult;
import com.itextpdf.tool.xml.xtra.xfa.element.TextDrawer;
import com.itextpdf.tool.xml.xtra.xfa.js.IJsObject;
import com.itextpdf.tool.xml.xtra.xfa.js.JsNode;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FlattenerContext;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import org.mozilla.javascript.Scriptable;

public class CaptionElement
extends JsNode {
    protected static final JsNode captionJsObject = new JsNode("caption");
    private XFARectangle elementRec;
    private TextDrawer textDrawer;
    private String captionText = null;

    public CaptionElement(Tag tag, IJsObject parent) {
        super(tag, parent);
        this.setPrototype((Scriptable)captionJsObject);
    }

    public PositionResult draw(PdfContentByte canvas, XFARectangle parentBoundingBox) {
        if (this.textDrawer != null) {
            return this.textDrawer.draw(canvas, parentBoundingBox, false);
        }
        return null;
    }

    public String getCaptionText() {
        if (this.captionText != null) {
            return this.captionText;
        }
        if (this.textDrawer != null) {
            return this.textDrawer.getContentAsString();
        }
        return null;
    }

    public TextDrawer getTextDrawer() {
        return this.textDrawer;
    }

    public boolean isEmpty() {
        return this.textDrawer == null || this.textDrawer.isEmpty();
    }

    public String getPlacement() {
        Object placement = this.getOwnProperty("placement");
        return placement != null ? (String)placement : "left";
    }

    public Float getReserve() {
        String reserveStr = this.retrieveAttribute("reserve");
        Float val = XFAUtil.parseFloatToPt(reserveStr);
        if (val != null && XFAUtil.lte(val.floatValue(), 0.0f)) {
            val = null;
        }
        return val;
    }

    public void fixCaptionAreaByContentArea(XFARectangle rec) {
        String placement = this.getPlacement();
        if (placement.equals("left") || placement.equalsIgnoreCase("right")) {
            if (placement.equalsIgnoreCase("right")) {
                this.elementRec.setLlx(Float.valueOf(rec.getLlx().floatValue() + rec.getWidth().floatValue()));
                if (this.textDrawer != null) {
                    this.textDrawer.createColumnText(this.elementRec);
                }
            }
            if (this.elementRec.getHeight() != null) {
                float captionLly = this.elementRec.getUry().floatValue() - this.elementRec.getHeight().floatValue();
                if (rec.getHeight() == null || XFAUtil.lt(captionLly, rec.getUry().floatValue() - rec.getHeight().floatValue())) {
                    rec.setHeight(Float.valueOf(rec.getUry().floatValue() - captionLly));
                }
            }
        } else if (placement.endsWith("top") || placement.equalsIgnoreCase("bottom")) {
            if (placement.equalsIgnoreCase("bottom")) {
                this.elementRec.setUry(Float.valueOf(this.elementRec.getUry().floatValue() - rec.getHeight().floatValue()));
                if (this.textDrawer != null) {
                    this.textDrawer.createColumnText(this.elementRec);
                }
            }
            if (this.elementRec.getWidth() != null) {
                float captionUrx = this.elementRec.getLlx().floatValue() + this.elementRec.getWidth().floatValue();
                if (rec.getWidth() == null || XFAUtil.gt(captionUrx, rec.getLlx().floatValue() + rec.getWidth().floatValue())) {
                    rec.setWidth(Float.valueOf(captionUrx - rec.getLlx().floatValue()));
                }
            }
        }
    }

    public void fixCaptionAreaByParentArea(XFARectangle contentArea) {
        String placement = this.getPlacement();
        if (placement.equalsIgnoreCase("right")) {
            if (contentArea.getLlx() != null && contentArea.getWidth() != null && this.elementRec.getWidth() != null && contentArea.getWidth().floatValue() > this.elementRec.getWidth().floatValue()) {
                this.elementRec.setLlx(Float.valueOf(contentArea.getLlx().floatValue() + contentArea.getWidth().floatValue() - this.elementRec.getWidth().floatValue()));
                if (this.textDrawer != null) {
                    this.textDrawer.createColumnText(this.elementRec);
                }
            }
        } else if (placement.equalsIgnoreCase("bottom") && contentArea.getUry() != null && contentArea.getHeight() != null && this.elementRec.getHeight() != null && contentArea.getHeight().floatValue() > this.elementRec.getHeight().floatValue()) {
            this.elementRec.setUry(Float.valueOf(contentArea.getUry().floatValue() - contentArea.getHeight().floatValue() + this.elementRec.getHeight().floatValue()));
            if (this.textDrawer != null) {
                this.textDrawer.createColumnText(this.elementRec);
            }
        }
    }

    public void place(XFARectangle contentArea, FlattenerContext flattenerContext) {
        FormNode ui;
        this.elementRec = contentArea;
        String placement = this.getPlacement();
        Float reserve = this.getReserve();
        XFARectangle captionRec = this.elementRec.clone();
        boolean isButton = false;
        JsNode parentNode = this.getParent();
        if (parentNode != null && (ui = parentNode.retrieveChild("ui")) != null && ui.retrieveChild("button") != null) {
            isButton = true;
        }
        if (!isButton) {
            if (placement.equalsIgnoreCase("top") || placement.equalsIgnoreCase("bottom")) {
                captionRec.setHeight(reserve);
                if (reserve == null) {
                    captionRec.setMinH(null);
                    captionRec.setMaxH(null);
                }
            } else {
                captionRec.setWidth(reserve);
                if (reserve == null) {
                    captionRec.setMinW(null);
                    captionRec.setMaxW(null);
                }
            }
        }
        if (reserve == null || reserve.floatValue() > 0.0f) {
            this.createTextDrawer(flattenerContext);
            if (this.textDrawer != null) {
                this.textDrawer.createColumnText(captionRec);
            }
        }
        if (reserve == null) {
            if (placement.equalsIgnoreCase("top") || placement.equalsIgnoreCase("bottom")) {
                if (captionRec.getHeight() == null) {
                    captionRec.setHeight(Float.valueOf(flattenerContext.getFont(this, "Identity-H").getSize()));
                }
            } else if (captionRec.getWidth() == null) {
                captionRec.setWidth(Float.valueOf(0.0f));
            }
        }
        this.elementRec = captionRec;
    }

    private void createTextDrawer(FlattenerContext flattenerContext) {
        String contentTypeValue;
        FormNode exDataTag;
        FormNode value = this.retrieveChild("value");
        String fetchedCaptionText = null;
        if (value != null) {
            String size;
            FormNode fontNode = flattenerContext.getFontNode(this);
            String string = size = fontNode != null ? fontNode.retrieveAttribute("size") : null;
            if (size == null || !"0".equals(size)) {
                FormNode text = value.retrieveChild("text");
                fetchedCaptionText = text != null ? text.retrieveValue() : value.retrieveAttribute("text");
            }
        }
        if (fetchedCaptionText != null) {
            this.captionText = fetchedCaptionText;
            this.textDrawer = new TextDrawer((JsNode)this, new XFARectangle(flattenerContext.getDocument().getPageSize()), this.captionText, flattenerContext);
        }
        if (value != null && (exDataTag = value.retrieveChild("exData")) != null && (contentTypeValue = exDataTag.retrieveAttribute("contentType")) != null && contentTypeValue.equals("text/html")) {
            this.textDrawer = new TextDrawer(this, new XFARectangle(flattenerContext.getDocument().getPageSize()), exDataTag.retrieveRichText(), flattenerContext, true);
        }
    }

    public boolean isTagged() {
        return !this.isEmpty();
    }

    public XFARectangle getElementRec() {
        return this.elementRec;
    }

    public PositionResult simulatePosition(XFARectangle parentBoundingBox) {
        if (parentBoundingBox != null && this.elementRec.getUry() != null && this.elementRec.getHeight() != null && (double)(this.elementRec.getUry().floatValue() - this.elementRec.getHeight().floatValue() - parentBoundingBox.getUry().floatValue() + parentBoundingBox.getHeight().floatValue()) < -0.01) {
            return new PositionResult(PositionResult.State.NO_CONTENT);
        }
        return new PositionResult(PositionResult.State.FULL_CONTENT);
    }

    public void move(float dx, float dy) {
        if (this.elementRec != null) {
            this.elementRec.setLlx(Float.valueOf(this.elementRec.getLlx().floatValue() + dx));
            this.elementRec.setUry(Float.valueOf(this.elementRec.getUry().floatValue() + dy));
        }
    }
}

