/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.tool.xml.xtra.xfa.element.BreakConditions;
import com.itextpdf.tool.xml.xtra.xfa.element.ContentArea;
import com.itextpdf.tool.xml.xtra.xfa.element.PageArea;
import com.itextpdf.tool.xml.xtra.xfa.js.JsInstanceManager;
import com.itextpdf.tool.xml.xtra.xfa.js.JsNode;
import com.itextpdf.tool.xml.xtra.xfa.js.JsTree;
import com.itextpdf.tool.xml.xtra.xfa.js.RhinoJsNodeList;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FlattenerContext;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.tags.XFATemplateTag;
import java.util.ArrayList;
import java.util.List;

public class PageSet
extends JsNode {
    protected static final JsNode pagesetJsObject = new JsNode("pageSet");
    protected PageArea currentPageArea = null;
    protected FlattenerContext flattenerContext;

    public PageSet(XFATemplateTag pageSetTag, JsNode parentNode, FlattenerContext flattenerContext) {
        super(pageSetTag, parentNode, pagesetJsObject);
        this.flattenerContext = flattenerContext;
    }

    @Override
    public String getClassName() {
        return "pageSet";
    }

    public PageArea getCurrentPageArea() {
        return this.currentPageArea;
    }

    public PageArea setCurrentPageArea(PageArea currentPageArea) {
        PageArea previousPageArea = this.currentPageArea;
        this.currentPageArea = currentPageArea;
        if (previousPageArea != null && previousPageArea.getTemplate() != currentPageArea.getTemplate() && currentPageArea.getOccured() > 0) {
            this.getNewInstanceOfCurrentPageArea();
            this.currentPageArea.setOccured(0);
        }
        return this.currentPageArea;
    }

    public ContentArea nextContentArea(BreakConditions breakConditions) {
        if (breakConditions != null) {
            if (!"pageArea".equals(breakConditions.getType())) {
                if (breakConditions.getTarget() != null) {
                    JsTree nextContentArea;
                    JsTree jsTree = nextContentArea = this.currentPageArea != null ? this.currentPageArea.searchNode(breakConditions.getTarget(), true) : this.searchNode(breakConditions.getTarget(), false);
                    if (nextContentArea instanceof ContentArea) {
                        return (ContentArea)nextContentArea;
                    }
                    return null;
                }
            } else {
                return null;
            }
        }
        return this.currentPageArea != null ? this.currentPageArea.getNextContentArea() : null;
    }

    public PageArea nextPageArea(BreakConditions breakConditions, ContentArea nextContentArea, int pageNumber) {
        PageArea next = this.nextPageArea(breakConditions, nextContentArea, pageNumber, true, false, null);
        if (next != null) {
            this.incPageAreaOccur(next);
        }
        return next;
    }

    public PageArea nextBlankPageArea(PageArea previousPageArea, int pageNumber) {
        PageArea startSearchFrom = previousPageArea != null && this.isDuplexPagination() ? previousPageArea.getParentPageSet().getChildPageAreas().get(0) : null;
        PageArea next = this.nextPageArea(null, null, pageNumber, true, true, startSearchFrom);
        if (next != null) {
            this.incPageAreaOccur(next);
        }
        return next;
    }

    public boolean isDuplexPagination() {
        return "duplexPaginated".equals(this.retrieveAttribute("relation"));
    }

    public PageArea getNewInstanceOfCurrentPageArea() {
        PageArea pageArea;
        List<PageArea> pageAreaInstances;
        int currentPageAreaInd;
        JsInstanceManager instanceManager = this.getInstanceManagerByTemplate(this.currentPageArea.getTemplate());
        if (instanceManager != null) {
            instanceManager.decCount();
        }
        int n = currentPageAreaInd = (pageAreaInstances = PageSet.filterPageAreasOnly(this.retrieveChildren(this.currentPageArea.retrieveName()))) != null ? pageAreaInstances.indexOf(this.currentPageArea) : -1;
        if (currentPageAreaInd != -1 && currentPageAreaInd + 1 < pageAreaInstances.size()) {
            pageArea = pageAreaInstances.get(currentPageAreaInd + 1);
            pageArea.setOccured(this.currentPageArea.getOccured());
            pageArea.setMaxOccur(this.currentPageArea.getMaxOccur());
            pageArea.setCurrentContentAreaInd(this.currentPageArea.getCurrentContentAreaInd());
            this.currentPageArea = pageArea;
        } else {
            pageArea = (PageArea)this.flattenerContext.getFormBuilder().buildSubForm(this.currentPageArea.getTemplate(), this.currentPageArea.getData(), this);
            pageArea.setOccured(this.currentPageArea.getOccured());
            pageArea.setMaxOccur(this.currentPageArea.getMaxOccur());
            pageArea.setCurrentContentAreaInd(this.currentPageArea.getCurrentContentAreaInd());
            RhinoJsNodeList nodes = (RhinoJsNodeList)((Object)this.getOwnProperty("nodes"));
            int i = 0;
            int j = 0;
            if (nodes != null) {
                while ((long)i < nodes.getLength()) {
                    Object node = nodes.item(i);
                    if (node instanceof PageArea) {
                        if (this.currentPageArea == node) {
                            nodes.insert(i + 1, pageArea);
                            nodes = this.currentPageArea.getAll();
                            if (nodes.getLength() > 1L) {
                                while ((long)j < nodes.getLength()) {
                                    if (this.currentPageArea == nodes.item(j)) {
                                        nodes.insert(j + 1, pageArea);
                                    }
                                    ++j;
                                }
                            } else {
                                nodes.append(pageArea);
                                this.defineProperty(this.currentPageArea.getName(), (Object)nodes);
                            }
                            this.currentPageArea = pageArea;
                            break;
                        }
                    } else if (node instanceof PageSet && ((PageSet)node).getCurrentPageArea() == this.currentPageArea && (pageArea = ((PageSet)node).getNewInstanceOfCurrentPageArea()) != null) {
                        this.currentPageArea = pageArea;
                        break;
                    }
                    ++i;
                }
            }
        }
        return pageArea;
    }

    public PageArea findPageAreaWithLastPagePosition() {
        RhinoJsNodeList nodes = (RhinoJsNodeList)((Object)this.getOwnProperty("nodes"));
        int i = 0;
        while ((long)i < nodes.getLength()) {
            PageArea currentContentArea;
            Object child = nodes.get(i);
            if (child instanceof PageArea && "last".equals((currentContentArea = (PageArea)child).retrieveAttribute("pagePosition"))) {
                return currentContentArea;
            }
            ++i;
        }
        return null;
    }

    private PageArea nextPageArea(BreakConditions breakConditions, ContentArea nextContentArea, int pageNumber, boolean fallbackToCurrentPageArea, boolean blankArea, PageArea startFrom) {
        JsTree targetContainer;
        if (breakConditions != null && !"contentArea".equals(breakConditions.getType()) && breakConditions.getTarget() != null && (targetContainer = this.searchNode(breakConditions.getTarget(), false)) instanceof PageArea && this.pageAreaSatisfiesAllConditionsToBeSelected((PageArea)targetContainer, pageNumber, breakConditions, blankArea)) {
            return this.setCurrentPageArea((PageArea)targetContainer).setCurrentContentAreaInd(0);
        }
        if (nextContentArea != null && this.pageAreaSatisfiesAllConditionsToBeSelected(nextContentArea.getPageArea(), pageNumber, breakConditions, blankArea)) {
            return this.setCurrentPageArea(nextContentArea.getPageArea()).setCurrentContentArea(nextContentArea);
        }
        RhinoJsNodeList nodes = (RhinoJsNodeList)((Object)this.getOwnProperty("nodes"));
        ArrayList<Object> queue = new ArrayList<Object>();
        if (nodes != null) {
            int i = 0;
            while ((long)i < nodes.getLength()) {
                queue.add(nodes.item(i));
                ++i;
            }
        }
        PageArea pageAreaToStartSearchingFrom = null;
        pageAreaToStartSearchingFrom = startFrom != null ? startFrom : (this.isDuplexPagination() ? (this.currentPageArea != null ? this.currentPageArea.getParentPageSet().getChildPageAreas().get(0) : null) : this.currentPageArea);
        boolean searchNextPageSets = pageAreaToStartSearchingFrom == null;
        PageArea nextPageArea = null;
        for (int i = 0; i < queue.size(); ++i) {
            Object node = queue.get(i);
            if (node instanceof PageArea) {
                if (pageAreaToStartSearchingFrom != null && this.containsOwnPageArea(pageAreaToStartSearchingFrom)) {
                    Object curItem;
                    if (pageAreaToStartSearchingFrom != node) continue;
                    if (this.pageAreaSatisfiesAllConditionsToBeSelected((PageArea)node, pageNumber, breakConditions, blankArea)) {
                        nextPageArea = (PageArea)node;
                        break;
                    }
                    pageAreaToStartSearchingFrom = null;
                    int j = 0;
                    while ((long)j < nodes.getLength() && (curItem = nodes.item(j)) != node) {
                        queue.add(curItem);
                        ++j;
                    }
                    continue;
                }
                PageArea pageArea = (PageArea)node;
                if (!this.pageAreaSatisfiesAllConditionsToBeSelected(pageArea, pageNumber, breakConditions, blankArea)) continue;
                nextPageArea = pageArea;
                break;
            }
            if (!(node instanceof PageSet) || !searchNextPageSets && (pageAreaToStartSearchingFrom == null || !((PageSet)node).containsOwnPageArea(pageAreaToStartSearchingFrom))) continue;
            searchNextPageSets = true;
            PageArea pageArea = ((PageSet)node).nextPageArea(breakConditions, null, pageNumber, false, blankArea, pageAreaToStartSearchingFrom);
            if (pageArea == null) continue;
            nextPageArea = pageArea;
            break;
        }
        if (nextPageArea != null) {
            return this.setCurrentPageArea(nextPageArea).setCurrentContentAreaInd(0);
        }
        if (fallbackToCurrentPageArea && this.currentPageArea != null) {
            this.currentPageArea.setCurrentContentAreaInd(0);
            return this.currentPageArea;
        }
        return null;
    }

    private boolean containsOwnPageArea(PageArea pageArea) {
        return this.getNodes().indexOfCompareReferences(pageArea) >= 0;
    }

    private boolean pageAreaSatisfiesAllConditionsToBeSelected(PageArea pageArea, int pageNumber, BreakConditions breakConditions, boolean blankArea) {
        return this.checkOccurRequirement(pageArea) && this.checkPageNumberRequirement(breakConditions, pageArea, pageNumber) && (pageArea.contentAreas.size() > 0 || blankArea) && PageSet.checkBlankPageRequirement(pageArea, blankArea);
    }

    private static boolean checkBlankPageRequirement(PageArea area, boolean blankArea) {
        return !blankArea || !"notBlank".equals(area.retrieveAttribute("blankOrNotBlank"));
    }

    private boolean checkOccurRequirement(PageArea pageArea) {
        if (this.currentPageArea != null && this.currentPageArea.getTemplate() == pageArea.getTemplate()) {
            return pageArea.getOccured() < pageArea.getMaxOccur();
        }
        return true;
    }

    private void incPageAreaOccur(PageArea pageArea) {
        for (PageArea sibling : pageArea.getParentPageSet().getChildPageAreas()) {
            if (sibling.getTemplate() != pageArea.getTemplate()) continue;
            sibling.incOccured();
        }
    }

    private List<PageArea> getChildPageAreas() {
        ArrayList<PageArea> childPageAreas = new ArrayList<PageArea>();
        RhinoJsNodeList nodes = this.getNodes();
        if (nodes != null) {
            int i = 0;
            while ((long)i < nodes.getLength()) {
                if (nodes.item(i) instanceof PageArea) {
                    childPageAreas.add((PageArea)nodes.item(i));
                }
                ++i;
            }
        }
        return childPageAreas;
    }

    private boolean checkPageNumberRequirement(BreakConditions breakConditions, PageArea pageArea, int pageNumber) {
        String oddOrEven;
        if (breakConditions == null || breakConditions.getTarget() == null) {
            String pagePosition = pageArea.retrieveAttribute("pagePosition");
            if ("first".equals(pagePosition) && pageNumber != 1) {
                return false;
            }
            if ("only".equals(pagePosition) && pageArea.getOccured() != 0) {
                return false;
            }
        }
        if (this.isDuplexPagination() && (breakConditions == null || !breakConditions.getStartNew() && !PageArea.arePartsOfDifferentPageSets(this.currentPageArea, pageArea))) {
            oddOrEven = pageArea.retrieveAttribute("oddOrEven");
            if ("odd".equals(oddOrEven) && pageNumber % 2 != 1) {
                return false;
            }
            if ("even".equals(oddOrEven) && pageNumber % 2 != 0) {
                return false;
            }
        }
        if (this.isDuplexPagination() && breakConditions != null) {
            oddOrEven = pageArea.retrieveAttribute("oddOrEven");
            if ("pageOdd".equals(breakConditions.getType()) && "even".equals(oddOrEven)) {
                return false;
            }
            if ("pageEven".equals(breakConditions.getType()) && "odd".equals(oddOrEven)) {
                return false;
            }
        }
        return true;
    }

    private static List<PageArea> filterPageAreasOnly(List<FormNode> nodes) {
        ArrayList<PageArea> pageAreas = new ArrayList<PageArea>();
        for (FormNode node : nodes) {
            if (!(node instanceof PageArea)) continue;
            pageAreas.add((PageArea)node);
        }
        return pageAreas;
    }
}

