/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.wsdl.runtime;

import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.mule.modules.wsdl.runtime.SoapCallException;

public class ServiceDefinition {
    public static final int DEFINITION_LENGTH = 3;
    private final String namespace;
    private final String serviceName;
    private final String portName;
    private final String baseEndpoint;
    private final String headerPrefix;

    private ServiceDefinition(@NotNull String namespace, @NotNull String serviceName, @NotNull String portName, @NotNull String baseEndpoint, @NotNull String headerPrefix) {
        this.namespace = namespace;
        this.serviceName = serviceName;
        this.portName = portName;
        this.baseEndpoint = baseEndpoint;
        this.headerPrefix = headerPrefix;
    }

    public static ServiceDefinition create(@NotNull String namespace, @NotNull String serviceName, @NotNull String portName, @NotNull String baseEndpoint, @NotNull String headerPrefix) {
        return new ServiceDefinition(namespace, serviceName, portName, baseEndpoint, headerPrefix);
    }

    public static ServiceDefinition create(@NotNull String definition, @NotNull String baseEndpoint, @NotNull String headerPrefix) throws SoapCallException {
        String[] definitionDetails = StringUtils.split((String)definition, (String)"-");
        if (!definition.contains("-") || definitionDetails.length < 3) {
            throw SoapCallException.createMetadataInvocationException(definition);
        }
        String serviceName = definitionDetails[0];
        String portName = definitionDetails[1];
        String nameSpace = definitionDetails[2];
        if (StringUtils.isEmpty((String)serviceName) || StringUtils.isEmpty((String)portName) || StringUtils.isEmpty((String)nameSpace)) {
            throw SoapCallException.createMetadataInvocationException(definition);
        }
        return new ServiceDefinition(nameSpace, serviceName, portName, baseEndpoint, headerPrefix);
    }

    @NotNull
    public String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public String getServiceName() {
        return this.serviceName;
    }

    @NotNull
    public String getPortName() {
        return this.portName;
    }

    @NotNull
    public String getBaseEndpoint() {
        return this.baseEndpoint;
    }

    @NotNull
    public String getHeaderPrefix() {
        return this.headerPrefix;
    }

    public String toString() {
        return "ServiceDefinition{namespace='" + this.namespace + '\'' + ", serviceName='" + this.serviceName + '\'' + ", portName='" + this.portName + '\'' + ", baseEndpoint='" + this.baseEndpoint + '\'' + ", headerPrefix='" + this.headerPrefix + '\'' + '}';
    }
}

