/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.AgentLinkingMetadata;
import com.newrelic.agent.TraceMetadataImpl;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.TransactionApiImpl;
import com.newrelic.agent.WeakRefTransaction;
import com.newrelic.agent.bridge.Agent;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.NoOpMetricAggregator;
import com.newrelic.agent.bridge.NoOpTracedMethod;
import com.newrelic.agent.bridge.NoOpTransaction;
import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.api.agent.Config;
import com.newrelic.api.agent.ErrorApi;
import com.newrelic.api.agent.Insights;
import com.newrelic.api.agent.Logger;
import com.newrelic.api.agent.Logs;
import com.newrelic.api.agent.MetricAggregator;
import com.newrelic.api.agent.TraceMetadata;
import java.util.Map;
import java.util.logging.Level;

public class AgentImpl
implements Agent {
    private final Logger logger;

    public AgentImpl(Logger logger) {
        this.logger = logger;
    }

    public TracedMethod getTracedMethod() {
        com.newrelic.agent.bridge.Transaction transaction = this.getTransaction(false);
        if (NoOpTransaction.INSTANCE.equals(transaction)) {
            return NoOpTracedMethod.INSTANCE;
        }
        Transaction txn = Transaction.getTransaction(false);
        if (txn == null) {
            return NoOpTracedMethod.INSTANCE;
        }
        TransactionActivity txa = txn.getTransactionActivity();
        if (txa == null) {
            return NoOpTracedMethod.INSTANCE;
        }
        Tracer tracer = txa.getLastTracer();
        return tracer == null ? NoOpTracedMethod.INSTANCE : tracer;
    }

    public com.newrelic.agent.bridge.Transaction getTransaction() {
        Transaction innerTx;
        TransactionActivity txa = TransactionActivity.get();
        if (txa != null) {
            Tracer tracer = txa.getRootTracer();
            Transaction txn = Transaction.getTransaction(false);
            if (txn == null && tracer != null && tracer.isAsync()) {
                return NoOpTransaction.INSTANCE;
            }
        }
        if ((innerTx = Transaction.getTransaction(false)) != null) {
            return TransactionApiImpl.INSTANCE;
        }
        return NoOpTransaction.INSTANCE;
    }

    public com.newrelic.agent.bridge.Transaction getTransaction(boolean createIfNotExists) {
        if (null == Transaction.getTransaction(createIfNotExists)) {
            return null;
        }
        return this.getTransaction();
    }

    public com.newrelic.agent.bridge.Transaction getWeakRefTransaction(boolean createIfNotExists) {
        Transaction transaction = Transaction.getTransaction(createIfNotExists);
        if (transaction == null) {
            return null;
        }
        return new WeakRefTransaction(transaction);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ErrorApi getErrorApi() {
        return AgentBridge.publicApi;
    }

    public Config getConfig() {
        return ServiceFactory.getConfigService().getDefaultAgentConfig();
    }

    public MetricAggregator getMetricAggregator() {
        try {
            Transaction tx = Transaction.getTransaction(false);
            if (null != tx && tx.isInProgress()) {
                return tx.getMetricAggregator();
            }
            return ServiceFactory.getStatsService().getMetricAggregator();
        }
        catch (Throwable t2) {
            com.newrelic.agent.Agent.LOG.log(Level.FINE, "getMetricAggregator() call failed : {0}", t2.getMessage());
            com.newrelic.agent.Agent.LOG.log(Level.FINEST, t2, "getMetricAggregator() call failed");
            return NoOpMetricAggregator.INSTANCE;
        }
    }

    public Insights getInsights() {
        return ServiceFactory.getServiceManager().getInsights();
    }

    public Logs getLogSender() {
        return ServiceFactory.getServiceManager().getLogSenderService();
    }

    public boolean startAsyncActivity(Object activityContext) {
        return ServiceFactory.getAsyncTxService().startAsyncActivity(activityContext);
    }

    public boolean ignoreIfUnstartedAsyncContext(Object activityContext) {
        return ServiceFactory.getAsyncTxService().ignoreIfUnstartedAsyncContext(activityContext);
    }

    public TraceMetadata getTraceMetadata() {
        return TraceMetadataImpl.INSTANCE;
    }

    public Map<String, String> getLinkingMetadata() {
        return AgentLinkingMetadata.getLinkingMetadata(this.getTraceMetadata(), ServiceFactory.getConfigService(), ServiceFactory.getRPMServiceManager() != null ? ServiceFactory.getRPMServiceManager().getRPMService() : null);
    }
}

