/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.classmatchers;

import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.util.Strings;
import com.newrelic.agent.util.asm.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ChildClassMatcher
extends ClassMatcher {
    private final String internalSuperClassName;
    private final String superClassName;
    private final boolean onlyMatchChildren;
    private final Set<String> classesToMatch;

    public ChildClassMatcher(String superClassName) {
        this(superClassName, true);
    }

    public ChildClassMatcher(String superClassName, boolean onlyMatchChildren) {
        this(superClassName, onlyMatchChildren, null);
    }

    public ChildClassMatcher(String superClassName, boolean onlyMatchChildren, String[] specificChildClasses) {
        superClassName = Strings.fixInternalClassName(superClassName);
        if (superClassName.indexOf(47) < 0) {
            throw new RuntimeException("Invalid class name format");
        }
        this.superClassName = Type.getObjectType(superClassName).getClassName();
        this.internalSuperClassName = superClassName;
        this.onlyMatchChildren = onlyMatchChildren;
        this.classesToMatch = new HashSet<String>();
        this.classesToMatch.add(this.internalSuperClassName);
        if (specificChildClasses != null) {
            this.classesToMatch.addAll(Arrays.asList(specificChildClasses));
        }
    }

    @Override
    public boolean isMatch(ClassLoader loader, ClassReader cr) {
        if (loader == null) {
            loader = AgentBridge.getAgent().getClass().getClassLoader();
        }
        if (cr.getClassName().equals(this.internalSuperClassName)) {
            return !this.onlyMatchChildren;
        }
        return this.isSuperMatch(loader, cr.getSuperName());
    }

    private boolean isSuperMatch(ClassLoader loader, String superName) {
        do {
            if (superName.equals(this.internalSuperClassName)) {
                return true;
            }
            URL resource = Utils.getClassResource(loader, superName);
            if (resource == null) {
                return false;
            }
            try (InputStream inputStream2 = resource.openStream();){
                ClassReader cr = new ClassReader(inputStream2);
                superName = cr.getSuperName();
            }
            catch (IOException ex) {
                return false;
            }
        } while (superName != null);
        return false;
    }

    @Override
    public boolean isMatch(Class<?> clazz) {
        if (clazz.getName().equals(this.superClassName)) {
            return !this.onlyMatchChildren;
        }
        while ((clazz = clazz.getSuperclass()) != null) {
            if (!clazz.getName().equals(this.superClassName)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.internalSuperClassName == null ? 0 : this.internalSuperClassName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChildClassMatcher other = (ChildClassMatcher)obj;
        return !(this.internalSuperClassName == null ? other.internalSuperClassName != null : !this.internalSuperClassName.equals(other.internalSuperClassName));
    }

    @Override
    public Collection<String> getClassNames() {
        return this.classesToMatch;
    }
}

