/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.classmatchers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.util.Strings;
import com.newrelic.agent.util.asm.BenignClassReadException;
import com.newrelic.agent.util.asm.MissingResourceException;
import com.newrelic.agent.util.asm.Utils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;

public class InterfaceMatcher
extends ClassMatcher {
    private final Type type;
    private final String internalName;

    public InterfaceMatcher(String interfaceName) {
        this.type = Type.getObjectType(Strings.fixInternalClassName(interfaceName));
        this.internalName = this.type.getInternalName();
    }

    @Override
    public boolean isMatch(ClassLoader loader, ClassReader cr) {
        if (loader == null) {
            loader = AgentBridge.getAgent().getClass().getClassLoader();
        }
        if ((cr.getAccess() & 0x200) != 0) {
            return false;
        }
        if (Utils.getClassResource(loader, this.type) == null) {
            return false;
        }
        String[] interfaces = cr.getInterfaces();
        if (this.isInterfaceMatch(loader, interfaces)) {
            return true;
        }
        String superName = cr.getSuperName();
        if (superName != null && !superName.equals("java/lang/Object")) {
            try {
                cr = Utils.readClass(loader, superName);
                return this.isMatch(loader, cr);
            }
            catch (MissingResourceException e) {
                if (Agent.LOG.isFinestEnabled()) {
                    Agent.LOG.finest(MessageFormat.format("Unable to load class {0}: {1}", superName, e));
                }
            }
            catch (BenignClassReadException e) {
            }
            catch (IOException ex) {
                Agent.LOG.log(Level.FINEST, "Unable to match " + this.internalName, ex);
            }
        }
        return false;
    }

    private boolean isInterfaceMatch(ClassLoader loader, String[] interfaces) {
        if (this.isNameMatch(interfaces)) {
            return true;
        }
        for (String interfaceName : interfaces) {
            if (!this.isInterfaceMatch(loader, interfaceName)) continue;
            return true;
        }
        return false;
    }

    private boolean isNameMatch(String[] interfaces) {
        for (String interfaceName : interfaces) {
            if (!this.internalName.equals(interfaceName)) continue;
            return true;
        }
        return false;
    }

    private boolean isInterfaceMatch(ClassLoader loader, String interfaceName) {
        try {
            ClassReader reader = Utils.readClass(loader, interfaceName);
            return this.isInterfaceMatch(loader, reader.getInterfaces());
        }
        catch (MissingResourceException e) {
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.finest(MessageFormat.format("Unable to load interface {0}: {1}", interfaceName, e));
            }
            return false;
        }
        catch (BenignClassReadException e) {
            return false;
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to load interface {0}: {1}", interfaceName, e);
            if (Agent.LOG.isFinestEnabled()) {
                if (interfaceName.startsWith("com/newrelic/agent/") || interfaceName.startsWith("com/newrelic/weave/")) {
                    Agent.LOG.log(Level.FINEST, msg);
                } else {
                    Agent.LOG.log(Level.FINEST, msg, e);
                }
            } else {
                Agent.LOG.finer(msg);
            }
            return false;
        }
    }

    @Override
    public boolean isMatch(Class<?> clazz) {
        try {
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null) {
                classLoader = AgentBridge.getAgent().getClass().getClassLoader();
            }
            if (Utils.getClassResource(classLoader, this.type) == null) {
                return false;
            }
            Class<?> interfaceClass = classLoader.loadClass(this.type.getClassName());
            if (interfaceClass.isInterface() && interfaceClass.isAssignableFrom(clazz)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public String toString() {
        return this.internalName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InterfaceMatcher other = (InterfaceMatcher)obj;
        if (this.type == null) {
            return other.type == null;
        }
        return this.type.equals(other.type);
    }

    @Override
    public Collection<String> getClassNames() {
        return Arrays.asList(this.internalName);
    }
}

