/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracing;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.tracing.DistributedTracePayloadImpl;
import com.newrelic.agent.tracing.W3CTraceParent;
import com.newrelic.agent.tracing.W3CTraceParentParser;
import com.newrelic.agent.tracing.W3CTraceState;
import com.newrelic.agent.tracing.W3CTraceStateSupport;
import com.newrelic.api.agent.DistributedTracePayload;
import java.util.List;

public class W3CTracePayload {
    private final DistributedTracePayload payload;
    private final W3CTraceParent traceParent;
    private final W3CTraceState traceState;

    private W3CTracePayload(W3CTraceParent parentHeader, W3CTraceState stateHeader, DistributedTracePayload payload) {
        this.payload = payload;
        this.traceParent = parentHeader;
        this.traceState = stateHeader;
    }

    public DistributedTracePayload getPayload() {
        return this.payload;
    }

    public W3CTraceParent getTraceParent() {
        return this.traceParent;
    }

    public W3CTraceState getTraceState() {
        return this.traceState;
    }

    public static W3CTracePayload parseHeaders(Transaction tx, List<String> parentHeaders, List<String> stateHeaders) {
        try {
            if (parentHeaders == null) {
                tx.getMetricAggregator().incrementCounter("Supportability/TraceContext/TraceParent/Ignored/NullHeaders");
                return null;
            }
            W3CTraceParent w3CTraceParent = W3CTraceParentParser.parseHeaders(parentHeaders);
            if (w3CTraceParent == null) {
                tx.getMetricAggregator().incrementCounter("Supportability/TraceContext/TraceParent/Parse/Exception");
                return null;
            }
            W3CTraceState w3CTraceState = W3CTraceStateSupport.parseHeaders(stateHeaders);
            if (w3CTraceState == null && stateHeaders != null && !stateHeaders.isEmpty()) {
                tx.getMetricAggregator().incrementCounter("Supportability/TraceContext/TraceState/Parse/Exception");
            }
            tx.getMetricAggregator().incrementCounter("Supportability/TraceContext/Accept/Success");
            if (w3CTraceState == null || !w3CTraceState.containsNrData()) {
                return new W3CTracePayload(w3CTraceParent, w3CTraceState, null);
            }
            return new W3CTracePayload(w3CTraceParent, w3CTraceState, (DistributedTracePayload)new DistributedTracePayloadImpl(w3CTraceState.getTimestamp(), w3CTraceState.getParentType().name(), w3CTraceState.getAccountId(), w3CTraceState.getTrustKey(), w3CTraceState.getApplicationId(), w3CTraceParent.getParentId(), w3CTraceParent.getTraceId(), w3CTraceState.getTxnId(), w3CTraceState.getPriority(), w3CTraceState.getSampled()));
        }
        catch (Exception e) {
            tx.getMetricAggregator().incrementCounter("Supportability/TraceContext/Accept/Exception");
            return null;
        }
    }
}

