/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.weavepackage;

import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AnnotationNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.FieldNode;
import com.newrelic.api.agent.weaver.NewField;
import com.newrelic.weave.ClassMatch;
import com.newrelic.weave.utils.WeaveUtils;
import com.newrelic.weave.violation.WeaveViolation;
import com.newrelic.weave.violation.WeaveViolationType;
import java.util.Collection;

public final class NewFieldValidator {
    private static final String NEW_FIELD_DESC = Type.getType(NewField.class).getDescriptor();

    private NewFieldValidator() {
    }

    public static void validate(ClassMatch match, Collection<WeaveViolation> violations) {
        for (String newFieldName : match.getNewFields()) {
            if (NewFieldValidator.hasNewFieldAnnotation(match, newFieldName)) continue;
            violations.add(new WeaveViolation(WeaveViolationType.EXPECTED_NEW_FIELD_ANNOTATION, match.getWeave().name, newFieldName));
        }
        for (String matchedFieldName : match.getMatchedFields()) {
            if (!NewFieldValidator.hasNewFieldAnnotation(match, matchedFieldName)) continue;
            violations.add(new WeaveViolation(WeaveViolationType.UNEXPECTED_NEW_FIELD_ANNOTATION, match.getWeave().name, matchedFieldName));
        }
    }

    private static boolean hasNewFieldAnnotation(ClassMatch match, String fieldName) {
        FieldNode fieldNode = WeaveUtils.findRequiredMatch(match.getWeave().fields, fieldName);
        if (fieldNode.visibleAnnotations != null) {
            for (AnnotationNode annotationNode : fieldNode.visibleAnnotations) {
                if (!annotationNode.desc.equals(NEW_FIELD_DESC)) continue;
                return true;
            }
        }
        return false;
    }
}

