/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.EISSystemException;
import jakarta.resource.spi.ManagedConnectionMetaData;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDatabaseMetaData;
import oracle.jdbc.connector.OracleManagedConnection;

public class OracleManagedConnectionMetaData
implements ManagedConnectionMetaData {
    private OracleManagedConnection managedConnection = null;
    private OracleDatabaseMetaData databaseMetaData = null;

    OracleManagedConnectionMetaData(OracleManagedConnection omc) throws ResourceException {
        try {
            this.managedConnection = omc;
            OracleConnection conn = (OracleConnection)omc.getPhysicalConnection();
            this.databaseMetaData = (OracleDatabaseMetaData)conn.getMetaData();
        }
        catch (Exception exc) {
            throw new EISSystemException("Exception: " + exc.getMessage(), (Throwable)exc);
        }
    }

    public String getEISProductName() throws ResourceException {
        try {
            return this.databaseMetaData.getDatabaseProductName();
        }
        catch (SQLException exc) {
            throw new EISSystemException("SQLException: " + exc.getMessage(), (Throwable)exc);
        }
    }

    public String getEISProductVersion() throws ResourceException {
        try {
            return this.databaseMetaData.getDatabaseProductVersion();
        }
        catch (Exception exc) {
            throw new EISSystemException("Exception: " + exc.getMessage(), (Throwable)exc);
        }
    }

    public int getMaxConnections() throws ResourceException {
        try {
            return this.databaseMetaData.getMaxConnections();
        }
        catch (SQLException exc) {
            throw new EISSystemException("SQLException: " + exc.getMessage(), (Throwable)exc);
        }
    }

    public String getUserName() throws ResourceException {
        try {
            return this.databaseMetaData.getUserName();
        }
        catch (SQLException exc) {
            throw new EISSystemException("SQLException: " + exc.getMessage(), (Throwable)exc);
        }
    }
}

