/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.url.builder;

import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import oracle.net.url.builder.ConnectDescriptorBuilderImpl;
import oracle.net.url.builder.URLBuilder;
import oracle.net.url.common.DriverType;
import oracle.net.url.common.Node;
import oracle.net.url.common.NodeType;

public interface ConnectDescriptorBuilder
extends URLBuilder {
    public static ConnectDescriptorBuilder create() {
        return new ConnectDescriptorBuilderImpl();
    }

    public ConnectDescriptorBuilder addProperties(Properties var1);

    public ConnectDescriptorBuilder addProperties(String var1, String var2);

    public ConnectDescriptorBuilder driverType(DriverType var1);

    public Node rootNode();

    public Properties connectionProperties();

    public <T extends Node> ConnectDescriptorBuilder rootNode(Class<T> var1, Consumer<T> var2);

    @Override
    public ConnectDescriptorBuilder strictMode(boolean var1);

    public static Class<? extends Node> nodeClass(NodeType nodeType) {
        if (nodeType.equals(NodeType.DESCRIPTION_LIST)) {
            return DescriptionListNode.class;
        }
        if (nodeType.equals(NodeType.DESCRIPTION)) {
            return DescriptionNode.class;
        }
        if (nodeType.equals(NodeType.ADDRESS_LIST)) {
            return AddressListNode.class;
        }
        if (nodeType.equals(NodeType.ADDRESS)) {
            return AddressNode.class;
        }
        if (nodeType.equals(NodeType.CONNECT_DATA)) {
            return ConnectDataNode.class;
        }
        if (nodeType.equals(NodeType.SECURITY)) {
            return SecurityNode.class;
        }
        if (nodeType.equals(NodeType.COMPRESSION_LEVELS)) {
            return CompressionLevelsNode.class;
        }
        if (nodeType.equals(NodeType.FAILOVER_MODE)) {
            return FailOverModeNode.class;
        }
        if (nodeType.equals(NodeType.UNKNOWN_TYPE)) {
            return UnknownTypeNode.class;
        }
        throw new IllegalArgumentException("Invalid Node : " + nodeType);
    }

    public static interface DescriptionListNode
    extends Node {
        default public List<DescriptionNode> descriptions() {
            return this.childNodes(DescriptionNode.class);
        }
    }

    public static interface DescriptionNode
    extends Node {
        default public DescriptionNode failOver(boolean failOver) {
            this.param("FAILOVER", String.valueOf(failOver));
            return this;
        }

        default public DescriptionNode loadBalance(boolean loadBalance) {
            this.param("LOAD_BALANCE", String.valueOf(loadBalance));
            return this;
        }

        default public DescriptionNode sourceRoute(boolean sourceRoute) {
            this.param("SOURCE_ROUTE", String.valueOf(sourceRoute));
            return this;
        }

        default public DescriptionNode connectTimeout(int timeout) {
            this.param("CONNECT_TIMEOUT", String.valueOf(timeout));
            return this;
        }

        default public DescriptionNode transportTimeout(int timeout) {
            this.param("TRANSPORT_CONNECT_TIMEOUT", String.valueOf(timeout));
            return this;
        }

        default public DescriptionNode retryCount(int retryCount) {
            this.param("RETRY_COUNT", String.valueOf(retryCount));
            return this;
        }

        default public DescriptionNode retryDelay(int retryDelay) {
            this.param("RETRY_DELAY", String.valueOf(retryDelay));
            return this;
        }

        default public DescriptionNode sdu(int sdu) {
            this.param("SDU", String.valueOf(sdu));
            return this;
        }

        default public DescriptionNode tdu(int tdu) {
            this.param("TDU", String.valueOf(tdu));
            return this;
        }

        default public DescriptionNode keepAlive(boolean status) {
            this.param("ENABLE", status ? "BROKEN" : "OFF");
            return this;
        }

        default public DescriptionNode expireTime(int expireTime) {
            this.param("EXPIRE_TIME", String.valueOf(expireTime));
            return this;
        }

        default public DescriptionNode sendBufferSize(int bufferSize) {
            this.param("SEND_BUF_SIZE", String.valueOf(bufferSize));
            return this;
        }

        default public DescriptionNode receiveBufferSize(int bufferSize) {
            this.param("RECV_BUF_SIZE", String.valueOf(bufferSize));
            return this;
        }

        default public DescriptionNode useSNI(boolean status) {
            this.param("USE_SNI", String.valueOf(status));
            return this;
        }

        default public DescriptionNode compression(boolean status) {
            this.param("COMPRESSION", String.valueOf(status));
            return this;
        }

        default public DescriptionNode compressionLevels(String[] levels) {
            this.addChild(CompressionLevelsNode.class, compressionLevelsNode -> {
                for (String level : levels) {
                    compressionLevelsNode.param("LEVEL", level);
                }
            });
            return this;
        }

        default public String failOver() {
            return this.getParamValue("FAILOVER");
        }

        default public String loadBalance() {
            return this.getParamValue("LOAD_BALANCE");
        }

        default public String sourceRoute() {
            return this.getParamValue("SOURCE_ROUTE");
        }

        default public String connectTimeout() {
            return this.getParamValue("CONNECT_TIMEOUT");
        }

        default public String transportTimeout() {
            return this.getParamValue("TRANSPORT_CONNECT_TIMEOUT");
        }

        default public String retryCount() {
            return this.getParamValue("RETRY_COUNT");
        }

        default public String retryDelay() {
            return this.getParamValue("RETRY_DELAY");
        }

        default public String sdu() {
            return this.getParamValue("SDU");
        }

        default public String tdu() {
            return this.getParamValue("TDU");
        }

        default public String keepAlive() {
            return this.getParamValue("ENABLE");
        }

        default public String expireTime() {
            return this.getParamValue("EXPIRE_TIME");
        }

        default public String sendBufferSize() {
            return this.getParamValue("SEND_BUF_SIZE");
        }

        default public String receiveBufferSize() {
            return this.getParamValue("RECV_BUF_SIZE");
        }

        default public String useSNI() {
            return this.getParamValue("USE_SNI");
        }

        default public String compression() {
            return this.getParamValue("COMPRESSION");
        }

        default public String compressionLevels() {
            return this.getParamValue("COMPRESSION_LEVELS");
        }

        default public List<AddressNode> addresses() {
            return this.childNodes(AddressNode.class);
        }

        default public List<AddressListNode> addressLists() {
            return this.childNodes(AddressListNode.class);
        }

        default public ConnectDataNode connectData() {
            return this.childNodes().stream().filter(child -> child.type().equals(NodeType.CONNECT_DATA)).findAny().orElse(null);
        }

        default public SecurityNode security() {
            return this.childNodes().stream().filter(child -> child.type().equals(NodeType.SECURITY)).findAny().orElse(null);
        }
    }

    public static interface AddressListNode
    extends Node {
        default public AddressListNode failOver(boolean failOver) {
            this.param("FAILOVER", String.valueOf(failOver));
            return this;
        }

        default public AddressListNode loadBalance(boolean loadBalance) {
            this.param("LOAD_BALANCE", String.valueOf(loadBalance));
            return this;
        }

        default public AddressListNode sourceRoute(boolean sourceRoute) {
            this.param("SOURCE_ROUTE", String.valueOf(sourceRoute));
            return this;
        }

        default public AddressListNode sdu(int sdu) {
            this.param("SDU", String.valueOf(sdu));
            return this;
        }

        default public AddressListNode tdu(int tdu) {
            this.param("TDU", String.valueOf(tdu));
            return this;
        }

        default public AddressListNode keepAlive(boolean status) {
            this.param("ENABLE", status ? "BROKEN" : "OFF");
            return this;
        }

        default public AddressListNode expireTime(int expireTime) {
            this.param("EXPIRE_TIME", String.valueOf(expireTime));
            return this;
        }

        default public AddressListNode sendBufferSize(int bufferSize) {
            this.param("SEND_BUF_SIZE", String.valueOf(bufferSize));
            return this;
        }

        default public AddressListNode receiveBufferSize(int bufferSize) {
            this.param("RECV_BUF_SIZE", String.valueOf(bufferSize));
            return this;
        }

        default public AddressListNode typeOfService(String serviceType) {
            this.param("TYPE_OF_SERVICE", serviceType);
            return this;
        }

        default public String failOver() {
            return this.getParamValue("FAILOVER");
        }

        default public String loadBalance() {
            return this.getParamValue("LOAD_BALANCE");
        }

        default public String sourceRoute() {
            return this.getParamValue("SOURCE_ROUTE");
        }

        default public String sdu() {
            return this.getParamValue("SDU");
        }

        default public String tdu() {
            return this.getParamValue("TDU");
        }

        default public String keepAlive() {
            return this.getParamValue("ENABLE");
        }

        default public String expireTime() {
            return this.getParamValue("EXPIRE_TIME");
        }

        default public String sendBufferSize() {
            return this.getParamValue("SEND_BUF_SIZE");
        }

        default public String receiveBufferSize() {
            return this.getParamValue("RECV_BUF_SIZE");
        }

        default public String typeOfService() {
            return this.getParamValue("TYPE_OF_SERVICE");
        }

        default public List<AddressNode> addresses() {
            return this.childNodes(AddressNode.class);
        }
    }

    public static interface AddressNode
    extends Node {
        default public AddressNode httpProxy(String proxyHost, int proxyPort) {
            this.param("HTTPS_PROXY", proxyHost);
            this.param("HTTPS_PROXY_PORT", String.valueOf(proxyPort));
            return this;
        }

        default public AddressNode host(String dbHost, int dbPort) {
            this.param("HOST", dbHost);
            this.param("PORT", String.valueOf(dbPort));
            return this;
        }

        default public AddressNode host(String dbHost) {
            this.param("HOST", dbHost);
            return this;
        }

        default public AddressNode port(int dbPort) {
            this.param("PORT", String.valueOf(dbPort));
            return this;
        }

        default public AddressNode protocol(String protocol) {
            this.param("PROTOCOL", protocol);
            return this;
        }

        default public AddressNode websocketURI(String uri) {
            this.param("WEBSOCK_URI", uri);
            return this;
        }

        default public String httpProxyHost() {
            return this.getParamValue("HTTPS_PROXY");
        }

        default public String httpProxyPort() {
            return this.getParamValue("HTTPS_PROXY_PORT");
        }

        default public String host() {
            return this.getParamValue("HOST");
        }

        default public String port() {
            return this.getParamValue("PORT");
        }

        default public String protocol() {
            return this.getParamValue("PROTOCOL");
        }

        default public String websocketURI() {
            return this.getParamValue("WEBSOCK_URI");
        }
    }

    public static interface ConnectDataNode
    extends Node {
        default public ConnectDataNode serviceName(String serviceName) {
            this.param("SERVICE_NAME", serviceName);
            return this;
        }

        default public ConnectDataNode instanceName(String instanceName) {
            this.param("INSTANCE_NAME", instanceName);
            return this;
        }

        default public ConnectDataNode connectionIDPrefix(String prefix) {
            this.param("CONNECTION_ID_PREFIX", prefix);
            return this;
        }

        default public ConnectDataNode failoverMode(String failoverMode) {
            this.param("FAILOVER_MODE", failoverMode);
            return this;
        }

        default public ConnectDataNode globalName(String globalName) {
            this.param("GLOBAL_NAME", globalName);
            return this;
        }

        default public ConnectDataNode poolConnectionClass(String pc2) {
            this.param("POOL_CONNECTION_CLASS", pc2);
            return this;
        }

        default public ConnectDataNode poolPurity(String purity) {
            this.param("POOL_PURITY", purity);
            return this;
        }

        default public ConnectDataNode rdbDatabase(String rdb) {
            this.param("RDB_DATABASE", rdb);
            return this;
        }

        default public ConnectDataNode shardingKey(String skey) {
            this.param("SHARDING_KEY", skey);
            return this;
        }

        default public ConnectDataNode superShardingKey(String ssKey) {
            this.param("SUPER_SHARDING_KEY", ssKey);
            return this;
        }

        default public ConnectDataNode serverMode(String mode) {
            this.param("SERVER", mode);
            return this;
        }

        default public ConnectDataNode tunnelServiceName(String tsn) {
            this.param("TUNNEL_SERVICE_NAME", tsn);
            return this;
        }

        default public ConnectDataNode colocationTag(String ct) {
            this.param("COLOCATION_TAG", ct);
            return this;
        }

        default public String serviceName() {
            return this.getParamValue("SERVICE_NAME");
        }

        default public String instanceName() {
            return this.getParamValue("INSTANCE_NAME");
        }

        default public String connectionIDPrefix() {
            return this.getParamValue("CONNECTION_ID_PREFIX");
        }

        default public String failoverMode() {
            return this.getParamValue("FAILOVER_MODE");
        }

        default public String globalName() {
            return this.getParamValue("GLOBAL_NAME");
        }

        default public String poolConnectionClass() {
            return this.getParamValue("POOL_CONNECTION_CLASS");
        }

        default public String poolPurity() {
            return this.getParamValue("POOL_PURITY");
        }

        default public String rdbDatabase() {
            return this.getParamValue("RDB_DATABASE");
        }

        default public String shardingKey() {
            return this.getParamValue("SHARDING_KEY");
        }

        default public String superShardingKey() {
            return this.getParamValue("SUPER_SHARDING_KEY");
        }

        default public String serverMode() {
            return this.getParamValue("SERVER");
        }

        default public String tunnelServiceName() {
            return this.getParamValue("TUNNEL_SERVICE_NAME");
        }

        default public String colocationTag() {
            return this.getParamValue("COLOCATION_TAG");
        }
    }

    public static interface SecurityNode
    extends Node {
        default public SecurityNode authenticationService(String srv) {
            this.param("AUTHENTICATION_SERVICE", srv);
            return this;
        }

        default public SecurityNode ignoreANOForTCPS(boolean status) {
            this.param("IGNORE_ANO_ENCRYPTION_FOR_TCPS", String.valueOf(status));
            return this;
        }

        default public SecurityNode kerberosClientCredential(String path) {
            this.param("KERBEROS5_CC_NAME", path);
            return this;
        }

        default public SecurityNode kerberosPrincipal(String principalName) {
            this.param("KERBEROS5_PRINCIPAL", principalName);
            return this;
        }

        default public SecurityNode serverDN(String serverDN) {
            this.param("SSL_SERVER_CERT_DN", serverDN);
            return this;
        }

        default public SecurityNode enableDNMatch(boolean dnMatch) {
            this.param("SSL_SERVER_DN_MATCH", String.valueOf(dnMatch));
            return this;
        }

        default public SecurityNode tlsVersion(String version) {
            this.param("SSL_VERSION", version);
            return this;
        }

        default public SecurityNode wallet(String walletPath) {
            this.param("WALLET_LOCATION", walletPath);
            return this;
        }

        default public SecurityNode sepsWallet(String walletPath) {
            this.param("SEPS_WALLET_LOCATION", walletPath);
            return this;
        }

        default public SecurityNode tlsCertAlias(String tlsCertiAlias) {
            this.param("SSL_CERTIFICATE_ALIAS", tlsCertiAlias);
            return this;
        }

        default public SecurityNode tlsCertThumbprint(String thumbprint) {
            this.param("SSL_CERTIFICATE_THUMBPRINT", thumbprint);
            return this;
        }

        default public SecurityNode encryptionClient(String ec) {
            this.param("ENCRYPTION_CLIENT", ec);
            return this;
        }

        default public SecurityNode encryptionType(String et) {
            this.param("ENCRYPTION_TYPES_CLIENT", et);
            return this;
        }

        default public SecurityNode checksumClient(String cc) {
            this.param("CRYPTO_CHECKSUM_CLIENT", cc);
            return this;
        }

        default public SecurityNode checksumType(String ct) {
            this.param("CRYPTO_CHECKSUM_TYPES_CLIENT", ct);
            return this;
        }

        default public String authenticationService() {
            return this.getParamValue("AUTHENTICATION_SERVICE");
        }

        default public String ignoreANOForTCPS() {
            return this.getParamValue("IGNORE_ANO_ENCRYPTION_FOR_TCPS");
        }

        default public String kerberosClientCredential() {
            return this.getParamValue("KERBEROS5_CC_NAME");
        }

        default public String kerberosPrincipal() {
            return this.getParamValue("KERBEROS5_PRINCIPAL");
        }

        default public String serverDN() {
            return this.getParamValue("SSL_SERVER_CERT_DN");
        }

        default public String enableDNMatch() {
            return this.getParamValue("SSL_SERVER_DN_MATCH");
        }

        default public String tlsVersion() {
            return this.getParamValue("SSL_VERSION");
        }

        default public String wallet() {
            return this.getParamValue("WALLET_LOCATION");
        }

        default public String sepsWallet() {
            return this.getParamValue("SEPS_WALLET_LOCATION");
        }

        default public String tlsCertAlias() {
            return this.getParamValue("SSL_CERTIFICATE_ALIAS");
        }

        default public String tlsCertThumbprint() {
            return this.getParamValue("SSL_CERTIFICATE_THUMBPRINT");
        }

        default public String encryptionClient() {
            return this.getParamValue("ENCRYPTION_CLIENT");
        }

        default public String encryptionType() {
            return this.getParamValue("ENCRYPTION_TYPES_CLIENT");
        }

        default public String checksumClient() {
            return this.getParamValue("CRYPTO_CHECKSUM_CLIENT");
        }

        default public String checksumType() {
            return this.getParamValue("CRYPTO_CHECKSUM_TYPES_CLIENT");
        }
    }

    public static interface CompressionLevelsNode
    extends Node {
    }

    public static interface FailOverModeNode
    extends Node {
    }

    public static interface UnknownTypeNode
    extends Node {
    }
}

