/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OldUpdatableResultSet;
import oracle.jdbc.driver.OracleParameterMetaDataParser;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.UpdatableResultSet;
import oracle.jdbc.driver.utils.SQLTokenizer;
import oracle.jdbc.driver.utils.StringUtils;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;

public class OracleSql {
    protected static final int UNINITIALIZED = -1;
    protected static final String[] EMPTY_ARRAY = new String[0];
    static final Pattern CONNECTION_VALIDATION_SQL_PATTERN = Pattern.compile("\\A\\s*/\\*\\+\\s*CLIENT_CONNECTION_VALIDATION\\s*\\*/.*", 2);
    private DBConversion conversion;
    private boolean allowMixingJdbcAndNamedBinds = false;
    protected String originalSql;
    private String parameterSql;
    private String utickSql;
    private String processedSql;
    private String rowidSql;
    protected String actualSql;
    private byte[] sqlBytes;
    protected OracleStatement.SqlKind sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
    private byte sqlKindByte = (byte)-1;
    protected int parameterCount = -1;
    protected int returningIntoParameterCount = 0;
    protected int orderByStartTokenIndex = -1;
    protected int orderByEndTokenIndex = -1;
    protected int forUpdateStartTokenIndex = -1;
    protected int forUpdateEndTokenIndex = -1;
    protected int selectIndex = -1;
    protected int whereIndex = -1;
    private boolean isConnectionValidationSql;
    private boolean connectionValidationSqlChecked = false;
    private StringBuilder stringBuilderForScrollableStatement = null;
    private boolean currentConvertNcharLiterals = false;
    private boolean currentProcessEscapes = false;
    protected boolean includeRowid = false;
    private List<SQLTokenizer.OracleConvertedSqlSequence> escapeSequences = null;
    int bindParameterCount = -1;
    String[] bindParameterList = null;
    int cachedBindParameterCount = -1;
    String[] cachedBindParameterList = null;
    String cachedParameterSql;
    String cachedUtickSql;
    String cachedProcessedSql;
    String cachedRowidSql;
    String cachedActualSql;
    byte[] cachedSqlBytes;
    String[] parameterList = EMPTY_ARRAY;
    static final String paramPrefix = "rowid";
    int paramSuffix = 0;
    int selectEndIndex = -1;
    int whereStartIndex = -1;
    int whereEndIndex = -1;
    int orderByStartIndex = -1;
    int orderByEndIndex = -1;
    int forUpdateStartIndex = -1;
    int forUpdateEndIndex = -1;
    String sqlId;
    String localSqlId;
    protected SQLTokenizer sqlTokenizer;
    private static final Pattern DATABASE_OBJECT_NAME_RULE = Pattern.compile("\"[^\"\\u0000]+\"|\\p{L}[\\p{L}\\p{N}_$#@]*");

    public static void main(String[] args) {
        String[] cases;
        if (args.length < 2) {
            System.err.println("ERROR: incorrect usage. OracleSql (-transition <file> | <process_escapes> <convert_nchars> { <sql> } )");
            return;
        }
        if (args[0].equals("-dump")) {
            return;
        }
        boolean escapes = args[0].equals("true");
        boolean nchar = args[1].equals("true");
        if (args.length > 2) {
            cases = new String[args.length - 2];
            System.arraycopy(args, 2, cases, 0, cases.length);
        } else {
            cases = new String[]{"select ? from dual", "insert into dual values (?)", "delete from dual", "update dual set dummy = ?", "merge tab into dual", " select ? from dual where ? = ?", "select ?from dual where?=?for update", "select '?', n'?', q'???', q'{?}', q'{cat's}' from dual", "select'?',n'?',q'???',q'{?}',q'{cat's}'from dual", "select--line\n? from dual", "select --line\n? from dual", "--line\nselect ? from dual", " --line\nselect ? from dual", "--line\n select ? from dual", "begin proc4in4out (:x1, :x2, :x3, :x4); end;", "{CALL tkpjpn01(:pin, :pinout, :pout)}", "select :NumberBindVar as the_number from dual", "select {fn locate(bob(carol(),ted(alice,sue)), 'xfy')} from dual", "CREATE USER vijay6 IDENTIFIED BY \"vjay?\"", "ALTER SESSION SET TIME", "SELECT ename FROM emp WHERE hiredate BETWEEN {ts'1980-12-17'} AND {ts '1981-09-28'} "};
        }
        for (String testCase : cases) {
            try {
                System.out.println("\n\n-----------------------");
                System.out.println(testCase);
                System.out.println();
                OracleSql o = new OracleSql(null);
                o.initialize(testCase);
                String sql = o.getSql(escapes, nchar);
                System.out.println(o.sqlKind + ", " + o.parameterCount);
                String[] p = o.getParameterList();
                if (p == EMPTY_ARRAY) {
                    System.out.println("parameterList is empty");
                } else {
                    for (int i = 0; i < p.length; ++i) {
                        System.out.println("parameterList[" + i + "] = " + p[i]);
                    }
                }
                if (o.getSqlKind().isDML()) {
                    int c = o.getReturnParameterCount();
                    if (c == -1) {
                        System.out.println("no return parameters");
                    } else {
                        System.out.println(c + " return parameters");
                    }
                }
                if (o.sqlTokenizer.getNCharLiterals() == null || o.sqlTokenizer.getNCharLiterals().isEmpty()) {
                    System.out.println("No NCHAR literals");
                } else {
                    System.out.println("NCHAR Literals");
                    for (SQLTokenizer.OracleConvertedSqlSequence oracleConvertedSqlSequence : o.sqlTokenizer.getNCharLiterals()) {
                        System.out.println(o.getSubString(oracleConvertedSqlSequence.getBeginTokenIndex(), oracleConvertedSqlSequence.getEndTokenIndex()));
                    }
                }
                System.out.println("Keywords");
                if (o.selectIndex == -1) {
                    System.out.println("no select");
                } else {
                    System.out.println("'" + o.sqlTokenizer.getTokens(o.selectIndex, o.selectIndex + 1) + "'");
                }
                if (o.orderByStartTokenIndex == -1) {
                    System.out.println("no order by");
                } else {
                    System.out.println("'" + o.sqlTokenizer.getTokens(o.orderByStartTokenIndex, o.orderByEndTokenIndex + 1) + "'");
                }
                if (o.whereIndex == -1) {
                    System.out.println("no where");
                } else {
                    System.out.println("'" + o.sqlTokenizer.getTokens(o.whereIndex, o.whereIndex + 1) + "'");
                }
                if (o.forUpdateStartTokenIndex == -1) {
                    System.out.println("no for update");
                } else if (o.forUpdateEndTokenIndex == o.sqlTokenizer.getNbTokens() - 1) {
                    System.out.println("'" + o.sqlTokenizer.getTokens(o.forUpdateStartTokenIndex, o.sqlTokenizer.getNbTokens()) + "'");
                } else {
                    System.out.println("'" + o.sqlTokenizer.getTokens(o.forUpdateStartTokenIndex, o.forUpdateEndTokenIndex + 1) + "'");
                }
                System.out.println("isPlsqlOrCall(): " + o.getSqlKind().isPlsqlOrCall());
                System.out.println("isDML(): " + o.getSqlKind().isDML());
                System.out.println("isSELECT(): " + o.getSqlKind().isSELECT());
                System.out.println("isOTHER(): " + o.getSqlKind().isOTHER());
                System.out.println("\"" + sql + "\"");
                System.out.println("\"" + o.getRevisedSql() + "\"");
                System.out.println("\"" + o.getRefetchSql() + "\"");
                String[] sArray = new String[]{sql};
                OracleParameterMetaDataParser.main(sArray);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    public OracleSql(DBConversion conv) {
        this(conv, false);
    }

    public OracleSql(DBConversion conv, boolean allowMixingJdbcAndNamedBinds) {
        this.conversion = conv;
        this.allowMixingJdbcAndNamedBinds = allowMixingJdbcAndNamedBinds;
    }

    protected void initialize(String sql) throws SQLException {
        if (sql == null || sql.length() == 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 104).fillInStackTrace();
        }
        this.originalSql = sql;
        this.parameterSql = sql;
        this.utickSql = null;
        this.processedSql = null;
        this.rowidSql = null;
        this.actualSql = null;
        this.sqlBytes = null;
        this.cachedParameterSql = null;
        this.cachedUtickSql = null;
        this.cachedProcessedSql = null;
        this.cachedRowidSql = null;
        this.cachedActualSql = null;
        this.cachedSqlBytes = null;
        this.sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
        this.parameterCount = -1;
        this.parameterList = EMPTY_ARRAY;
        this.bindParameterCount = -1;
        this.bindParameterList = null;
        this.cachedBindParameterCount = -1;
        this.cachedBindParameterList = null;
        this.currentConvertNcharLiterals = false;
        this.currentProcessEscapes = false;
        this.includeRowid = false;
        this.escapeSequences = null;
        this.connectionValidationSqlChecked = false;
        this.sqlId = null;
        this.localSqlId = null;
        this.sqlTokenizer = null;
    }

    protected void computeBasicInfo() throws SQLException {
        if (this.sqlTokenizer == null) {
            this.sqlTokenizer = new SQLTokenizer(this.originalSql);
        }
        int j = 0;
        boolean isFirstToken = true;
        boolean isJDBCEscapeSequence = false;
        boolean inReturningInto = false;
        boolean previousTokenWasReturning = false;
        int returningIndex = -1;
        int alterIndex = -1;
        int forIndex = -1;
        int orderIndex = -1;
        int forOriginalIndex = -1;
        int orderOriginalIndex = -1;
        this.parameterCount = 0;
        boolean isUsingJDBCBindNotation = false;
        boolean isUsingNamedBindNotation = false;
        block51: for (int i = 0; i < this.sqlTokenizer.getNbTokens(); ++i) {
            SQLTokenizer.TokenType tokenType = this.sqlTokenizer.getTokenType(i);
            if (tokenType == SQLTokenizer.TokenType.WHITESPACES) continue;
            if (tokenType == SQLTokenizer.TokenType.COMMENT) continue;
            ++j;
            String token = null;
            switch (tokenType) {
                case BIND: {
                    if (this.sqlTokenizer.getTokenLength(i) != 1) {
                        if (!this.allowMixingJdbcAndNamedBinds && isUsingJDBCBindNotation) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!").fillInStackTrace();
                        }
                        isUsingNamedBindNotation = true;
                        if (this.parameterList == EMPTY_ARRAY) {
                            this.parameterList = new String[8];
                        } else if (this.parameterList.length <= this.parameterCount) {
                            String[] newList = new String[this.parameterList.length * 4];
                            System.arraycopy(this.parameterList, 0, newList, 0, this.parameterList.length);
                            this.parameterList = newList;
                        }
                        token = this.sqlTokenizer.getToken(i);
                        this.parameterList[this.parameterCount] = token.substring(1, token.length()).trim().intern();
                    } else {
                        if (!this.allowMixingJdbcAndNamedBinds && isUsingNamedBindNotation) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!").fillInStackTrace();
                        }
                        isUsingJDBCBindNotation = true;
                    }
                    ++this.parameterCount;
                    if (!inReturningInto) continue block51;
                    ++this.returningIntoParameterCount;
                    continue block51;
                }
                case BLOCK_ESCAPE: {
                    if (!isFirstToken) continue block51;
                }
                case TOKEN: {
                    if (isFirstToken) {
                        token = null;
                        int tokenLength = this.sqlTokenizer.getTokenLength(i);
                        if (tokenType == SQLTokenizer.TokenType.BLOCK_ESCAPE) {
                            String blockEscapeContent = this.sqlTokenizer.getToken(i).trim();
                            token = blockEscapeContent.indexOf(" ") > 0 ? blockEscapeContent.substring(0, blockEscapeContent.indexOf(" ")).toUpperCase() : blockEscapeContent.toUpperCase();
                            tokenLength = token.length();
                        } else {
                            token = this.sqlTokenizer.getToken(i).toUpperCase();
                        }
                        switch (tokenLength) {
                            case 7: {
                                if (!"DECLARE".equals(token)) break;
                                this.sqlKind = OracleStatement.SqlKind.PLSQL_BLOCK;
                                break;
                            }
                            case 6: {
                                switch (token) {
                                    case "SELECT": {
                                        this.sqlKind = OracleStatement.SqlKind.SELECT;
                                        this.selectIndex = i;
                                        break;
                                    }
                                    case "INSERT": {
                                        this.sqlKind = OracleStatement.SqlKind.INSERT;
                                        break;
                                    }
                                    case "DELETE": {
                                        this.sqlKind = OracleStatement.SqlKind.DELETE;
                                        break;
                                    }
                                    case "UPDATE": {
                                        this.sqlKind = OracleStatement.SqlKind.UPDATE;
                                    }
                                }
                                break;
                            }
                            case 5: {
                                switch (token) {
                                    case "BEGIN": {
                                        this.sqlKind = OracleStatement.SqlKind.PLSQL_BLOCK;
                                        break;
                                    }
                                    case "MERGE": {
                                        this.sqlKind = OracleStatement.SqlKind.MERGE;
                                        break;
                                    }
                                    case "ALTER": {
                                        alterIndex = j;
                                    }
                                }
                                break;
                            }
                            case 4: {
                                switch (token) {
                                    case "CALL": {
                                        if (isJDBCEscapeSequence) {
                                            this.sqlKind = OracleStatement.SqlKind.PLSQL_BLOCK;
                                            break;
                                        }
                                        this.sqlKind = OracleStatement.SqlKind.CALL_BLOCK;
                                        break;
                                    }
                                    case "WITH": {
                                        this.sqlKind = OracleStatement.SqlKind.SELECT;
                                        this.selectIndex = i;
                                    }
                                }
                                break;
                            }
                        }
                        if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                            this.sqlKind = OracleStatement.SqlKind.OTHER;
                        }
                        previousTokenWasReturning = false;
                        isFirstToken = false;
                        continue block51;
                    }
                    token = null;
                    switch (this.sqlTokenizer.getTokenLength(i)) {
                        case 9: {
                            if (!"RETURNING".equals(this.sqlTokenizer.getToken(i).toUpperCase())) break;
                            returningIndex = j;
                            previousTokenWasReturning = true;
                            break;
                        }
                        case 7: {
                            if (!"SESSION".equals(this.sqlTokenizer.getToken(i).toUpperCase()) || alterIndex != j - 1) break;
                            this.sqlKind = OracleStatement.SqlKind.ALTER_SESSION;
                            previousTokenWasReturning = false;
                            break;
                        }
                        case 6: {
                            if ("UPDATE".equals(this.sqlTokenizer.getToken(i).toUpperCase())) {
                                if (forIndex == j - 1) {
                                    this.forUpdateStartTokenIndex = forOriginalIndex;
                                    this.forUpdateStartIndex = this.sqlTokenizer.getTokenBeginIndex(forOriginalIndex);
                                    this.forUpdateEndTokenIndex = i;
                                    this.forUpdateEndIndex = this.sqlTokenizer.getTokenBeginIndex(i);
                                    if (this.sqlKind == OracleStatement.SqlKind.SELECT) {
                                        this.sqlKind = OracleStatement.SqlKind.SELECT_FOR_UPDATE;
                                        this.sqlKind = OracleStatement.SqlKind.SELECT_FOR_UPDATE;
                                    }
                                }
                                previousTokenWasReturning = false;
                                break;
                            }
                            if (!"RETURN".equals(this.sqlTokenizer.getToken(i).toUpperCase())) break;
                            returningIndex = j;
                            previousTokenWasReturning = true;
                            break;
                        }
                        case 5: {
                            token = this.sqlTokenizer.getToken(i).toUpperCase();
                            if ("ORDER".equals(token)) {
                                orderIndex = j;
                                orderOriginalIndex = i;
                                previousTokenWasReturning = false;
                                break;
                            }
                            if ("WHERE".equals(token)) {
                                this.whereIndex = i;
                                this.whereStartIndex = this.sqlTokenizer.getTokenBeginIndex(i);
                                this.whereEndIndex = this.whereStartIndex + 5;
                                previousTokenWasReturning = false;
                                break;
                            }
                            if (!"FETCH".equals(token)) break;
                            previousTokenWasReturning = false;
                            break;
                        }
                        case 4: {
                            if (!"INTO".equals(this.sqlTokenizer.getToken(i).toUpperCase()) || !previousTokenWasReturning) break;
                            inReturningInto = true;
                            break;
                        }
                        case 3: {
                            if (!"FOR".equals(this.sqlTokenizer.getToken(i).toUpperCase())) break;
                            forIndex = j;
                            forOriginalIndex = i;
                            previousTokenWasReturning = false;
                            break;
                        }
                        case 2: {
                            if (!"BY".equals(this.sqlTokenizer.getToken(i).toUpperCase())) break;
                            if (orderIndex == j - 1) {
                                this.orderByStartTokenIndex = orderOriginalIndex;
                                this.orderByStartIndex = this.sqlTokenizer.getTokenBeginIndex(orderOriginalIndex);
                                this.orderByEndTokenIndex = i;
                                this.orderByEndIndex = this.sqlTokenizer.getTokenBeginIndex(i) + 2;
                            }
                            previousTokenWasReturning = false;
                        }
                    }
                    continue block51;
                }
                case OPEN_BRACKET: {
                    if (!isFirstToken) continue block51;
                    isJDBCEscapeSequence = true;
                }
            }
        }
    }

    String getOriginalSql() {
        return this.originalSql;
    }

    protected String getSql(boolean processEscapes, boolean convertNcharLiterals) throws SQLException {
        if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
            this.computeBasicInfo();
        }
        if (processEscapes != this.currentProcessEscapes || convertNcharLiterals != this.currentConvertNcharLiterals) {
            this.actualSql = null;
            this.sqlBytes = null;
        }
        this.currentConvertNcharLiterals = convertNcharLiterals;
        this.currentProcessEscapes = processEscapes;
        if (this.actualSql == null) {
            int nextEscapeSequenceBegin = -1;
            int processedEscapeSequences = 0;
            int nextNtickBegin = -1;
            int processedNTicks = 0;
            boolean skipNextWhitespace = false;
            if (this.currentConvertNcharLiterals && this.sqlTokenizer.getNCharLiterals() != null && !this.sqlTokenizer.getNCharLiterals().isEmpty()) {
                nextNtickBegin = this.sqlTokenizer.getNCharLiterals().get(processedNTicks).getBeginTokenIndex();
            }
            if (this.currentProcessEscapes) {
                this.convertEscapeSequences();
                if (this.escapeSequences != null && !this.escapeSequences.isEmpty()) {
                    nextEscapeSequenceBegin = this.escapeSequences.get(processedEscapeSequences).getBeginTokenIndex();
                }
            }
            int numBind = 1;
            StringBuilder sqlBuilder = new StringBuilder();
            for (int i = 0; i < this.sqlTokenizer.getNbTokens(); ++i) {
                if (i == nextEscapeSequenceBegin && this.currentProcessEscapes) {
                    sqlBuilder.append(this.escapeSequences.get(processedEscapeSequences).getConvertedSqlSequence());
                    i = this.escapeSequences.get(processedEscapeSequences).getEndTokenIndex();
                    if (this.escapeSequences.size() > ++processedEscapeSequences && this.currentConvertNcharLiterals) {
                        nextEscapeSequenceBegin = this.escapeSequences.get(processedEscapeSequences).getBeginTokenIndex();
                        continue;
                    }
                    nextEscapeSequenceBegin = -1;
                    continue;
                }
                if (i == nextNtickBegin) {
                    sqlBuilder.append(this.sqlTokenizer.getNCharLiterals().get(processedNTicks).getConvertedSqlSequence());
                    i = this.sqlTokenizer.getNCharLiterals().get(processedNTicks).getEndTokenIndex();
                    if (this.sqlTokenizer.getNCharLiterals().size() > ++processedNTicks) {
                        nextNtickBegin = this.sqlTokenizer.getNCharLiterals().get(processedNTicks).getBeginTokenIndex();
                        continue;
                    }
                    nextNtickBegin = -1;
                    continue;
                }
                if (this.currentProcessEscapes && this.sqlTokenizer.getTokenType(i) == SQLTokenizer.TokenType.BIND && this.sqlTokenizer.getTokenLength(i) == 1) {
                    if (this.bindParameterList != null && numBind - 1 < this.bindParameterList.length && this.bindParameterList[numBind - 1] != null) {
                        sqlBuilder.append(this.bindParameterList[numBind - 1] + "=>:" + numBind++ + " ");
                    } else {
                        sqlBuilder.append(":" + numBind++ + " ");
                    }
                    skipNextWhitespace = true;
                    continue;
                }
                if (this.sqlTokenizer.getTokenType(i) == SQLTokenizer.TokenType.WHITESPACES && skipNextWhitespace) {
                    skipNextWhitespace = false;
                    continue;
                }
                sqlBuilder.append(this.sqlTokenizer.getToken(i));
                skipNextWhitespace = false;
            }
            if (this.includeRowid) {
                if (this.selectIndex == -1) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 88).fillInStackTrace();
                }
                this.actualSql = "select rowid as \"__Oracle_JDBC_internal_ROWID__\"," + sqlBuilder.substring(this.sqlTokenizer.getTokenBeginIndex(this.selectIndex + 1));
            } else {
                this.actualSql = sqlBuilder.toString();
            }
        }
        return this.actualSql;
    }

    protected String getRevisedSql() throws SQLException {
        String result = null;
        if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
            this.computeBasicInfo();
        }
        result = this.removeOrderByForUpdate(this.parameterSql);
        return this.addRowid(result);
    }

    private String getSubString(int fromToken, int toToken) {
        int strEndIndex = 0;
        strEndIndex = toToken >= this.sqlTokenizer.getNbTokens() - 1 ? this.originalSql.length() : this.sqlTokenizer.getTokenBeginIndex(toToken + 1);
        return this.originalSql.substring(this.sqlTokenizer.getTokenBeginIndex(fromToken), strEndIndex);
    }

    private String removeForUpdate(String revisedSql) throws SQLException {
        if (this.forUpdateStartTokenIndex != -1) {
            return revisedSql.substring(0, this.sqlTokenizer.getTokenBeginIndex(this.forUpdateStartTokenIndex));
        }
        return revisedSql;
    }

    private String removeOrderByForUpdate(String revisedSql) throws SQLException {
        if (this.orderByStartTokenIndex != -1 && (this.forUpdateStartTokenIndex == -1 || this.forUpdateStartTokenIndex > this.orderByStartTokenIndex)) {
            revisedSql = revisedSql.substring(0, this.sqlTokenizer.getTokenBeginIndex(this.orderByStartTokenIndex));
        } else if (this.forUpdateStartTokenIndex != -1) {
            revisedSql = revisedSql.substring(0, this.sqlTokenizer.getTokenBeginIndex(this.forUpdateStartTokenIndex));
        }
        return revisedSql;
    }

    void appendForUpdate(StringBuilder sb) throws SQLException {
        if (this.orderByStartTokenIndex != -1 && (this.forUpdateStartTokenIndex == -1 || this.forUpdateStartTokenIndex > this.orderByStartTokenIndex)) {
            sb.append(this.originalSql.substring(this.sqlTokenizer.getTokenBeginIndex(this.orderByStartTokenIndex)));
        } else if (this.forUpdateStartTokenIndex != -1) {
            sb.append(this.originalSql.substring(this.sqlTokenizer.getTokenBeginIndex(this.forUpdateStartTokenIndex)));
        }
    }

    String getInsertSqlForUpdatableResultSet(List<String> names) throws SQLException {
        String originalSql = this.getOriginalSql();
        boolean needEscapeProcessing = this.generatedSqlNeedEscapeProcessing();
        if (this.stringBuilderForScrollableStatement == null) {
            this.stringBuilderForScrollableStatement = new StringBuilder(originalSql.length() + 30 + names.size() * 10);
        } else {
            this.stringBuilderForScrollableStatement.delete(0, this.stringBuilderForScrollableStatement.length());
        }
        this.stringBuilderForScrollableStatement.append("insert into (");
        this.stringBuilderForScrollableStatement.append(this.removeOrderByForUpdate(originalSql));
        this.stringBuilderForScrollableStatement.append(") (");
        String sep = "";
        for (String n : names) {
            this.stringBuilderForScrollableStatement.append(sep);
            this.stringBuilderForScrollableStatement.append("\"");
            this.stringBuilderForScrollableStatement.append(n);
            this.stringBuilderForScrollableStatement.append("\"");
            sep = ", ";
        }
        this.stringBuilderForScrollableStatement.append(") values ( ");
        sep = "";
        for (String n : names) {
            this.stringBuilderForScrollableStatement.append(sep);
            sep = ", ";
            if (needEscapeProcessing) {
                this.stringBuilderForScrollableStatement.append("?");
                continue;
            }
            this.stringBuilderForScrollableStatement.append(":" + this.generateParameterName());
        }
        this.stringBuilderForScrollableStatement.append(")");
        this.paramSuffix = 0;
        return this.stringBuilderForScrollableStatement.toString();
    }

    String getRefetchSqlForScrollableResultSet(OracleResultSet scrollableResultSet, int realRefreshSize) throws SQLException {
        throw new SQLException("no longer used");
    }

    String getRefetchSql() throws SQLException {
        String sql = this.removeForUpdate(this.parameterSql);
        StringBuilder s = new StringBuilder(sql.length() + 240);
        s.append("WITH \"__JDBC_ROWIDS__\" AS (SELECT COLUMN_VALUE ID, ROWNUM NUM FROM TABLE(");
        s.append((String)(this.generatedSqlNeedEscapeProcessing() ? "?" : ":" + this.generateParameterName()));
        s.append("))\n");
        s.append("SELECT \"__JDBC_ORIGINAL__\".*\n");
        s.append("FROM (");
        s.append(this.addRowid(sql));
        s.append(") \"__JDBC_ORIGINAL__\", \"__JDBC_ROWIDS__\"\n");
        s.append("WHERE \"__JDBC_ORIGINAL__\".\"__Oracle_JDBC_internal_ROWID__\"(+) = \"__JDBC_ROWIDS__\".ID\n");
        s.append("ORDER BY \"__JDBC_ROWIDS__\".NUM");
        this.paramSuffix = 0;
        return s.toString();
    }

    String getUpdateSqlForUpdatableResultSet(UpdatableResultSet updatableResultSet, int numberOfColumnsChanged, Object[] rowBuffer, int[] indexColsChanged) throws SQLException {
        String revisedSql = this.getRevisedSql();
        boolean needEscapeProcessing = this.generatedSqlNeedEscapeProcessing();
        if (this.stringBuilderForScrollableStatement == null) {
            this.stringBuilderForScrollableStatement = new StringBuilder(revisedSql.length() + 100);
        } else {
            this.stringBuilderForScrollableStatement.delete(0, this.stringBuilderForScrollableStatement.length());
        }
        this.stringBuilderForScrollableStatement.append("update (");
        this.stringBuilderForScrollableStatement.append(revisedSql);
        this.stringBuilderForScrollableStatement.append(") set ");
        if (rowBuffer != null) {
            for (int i = 0; i < numberOfColumnsChanged; ++i) {
                if (i > 0) {
                    this.stringBuilderForScrollableStatement.append(", ");
                }
                this.stringBuilderForScrollableStatement.append("\"");
                this.stringBuilderForScrollableStatement.append(updatableResultSet.getInternalMetadata().getColumnName(indexColsChanged[i] + 1));
                this.stringBuilderForScrollableStatement.append("\"");
                if (needEscapeProcessing) {
                    this.stringBuilderForScrollableStatement.append(" = ?");
                    continue;
                }
                this.stringBuilderForScrollableStatement.append(" = :" + this.generateParameterName());
            }
        }
        this.stringBuilderForScrollableStatement.append(" WHERE ");
        if (needEscapeProcessing) {
            this.stringBuilderForScrollableStatement.append(" ROWID = ?");
        } else {
            this.stringBuilderForScrollableStatement.append(" ROWID = :" + this.generateParameterName());
        }
        this.paramSuffix = 0;
        return this.stringBuilderForScrollableStatement.substring(0, this.stringBuilderForScrollableStatement.length());
    }

    String getDeleteSqlForUpdatableResultSet(UpdatableResultSet updatableResultSet) throws SQLException {
        String revisedSql = this.getRevisedSql();
        boolean needEscapeProcessing = this.generatedSqlNeedEscapeProcessing();
        if (this.stringBuilderForScrollableStatement == null) {
            this.stringBuilderForScrollableStatement = new StringBuilder(revisedSql.length() + 100);
        } else {
            this.stringBuilderForScrollableStatement.delete(0, this.stringBuilderForScrollableStatement.length());
        }
        this.stringBuilderForScrollableStatement.append("delete from (");
        this.stringBuilderForScrollableStatement.append(revisedSql);
        this.stringBuilderForScrollableStatement.append(") where ");
        if (needEscapeProcessing) {
            this.stringBuilderForScrollableStatement.append(" ROWID = ?");
        } else {
            this.stringBuilderForScrollableStatement.append(" ROWID = :" + this.generateParameterName());
        }
        this.paramSuffix = 0;
        return this.stringBuilderForScrollableStatement.substring(0, this.stringBuilderForScrollableStatement.length());
    }

    String getInsertSqlForUpdatableResultSet(OldUpdatableResultSet updatableResultSet) throws SQLException {
        String originalSql = this.getOriginalSql();
        boolean needEscapeProcessing = this.generatedSqlNeedEscapeProcessing();
        if (this.stringBuilderForScrollableStatement == null) {
            this.stringBuilderForScrollableStatement = new StringBuilder(originalSql.length() + 100);
        } else {
            this.stringBuilderForScrollableStatement.delete(0, this.stringBuilderForScrollableStatement.length());
        }
        this.stringBuilderForScrollableStatement.append("insert into (");
        this.stringBuilderForScrollableStatement.append(this.removeOrderByForUpdate(originalSql));
        this.stringBuilderForScrollableStatement.append(") values ( ");
        for (int i = 0; i < updatableResultSet.getColumnCount(); ++i) {
            if (i != 0) {
                this.stringBuilderForScrollableStatement.append(", ");
            }
            if (needEscapeProcessing) {
                this.stringBuilderForScrollableStatement.append("?");
                continue;
            }
            this.stringBuilderForScrollableStatement.append(":" + this.generateParameterName());
        }
        this.stringBuilderForScrollableStatement.append(")");
        this.paramSuffix = 0;
        return this.stringBuilderForScrollableStatement.substring(0, this.stringBuilderForScrollableStatement.length());
    }

    String getUpdateSqlForUpdatableResultSet(OldUpdatableResultSet updatableResultSet, int numberOfColumnsChanged, Object[] rowBuffer, int[] indexColsChanged) throws SQLException {
        String revisedSql = this.getRevisedSql();
        boolean needEscapeProcessing = this.generatedSqlNeedEscapeProcessing();
        if (this.stringBuilderForScrollableStatement == null) {
            this.stringBuilderForScrollableStatement = new StringBuilder(revisedSql.length() + 100);
        } else {
            this.stringBuilderForScrollableStatement.delete(0, this.stringBuilderForScrollableStatement.length());
        }
        this.stringBuilderForScrollableStatement.append("update (");
        this.stringBuilderForScrollableStatement.append(revisedSql);
        this.stringBuilderForScrollableStatement.append(") set ");
        if (rowBuffer != null) {
            for (int i = 0; i < numberOfColumnsChanged; ++i) {
                if (i > 0) {
                    this.stringBuilderForScrollableStatement.append(", ");
                }
                this.stringBuilderForScrollableStatement.append("\"");
                this.stringBuilderForScrollableStatement.append(updatableResultSet.getInternalMetadata().getColumnName(indexColsChanged[i] + 1));
                this.stringBuilderForScrollableStatement.append("\"");
                if (needEscapeProcessing) {
                    this.stringBuilderForScrollableStatement.append(" = ?");
                    continue;
                }
                this.stringBuilderForScrollableStatement.append(" = :" + this.generateParameterName());
            }
        }
        this.stringBuilderForScrollableStatement.append(" WHERE ");
        if (needEscapeProcessing) {
            this.stringBuilderForScrollableStatement.append(" ROWID = ?");
        } else {
            this.stringBuilderForScrollableStatement.append(" ROWID = :" + this.generateParameterName());
        }
        this.paramSuffix = 0;
        return this.stringBuilderForScrollableStatement.substring(0, this.stringBuilderForScrollableStatement.length());
    }

    String getDeleteSqlForUpdatableResultSet(OldUpdatableResultSet updatableResultSet) throws SQLException {
        String revisedSql = this.getRevisedSql();
        boolean needEscapeProcessing = this.generatedSqlNeedEscapeProcessing();
        if (this.stringBuilderForScrollableStatement == null) {
            this.stringBuilderForScrollableStatement = new StringBuilder(revisedSql.length() + 100);
        } else {
            this.stringBuilderForScrollableStatement.delete(0, this.stringBuilderForScrollableStatement.length());
        }
        this.stringBuilderForScrollableStatement.append("delete from (");
        this.stringBuilderForScrollableStatement.append(revisedSql);
        this.stringBuilderForScrollableStatement.append(") where ");
        if (needEscapeProcessing) {
            this.stringBuilderForScrollableStatement.append(" ROWID = ?");
        } else {
            this.stringBuilderForScrollableStatement.append(" ROWID = :" + this.generateParameterName());
        }
        this.paramSuffix = 0;
        return this.stringBuilderForScrollableStatement.substring(0, this.stringBuilderForScrollableStatement.length());
    }

    final boolean generatedSqlNeedEscapeProcessing() {
        return this.parameterCount > 0 && this.parameterList == EMPTY_ARRAY;
    }

    byte[] getSqlBytes(boolean desiredProcessEscapes, boolean desiredConvertNcharLiterals) throws SQLException {
        if (this.sqlBytes == null || desiredProcessEscapes != this.currentProcessEscapes) {
            this.sqlBytes = this.conversion.StringToCharBytes(this.getSql(desiredProcessEscapes, desiredConvertNcharLiterals));
        }
        return this.sqlBytes;
    }

    protected OracleStatement.SqlKind getSqlKind() throws SQLException {
        if (this.parameterSql == null) {
            return OracleStatement.SqlKind.UNINITIALIZED;
        }
        if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
            this.computeBasicInfo();
        }
        return this.sqlKind;
    }

    protected int getParameterCount() throws SQLException {
        if (this.parameterCount == -1) {
            this.computeBasicInfo();
        }
        return this.parameterCount;
    }

    protected String[] getParameterList() throws SQLException {
        if (this.parameterCount == -1) {
            this.computeBasicInfo();
        }
        return this.parameterList;
    }

    private boolean isEscapeSequenceEnd(int tokenIndex) {
        return tokenIndex > 0 && tokenIndex < this.sqlTokenizer.getNbTokens() && this.sqlTokenizer.getTokenType(tokenIndex) == SQLTokenizer.TokenType.CLOSE_BRACKET;
    }

    /*
     * Unable to fully structure code
     */
    void convertEscapeSequences() throws SQLException {
        if (this.escapeSequences != null) {
            return;
        }
        this.escapeSequences = new ArrayList<SQLTokenizer.OracleConvertedSqlSequence>();
        isFirstToken = true;
        lastTokenIndex = -1;
        inJson = false;
        jsonStack = new Stack<Character>();
        numBind = 0;
        j = -1;
lbl10:
        // 34 sources

        block33: for (i = 0; i < this.sqlTokenizer.getNbTokens() - 3; ++i) {
            j = i + 1;
            switch (1.$SwitchMap$oracle$jdbc$driver$utils$SQLTokenizer$TokenType[this.sqlTokenizer.getTokenType(i).ordinal()]) {
                case 4: {
                    if (lastTokenIndex != -1 && this.sqlTokenizer.getTokenLength(lastTokenIndex) == 4 && "JSON".equals(this.sqlTokenizer.getToken(lastTokenIndex).toUpperCase())) {
                        inJson = true;
                    }
                    if (inJson) continue block33;
                    j = this.sqlTokenizer.nextSignificantToken(j);
                    block10 : switch (1.$SwitchMap$oracle$jdbc$driver$utils$SQLTokenizer$TokenType[this.sqlTokenizer.getTokenType(j).ordinal()]) {
                        case 1: {
                            if (this.sqlTokenizer.getTokenLength(j) != 1) ** GOTO lbl10
                            ++numBind;
                            ++j;
                            while (j < this.sqlTokenizer.getNbTokens() && (this.sqlTokenizer.getTokenType(j) == SQLTokenizer.TokenType.WHITESPACES || this.sqlTokenizer.getTokenType(j) == SQLTokenizer.TokenType.COMMENT || this.sqlTokenizer.getTokenType(j) == SQLTokenizer.TokenType.OTHER)) {
                                if (this.sqlTokenizer.getTokenType(j) == SQLTokenizer.TokenType.OTHER && (this.sqlTokenizer.getTokenLength(j) != 1 || !"=".equals(this.sqlTokenizer.getToken(j)))) continue;
                                ++j;
                            }
                            switch (this.sqlTokenizer.getTokenLength(j)) {
                                case 4: {
                                    if ("CALL".equalsIgnoreCase(this.sqlTokenizer.getToken(j).toUpperCase())) {
                                        builder = new StringBuilder();
                                        builder.append("BEGIN :1 := ");
                                        ++numBind;
                                        ++j;
                                        while (j < this.sqlTokenizer.getNbTokens() && !this.isEscapeSequenceEnd(j)) {
                                            if (this.sqlTokenizer.getTokenType(j) == SQLTokenizer.TokenType.BIND && this.sqlTokenizer.getTokenLength(j) == 1) {
                                                if (this.bindParameterList != null && numBind - 1 < this.bindParameterList.length && this.bindParameterList[numBind - 1] != null) {
                                                    builder.append(this.bindParameterList[numBind - 1] + "=>:" + numBind++);
                                                } else {
                                                    builder.append(":" + numBind++);
                                                }
                                            } else {
                                                builder.append(this.sqlTokenizer.getToken(j));
                                            }
                                            ++j;
                                        }
                                        builder.append("; END;");
                                        if (!this.isEscapeSequenceEnd(j)) continue block33;
                                        this.escapeSequences.add(new SQLTokenizer.OracleConvertedSqlSequence(i, j, builder.toString()));
                                        i = j;
                                        break;
                                    }
                                    ** GOTO lbl10
                                }
                            }
                            continue block33;
                        }
                        case 3: {
                            switch (this.sqlTokenizer.getTokenLength(j)) {
                                case 6: {
                                    escapeType = this.sqlTokenizer.getToken(j).toUpperCase();
                                    if ("ESCAPE".equals(escapeType)) {
                                        builder = new StringBuilder();
                                        builder.append("ESCAPE ");
                                        ++j;
                                        for (j = this.sqlTokenizer.nextSignificantToken(j); j < this.sqlTokenizer.getNbTokens() && !this.isEscapeSequenceEnd(j); ++j) {
                                            if (this.sqlTokenizer.getTokenType(j) != SQLTokenizer.TokenType.SINGLE_QUOTED_STRING && this.sqlTokenizer.getTokenType(j) != SQLTokenizer.TokenType.DOUBLE_QUOTED_STRING) continue;
                                            builder.append(this.sqlTokenizer.getToken(j));
                                        }
                                        if (!this.isEscapeSequenceEnd(j)) continue block33;
                                        this.escapeSequences.add(new SQLTokenizer.OracleConvertedSqlSequence(i, j, builder.toString()));
                                        i = j;
                                        break block10;
                                    }
                                    ** GOTO lbl10
                                }
                                case 5: {
                                    escapeType = this.sqlTokenizer.getToken(j).toUpperCase();
                                    if ("LIMIT".equals(this.sqlTokenizer.getToken(j).toUpperCase())) {
                                        builder = new StringBuilder();
                                        builder.append("ROWNUM <= ");
                                        ++j;
                                        nbTokenFound = 0;
                                        for (j = this.sqlTokenizer.nextSignificantToken(j); j < this.sqlTokenizer.getNbTokens() && !this.isEscapeSequenceEnd(j); ++j) {
                                            if (this.sqlTokenizer.getTokenType(j) != SQLTokenizer.TokenType.TOKEN || ++nbTokenFound > 1) continue;
                                            builder.append(this.sqlTokenizer.getToken(j));
                                        }
                                        if (!this.isEscapeSequenceEnd(j)) continue block33;
                                        this.escapeSequences.add(new SQLTokenizer.OracleConvertedSqlSequence(i, j, builder.toString()));
                                        i = j;
                                        break block10;
                                    }
                                    ** GOTO lbl10
                                }
                                case 4: {
                                    escapeType = this.sqlTokenizer.getToken(j).toUpperCase();
                                    if ("CALL".equals(escapeType)) {
                                        builder = new StringBuilder();
                                        if (isFirstToken) {
                                            builder.append("BEGIN ");
                                        }
                                        ++j;
                                        nbOpenBracketsFound = 0;
                                        block38: for (j = this.sqlTokenizer.nextSignificantToken(j); !(j >= this.sqlTokenizer.getNbTokens() || nbOpenBracketsFound == 0 && this.isEscapeSequenceEnd(j)); ++j) {
                                            switch (1.$SwitchMap$oracle$jdbc$driver$utils$SQLTokenizer$TokenType[this.sqlTokenizer.getTokenType(j).ordinal()]) {
                                                case 1: {
                                                    if (this.sqlTokenizer.getTokenLength(j) == 1) {
                                                        if (this.bindParameterList != null && ++numBind - 1 < this.bindParameterList.length && this.bindParameterList[numBind - 1] != null) {
                                                            builder.append(this.bindParameterList[numBind - 1] + "=>:" + numBind);
                                                            continue block38;
                                                        }
                                                        builder.append(":" + numBind);
                                                        continue block38;
                                                    }
                                                    builder.append(this.sqlTokenizer.getToken(j));
                                                    continue block38;
                                                }
                                                case 4: {
                                                    ++nbOpenBracketsFound;
                                                    builder.append(this.sqlTokenizer.getToken(j));
                                                    continue block38;
                                                }
                                                case 5: {
                                                    --nbOpenBracketsFound;
                                                    builder.append(this.sqlTokenizer.getToken(j));
                                                    continue block38;
                                                }
                                                default: {
                                                    builder.append(this.sqlTokenizer.getToken(j));
                                                }
                                            }
                                        }
                                        if (!this.isEscapeSequenceEnd(j)) continue block33;
                                        if (isFirstToken) {
                                            builder.append("; END;");
                                            isFirstToken = false;
                                        }
                                        this.escapeSequences.add(new SQLTokenizer.OracleConvertedSqlSequence(i, j, builder.toString()));
                                        i = j;
                                        break block10;
                                    }
                                    ** GOTO lbl10
                                }
                                case 2: {
                                    escapeType = this.sqlTokenizer.getToken(j).toUpperCase();
                                    if ("FN".equals(escapeType)) {
                                        ++j;
                                        nbOpenBracketsFound = 0;
                                        while (!(j >= this.sqlTokenizer.getNbTokens() || nbOpenBracketsFound == 0 && this.isEscapeSequenceEnd(j))) {
                                            switch (1.$SwitchMap$oracle$jdbc$driver$utils$SQLTokenizer$TokenType[this.sqlTokenizer.getTokenType(j).ordinal()]) {
                                                case 4: {
                                                    ++nbOpenBracketsFound;
                                                    break;
                                                }
                                                case 5: {
                                                    --nbOpenBracketsFound;
                                                }
                                            }
                                            ++j;
                                        }
                                        if (j < this.sqlTokenizer.getNbTokens() && this.isEscapeSequenceEnd(j)) {
                                            pessf = this.parseEscapeSequenceScalarFunction(i, j, numBind);
                                            numBind += pessf.getNbBinds();
                                            this.escapeSequences.add(new SQLTokenizer.OracleConvertedSqlSequence(i, j, pessf.getConvertedEscapeSequence()));
                                        }
                                        i = j;
                                        break block10;
                                    }
                                    if ("OJ".equals(escapeType)) {
                                        builder = new StringBuilder();
                                        builder.append(" ( ");
                                        ++j;
                                        if (this.sqlTokenizer.getTokenType(j) != SQLTokenizer.TokenType.TOKEN) continue block33;
                                        for (j = this.sqlTokenizer.nextSignificantToken(j); j < this.sqlTokenizer.getNbTokens() && !this.isEscapeSequenceEnd(j); ++j) {
                                            builder.append(this.sqlTokenizer.getToken(j));
                                        }
                                        if (j >= this.sqlTokenizer.getNbTokens() || !this.isEscapeSequenceEnd(j)) continue block33;
                                        builder.append(" ) ");
                                        this.escapeSequences.add(new SQLTokenizer.OracleConvertedSqlSequence(i, j, builder.toString()));
                                        i = j;
                                        break block10;
                                    }
                                    if ("TS".equals(escapeType)) {
                                        parsedDateTimeLiteral = this.parseDateTimeLiterals(j);
                                        if (parsedDateTimeLiteral == null) continue block33;
                                        this.escapeSequences.add(new SQLTokenizer.OracleConvertedSqlSequence(i, parsedDateTimeLiteral.getDateTimeLiteralEndIndex(), parsedDateTimeLiteral.getConvertedDateTimeLiteral()));
                                        i = parsedDateTimeLiteral.getDateTimeLiteralEndIndex();
                                        break block10;
                                    }
                                    ** GOTO lbl10
                                }
                                case 1: {
                                    escapeType = this.sqlTokenizer.getToken(j).toUpperCase();
                                    if (("T".equals(escapeType) || "D".equals(escapeType)) && (parsedDateTimeLiteral = this.parseDateTimeLiterals(j)) != null) {
                                        this.escapeSequences.add(new SQLTokenizer.OracleConvertedSqlSequence(i, parsedDateTimeLiteral.getDateTimeLiteralEndIndex(), parsedDateTimeLiteral.getConvertedDateTimeLiteral()));
                                        i = parsedDateTimeLiteral.getDateTimeLiteralEndIndex();
                                    } else {
                                        ** GOTO lbl196
                                    }
                                }
                            }
                        }
                    }
lbl196:
                    // 11 sources

                    continue block33;
                }
                case 6: {
                    if (lastTokenIndex != -1 && this.sqlTokenizer.getTokenLength(lastTokenIndex) == 4 && "JSON".equals(this.sqlTokenizer.getToken(lastTokenIndex).toUpperCase())) {
                        inJson = true;
                    }
                    if (!inJson) continue block33;
                    jsonStack.push(Character.valueOf('['));
                    continue block33;
                }
                case 7: {
                    if (inJson) {
                        inJson = false;
                    } else if (lastTokenIndex != -1 && this.sqlTokenizer.getTokenLength(lastTokenIndex) == 4 && "JSON".equals(this.sqlTokenizer.getToken(lastTokenIndex).toUpperCase())) {
                        inJson = true;
                    }
                    if (!inJson) continue block33;
                    jsonStack.push(Character.valueOf('('));
                    continue block33;
                }
                case 8: {
                    if (!inJson || jsonStack.isEmpty() || ((Character)jsonStack.peek()).charValue() != '[') continue block33;
                    jsonStack.pop();
                    if (!jsonStack.isEmpty()) continue block33;
                    inJson = false;
                    continue block33;
                }
                case 5: {
                    if (!inJson || jsonStack.isEmpty() || ((Character)jsonStack.peek()).charValue() != '{') continue block33;
                    jsonStack.pop();
                    if (!jsonStack.isEmpty()) continue block33;
                    inJson = false;
                    continue block33;
                }
                case 9: {
                    if (jsonStack.isEmpty()) continue block33;
                    if (!inJson) {
                        inJson = true;
                        continue block33;
                    }
                    if (!inJson || ((Character)jsonStack.peek()).charValue() != '(') continue block33;
                    jsonStack.pop();
                    if (!jsonStack.isEmpty()) continue block33;
                    inJson = false;
                    continue block33;
                }
                case 1: {
                    ++numBind;
                    continue block33;
                }
                case 3: {
                    isFirstToken = false;
                    lastTokenIndex = i;
                }
            }
        }
    }

    private String addRowid(String sql) throws SQLException {
        if (this.selectIndex == -1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 88).fillInStackTrace();
        }
        String result = "select rowid as \"__Oracle_JDBC_internal_ROWID__\"," + sql.substring(this.sqlTokenizer.getTokenBeginIndex(this.selectIndex + 1));
        return result;
    }

    boolean setNamedParameters(int paramCount, String[] paramList) throws SQLException {
        boolean needToParse = false;
        if (paramCount == 0) {
            this.bindParameterCount = -1;
            needToParse = this.bindParameterCount != this.cachedBindParameterCount;
        } else {
            this.bindParameterCount = paramCount;
            this.bindParameterList = paramList;
            boolean bl = needToParse = this.bindParameterCount != this.cachedBindParameterCount || this.cachedBindParameterList == null;
            if (!needToParse) {
                for (int i = 0; i < paramCount; ++i) {
                    if (this.bindParameterList[i] == this.cachedBindParameterList[i]) continue;
                    needToParse = true;
                    break;
                }
            }
            if (needToParse) {
                if (this.bindParameterCount != this.getParameterCount()) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 197).fillInStackTrace();
                }
                char[] sqlArray = this.originalSql.toCharArray();
                StringBuilder strBuf = new StringBuilder();
                int j = 0;
                for (int i = 0; i < sqlArray.length; ++i) {
                    if (sqlArray[i] != '?') {
                        strBuf.append(sqlArray[i]);
                        continue;
                    }
                    strBuf.append(this.bindParameterList[j++]);
                    strBuf.append("=>:" + j);
                }
                this.parameterSql = strBuf.toString();
                this.actualSql = null;
                this.utickSql = null;
                this.processedSql = null;
                this.rowidSql = null;
                this.sqlBytes = null;
            } else {
                this.parameterSql = this.cachedParameterSql;
                this.actualSql = this.cachedActualSql;
                this.utickSql = this.cachedUtickSql;
                this.processedSql = this.cachedProcessedSql;
                this.rowidSql = this.cachedRowidSql;
                this.sqlBytes = this.cachedSqlBytes;
            }
        }
        this.cachedBindParameterList = null;
        this.cachedParameterSql = null;
        this.cachedActualSql = null;
        this.cachedUtickSql = null;
        this.cachedProcessedSql = null;
        this.cachedProcessedSql = null;
        this.cachedRowidSql = null;
        this.cachedSqlBytes = null;
        return needToParse;
    }

    void resetNamedParameters() {
        this.cachedBindParameterCount = this.bindParameterCount;
        if (this.bindParameterCount != -1) {
            if (this.cachedBindParameterList == null || this.cachedBindParameterList == this.bindParameterList || this.cachedBindParameterList.length < this.bindParameterCount) {
                this.cachedBindParameterList = new String[this.bindParameterCount];
            }
            System.arraycopy(this.bindParameterList, 0, this.cachedBindParameterList, 0, this.bindParameterCount);
            this.cachedParameterSql = this.parameterSql;
            this.cachedActualSql = this.actualSql;
            this.cachedUtickSql = this.utickSql;
            this.cachedProcessedSql = this.processedSql;
            this.cachedRowidSql = this.rowidSql;
            this.cachedSqlBytes = this.sqlBytes;
            this.bindParameterCount = -1;
            this.bindParameterList = null;
            this.parameterSql = this.originalSql;
            this.actualSql = null;
            this.utickSql = null;
            this.processedSql = null;
            this.rowidSql = null;
            this.sqlBytes = null;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    int getReturnParameterCount() throws SQLException {
        if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
            this.computeBasicInfo();
        }
        if (!this.sqlKind.isDML()) {
            return -1;
        }
        return this.returningIntoParameterCount;
    }

    public String getSqlId(boolean processEscapes, boolean convertNcharLiterals) throws SQLException {
        if (processEscapes != this.currentProcessEscapes || convertNcharLiterals != this.currentConvertNcharLiterals) {
            this.sqlId = null;
            this.localSqlId = null;
        }
        if (this.sqlId != null) {
            return this.sqlId;
        }
        if (this.localSqlId == null) {
            try {
                this.localSqlId = OracleSql.getLocalSqlId(this.getSql(processEscapes, convertNcharLiterals));
            }
            catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
                throw new SQLException("Unable to generate SQL ID locally", e);
            }
        }
        return this.localSqlId;
    }

    public static String getLocalSqlId(String sql) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        if (sql == null) {
            return null;
        }
        byte[] sqlBytes = sql.trim().getBytes("UTF-8");
        byte[] sqlBytesNullTerminated = new byte[sqlBytes.length + 1];
        System.arraycopy(sqlBytes, 0, sqlBytesNullTerminated, 0, sqlBytes.length);
        sqlBytesNullTerminated[sqlBytes.length] = 0;
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] md5bytes = md.digest(sqlBytesNullTerminated);
        String[] md5HexHash = new String[8];
        for (int i = 8; i < 16; ++i) {
            md5HexHash[i - 8] = Integer.toString((md5bytes[i] & 0xFF) + 256, 16).substring(1);
        }
        String reversed = md5HexHash[3] + md5HexHash[2] + md5HexHash[1] + md5HexHash[0] + md5HexHash[7] + md5HexHash[6] + md5HexHash[5] + md5HexHash[4];
        String binaryString = new BigInteger(reversed, 16).toString(2);
        StringBuilder paddedBinaryString = new StringBuilder(64);
        for (int i = binaryString.length(); i < 64; ++i) {
            paddedBinaryString.append('0');
        }
        binaryString = paddedBinaryString.append(binaryString).toString();
        String base32 = "0123456789abcdfghjkmnpqrstuvwxyz";
        String[] binaryStringGroups = StringUtils.splitString(binaryString, 4, 5);
        StringBuilder sqlid = new StringBuilder(13);
        for (int i = 0; i < 13; ++i) {
            String currentPiece = i == 0 ? binaryString.substring(0, 4) : binaryStringGroups[i - 1];
            int base32Index = Integer.parseInt(currentPiece, 2);
            sqlid.append(base32.charAt(base32Index));
        }
        return sqlid.toString();
    }

    /*
     * Unable to fully structure code
     */
    private ParsedEscapeSequenceScalarFunction parseEscapeSequenceScalarFunction(int beginTokenIndex, int endTokenIndex, int questionBindStartNumber) throws SQLException {
        functionName = null;
        nbTokenFound = 0;
        functionTokenIndex = -1;
        questionBindNumber = 0;
        block108: for (i = beginTokenIndex; i <= endTokenIndex; ++i) {
            switch (1.$SwitchMap$oracle$jdbc$driver$utils$SQLTokenizer$TokenType[this.sqlTokenizer.getTokenType(i).ordinal()]) {
                case 3: {
                    if (++nbTokenFound != 1) ** GOTO lbl20
                    if (this.sqlTokenizer.getTokenLength(i) != 2 || !"FN".equalsIgnoreCase(this.sqlTokenizer.getToken(i))) {
                        switch (this.sqlTokenizer.getTokenLength(i)) {
                            case 1: {
                                if (!"T".equalsIgnoreCase(this.sqlTokenizer.getToken(i)) && !"D".equalsIgnoreCase(this.sqlTokenizer.getToken(i))) break;
                                parsedDateTimeLiteral = this.parseDateTimeLiterals(i);
                                return new ParsedEscapeSequenceScalarFunction(parsedDateTimeLiteral.getConvertedDateTimeLiteral(), 0);
                            }
                            case 2: {
                                if (!"TS".equalsIgnoreCase(this.sqlTokenizer.getToken(i))) break;
                                parsedDateTimeLiteral = this.parseDateTimeLiterals(i);
                                return new ParsedEscapeSequenceScalarFunction(parsedDateTimeLiteral.getConvertedDateTimeLiteral(), 0);
                            }
                        }
                    }
                    ** GOTO lbl24
lbl20:
                    // 1 sources

                    if (nbTokenFound == 2) {
                        functionName = this.sqlTokenizer.getToken(i).toUpperCase().intern();
                        functionTokenIndex = i;
                        break block108;
                    }
                }
lbl24:
                // 4 sources

                default: {
                    continue block108;
                }
            }
        }
        functionCall = new StringBuilder();
        parsedDateTimeLiteral = functionName;
        var10_14 = -1;
        switch (parsedDateTimeLiteral.hashCode()) {
            case 64594: {
                if (!parsedDateTimeLiteral.equals("ABS")) break;
                var10_14 = 0;
                break;
            }
            case 2003334: {
                if (!parsedDateTimeLiteral.equals("ACOS")) break;
                var10_14 = 1;
                break;
            }
            case 2018519: {
                if (!parsedDateTimeLiteral.equals("ASIN")) break;
                var10_14 = 2;
                break;
            }
            case 2019232: {
                if (!parsedDateTimeLiteral.equals("ATAN")) break;
                var10_14 = 3;
                break;
            }
            case 62596242: {
                if (!parsedDateTimeLiteral.equals("ATAN2")) break;
                var10_14 = 4;
                break;
            }
            case 66919: {
                if (!parsedDateTimeLiteral.equals("COS")) break;
                var10_14 = 5;
                break;
            }
            case 69117: {
                if (!parsedDateTimeLiteral.equals("EXP")) break;
                var10_14 = 6;
                break;
            }
            case 66989036: {
                if (!parsedDateTimeLiteral.equals("FLOOR")) break;
                var10_14 = 7;
                break;
            }
            case 76514: {
                if (!parsedDateTimeLiteral.equals("MOD")) break;
                var10_14 = 8;
                break;
            }
            case 76320997: {
                if (!parsedDateTimeLiteral.equals("POWER")) break;
                var10_14 = 9;
                break;
            }
            case 78166382: {
                if (!parsedDateTimeLiteral.equals("ROUND")) break;
                var10_14 = 10;
                break;
            }
            case 2545085: {
                if (!parsedDateTimeLiteral.equals("SIGN")) break;
                var10_14 = 11;
                break;
            }
            case 82104: {
                if (!parsedDateTimeLiteral.equals("SIN")) break;
                var10_14 = 12;
                break;
            }
            case 2553120: {
                if (!parsedDateTimeLiteral.equals("SQRT")) break;
                var10_14 = 13;
                break;
            }
            case 82817: {
                if (!parsedDateTimeLiteral.equals("TAN")) break;
                var10_14 = 14;
                break;
            }
            case 62568241: {
                if (!parsedDateTimeLiteral.equals("ASCII")) break;
                var10_14 = 15;
                break;
            }
            case 1993501460: {
                if (!parsedDateTimeLiteral.equals("CONCAT")) break;
                var10_14 = 16;
                break;
            }
            case -2053034266: {
                if (!parsedDateTimeLiteral.equals("LENGTH")) break;
                var10_14 = 17;
                break;
            }
            case 72771182: {
                if (!parsedDateTimeLiteral.equals("LTRIM")) break;
                var10_14 = 18;
                break;
            }
            case 1812479636: {
                if (!parsedDateTimeLiteral.equals("REPLACE")) break;
                var10_14 = 19;
                break;
            }
            case 78312308: {
                if (!parsedDateTimeLiteral.equals("RTRIM")) break;
                var10_14 = 20;
                break;
            }
            case -1304012318: {
                if (!parsedDateTimeLiteral.equals("SOUNDEX")) break;
                var10_14 = 21;
                break;
            }
            case -587306911: {
                if (!parsedDateTimeLiteral.equals("EXTRACT")) break;
                var10_14 = 22;
                break;
            }
            case 1378369693: {
                if (!parsedDateTimeLiteral.equals("CEILING")) break;
                var10_14 = 23;
                break;
            }
            case 75556: {
                if (!parsedDateTimeLiteral.equals("LOG")) break;
                var10_14 = 24;
                break;
            }
            case 72610883: {
                if (!parsedDateTimeLiteral.equals("LOG10")) break;
                var10_14 = 25;
                break;
            }
            case 2553: {
                if (!parsedDateTimeLiteral.equals("PI")) break;
                var10_14 = 26;
                break;
            }
            case -1659355802: {
                if (!parsedDateTimeLiteral.equals("TRUNCATE")) break;
                var10_14 = 27;
                break;
            }
            case 2067286: {
                if (!parsedDateTimeLiteral.equals("CHAR")) break;
                var10_14 = 28;
                break;
            }
            case -1089186833: {
                if (!parsedDateTimeLiteral.equals("CHAR_LENGTH")) break;
                var10_14 = 29;
                break;
            }
            case -2049076004: {
                if (!parsedDateTimeLiteral.equals("CHARACTER_LENGTH")) break;
                var10_14 = 30;
                break;
            }
            case 72248700: {
                if (!parsedDateTimeLiteral.equals("LCASE")) break;
                var10_14 = 31;
                break;
            }
            case -2044132526: {
                if (!parsedDateTimeLiteral.equals("LOCATE")) break;
                var10_14 = 32;
                break;
            }
            case -1288978570: {
                if (!parsedDateTimeLiteral.equals("OCTET_LENGTH")) break;
                var10_14 = 33;
                break;
            }
            case -977830351: {
                if (!parsedDateTimeLiteral.equals("SUBSTRING")) break;
                var10_14 = 34;
                break;
            }
            case 80560389: {
                if (!parsedDateTimeLiteral.equals("UCASE")) break;
                var10_14 = 35;
                break;
            }
            case -479705388: {
                if (!parsedDateTimeLiteral.equals("CURRENT_DATE")) break;
                var10_14 = 36;
                break;
            }
            case 1844501966: {
                if (!parsedDateTimeLiteral.equals("CURDATE")) break;
                var10_14 = 37;
                break;
            }
            case -262905456: {
                if (!parsedDateTimeLiteral.equals("CURRENT_TIMESTAMP")) break;
                var10_14 = 38;
                break;
            }
            case 1844986093: {
                if (!parsedDateTimeLiteral.equals("CURTIME")) break;
                var10_14 = 39;
                break;
            }
            case 77494: {
                if (!parsedDateTimeLiteral.equals("NOW")) break;
                var10_14 = 40;
                break;
            }
            case 1963754477: {
                if (!parsedDateTimeLiteral.equals("DAYOFMONTH")) break;
                var10_14 = 41;
                break;
            }
            case 2223588: {
                if (!parsedDateTimeLiteral.equals("HOUR")) break;
                var10_14 = 42;
                break;
            }
            case -2020697580: {
                if (!parsedDateTimeLiteral.equals("MINUTE")) break;
                var10_14 = 43;
                break;
            }
            case 73542240: {
                if (!parsedDateTimeLiteral.equals("MONTH")) break;
                var10_14 = 44;
                break;
            }
            case -1852950412: {
                if (!parsedDateTimeLiteral.equals("SECOND")) break;
                var10_14 = 45;
                break;
            }
            case 2719805: {
                if (!parsedDateTimeLiteral.equals("YEAR")) break;
                var10_14 = 46;
                break;
            }
            case -2137984988: {
                if (!parsedDateTimeLiteral.equals("IFNULL")) break;
                var10_14 = 47;
                break;
            }
            case 2614219: {
                if (!parsedDateTimeLiteral.equals("USER")) break;
                var10_14 = 48;
                break;
            }
            case 66920: {
                if (!parsedDateTimeLiteral.equals("COT")) break;
                var10_14 = 49;
                break;
            }
            case -2030766329: {
                if (!parsedDateTimeLiteral.equals("DEGREES")) break;
                var10_14 = 50;
                break;
            }
            case 1686791762: {
                if (!parsedDateTimeLiteral.equals("RADIANS")) break;
                var10_14 = 51;
                break;
            }
            case 2507813: {
                if (!parsedDateTimeLiteral.equals("RAND")) break;
                var10_14 = 52;
                break;
            }
            case -2081513155: {
                if (!parsedDateTimeLiteral.equals("DIFFERENCE")) break;
                var10_14 = 53;
                break;
            }
            case -2130463047: {
                if (!parsedDateTimeLiteral.equals("INSERT")) break;
                var10_14 = 54;
                break;
            }
            case 2332679: {
                if (!parsedDateTimeLiteral.equals("LEFT")) break;
                var10_14 = 55;
                break;
            }
            case 1530431785: {
                if (!parsedDateTimeLiteral.equals("POSITION")) break;
                var10_14 = 56;
                break;
            }
            case -1881202277: {
                if (!parsedDateTimeLiteral.equals("REPEAT")) break;
                var10_14 = 57;
                break;
            }
            case 77974012: {
                if (!parsedDateTimeLiteral.equals("RIGHT")) break;
                var10_14 = 58;
                break;
            }
            case 79100134: {
                if (!parsedDateTimeLiteral.equals("SPACE")) break;
                var10_14 = 59;
                break;
            }
            case -479221261: {
                if (!parsedDateTimeLiteral.equals("CURRENT_TIME")) break;
                var10_14 = 60;
                break;
            }
            case -2128782329: {
                if (!parsedDateTimeLiteral.equals("DAYNAME")) break;
                var10_14 = 61;
                break;
            }
            case -1321838393: {
                if (!parsedDateTimeLiteral.equals("DAYOFWEEK")) break;
                var10_14 = 62;
                break;
            }
            case 1487564011: {
                if (!parsedDateTimeLiteral.equals("MONTHNAME")) break;
                var10_14 = 63;
                break;
            }
            case 1369386636: {
                if (!parsedDateTimeLiteral.equals("QUARTER")) break;
                var10_14 = 64;
                break;
            }
            case -387672117: {
                if (!parsedDateTimeLiteral.equals("TIMESTAMPADD")) break;
                var10_14 = 65;
                break;
            }
            case 867160571: {
                if (!parsedDateTimeLiteral.equals("TIMESTAMPDIFF")) break;
                var10_14 = 66;
                break;
            }
            case 2660340: {
                if (!parsedDateTimeLiteral.equals("WEEK")) break;
                var10_14 = 67;
                break;
            }
            case -1722875525: {
                if (!parsedDateTimeLiteral.equals("DATABASE")) break;
                var10_14 = 68;
                break;
            }
            case 1669573011: {
                if (!parsedDateTimeLiteral.equals("CONVERT")) break;
                var10_14 = 69;
            }
        }
        switch (var10_14) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                functionCall.append(functionName + "(");
                break;
            }
            case 23: {
                functionCall.append("CEIL(");
                break;
            }
            case 24: {
                functionCall.append("LN(");
                break;
            }
            case 25: {
                functionCall.append("LOG ( 10, ");
                break;
            }
            case 26: {
                functionCall.append("( 3.141592653589793238462643383279502884197169399375 ");
                break;
            }
            case 27: {
                functionCall.append("TRUNC(");
                break;
            }
            case 28: {
                functionCall.append("CHR(");
                break;
            }
            case 29: 
            case 30: {
                functionCall.append("LENGTH(");
                break;
            }
            case 31: {
                functionCall.append("LOWER(");
                break;
            }
            case 32: {
                functionCall.append("INSTR(");
                break;
            }
            case 33: {
                functionCall.append("LENGTHB(");
                break;
            }
            case 34: {
                functionCall.append("SUBSTR(");
                break;
            }
            case 35: {
                functionCall.append("UPPER(");
                break;
            }
            case 36: 
            case 37: {
                functionCall.append("(CURRENT_DATE");
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                functionCall.append("(CURRENT_TIMESTAMP");
                break;
            }
            case 41: {
                functionCall.append("EXTRACT ( DAY FROM ");
                break;
            }
            case 42: {
                functionCall.append("EXTRACT ( HOUR FROM ");
                break;
            }
            case 43: {
                functionCall.append("EXTRACT ( MINUTE FROM ");
                break;
            }
            case 44: {
                functionCall.append("EXTRACT ( MONTH FROM ");
                break;
            }
            case 45: {
                functionCall.append("EXTRACT ( SECOND FROM ");
                break;
            }
            case 46: {
                functionCall.append("EXTRACT ( YEAR FROM ");
                break;
            }
            case 47: {
                functionCall.append("NVL(");
                break;
            }
            case 48: {
                functionCall.append("(USER");
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
            }
        }
        seenFirstOpenParenthese = false;
        parentheseTracker = 0;
        firstParameterBuilder = new StringBuilder();
        firstParameter = null;
        for (i = functionTokenIndex + 1; i < endTokenIndex; ++i) {
            if (!seenFirstOpenParenthese) {
                if (this.sqlTokenizer.getTokenType(i) == SQLTokenizer.TokenType.OPEN_PARENTHESE) {
                    seenFirstOpenParenthese = true;
                    continue;
                }
                functionCall.append(this.sqlTokenizer.getToken(i));
                continue;
            }
            if (functionName == "LOCATE") {
                if (this.sqlTokenizer.getTokenType(i) == SQLTokenizer.TokenType.OPEN_PARENTHESE) {
                    if (firstParameter == null) {
                        firstParameterBuilder.append(this.sqlTokenizer.getToken(i));
                    } else {
                        functionCall.append(this.sqlTokenizer.getToken(i));
                    }
                    ++parentheseTracker;
                    continue;
                }
                if (this.sqlTokenizer.getTokenType(i) == SQLTokenizer.TokenType.CLOSE_PARENTHESE) {
                    if (firstParameter == null) {
                        firstParameterBuilder.append(this.sqlTokenizer.getToken(i));
                    } else {
                        if (parentheseTracker == 0) {
                            functionCall.append(", " + firstParameter);
                        }
                        functionCall.append(this.sqlTokenizer.getToken(i));
                    }
                    --parentheseTracker;
                    continue;
                }
                if (this.sqlTokenizer.getTokenType(i) == SQLTokenizer.TokenType.BIND && this.sqlTokenizer.getTokenLength(i) == 1) {
                    ++questionBindNumber;
                    ++questionBindStartNumber;
                    if (firstParameter == null) {
                        firstParameterBuilder.append(":" + questionBindStartNumber);
                        continue;
                    }
                    functionCall.append(":" + questionBindStartNumber);
                    continue;
                }
                if (this.sqlTokenizer.getTokenType(i) == SQLTokenizer.TokenType.COMMA && parentheseTracker == 0 && firstParameter == null) {
                    firstParameter = firstParameterBuilder.toString();
                    continue;
                }
                if (i == endTokenIndex) continue;
                if (firstParameter == null) {
                    firstParameterBuilder.append(this.sqlTokenizer.getToken(i));
                    continue;
                }
                functionCall.append(this.sqlTokenizer.getToken(i));
                continue;
            }
            if (this.sqlTokenizer.getTokenType(i) == SQLTokenizer.TokenType.BIND && this.sqlTokenizer.getTokenLength(i) == 1) {
                ++questionBindNumber;
                functionCall.append(":" + ++questionBindStartNumber);
                continue;
            }
            if (this.sqlTokenizer.getTokenType(i) == SQLTokenizer.TokenType.OPEN_BRACKET) {
                nbOpenBracketsFound = 0;
                block110: for (j = i + 1; j < this.sqlTokenizer.getNbTokens() && (this.sqlTokenizer.getTokenType(j) != SQLTokenizer.TokenType.CLOSE_BRACKET || nbOpenBracketsFound != 0); ++j) {
                    switch (1.$SwitchMap$oracle$jdbc$driver$utils$SQLTokenizer$TokenType[this.sqlTokenizer.getTokenType(j).ordinal()]) {
                        case 4: {
                            ++nbOpenBracketsFound;
                            continue block110;
                        }
                        case 5: {
                            --nbOpenBracketsFound;
                        }
                    }
                }
                if (j >= this.sqlTokenizer.getNbTokens() || this.sqlTokenizer.getTokenType(j) != SQLTokenizer.TokenType.CLOSE_BRACKET) continue;
                nestedEscapeSeq = this.parseEscapeSequenceScalarFunction(i, j, questionBindStartNumber);
                questionBindStartNumber += nestedEscapeSeq.getNbBinds();
                functionCall.append(nestedEscapeSeq.getConvertedEscapeSequence());
                i = j;
                continue;
            }
            functionCall.append(this.sqlTokenizer.getToken(i));
        }
        return new ParsedEscapeSequenceScalarFunction(functionCall.toString(), questionBindNumber);
    }

    private ParsedDateTimeLiteral parseDateTimeLiterals(int beginTokenIndex) {
        for (int i = beginTokenIndex; i < this.sqlTokenizer.getNbTokens(); ++i) {
            String dateTimeLiteralType = null;
            if (this.sqlTokenizer.getTokenType(i) != SQLTokenizer.TokenType.TOKEN) continue;
            switch (this.sqlTokenizer.getTokenLength(i)) {
                case 2: {
                    dateTimeLiteralType = this.sqlTokenizer.getToken(beginTokenIndex).toUpperCase();
                    if ("TS".equals(dateTimeLiteralType)) {
                        int j;
                        StringBuilder builder = new StringBuilder();
                        builder.append("TO_TIMESTAMP (");
                        ++i;
                        switch (this.sqlTokenizer.getTokenType(j)) {
                            case SINGLE_QUOTED_STRING: {
                                builder.append(this.sqlTokenizer.getToken(j));
                                ++j;
                                break;
                            }
                            case TOKEN: {
                                for (j = i = this.sqlTokenizer.nextSignificantToken(i); j < this.sqlTokenizer.getNbTokens() && this.sqlTokenizer.getTokenType(j) != SQLTokenizer.TokenType.CLOSE_BRACKET; ++j) {
                                    builder.append(this.sqlTokenizer.getToken(j));
                                }
                                break;
                            }
                            default: {
                                return null;
                            }
                        }
                        if (j < this.sqlTokenizer.getNbTokens() && this.isEscapeSequenceEnd(j)) {
                            builder.append(", 'YYYY-MM-DD HH24:MI:SS.FF')");
                            return new ParsedDateTimeLiteral(builder.toString(), j);
                        }
                        return null;
                    }
                    return null;
                }
                case 1: {
                    dateTimeLiteralType = this.sqlTokenizer.getToken(beginTokenIndex).toUpperCase();
                    if ("T".equals(dateTimeLiteralType)) {
                        int j;
                        StringBuilder builder = new StringBuilder();
                        builder.append("TO_DATE('1-JAN-1970 '||TO_CHAR(TO_DATE(");
                        ++i;
                        switch (this.sqlTokenizer.getTokenType(j)) {
                            case SINGLE_QUOTED_STRING: {
                                builder.append(this.sqlTokenizer.getToken(j));
                                ++j;
                                break;
                            }
                            case TOKEN: {
                                for (j = i = this.sqlTokenizer.nextSignificantToken(i); j < this.sqlTokenizer.getNbTokens() && this.sqlTokenizer.getTokenType(j) != SQLTokenizer.TokenType.CLOSE_BRACKET; ++j) {
                                    builder.append(this.sqlTokenizer.getToken(j));
                                }
                                break;
                            }
                            default: {
                                return null;
                            }
                        }
                        if (j < this.sqlTokenizer.getNbTokens() && this.isEscapeSequenceEnd(j)) {
                            builder.append(", 'HH24:MI:SS'),'HH24:MI:SS'),'DD-MON-YYYY HH24:MI:SS')");
                            return new ParsedDateTimeLiteral(builder.toString(), j);
                        }
                        return null;
                    }
                    if ("D".equals(dateTimeLiteralType)) {
                        int j;
                        StringBuilder builder = new StringBuilder();
                        builder.append("TO_DATE (");
                        ++i;
                        switch (this.sqlTokenizer.getTokenType(j)) {
                            case SINGLE_QUOTED_STRING: {
                                builder.append(this.sqlTokenizer.getToken(j));
                                ++j;
                                break;
                            }
                            case TOKEN: {
                                for (j = i = this.sqlTokenizer.nextSignificantToken(i); j < this.sqlTokenizer.getNbTokens() && this.sqlTokenizer.getTokenType(j) != SQLTokenizer.TokenType.CLOSE_BRACKET; ++j) {
                                    builder.append(this.sqlTokenizer.getToken(j));
                                }
                                break;
                            }
                            default: {
                                return null;
                            }
                        }
                        if (j < this.sqlTokenizer.getNbTokens() && this.isEscapeSequenceEnd(j)) {
                            builder.append(", 'YYYY-MM-DD')");
                            return new ParsedDateTimeLiteral(builder.toString(), j);
                        }
                        return null;
                    }
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    void setIncludeRowid(boolean enable) {
        if (enable != this.includeRowid) {
            this.includeRowid = enable;
            this.rowidSql = null;
            this.actualSql = null;
            this.sqlBytes = null;
            this.sqlId = null;
            this.localSqlId = null;
        }
    }

    String generateParameterName() {
        String newParameter;
        if (this.parameterCount == 0 || this.parameterList == null) {
            return paramPrefix + this.paramSuffix++;
        }
        block0: while (true) {
            newParameter = paramPrefix + this.paramSuffix++;
            for (int i = 0; i < this.parameterList.length; ++i) {
                if (newParameter.equals(this.parameterList[i])) continue block0;
            }
            break;
        }
        return newParameter;
    }

    public String toString() {
        return this.parameterSql == null ? "null" : this.parameterSql;
    }

    boolean isConnectionValidationSql() {
        if (!this.connectionValidationSqlChecked) {
            Matcher m = CONNECTION_VALIDATION_SQL_PATTERN.matcher(this.originalSql);
            this.isConnectionValidationSql = m.matches();
            this.connectionValidationSqlChecked = true;
        }
        return this.isConnectionValidationSql;
    }

    String parse() throws SQLException {
        return this.getSql(true, true);
    }

    static boolean isValidPlsqlWarning(String setting) throws SQLException {
        return setting.matches("('\\s*([a-zA-Z0-9:,\\(\\)\\s])*')\\s*(,\\s*'([a-zA-Z0-9:,\\(\\)\\s])*')*");
    }

    public static boolean isValidObjectName(String name) {
        assert (name != null && name.length() > 0) : "name is null or empty";
        return DATABASE_OBJECT_NAME_RULE.matcher(name).matches();
    }

    private class ParsedEscapeSequenceScalarFunction {
        private String convertedEscapeSequence;
        private int nbBinds = 0;

        ParsedEscapeSequenceScalarFunction(String convertedEscapeSequence, int nbBinds) {
            this.convertedEscapeSequence = convertedEscapeSequence;
            this.nbBinds = nbBinds;
        }

        public String getConvertedEscapeSequence() {
            return this.convertedEscapeSequence;
        }

        public int getNbBinds() {
            return this.nbBinds;
        }
    }

    private class ParsedDateTimeLiteral {
        private String convertedDateTimeLiteral;
        private int dateTimeLiteralEndIndex;

        ParsedDateTimeLiteral(String convertedDateTimeLiteral, int dateTimeLiteralEndIndex) {
            this.convertedDateTimeLiteral = convertedDateTimeLiteral;
            this.dateTimeLiteralEndIndex = dateTimeLiteralEndIndex;
        }

        public String getConvertedDateTimeLiteral() {
            return this.convertedDateTimeLiteral;
        }

        public int getDateTimeLiteralEndIndex() {
            return this.dateTimeLiteralEndIndex;
        }
    }
}

