/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.NIOAcceptPacket;
import oracle.net.ns.NIOHeader;
import oracle.net.ns.NIOMarkerPacket;
import oracle.net.ns.NIORedirectPacket;
import oracle.net.ns.NIORefusePacket;
import oracle.net.ns.NIOResendPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.MQLNTAdapter;
import oracle.net.nt.NTAdapter;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
abstract class NIOPacket {
    final NIOHeader header;
    public SessionAtts session;
    static final String[] toHex = new String[]{" 00", " 01", " 02", " 03", " 04", " 05", " 06", " 07", " 08", " 09", " 0A", " 0B", " 0C", " 0D", " 0E", " 0F", " 10", " 11", " 12", " 13", " 14", " 15", " 16", " 17", " 18", " 19", " 1A", " 1B", " 1C", " 1D", " 1E", " 1F", " 20", " 21", " 22", " 23", " 24", " 25", " 26", " 27", " 28", " 29", " 2A", " 2B", " 2C", " 2D", " 2E", " 2F", " 30", " 31", " 32", " 33", " 34", " 35", " 36", " 37", " 38", " 39", " 3A", " 3B", " 3C", " 3D", " 3E", " 3F", " 40", " 41", " 42", " 43", " 44", " 45", " 46", " 47", " 48", " 49", " 4A", " 4B", " 4C", " 4D", " 4E", " 4F", " 50", " 51", " 52", " 53", " 54", " 55", " 56", " 57", " 58", " 59", " 5A", " 5B", " 5C", " 5D", " 5E", " 5F", " 60", " 61", " 62", " 63", " 64", " 65", " 66", " 67", " 68", " 69", " 6A", " 6B", " 6C", " 6D", " 6E", " 6F", " 70", " 71", " 72", " 73", " 74", " 75", " 76", " 77", " 78", " 79", " 7A", " 7B", " 7C", " 7D", " 7E", " 7F", " 80", " 81", " 82", " 83", " 84", " 85", " 86", " 87", " 88", " 89", " 8A", " 8B", " 8C", " 8D", " 8E", " 8F", " 90", " 91", " 92", " 93", " 94", " 95", " 96", " 97", " 98", " 99", " 9A", " 9B", " 9C", " 9D", " 9E", " 9F", " A0", " A1", " A2", " A3", " A4", " A5", " A6", " A7", " A8", " A9", " AA", " AB", " AC", " AD", " AE", " AF", " B0", " B1", " B2", " B3", " B4", " B5", " B6", " B7", " B8", " B9", " BA", " BB", " BC", " BD", " BE", " BF", " C0", " C1", " C2", " C3", " C4", " C5", " C6", " C7", " C8", " C9", " CA", " CB", " CC", " CD", " CE", " CF", " D0", " D1", " D2", " D3", " D4", " D5", " D6", " D7", " D8", " D9", " DA", " DB", " DC", " DD", " DE", " DF", " E0", " E1", " E2", " E3", " E4", " E5", " E6", " E7", " E8", " E9", " EA", " EB", " EC", " ED", " EE", " EF", " F0", " F1", " F2", " F3", " F4", " F5", " F6", " F7", " F8", " F9", " FA", " FB", " FC", " FD", " FE", " FF"};
    static final char[] toChar = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};

    NIOPacket(SessionAtts sessionAtts) {
        this.session = sessionAtts;
        this.header = new NIOHeader(sessionAtts);
    }

    NIOPacket(NIOHeader nIOHeader, SessionAtts sessionAtts) throws IOException {
        this.header = nIOHeader;
        this.session = sessionAtts;
    }

    abstract void readPayloadBuffer() throws IOException;

    final void readFromSocketChannel(boolean bl) throws IOException {
        this.readFromSocketChannel(bl, true);
    }

    final void readFromSocketChannel(boolean bl, boolean bl2) throws IOException {
        if (this.session.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            ByteOrder byteOrder = this.session.buffer.order();
            ByteBuffer byteBuffer = ((MQLNTAdapter)this.session.nt).readFromLocalQueue();
            int n2 = byteBuffer.limit();
            byteBuffer.order(byteOrder);
            this.session.setBuffer(byteBuffer);
            this.session.payloadDataBuffer.position(this.session.payloadDataBuffer.limit());
            if (n2 >= 8) {
                this.session.headerBuffer.position(0);
                this.session.headerBuffer.limit(8);
                this.header.readNSHeader();
            }
            this.session.payloadBuffer.clear();
            this.session.payloadBuffer.limit(this.header.length - 8);
        } else {
            if (bl) {
                this.header.readHeaderBuffer();
            }
            this.session.payloadBuffer.clear();
            this.session.payloadBuffer.limit(this.header.length - 8);
            while (this.session.payloadBuffer.hasRemaining()) {
                this.session.socketChannel.read(this.session.payloadBuffer);
            }
            this.session.payloadBuffer.rewind();
        }
        if (this.header.type == 14) {
            this.session.controlPacket.readPayloadBuffer();
        }
        if (bl2 && this.header.type == 12) {
            this.session.markerPacket.readPayloadBuffer();
            this.processMarker();
            this.session.onBreakReset = this.session.markerPacket.isBreakPkt();
            throw new BreakNetException(500);
        }
    }

    protected void processMarker() throws IOException, NetException, BreakNetException {
    }

    final void writeToSocketChannel() throws IOException {
        this.header.length = this.session.payloadBuffer.position() + 8;
        this.header.fillHeaderBuffer();
        this.session.buffer.clear();
        this.session.buffer.limit(this.session.payloadBuffer.position() + 8);
        if (this.session.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            ((MQLNTAdapter)this.session.nt).writeToRemoteQueue(this.session.buffer, this.session.needToReleaseMSGQBuffer);
            this.session.buffer = null;
            this.session.initializeBuffer(this.session.getSDU());
        } else {
            while (this.session.buffer.hasRemaining()) {
                this.session.socketChannel.write(this.session.buffer);
            }
        }
        this.session.payloadBuffer.clear();
    }

    static NIOPacket readNIOPacket(SessionAtts sessionAtts) throws IOException {
        NIOPacket nIOPacket = null;
        NIOHeader nIOHeader = new NIOHeader(sessionAtts);
        if (sessionAtts.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            ByteBuffer byteBuffer = ((MQLNTAdapter)sessionAtts.nt).readFromLocalQueue();
            int n2 = byteBuffer.limit();
            sessionAtts.setBuffer(byteBuffer);
            if (n2 >= 8) {
                sessionAtts.headerBuffer.position(0);
                sessionAtts.headerBuffer.limit(8);
                nIOHeader.readNSHeader();
            }
            sessionAtts.payloadBuffer.clear();
            sessionAtts.payloadBuffer.limit(nIOHeader.length - 8);
            sessionAtts.buffer.position(nIOHeader.length);
        } else {
            nIOHeader.readHeaderBuffer();
        }
        switch (nIOHeader.type) {
            case 2: {
                nIOPacket = new NIOAcceptPacket(nIOHeader, sessionAtts);
                break;
            }
            case 5: {
                nIOPacket = new NIORedirectPacket(nIOHeader, sessionAtts);
                break;
            }
            case 4: {
                nIOPacket = new NIORefusePacket(nIOHeader, sessionAtts);
                break;
            }
            case 11: {
                nIOPacket = new NIOResendPacket(nIOHeader, sessionAtts);
                break;
            }
            case 12: {
                nIOPacket = new NIOMarkerPacket(nIOHeader, sessionAtts);
                break;
            }
            default: {
                throw new NetException(204);
            }
        }
        if (sessionAtts.networkType != NTAdapter.NetworkAdapterType.MSGQ) {
            nIOPacket.readFromSocketChannel(false);
        }
        nIOPacket.readPayloadBuffer();
        return nIOPacket;
    }

    void reinitialize(SessionAtts sessionAtts) throws NetException {
        this.session = sessionAtts;
    }

    void addFlags(int n2) throws NetException {
        this.header.flags |= n2;
    }

    void setPoolEnabled(boolean bl) throws IOException, NetException, BreakNetException {
        if (bl) {
            this.addFlags(1);
        }
    }

    void setLargeSDU(boolean bl) throws IOException, NetException, BreakNetException {
        if (bl) {
            this.addFlags(32);
        }
    }

    String dumpBytes(ByteBuffer byteBuffer, int n2) {
        StringBuilder stringBuilder = new StringBuilder(16384);
        StringBuilder stringBuilder2 = new StringBuilder(80);
        if (byteBuffer == null) {
            return "NULL";
        }
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        byteBuffer.rewind();
        byteBuffer.limit(n2);
        stringBuilder.delete(0, stringBuilder.length());
        stringBuilder2.delete(0, stringBuilder2.length());
        int n5 = 0;
        while (byteBuffer.hasRemaining()) {
            int n6 = byteBuffer.get() & 0xFF;
            stringBuilder.append(toHex[n6]);
            stringBuilder2.append(toChar[n6]);
            if (++n5 != 8) continue;
            stringBuilder.append("     |");
            stringBuilder.append(stringBuilder2.substring(0, stringBuilder2.length()));
            stringBuilder.append("|\n");
            stringBuilder2.delete(0, stringBuilder2.length());
            n5 = 0;
        }
        if (n5 > 0) {
            int n7;
            int n8 = 8 - n5 - 1;
            for (n7 = 0; n7 <= n8; ++n7) {
                stringBuilder.append("   ");
            }
            stringBuilder.append("     |");
            stringBuilder.append(stringBuilder2.substring(0, stringBuilder2.length()));
            for (n7 = 0; n7 <= n8; ++n7) {
                stringBuilder.append(" ");
            }
            stringBuilder.append("|\n");
            stringBuilder2.delete(0, stringBuilder2.length());
        }
        byteBuffer.rewind();
        if (n4 >= 0) {
            byteBuffer.limit(n4);
        }
        if (n3 >= 0 && n3 <= n4) {
            byteBuffer.position(n3);
        }
        return stringBuilder.substring(0, stringBuilder.length());
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

