
package com.prowidesoftware.swift.model.mx.dic;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for InformationQualify1Code.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="InformationQualify1Code">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="CUSA"/>
 *     <enumeration value="DISP"/>
 *     <enumeration value="DOCT"/>
 *     <enumeration value="ERRO"/>
 *     <enumeration value="INPT"/>
 *     <enumeration value="POIR"/>
 *     <enumeration value="RCPT"/>
 *     <enumeration value="SOND"/>
 *     <enumeration value="STAT"/>
 *     <enumeration value="VCHR"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "InformationQualify1Code")
@XmlEnum
public enum InformationQualify1Code {


    /**
     * Input of the Cardholder POI interface which can be entered by the Cashier to assist the Customer.
     * 
     */
    CUSA,

    /**
     * Standard display interface.
     * 
     */
    DISP,

    /**
     * When the POI System wants to print specific document (check, dynamic currency conversion ...). Used by the Sale System when the printer is not located on the Sale System.
     * 
     */
    DOCT,

    /**
     * The information is related to an error situation occurring on the message sender.
     * 
     */
    ERRO,

    /**
     * Answer to a question or information to be entered by the Cashier or the Customer, at the request of the POI Terminal or the Sale Terminal.
     * 
     */
    INPT,

    /**
     * Information displayed on the Cardholder POI interface, replicated on the Cashier interface.
     * 
     */
    POIR,

    /**
     * Where you print the Payment receipt that could be located on the Sale System or in some cases a restricted Sale ticket on the POI Terminal.
     * 
     */
    RCPT,

    /**
     * Standard sound interface.
     * 
     */
    SOND,

    /**
     * The information is a new state on which the message sender is entering. For instance, during a payment, the POI could display to the Cashier that POI request an authorisation to the host acquirer.
     * 
     */
    STAT,

    /**
     * Coupons, voucher or special ticket generated by the POI or the Sale System and to be printed.
     * 
     */
    VCHR;

    public String value() {
        return name();
    }

    public static InformationQualify1Code fromValue(String v) {
        return valueOf(v);
    }

}
