/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.ProwideException;
import com.prowidesoftware.swift.model.MxId;
import com.prowidesoftware.swift.model.mx.AppHdr;
import com.prowidesoftware.swift.model.mx.AppHdrType;
import com.prowidesoftware.swift.model.mx.BusinessAppHdrV01;
import com.prowidesoftware.swift.model.mx.BusinessAppHdrV02;
import com.prowidesoftware.swift.model.mx.BusinessAppHdrV03;
import com.prowidesoftware.swift.model.mx.BusinessAppHdrV04;
import com.prowidesoftware.swift.model.mx.LegacyAppHdr;
import com.prowidesoftware.swift.model.mx.dic.BranchAndFinancialInstitutionIdentification5;
import com.prowidesoftware.swift.model.mx.dic.BranchAndFinancialInstitutionIdentification6;
import com.prowidesoftware.swift.model.mx.dic.BranchAndFinancialInstitutionIdentification8;
import com.prowidesoftware.swift.model.mx.dic.EntityIdentification;
import com.prowidesoftware.swift.model.mx.dic.FinancialInstitutionIdentification18;
import com.prowidesoftware.swift.model.mx.dic.FinancialInstitutionIdentification23;
import com.prowidesoftware.swift.model.mx.dic.FinancialInstitutionIdentification8;
import com.prowidesoftware.swift.model.mx.dic.Party44Choice;
import com.prowidesoftware.swift.model.mx.dic.Party51Choice;
import com.prowidesoftware.swift.model.mx.dic.Party9Choice;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class AppHdrFactory {
    public static BusinessAppHdrV01 createBusinessAppHdrV01(String sender, String receiver, String reference, MxId id) {
        BusinessAppHdrV01 h = new BusinessAppHdrV01();
        if (sender != null) {
            h.setFr(new Party9Choice());
            h.getFr().setFIId(new BranchAndFinancialInstitutionIdentification5());
            h.getFr().getFIId().setFinInstnId(new FinancialInstitutionIdentification8());
            h.getFr().getFIId().getFinInstnId().setBICFI(sender);
        }
        if (receiver != null) {
            h.setTo(new Party9Choice());
            h.getTo().setFIId(new BranchAndFinancialInstitutionIdentification5());
            h.getTo().getFIId().setFinInstnId(new FinancialInstitutionIdentification8());
            h.getTo().getFIId().getFinInstnId().setBICFI(receiver);
        }
        if (reference != null) {
            h.setBizMsgIdr(reference);
        }
        if (id != null) {
            h.setMsgDefIdr(id.id());
        }
        h.setCreDt(OffsetDateTime.now(ZoneOffset.UTC));
        return h;
    }

    public static BusinessAppHdrV02 createBusinessAppHdrV02(String sender, String receiver, String reference, MxId id) {
        BusinessAppHdrV02 h = new BusinessAppHdrV02();
        if (sender != null) {
            h.setFr(new Party44Choice());
            h.getFr().setFIId(new BranchAndFinancialInstitutionIdentification6());
            h.getFr().getFIId().setFinInstnId(new FinancialInstitutionIdentification18());
            h.getFr().getFIId().getFinInstnId().setBICFI(sender);
        }
        if (receiver != null) {
            h.setTo(new Party44Choice());
            h.getTo().setFIId(new BranchAndFinancialInstitutionIdentification6());
            h.getTo().getFIId().setFinInstnId(new FinancialInstitutionIdentification18());
            h.getTo().getFIId().getFinInstnId().setBICFI(receiver);
        }
        if (reference != null) {
            h.setBizMsgIdr(reference);
        }
        if (id != null) {
            h.setMsgDefIdr(id.id());
            if (id.getBusinessService().isPresent()) {
                h.setBizSvc(id.getBusinessService().get());
            }
        }
        h.setCreDt(OffsetDateTime.now());
        return h;
    }

    public static BusinessAppHdrV03 createBusinessAppHdrV03(String sender, String receiver, String reference, MxId id) {
        BusinessAppHdrV03 h = new BusinessAppHdrV03();
        if (sender != null) {
            h.setFr(new Party44Choice());
            h.getFr().setFIId(new BranchAndFinancialInstitutionIdentification6());
            h.getFr().getFIId().setFinInstnId(new FinancialInstitutionIdentification18());
            h.getFr().getFIId().getFinInstnId().setBICFI(sender);
        }
        if (receiver != null) {
            h.setTo(new Party44Choice());
            h.getTo().setFIId(new BranchAndFinancialInstitutionIdentification6());
            h.getTo().getFIId().setFinInstnId(new FinancialInstitutionIdentification18());
            h.getTo().getFIId().getFinInstnId().setBICFI(receiver);
        }
        if (reference != null) {
            h.setBizMsgIdr(reference);
        }
        if (id != null) {
            h.setMsgDefIdr(id.id());
            if (id.getBusinessService().isPresent()) {
                h.setBizSvc(id.getBusinessService().get());
            }
        }
        h.setCreDt(OffsetDateTime.now());
        return h;
    }

    public static BusinessAppHdrV04 createBusinessAppHdrV04(String sender, String receiver, String reference, MxId id) {
        BusinessAppHdrV04 h = new BusinessAppHdrV04();
        if (sender != null) {
            h.setFr(new Party51Choice());
            h.getFr().setFIId(new BranchAndFinancialInstitutionIdentification8());
            h.getFr().getFIId().setFinInstnId(new FinancialInstitutionIdentification23());
            h.getFr().getFIId().getFinInstnId().setBICFI(sender);
        }
        if (receiver != null) {
            h.setTo(new Party51Choice());
            h.getTo().setFIId(new BranchAndFinancialInstitutionIdentification8());
            h.getTo().getFIId().setFinInstnId(new FinancialInstitutionIdentification23());
            h.getTo().getFIId().getFinInstnId().setBICFI(receiver);
        }
        if (reference != null) {
            h.setBizMsgIdr(reference);
        }
        if (id != null) {
            h.setMsgDefIdr(id.id());
            if (id.getBusinessService().isPresent()) {
                h.setBizSvc(id.getBusinessService().get());
            }
        }
        h.setCreDt(OffsetDateTime.now());
        return h;
    }

    public static LegacyAppHdr createLegacyAppHdr(String sender, String receiver, String reference, MxId id) {
        LegacyAppHdr h = new LegacyAppHdr();
        if (sender != null) {
            h.setFrom(new EntityIdentification());
            h.getFrom().setType("BIC");
            h.getFrom().setId(sender);
        }
        if (receiver != null) {
            h.setTo(new EntityIdentification());
            h.getTo().setType("BIC");
            h.getTo().setId(receiver);
        }
        if (reference != null) {
            h.setMsgRef(reference);
        }
        if (id != null) {
            h.setMsgName(id.id());
        }
        h.setCrDate(OffsetDateTime.now());
        return h;
    }

    public static AppHdr createAppHdr(AppHdrType type, String sender, String receiver, String reference, MxId id) {
        switch (type) {
            case LEGACY: {
                return AppHdrFactory.createLegacyAppHdr(sender, receiver, reference, id);
            }
            case BAH_V1: {
                return AppHdrFactory.createBusinessAppHdrV01(sender, receiver, reference, id);
            }
            case BAH_V2: {
                return AppHdrFactory.createBusinessAppHdrV02(sender, receiver, reference, id);
            }
            case BAH_V3: {
                return AppHdrFactory.createBusinessAppHdrV03(sender, receiver, reference, id);
            }
            case BAH_V4: {
                return AppHdrFactory.createBusinessAppHdrV04(sender, receiver, reference, id);
            }
        }
        throw new ProwideException("Don't know how to create header " + type);
    }
}

