/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field44J
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "44J";
    public static final String F_44J = "44J";
    public static final Integer COUNTRY_CODE = 1;
    public static final Integer COUNTRY_SUB_DIVISION = 2;
    public static final Integer NARRATIVE = 3;

    public Field44J() {
        super(3);
    }

    public Field44J(String value) {
        super(value);
    }

    public Field44J(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"44J")) {
            throw new IllegalArgumentException("cannot create field 44J from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field44J newInstance(Field44J source) {
        Field44J cp = new Field44J();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("44J", value);
    }

    public static Tag emptyTag() {
        return new Tag("44J", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            this.setComponent1(SwiftParseUtils.getTokenFirst(lines.get(0), "/", "/"));
            this.setComponent2(SwiftParseUtils.getTokenSecondLast(lines.get(0), "/"));
            SwiftParseUtils.setComponentsFromLines(this, 3, null, 1, lines);
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null) {
            result.append("/").append(this.getComponent2());
        }
        if (this.getComponent3() != null) {
            result.append("\r\n");
            result.append(this.getComponent3());
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 44J");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "SSS";
    }

    @Override
    public String parserPattern() {
        return "S[/S][$/S]";
    }

    @Override
    public String validatorPattern() {
        return "<CC>[/35x][$/65x]";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 2) {
            return true;
        }
        return component == 3;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Country Code");
        result.add("Country Sub Division");
        result.add("Narrative");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "countryCode");
        result.put(2, "countrySubDivision");
        result.put(3, "narrative");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("countrycode", 1);
        this.labelMap.put("countrysubdivision", 2);
        this.labelMap.put("narrative", 3);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getCountryCode() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getCountrySubDivision() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getNarrative() {
        return this.getComponent3();
    }

    public Field44J setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field44J setCountryCode(String component1) {
        return this.setComponent1(component1);
    }

    public Field44J setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field44J setCountrySubDivision(String component2) {
        return this.setComponent2(component2);
    }

    public Field44J setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field44J setNarrative(String component3) {
        return this.setComponent3(component3);
    }

    @Override
    public String getName() {
        return "44J";
    }

    public static Field44J get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("44J");
        if (t == null) {
            return null;
        }
        return new Field44J(t);
    }

    public static Field44J get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field44J.get(msg.getBlock4());
    }

    public static List<Field44J> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field44J.getAll(msg.getBlock4());
    }

    public static List<Field44J> getAll(SwiftTagListBlock block) {
        ArrayList<Field44J> result = new ArrayList<Field44J>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("44J");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field44J(f));
            }
        }
        return result;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field44J cp = Field44J.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field44J cp = Field44J.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field44J cp = Field44J.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field44J fromJson(String json) {
        Field44J field = new Field44J();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("countryCode") != null) {
            field.setComponent1(jsonObject.get("countryCode").getAsString());
        }
        if (jsonObject.get("countrySubDivision") != null) {
            field.setComponent2(jsonObject.get("countrySubDivision").getAsString());
        }
        if (jsonObject.get("narrative") != null) {
            field.setComponent3(jsonObject.get("narrative").getAsString());
        }
        return field;
    }
}

