/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.BICResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field59A
extends Field
implements Serializable,
BICContainer,
MultiLineField {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "59A";
    public static final String F_59A = "59A";
    public static final Integer ACCOUNT = 1;
    public static final Integer IDENTIFIER_CODE = 2;

    public Field59A() {
        super(2);
    }

    public Field59A(String value) {
        super(value);
    }

    public Field59A(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"59A")) {
            throw new IllegalArgumentException("cannot create field 59A from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field59A newInstance(Field59A source) {
        Field59A cp = new Field59A();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("59A", value);
    }

    public static Tag emptyTag() {
        return new Tag("59A", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            if (lines.get(0).startsWith("/")) {
                this.setComponent1(StringUtils.substring((String)lines.get(0), (int)1));
                SwiftParseUtils.setComponentsFromLines(this, 2, null, 1, lines);
            } else {
                SwiftParseUtils.setComponentsFromLines(this, 2, null, 0, lines);
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        if (this.getComponent1() != null) {
            result.append("/").append(this.getComponent1());
        }
        this.appendInLines(result, this.getComponent2());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 59A");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "SB";
    }

    @Override
    public String parserPattern() {
        return "[/S$]S";
    }

    @Override
    public String validatorPattern() {
        return "[/34x$]<BIC>";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 1;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Account");
        result.add("Identifier Code");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "account");
        result.put(2, "identifierCode");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("account", 1);
        this.labelMap.put("identifiercode", 2);
        this.labelMap.put("bic", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getAccount() {
        String account = this.getComponent(1);
        if (account != null) {
            for (int i = 0; i < account.length(); ++i) {
                if (account.charAt(i) == '/') continue;
                return account.substring(i);
            }
            return "";
        }
        return null;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public BIC getComponent2AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(2));
    }

    public String getIdentifierCode() {
        return this.getComponent2();
    }

    public BIC getIdentifierCodeAsBIC() {
        return this.getComponent2AsBIC();
    }

    public Field59A setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field59A setAccount(String component1) {
        return this.setComponent1(component1);
    }

    public Field59A setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field59A setComponent2(BIC component2) {
        this.setComponent(2, SwiftFormatUtils.getBIC(component2));
        return this;
    }

    public Field59A setIdentifierCode(String component2) {
        return this.setComponent2(component2);
    }

    public Field59A setIdentifierCode(BIC component2) {
        return this.setComponent2(component2);
    }

    @Override
    public List<BIC> bics() {
        return BICResolver.bics(this);
    }

    @Override
    public List<String> bicStrings() {
        return BICResolver.bicStrings(this);
    }

    @Override
    public String getName() {
        return "59A";
    }

    public static Field59A get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("59A");
        if (t == null) {
            return null;
        }
        return new Field59A(t);
    }

    public static Field59A get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field59A.get(msg.getBlock4());
    }

    public static List<Field59A> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field59A.getAll(msg.getBlock4());
    }

    public static List<Field59A> getAll(SwiftTagListBlock block) {
        ArrayList<Field59A> result = new ArrayList<Field59A>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("59A");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field59A(f));
            }
        }
        return result;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field59A cp = Field59A.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field59A cp = Field59A.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field59A cp = Field59A.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field59A fromJson(String json) {
        Field59A field = new Field59A();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("account") != null) {
            field.setComponent1(jsonObject.get("account").getAsString());
        }
        if (jsonObject.get("bIC") != null) {
            field.setComponent2(jsonObject.get("bIC").getAsString());
        }
        if (jsonObject.get("identifierCode") != null) {
            field.setComponent2(jsonObject.get("identifierCode").getAsString());
        }
        return field;
    }
}

