/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.LogicalTerminalAddress;
import com.prowidesoftware.swift.model.MessageDirection;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock2InputField;
import java.io.Serializable;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;

public class SwiftBlock2Input
extends SwiftBlock2
implements Serializable {
    private static final transient Logger log = Logger.getLogger(SwiftBlock2.class.getName());
    private static final long serialVersionUID = 6094810199379196198L;
    private String receiverAddress;
    private String deliveryMonitoring;
    private String obsolescencePeriod;

    public SwiftBlock2Input(String messageType, String receiverAddress, String messagePriority, String deliveryMonitoring, String obsolescencePeriod) {
        this.input = true;
        this.messageType = messageType;
        this.receiverAddress = receiverAddress;
        this.messagePriority = messagePriority;
        this.deliveryMonitoring = deliveryMonitoring;
        this.obsolescencePeriod = obsolescencePeriod;
    }

    public SwiftBlock2Input(String value) {
        this(value, false);
    }

    public SwiftBlock2Input(String value, boolean lenient) {
        this.setValue(value, lenient);
    }

    public SwiftBlock2Input() {
    }

    public SwiftBlock2Input(SwiftBlock2Input block) {
        this(block.getMessageType(), block.getReceiverAddress(), block.getMessagePriority(), block.getDeliveryMonitoring(), block.getObsolescencePeriod());
    }

    public static SwiftBlock2Input fromJson(String json) {
        Gson gson = new GsonBuilder().create();
        return (SwiftBlock2Input)gson.fromJson(json, SwiftBlock2Input.class);
    }

    @Override
    public String getMessageType() {
        return this.messageType;
    }

    @Override
    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public void setReceiver(BIC bic) {
        this.setReceiverAddress(new LogicalTerminalAddress(bic.getBic11()));
    }

    public void setReceiver(String receiver) {
        this.setReceiverAddress(new LogicalTerminalAddress(receiver));
    }

    public String getReceiverAddress() {
        return this.receiverAddress;
    }

    public void setReceiverAddress(String receiverAddress) {
        this.receiverAddress = receiverAddress;
    }

    public void setReceiverAddress(LogicalTerminalAddress logicalTerminal) {
        this.receiverAddress = logicalTerminal.getReceiverLogicalTerminalAddress();
    }

    public BIC getReceiverBIC() {
        return new BIC(this.receiverAddress);
    }

    @Override
    public String getMessagePriority() {
        return this.messagePriority;
    }

    @Override
    public void setMessagePriority(String messagePriority) {
        this.messagePriority = messagePriority;
    }

    public String getDeliveryMonitoring() {
        return this.deliveryMonitoring;
    }

    public void setDeliveryMonitoring(String deliveryMonitoring) {
        this.deliveryMonitoring = deliveryMonitoring;
    }

    public DeliveryMonitoring getDeliveryMonitoringType() {
        if (this.deliveryMonitoring != null) {
            try {
                return DeliveryMonitoring.valueOf("_" + this.deliveryMonitoring);
            }
            catch (Exception e) {
                String text = "Block2 deliveryMonitoring contains an invalid value [" + this.deliveryMonitoring + "]";
                log.warning(text);
                log.log(Level.FINEST, text, e);
            }
        }
        return null;
    }

    public String getObsolescencePeriod() {
        return this.obsolescencePeriod;
    }

    public void setObsolescencePeriod(String obsolescencePeriod) {
        this.obsolescencePeriod = obsolescencePeriod;
    }

    @Override
    public boolean isEmpty() {
        return this.messageType == null && this.receiverAddress == null && this.messagePriority == null && this.deliveryMonitoring == null && this.obsolescencePeriod == null;
    }

    @Override
    public String getValue() {
        if (this.isEmpty()) {
            return null;
        }
        StringBuilder v = new StringBuilder("I");
        if (this.messageType != null) {
            v.append(this.messageType);
        }
        if (this.receiverAddress != null) {
            v.append(this.receiverAddress);
        }
        if (this.messagePriority != null) {
            v.append(this.messagePriority);
        }
        if (this.deliveryMonitoring != null) {
            v.append(this.deliveryMonitoring);
        }
        if (this.obsolescencePeriod != null) {
            v.append(this.obsolescencePeriod);
        }
        return v.toString();
    }

    @Override
    public void setValue(String value) {
        this.setValue(value, false);
    }

    @Override
    public String getBlockValue() {
        return this.getValue();
    }

    @Override
    public void setBlockValue(String value) {
        this.setValue(value);
    }

    public void setValue(String value, boolean lenient) {
        if (lenient) {
            this.clean();
        } else {
            Objects.requireNonNull(value, "value must not be null");
        }
        if (value != null) {
            int slen = value.length();
            if (!lenient) {
                Objects.requireNonNull(value, "value must not be null");
                Validate.isTrue((slen >= 16 && slen <= 23 ? 1 : 0) != 0, (String)("expected a string value of 17 up to 23 chars and obtained a " + slen + " chars string: '" + value + "'"), (Object[])new Object[0]);
            }
            int offset = 0;
            if (value.startsWith("2:")) {
                offset = 2;
            }
            if (!lenient && (slen -= offset) != 16 && slen != 17 && slen != 18 && slen != 21) {
                throw new IllegalArgumentException("Value must match: I<mt><address>[<pri>[<monitoring>[<obsolescence>]]]");
            }
            int len = 3;
            this.setMessageType(this.getValuePart(value, ++offset, len));
            offset += len;
            len = 12;
            this.setReceiverAddress(this.getValuePart(value, offset, len));
            offset += len;
            len = 1;
            this.setMessagePriority(this.getValuePart(value, offset, len));
            offset += len;
            len = 1;
            this.setDeliveryMonitoring(this.getValuePart(value, offset, len));
            offset += len;
            if (lenient) {
                this.setObsolescencePeriod(this.getValuePart(value, offset));
            } else {
                len = 3;
                this.setObsolescencePeriod(this.getValuePart(value, offset, len));
            }
        }
    }

    @Override
    public void clean() {
        this.messagePriority = null;
        this.messageType = null;
        this.receiverAddress = null;
        this.deliveryMonitoring = null;
        this.obsolescencePeriod = null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SwiftBlock2Input that = (SwiftBlock2Input)o;
        return Objects.equals(this.receiverAddress, that.receiverAddress) && Objects.equals(this.deliveryMonitoring, that.deliveryMonitoring) && Objects.equals(this.obsolescencePeriod, that.obsolescencePeriod);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.receiverAddress, this.deliveryMonitoring, this.obsolescencePeriod);
    }

    public String field(SwiftBlock2InputField field) {
        switch (field) {
            case Direction: {
                return MessageDirection.Input.name();
            }
            case MessageType: {
                return this.getMessageType();
            }
            case MessagePriority: {
                return this.getMessagePriority();
            }
            case ReceiverAddress: {
                return this.getReceiverAddress();
            }
            case DeliveryMonitoring: {
                return this.getDeliveryMonitoring();
            }
            case ObsolescencePeriod: {
                return this.getObsolescencePeriod();
            }
        }
        return null;
    }

    public void setField(SwiftBlock2InputField field, String value) {
        switch (field) {
            case MessageType: {
                this.setMessageType(value);
                break;
            }
            case MessagePriority: {
                this.setMessagePriority(value);
                break;
            }
            case ReceiverAddress: {
                this.setReceiverAddress(value);
                break;
            }
            case DeliveryMonitoring: {
                this.setDeliveryMonitoring(value);
                break;
            }
            case ObsolescencePeriod: {
                this.setObsolescencePeriod(value);
                break;
            }
            default: {
                log.warning("don't know how to set " + field + " to block2");
            }
        }
    }

    public static enum DeliveryMonitoring {
        _1("Non-Delivery Warning"),
        _2("Delivery Notification"),
        _3("Non-Delivery Warning and Delivery Notification");

        private final String label;

        private DeliveryMonitoring(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

