/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client.config;

import com.sun.jersey.api.client.config.ClientConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DefaultClientConfig
implements ClientConfig {
    private final Set<Class<?>> providers = new LinkedHashSet();
    private final Set<Object> providerInstances = new LinkedHashSet<Object>();
    private final Map<String, Boolean> features = new HashMap<String, Boolean>();
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public DefaultClientConfig() {
    }

    public DefaultClientConfig(Class<?> ... cs) {
        Collections.addAll(this.providers, cs);
    }

    public DefaultClientConfig(Set<Class<?>> cs) {
        this.providers.addAll(cs);
    }

    @Override
    public Set<Class<?>> getClasses() {
        return this.providers;
    }

    @Override
    public Set<Object> getSingletons() {
        return this.providerInstances;
    }

    public Map<String, Boolean> getFeatures() {
        return this.features;
    }

    public boolean getFeature(String featureName) {
        Boolean v = this.features.get(featureName);
        return v != null ? v : false;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Object getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    @Override
    public boolean getPropertyAsFeature(String name) {
        Boolean v = (Boolean)this.getProperties().get(name);
        return v != null ? v : false;
    }
}

