/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.CompressCssFormatter;
import com.inet.lib.less.CssFormatter;
import com.inet.lib.less.LessException;
import com.inet.lib.less.LessParser;
import com.inet.lib.less.ReaderFactory;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Map;

public class Less {
    public static final String COMPRESS = "compress";
    public static final String REWRITE_URLS = "rewrite-urls";

    public static String compile(URL baseURL, String lessData, boolean compress) throws LessException {
        return Less.compile(baseURL, lessData, compress, new ReaderFactory());
    }

    public static String compile(URL baseURL, String lessData, boolean compress, ReaderFactory readerFactory) throws LessException {
        Map<String, String> params = Collections.singletonMap(COMPRESS, Boolean.toString(compress));
        return Less.compile(baseURL, lessData, params, readerFactory);
    }

    public static String compile(URL baseURL, String lessData, Map<String, String> options) throws LessException {
        return Less.compile(baseURL, lessData, options, new ReaderFactory());
    }

    public static String compile(URL baseURL, String lessData, Map<String, String> options, ReaderFactory readerFactory) throws LessException {
        try {
            if (options == null) {
                options = Collections.emptyMap();
            }
            LessParser parser = new LessParser();
            parser.parse(baseURL, new StringReader(lessData), readerFactory);
            boolean compress = Boolean.parseBoolean(options.get(COMPRESS));
            CssFormatter formatter = compress ? new CompressCssFormatter() : new CssFormatter();
            parser.parseLazy(formatter);
            StringBuilder builder = new StringBuilder();
            formatter.format(parser, baseURL, readerFactory, builder, options);
            return builder.toString();
        }
        catch (LessException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new LessException(ex);
        }
    }

    public static String compile(File lessFile, boolean compress) throws IOException {
        String lessData = new String(Files.readAllBytes(lessFile.toPath()), StandardCharsets.UTF_8);
        return Less.compile(lessFile.toURI().toURL(), lessData, compress, new ReaderFactory());
    }

    public static String compile(File lessFile, boolean compress, ReaderFactory readerFactory) throws IOException {
        String lessData = new String(Files.readAllBytes(lessFile.toPath()), StandardCharsets.UTF_8);
        return Less.compile(lessFile.toURI().toURL(), lessData, compress, readerFactory);
    }
}

