/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefAssignActionResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestAssignAttributeDefActionsRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcAssignAttributeDefActions {
    private String clientVersion;
    private WsAttributeDefLookup wsAttributeDefLookup;
    private Set<String> actions = new LinkedHashSet<String>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private Boolean assign;
    private Boolean replaceAllExisting;

    public GcAssignAttributeDefActions assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcAssignAttributeDefActions assignAttributeDefLookup(WsAttributeDefLookup wsAttributeDefLookup1) {
        this.wsAttributeDefLookup = wsAttributeDefLookup1;
        return this;
    }

    public GcAssignAttributeDefActions addAction(String action) {
        this.actions.add(action);
        return this;
    }

    public GcAssignAttributeDefActions addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcAssignAttributeDefActions addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcAssignAttributeDefActions assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    public GcAssignAttributeDefActions assign(Boolean isAssign) {
        this.assign = isAssign;
        return this;
    }

    public GcAssignAttributeDefActions assignReplaceAllExisting(Boolean replaceAllExisting1) {
        this.replaceAllExisting = replaceAllExisting1;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.actions) == 0) {
            throw new RuntimeException("actions are required: " + this);
        }
        if (this.wsAttributeDefLookup == null || GrouperClientUtils.isBlank(this.wsAttributeDefLookup.getName()) && GrouperClientUtils.isBlank(this.wsAttributeDefLookup.getUuid()) && GrouperClientUtils.isBlank(this.wsAttributeDefLookup.getIdIndex())) {
            throw new RuntimeException("AttributeDef is required: " + this);
        }
        if (this.assign == null) {
            throw new RuntimeException("Assign is required, true means you are assigning, false means you are removing a direct assignment");
        }
    }

    public WsAttributeDefAssignActionResults execute() {
        this.validate();
        WsAttributeDefAssignActionResults wsAttributeDefAssignActionResults = null;
        try {
            WsRestAssignAttributeDefActionsRequest assignAttributeDefActionRequest = new WsRestAssignAttributeDefActionsRequest();
            assignAttributeDefActionRequest.setActAsSubjectLookup(this.actAsSubject);
            assignAttributeDefActionRequest.setWsAttributeDefLookup(this.wsAttributeDefLookup);
            assignAttributeDefActionRequest.setActions(GrouperClientUtils.toArray(this.actions, String.class));
            if (this.assign != null) {
                assignAttributeDefActionRequest.setAssign(this.assign != false ? "T" : "F");
            }
            if (this.replaceAllExisting != null) {
                assignAttributeDefActionRequest.setReplaceAllExisting(this.replaceAllExisting != false ? "T" : "F");
            }
            if (this.params.size() > 0) {
                assignAttributeDefActionRequest.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsAttributeDefAssignActionResults = (WsAttributeDefAssignActionResults)grouperClientWs.executeService("attributeDefActions", assignAttributeDefActionRequest, "assignActionsToAttributeDef", this.clientVersion, false);
            String attributeDefNameSaveResultMessage = "";
            try {
                attributeDefNameSaveResultMessage = wsAttributeDefAssignActionResults.getResultMetadata().getResultMessage();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String resultMessage = wsAttributeDefAssignActionResults.getResultMetadata().getResultMessage() + "\n" + attributeDefNameSaveResultMessage;
            grouperClientWs.handleFailure(wsAttributeDefAssignActionResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsAttributeDefAssignActionResults;
    }
}

