/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GcTransactionType;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefDeleteResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestAttributeDefDeleteRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.List;

public class GcAttributeDefDelete {
    private List<WsAttributeDefLookup> attributeDefLookups = new ArrayList<WsAttributeDefLookup>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private GcTransactionType txType;
    private String clientVersion;

    public GcAttributeDefDelete addAttributeDefLookup(WsAttributeDefLookup wsAttributeDefLookup) {
        this.attributeDefLookups.add(wsAttributeDefLookup);
        return this;
    }

    public GcAttributeDefDelete addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcAttributeDefDelete addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcAttributeDefDelete assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.attributeDefLookups) == 0) {
            throw new RuntimeException("Need at least one attributeDefName to delete: " + this);
        }
    }

    public GcAttributeDefDelete assignTxType(GcTransactionType gcTransactionType) {
        this.txType = gcTransactionType;
        return this;
    }

    public GcAttributeDefDelete assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public WsAttributeDefDeleteResults execute() {
        this.validate();
        WsAttributeDefDeleteResults wsAttributeDefDeleteResults = null;
        try {
            WsRestAttributeDefDeleteRequest attributeDefDelete = new WsRestAttributeDefDeleteRequest();
            attributeDefDelete.setActAsSubjectLookup(this.actAsSubject);
            attributeDefDelete.setTxType(this.txType == null ? null : this.txType.name());
            attributeDefDelete.setWsAttributeDefLookups(GrouperClientUtils.toArray(this.attributeDefLookups, WsAttributeDefLookup.class));
            if (this.params.size() > 0) {
                attributeDefDelete.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsAttributeDefDeleteResults = (WsAttributeDefDeleteResults)grouperClientWs.executeService("attributeDefs", attributeDefDelete, "attributeDefDelete", this.clientVersion, false);
            String resultMessage = wsAttributeDefDeleteResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsAttributeDefDeleteResults, wsAttributeDefDeleteResults.getResults(), resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsAttributeDefDeleteResults;
    }
}

