/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GcTransactionType;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsExternalSubjectSaveResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsExternalSubjectToSave;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestExternalSubjectSaveRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.List;

public class GcExternalSubjectSave {
    private String clientVersion;
    private List<WsExternalSubjectToSave> externalSubjectsToSave = new ArrayList<WsExternalSubjectToSave>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private GcTransactionType txType;

    public GcExternalSubjectSave assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcExternalSubjectSave addExternalSubjectToSave(WsExternalSubjectToSave wsExternalSubjectToSave) {
        this.externalSubjectsToSave.add(wsExternalSubjectToSave);
        return this;
    }

    public GcExternalSubjectSave addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcExternalSubjectSave addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcExternalSubjectSave assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.externalSubjectsToSave) == 0) {
            throw new RuntimeException("External subject to save is required: " + this);
        }
    }

    public WsExternalSubjectSaveResults execute() {
        this.validate();
        WsExternalSubjectSaveResults wsExternalSubjectSaveResults = null;
        try {
            WsRestExternalSubjectSaveRequest externalSubjectSave = new WsRestExternalSubjectSaveRequest();
            externalSubjectSave.setActAsSubjectLookup(this.actAsSubject);
            externalSubjectSave.setTxType(this.txType == null ? null : this.txType.name());
            externalSubjectSave.setWsExternalSubjectToSaves(GrouperClientUtils.toArray(this.externalSubjectsToSave, WsExternalSubjectToSave.class));
            if (this.params.size() > 0) {
                externalSubjectSave.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsExternalSubjectSaveResults = (WsExternalSubjectSaveResults)grouperClientWs.executeService("externalSubjects", externalSubjectSave, "externalSubjectSave", this.clientVersion, false);
            String groupSaveResultMessage = "";
            try {
                groupSaveResultMessage = wsExternalSubjectSaveResults.getResults()[0].getResultMetadata().getResultMessage();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String resultMessage = wsExternalSubjectSaveResults.getResultMetadata().getResultMessage() + "\n" + groupSaveResultMessage;
            grouperClientWs.handleFailure(wsExternalSubjectSaveResults, wsExternalSubjectSaveResults.getResults(), resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsExternalSubjectSaveResults;
    }

    public GcExternalSubjectSave assignTxType(GcTransactionType gcTransactionType) {
        this.txType = gcTransactionType;
        return this;
    }

    public static void main(String[] args) {
    }
}

