/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.WsMemberFilter;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetMembersResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestGetMembersRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcGetMembers {
    private Integer pageSize;
    private Integer pageNumber;
    private String sortString;
    private Boolean ascending;
    private String clientVersion;
    private Set<String> groupNames = new LinkedHashSet<String>();
    private Set<String> groupUuids = new LinkedHashSet<String>();
    private Set<Long> groupIdIndexes = new LinkedHashSet<Long>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsMemberFilter memberFilter;
    private WsSubjectLookup actAsSubject;
    private String fieldName;
    private Boolean includeGroupDetail;
    private Boolean includeSubjectDetail;
    private Set<String> subjectAttributeNames = new LinkedHashSet<String>();
    private Set<String> sourceIds = null;
    private Timestamp pointInTimeFrom;
    private Timestamp pointInTimeTo;

    public static void main(String[] args) {
        new GcGetMembers().addGroupName("test:testGroup").execute();
    }

    public void assignPageSize(Integer pageSize1) {
        this.pageSize = pageSize1;
    }

    public void assignPageNumber(Integer pageNumber1) {
        this.pageNumber = pageNumber1;
    }

    public void assignSortString(String sortString1) {
        this.sortString = sortString1;
    }

    public void assignAscending(Boolean ascending1) {
        this.ascending = ascending1;
    }

    public GcGetMembers assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcGetMembers addGroupName(String theGroupName) {
        this.groupNames.add(theGroupName);
        return this;
    }

    public GcGetMembers addGroupIdIndex(Long theGroupIdIndex) {
        this.groupIdIndexes.add(theGroupIdIndex);
        return this;
    }

    public GcGetMembers addGroupUuid(String theGroupUuid) {
        this.groupUuids.add(theGroupUuid);
        return this;
    }

    public GcGetMembers addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcGetMembers addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcGetMembers assignMemberFilter(WsMemberFilter theMemberFilter) {
        this.memberFilter = theMemberFilter;
        return this;
    }

    public GcGetMembers assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.groupNames) == 0 && GrouperClientUtils.length(this.groupUuids) == 0 && GrouperClientUtils.length(this.groupIdIndexes) == 0) {
            throw new RuntimeException("Group name or uuid or id index is required: " + this);
        }
        if (this.pointInTimeFrom != null || this.pointInTimeTo != null) {
            if (this.includeGroupDetail != null && this.includeGroupDetail.booleanValue()) {
                throw new RuntimeException("Cannot specify includeGroupDetail for point in time queries.");
            }
            if (this.memberFilter != null && !this.memberFilter.equals((Object)WsMemberFilter.All)) {
                throw new RuntimeException("Cannot specify a member filter for point in time queries.");
            }
        }
    }

    public GcGetMembers assignFieldName(String theFieldName) {
        this.fieldName = theFieldName;
        return this;
    }

    public GcGetMembers addSourceId(String sourceId) {
        if (this.sourceIds == null) {
            this.sourceIds = new LinkedHashSet<String>();
        }
        this.sourceIds.add(sourceId);
        return this;
    }

    public GcGetMembers addSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeNames.add(subjectAttributeName);
        return this;
    }

    public GcGetMembers assignIncludeGroupDetail(Boolean theIncludeGroupDetail) {
        this.includeGroupDetail = theIncludeGroupDetail;
        return this;
    }

    public GcGetMembers assignIncludeSubjectDetail(Boolean theIncludeSubjectDetail) {
        this.includeSubjectDetail = theIncludeSubjectDetail;
        return this;
    }

    public GcGetMembers assignPointInTimeFrom(Timestamp pointInTimeFrom) {
        this.pointInTimeFrom = pointInTimeFrom;
        return this;
    }

    public GcGetMembers assignPointInTimeTo(Timestamp pointInTimeTo) {
        this.pointInTimeTo = pointInTimeTo;
        return this;
    }

    public WsGetMembersResults execute() {
        this.validate();
        WsGetMembersResults wsGetMembersResults = null;
        try {
            WsRestGetMembersRequest getMembers = new WsRestGetMembersRequest();
            getMembers.setActAsSubjectLookup(this.actAsSubject);
            getMembers.setFieldName(this.fieldName);
            getMembers.setMemberFilter(this.memberFilter == null ? null : this.memberFilter.name());
            ArrayList<WsGroupLookup> groupLookups = new ArrayList<WsGroupLookup>();
            for (String groupName : this.groupNames) {
                groupLookups.add(new WsGroupLookup(groupName, null));
            }
            for (String groupUuid : this.groupUuids) {
                groupLookups.add(new WsGroupLookup(null, groupUuid));
            }
            for (Long groupIdIndex : this.groupIdIndexes) {
                groupLookups.add(new WsGroupLookup(null, null, groupIdIndex.toString()));
            }
            getMembers.setWsGroupLookups(GrouperClientUtils.toArray(groupLookups, WsGroupLookup.class));
            if (this.includeGroupDetail != null) {
                getMembers.setIncludeGroupDetail(this.includeGroupDetail != false ? "T" : "F");
            }
            if (this.includeSubjectDetail != null) {
                getMembers.setIncludeSubjectDetail(this.includeSubjectDetail != false ? "T" : "F");
            }
            if (this.subjectAttributeNames.size() > 0) {
                getMembers.setSubjectAttributeNames(GrouperClientUtils.toArray(this.subjectAttributeNames, String.class));
            }
            if (this.params.size() > 0) {
                getMembers.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            if (GrouperClientUtils.length(this.sourceIds) > 0) {
                getMembers.setSourceIds(GrouperClientUtils.toArray(this.sourceIds, String.class));
            }
            if (this.ascending != null) {
                getMembers.setAscending(this.ascending != false ? "T" : "F");
            }
            getMembers.setSortString(this.sortString);
            if (this.pageNumber != null) {
                getMembers.setPageNumber(this.pageNumber.toString());
            }
            if (this.pageSize != null) {
                getMembers.setPageSize(this.pageSize.toString());
            }
            getMembers.setPointInTimeFrom(GrouperClientUtils.dateToString(this.pointInTimeFrom));
            getMembers.setPointInTimeTo(GrouperClientUtils.dateToString(this.pointInTimeTo));
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsGetMembersResults = (WsGetMembersResults)grouperClientWs.executeService("groups", getMembers, "getMembers", this.clientVersion, true);
            String resultMessage = wsGetMembersResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsGetMembersResults, wsGetMembersResults.getResults(), resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsGetMembersResults;
    }
}

