/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsMessage;
import edu.internet2.middleware.grouperClient.ws.beans.WsMessageResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestSendMessageRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.List;

public class GcMessageSend {
    private String queueType;
    private String queueOrTopicName;
    private String messageSystemName;
    private List<WsMessage> messages = new ArrayList<WsMessage>();
    private String routingKey;
    private Boolean autocreateObjects;
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private String clientVersion;

    public GcMessageSend assignRoutingKey(String theRoutingKey) {
        this.routingKey = theRoutingKey;
        return this;
    }

    public GcMessageSend assignAutocreateObjets(Boolean theAutocreateObjects) {
        this.autocreateObjects = theAutocreateObjects;
        return this;
    }

    public GcMessageSend assignQueueType(String theQueueOrTopic) {
        this.queueType = theQueueOrTopic;
        return this;
    }

    public GcMessageSend assignQueueOrTopicName(String theQueueOrTopicName) {
        this.queueOrTopicName = theQueueOrTopicName;
        return this;
    }

    public GcMessageSend assignMessageSystemName(String theMessageSystemName) {
        this.messageSystemName = theMessageSystemName;
        return this;
    }

    public GcMessageSend addMessage(WsMessage wsMessage) {
        this.messages.add(wsMessage);
        return this;
    }

    public GcMessageSend addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcMessageSend addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcMessageSend assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.messages) == 0) {
            throw new RuntimeException("Need at least one message to send: " + this);
        }
        if (GrouperClientUtils.isBlank(this.queueOrTopicName)) {
            throw new RuntimeException("Need queue or topic name where the message(s) needs to be sent " + this);
        }
        if (GrouperClientUtils.isBlank(this.queueType) || !GrouperClientUtils.equalsIgnoreCase("queue", this.queueType) && !GrouperClientUtils.equalsIgnoreCase("topic", this.queueType)) {
            throw new RuntimeException("Need type of destination. Valid values are queue and topic) " + this);
        }
    }

    public GcMessageSend assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public WsMessageResults execute() {
        this.validate();
        WsMessageResults wsMessageResults = null;
        try {
            WsRestSendMessageRequest messageSendRequest = new WsRestSendMessageRequest();
            messageSendRequest.setActAsSubjectLookup(this.actAsSubject);
            messageSendRequest.setQueueType(this.queueType);
            messageSendRequest.setQueueOrTopicName(this.queueOrTopicName);
            messageSendRequest.setMessageSystemName(this.messageSystemName);
            messageSendRequest.setMessages(GrouperClientUtils.toArray(this.messages, WsMessage.class));
            if (this.params.size() > 0) {
                messageSendRequest.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsMessageResults = (WsMessageResults)grouperClientWs.executeService("messaging", messageSendRequest, "send messages", this.clientVersion, false);
            String resultMessage = wsMessageResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsMessageResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsMessageResults;
    }
}

