/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.examples;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.XStream;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.annotations.XStreamOmitField;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.ConversionException;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.xml.DomDriver;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.mapper.MapperWrapper;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;

public class PersonXstreamExample {
    static Log log = GrouperClientUtils.retrieveLog(PersonXstreamExample.class);
    @XStreamOmitField
    private long millisStart = 500L;
    private String name;

    public static void main(String[] args) {
        PersonXstreamExample person = new PersonXstreamExample();
        person.setName("hey");
        XStream xStream = new XStream(new DomDriver()){

            @Override
            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new MapperWrapper(next){

                    @Override
                    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                        boolean definedInNotObject;
                        boolean bl = definedInNotObject = definedIn != Object.class;
                        if (definedInNotObject) {
                            return super.shouldSerializeMember(definedIn, fieldName);
                        }
                        log.info("Cant find field: " + fieldName);
                        return false;
                    }
                };
            }
        };
        xStream.autodetectAnnotations(true);
        xStream.alias("person", PersonXstreamExample.class);
        String xml = xStream.toXML(person);
        System.out.println(xml);
        PersonXstreamExample newPerson = (PersonXstreamExample)xStream.fromXML(xml);
        System.out.println(newPerson);
        try {
            newPerson = (PersonXstreamExample)xStream.fromXML("<person><name>hey</name><whatever>whatever</whatever></person>");
            System.out.println(newPerson);
        }
        catch (ConversionException ce) {
            ce.printStackTrace();
            throw new RuntimeException(ce);
        }
    }

    public String toString() {
        return "Person: " + this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name1) {
        this.name = name1;
    }
}

