/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.util;

import edu.internet2.middleware.grouperClient.util.ExpirableCache;
import edu.internet2.middleware.grouperClient.util.GrouperClientConfig;
import edu.internet2.middleware.grouperClient.util.GrouperClientLog;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.util.XmlIndenter;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.HttpMethodBase;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.CodeSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GrouperClientCommonUtils {
    private static ThreadLocal<Map<String, Map<String, String>>> propertiesThreadLocalOverrideMap;
    public static final String LOG_ERROR = "Error trying to make parent dirs for logger or logging first statement, check to make sure you have proper file permissions, and that your servlet container is giving your app rights to access the log directory (e.g. for tomcat set TOMCAT5_SECURITY=no), google it for more info";
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    private static final Map EMPTY_MAP;
    private static final String CACHE_SEPARATOR = "__";
    public static final String DATE_FORMAT = "yyyyMMdd";
    public static final String DATE_MINUTES_SECONDS_FORMAT = "yyyy/MM/dd HH:mm:ss";
    public static final String DATE_MINUTES_SECONDS_NO_SLASH_FORMAT = "yyyyMMdd HH:mm:ss";
    public static final String TIMESTAMP_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";
    public static final String TIMESTAMP_NO_SLASH_FORMAT = "yyyyMMdd HH:mm:ss.SSS";
    static final SimpleDateFormat dateFormat;
    static final SimpleDateFormat dateMinutesSecondsFormat;
    static final SimpleDateFormat dateMinutesSecondsNoSlashFormat;
    static final SimpleDateFormat timestampFormat;
    static final SimpleDateFormat timestampNoSlashFormat;
    private static ExpirableCache<String, Set<Field>> fieldSetCache;
    private static ExpirableCache<Class, Method[]> declaredMethodsCache;
    private static ExpirableCache<String, Set<Method>> getterSetCache;
    private static ExpirableCache<String, Set<Method>> setterSetCache;
    private static char[] lastId;
    private static Map<String, Properties> resourcePropertiesCache;
    private static final Object NO_PARAMS;
    private static final String errorStart = "Invalid timestamp, please use any of the formats: yyyyMMdd, yyyy/MM/dd HH:mm:ss.SSS, yyyy/MM/dd HH:mm:ss: ";
    public static final int NOT_FOUND = -999999999;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private static Log LOG;
    private static String hostname;
    public static final String[] EMPTY_STRING_ARRAY;
    private static String[] CAUSE_METHOD_NAMES;
    private static final Method THROWABLE_CAUSE_METHOD;
    public static final Object[] EMPTY_OBJECT_ARRAY;
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;
    private static final int PAD_LIMIT = 8192;
    private static final String[] PADDING;
    private static final String WS_DATE_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";
    private static final String WS_DATE_FORMAT2 = "yyyy/MM/dd_HH:mm:ss.SSS";
    private static Pattern datePattern_yyyy_mm_dd;
    private static Pattern datePattern_dd_mon_yyyy;
    private static Pattern datePattern_yyyy_mm_dd_hhmmss;
    private static Pattern datePattern_dd_mon_yyyy_hhmmss;
    private static Pattern datePattern_yyyy_mm_dd_hhmmss_SSS;
    private static Pattern datePattern_dd_mon_yyyy_hhmmss_SSS;
    private static ExecutorService executorService;
    private static Pattern fileLocationPattern;

    public static String argAfter(String[] args, String argBefore) {
        if (GrouperClientCommonUtils.length(args) <= 1) {
            return null;
        }
        int argBeforeIndex = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!GrouperClientCommonUtils.equals(args[i], argBefore)) continue;
            argBeforeIndex = i;
            break;
        }
        if (argBeforeIndex == -1) {
            throw new RuntimeException("Cant find arg before");
        }
        if (argBeforeIndex < args.length - 1) {
            return args[argBeforeIndex + 1];
        }
        return null;
    }

    public static void append(StringBuilder result, String separatorIfResultNotEmpty, String stringToAppend) {
        if (result.length() != 0) {
            result.append(separatorIfResultNotEmpty);
        }
        result.append(stringToAppend);
    }

    public static String byteCountToDisplaySize(long size) {
        String displaySize = size / 0x40000000L > 0L ? String.valueOf(size / 0x40000000L) + " GB" : (size / 0x100000L > 0L ? String.valueOf(size / 0x100000L) + " MB" : (size / 1024L > 0L ? String.valueOf(size / 1024L) + " KB" : String.valueOf(size) + " bytes"));
        return displaySize;
    }

    public static boolean hasOption(int options, int option) {
        return (options & option) > 0;
    }

    public static String fileCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static String suffixAfterChar(String input, char theChar) {
        if (input == null) {
            return null;
        }
        int lastIndex = input.lastIndexOf(theChar);
        if (lastIndex > -1) {
            input = input.substring(lastIndex + 1, input.length());
        }
        return input;
    }

    public static String oracleStandardNameFromJava(String javaName) {
        StringBuilder result = new StringBuilder();
        if (javaName == null || 0 == EMPTY.compareTo(javaName)) {
            return javaName;
        }
        javaName = GrouperClientCommonUtils.suffixAfterChar(javaName, '.');
        result.append(javaName.charAt(0));
        boolean previousCap = false;
        for (int i = 1; i < javaName.length(); ++i) {
            char currChar = javaName.charAt(i);
            if (!previousCap && currChar >= 'A' && currChar <= 'Z') {
                result.append("_");
            }
            result.append(currChar);
            previousCap = currChar >= 'A' && currChar <= 'Z';
        }
        return result.toString().toUpperCase();
    }

    public static <K, V> boolean mapEquals(Map<K, V> first, Map<K, V> second) {
        HashSet keysMismatch = new HashSet();
        GrouperClientCommonUtils.mapDifferences(first, second, keysMismatch, null);
        return keysMismatch.size() == 0;
    }

    public static <K, V> void mapDifferences(Map<K, V> first, Map<K, V> second, Set<K> differences, String prefix) {
        int secondSize;
        if (first == second) {
            return;
        }
        if (first == null) {
            first = EMPTY_MAP;
        }
        second = second == null ? EMPTY_MAP : new LinkedHashMap(second);
        int firstSize = first == null ? 0 : first.size();
        int n = secondSize = second == null ? 0 : second.size();
        if (firstSize == 0 && secondSize == 0) {
            return;
        }
        for (Object key : first.keySet()) {
            if (second.containsKey(key)) {
                Object firstValue = first.get(key);
                Object secondValue = second.get(key);
                second.remove(key);
                if (GrouperClientCommonUtils.equals(firstValue, secondValue)) continue;
            }
            differences.add(GrouperClientCommonUtils.isNotBlank(prefix) ? prefix + key : key);
        }
        for (Object key : second.keySet()) {
            differences.add(GrouperClientCommonUtils.isNotBlank(prefix) ? prefix + key : key);
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public static boolean injectInException(Throwable t, String message) {
        String throwableFieldName = "detailMessage";
        try {
            String currentValue = t.getMessage();
            currentValue = !GrouperClientCommonUtils.isBlank(currentValue) ? currentValue + ",\n" + message : message;
            GrouperClientCommonUtils.assignField(t, throwableFieldName, currentValue);
            return true;
        }
        catch (Throwable t2) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uniqueId() {
        Class<GrouperClientCommonUtils> clazz = GrouperClientCommonUtils.class;
        synchronized (GrouperClientCommonUtils.class) {
            lastId = GrouperClientCommonUtils.incrementStringInt(lastId);
            // ** MonitorExit[var0] (shouldn't be in output)
            return String.valueOf(lastId);
        }
    }

    public static File fileFromResourceName(String resourceName) {
        URL url = GrouperClientCommonUtils.computeUrl(resourceName, true);
        if (url == null) {
            return null;
        }
        try {
            String fileName = URLDecoder.decode(url.getFile(), "UTF-8");
            File configFile = new File(fileName);
            return configFile;
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public static URL computeUrl(String resourceName, boolean canBeNull) {
        ClassLoader cl = GrouperClientCommonUtils.classLoader();
        URL url = null;
        try {
            String newResourceName = resourceName.startsWith("/") ? resourceName.substring(1) : resourceName;
            url = cl.getResource(newResourceName);
        }
        catch (NullPointerException npe) {
            String error = "computeUrl() Could not find resource file: " + resourceName;
            throw new RuntimeException(error, npe);
        }
        if (!canBeNull && url == null) {
            throw new RuntimeException("Cant find resource: " + resourceName);
        }
        return url;
    }

    public static ClassLoader classLoader() {
        return GrouperClientCommonUtils.class.getClassLoader();
    }

    public static <T> T[] nonNull(T[] array, Class<?> theClass) {
        return array == null ? (Object[])Array.newInstance(theClass, 0) : array;
    }

    public static String prefixOrSuffix(String startString, String separator, boolean isPrefix) {
        String prefixOrSuffix = null;
        if (startString == null) {
            return startString;
        }
        int separatorIndex = startString.indexOf(separator);
        if (separatorIndex == -1) {
            return startString;
        }
        int separatorLength = separator.length();
        prefixOrSuffix = isPrefix ? startString.substring(0, separatorIndex) : startString.substring(separatorIndex + separatorLength, startString.length());
        return prefixOrSuffix;
    }

    public static String indent(String string, boolean failIfTypeNotFound) {
        if (string == null) {
            return null;
        }
        if ((string = GrouperClientCommonUtils.trim(string)).startsWith("<")) {
            return new XmlIndenter(string).result();
        }
        if (!failIfTypeNotFound) {
            return string;
        }
        throw new RuntimeException("Cant find type of string: " + string);
    }

    public static String extensionFromName(String name) {
        if (GrouperClientCommonUtils.isBlank(name)) {
            return name;
        }
        int lastColonIndex = name.lastIndexOf(58);
        if (lastColonIndex == -1) {
            return name;
        }
        String extension = name.substring(lastColonIndex + 1);
        return extension;
    }

    public static Class forName(String origClassName) {
        try {
            return Class.forName(origClassName);
        }
        catch (Throwable t) {
            throw new RuntimeException("Problem loading class: " + origClassName, t);
        }
    }

    public static <T> T newInstance(Class<T> theClass) {
        try {
            return theClass.newInstance();
        }
        catch (Throwable e) {
            if (theClass != null && Modifier.isAbstract(theClass.getModifiers())) {
                throw new RuntimeException("Problem with class: " + theClass + ", maybe because it is abstract!", e);
            }
            throw new RuntimeException("Problem with class: " + theClass, e);
        }
    }

    public static <T> T newInstance(Class<T> theClass, boolean allowPrivateConstructor) {
        if (!allowPrivateConstructor) {
            return GrouperClientCommonUtils.newInstance(theClass);
        }
        try {
            Constructor<?>[] constructorArray;
            for (Constructor<?> constructor : constructorArray = theClass.getDeclaredConstructors()) {
                if (constructor.getGenericParameterTypes().length != 0) continue;
                if (allowPrivateConstructor) {
                    constructor.setAccessible(true);
                }
                return (T)constructor.newInstance(new Object[0]);
            }
            throw new RuntimeException("Why cant we find a constructor for class: " + theClass);
        }
        catch (Throwable e) {
            if (theClass != null && Modifier.isAbstract(theClass.getModifiers())) {
                throw new RuntimeException("Problem with class: " + theClass + ", maybe because it is abstract!", e);
            }
            throw new RuntimeException("Problem with class: " + theClass, e);
        }
    }

    public static String parentStemNameFromName(String name) {
        int lastColonIndex = name.lastIndexOf(58);
        if (lastColonIndex == -1) {
            return null;
        }
        String parentStemName = name.substring(0, lastColonIndex);
        return parentStemName;
    }

    public static String defaultIfBlank(String string, String defaultStringIfBlank) {
        return GrouperClientCommonUtils.isBlank(string) ? defaultStringIfBlank : string;
    }

    public static <T> T defaultIfNull(T theValue, T defaultIfTheValueIsNull) {
        return theValue != null ? theValue : defaultIfTheValueIsNull;
    }

    public static <T> void addIfNotThere(Collection<T> list, Collection<T> listToAdd) {
        if (listToAdd == null) {
            return;
        }
        for (T t : listToAdd) {
            if (list.contains(t)) continue;
            list.add(t);
        }
    }

    private static void toStringForLogHelper(Object object, int maxChars, StringBuilder result) {
        try {
            if (object == null) {
                result.append("null");
            } else if (object.getClass().isArray()) {
                int length = Array.getLength(object);
                if (length == 0) {
                    result.append("Empty array");
                } else {
                    result.append("Array size: ").append(length).append(": ");
                    for (int i = 0; i < length; ++i) {
                        result.append("[").append(i).append("]: ").append(Array.get(object, i)).append("\n");
                        if (maxChars == -1 || result.length() <= maxChars) continue;
                        return;
                    }
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                int collectionSize = collection.size();
                if (collectionSize == 0) {
                    result.append("Empty ").append(object.getClass().getSimpleName());
                } else {
                    result.append(object.getClass().getSimpleName()).append(" size: ").append(collectionSize).append(": ");
                    int i = 0;
                    for (Object collectionObject : collection) {
                        result.append("[").append(i).append("]: ").append(collectionObject).append("\n");
                        if (maxChars != -1 && result.length() > maxChars) {
                            return;
                        }
                        ++i;
                    }
                }
            } else {
                result.append(object.toString());
            }
        }
        catch (Exception e) {
            result.append("<<exception>> ").append(object.getClass()).append(":\n").append(GrouperClientCommonUtils.getFullStackTrace(e)).append("\n");
        }
    }

    public static String setToString(Set set) {
        if (set == null) {
            return "null";
        }
        if (set.size() == 0) {
            return "empty";
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Object object : set) {
            if (!first) {
                result.append(", ");
            }
            first = false;
            result.append(object);
        }
        return result.toString();
    }

    @Deprecated
    public static String MapToString(Map map) {
        return GrouperClientCommonUtils.mapToString(map);
    }

    public static String mapToString(Map map) {
        if (map == null) {
            return "null";
        }
        if (map.size() == 0) {
            return "empty";
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Object object : map.keySet()) {
            if (!first) {
                result.append(", ");
            }
            first = false;
            result.append(object).append(": ").append(map.get(object));
        }
        return result.toString();
    }

    public static String toStringForLog(Object object) {
        StringBuilder result = new StringBuilder();
        GrouperClientCommonUtils.toStringForLogHelper(object, -1, result);
        return result.toString();
    }

    public static String toStringForLog(Object object, int maxChars) {
        StringBuilder result = new StringBuilder();
        GrouperClientCommonUtils.toStringForLogHelper(object, -1, result);
        String resultString = result.toString();
        if (maxChars != -1) {
            return GrouperClientCommonUtils.abbreviate(resultString, maxChars);
        }
        return resultString;
    }

    public static int batchNumberOfBatches(int count, int batchSize) {
        int batches = 1 + (count - 1) / batchSize;
        return batches;
    }

    public static int batchNumberOfBatches(Collection<?> collection, int batchSize) {
        int arrraySize = GrouperClientCommonUtils.length(collection);
        return GrouperClientCommonUtils.batchNumberOfBatches(arrraySize, batchSize);
    }

    public static <T> List<T> batchList(Collection<T> collection, int batchSize, int batchIndex) {
        int numberOfBatches = GrouperClientCommonUtils.batchNumberOfBatches(collection, batchSize);
        int arraySize = GrouperClientCommonUtils.length(collection);
        if (arraySize == 0) {
            return new ArrayList();
        }
        ArrayList<T> theBatchObjects = new ArrayList<T>();
        if (batchIndex == numberOfBatches - 1) {
            int collectionIndex = 0;
            for (T t : collection) {
                if (collectionIndex++ < batchIndex * batchSize) continue;
                theBatchObjects.add(t);
            }
        } else {
            int collectionIndex = 0;
            for (T t : collection) {
                if (collectionIndex < batchIndex * batchSize) {
                    ++collectionIndex;
                    continue;
                }
                if (collectionIndex < (batchIndex + 1) * batchSize) {
                    theBatchObjects.add(t);
                    ++collectionIndex;
                    continue;
                }
                break;
            }
        }
        return theBatchObjects;
    }

    public static String[] splitTrim(String input, String separator) {
        return GrouperClientCommonUtils.splitTrim(input, separator, true);
    }

    public static List<String> splitTrimToList(String input, String separator) {
        if (GrouperClientCommonUtils.isBlank(input)) {
            return null;
        }
        String[] array = GrouperClientCommonUtils.splitTrim(input, separator);
        return GrouperClientCommonUtils.toList(array);
    }

    public static Set<String> splitTrimToSet(String input, String separator) {
        if (GrouperClientCommonUtils.isBlank(input)) {
            return null;
        }
        String[] array = GrouperClientCommonUtils.splitTrim(input, separator);
        return GrouperClientCommonUtils.toSet(array);
    }

    public static String[] splitTrim(String input, String separator, boolean treatAdjacentSeparatorsAsOne) {
        if (GrouperClientCommonUtils.isBlank(input)) {
            return null;
        }
        String[] items = treatAdjacentSeparatorsAsOne ? GrouperClientCommonUtils.split(input, separator) : GrouperClientCommonUtils.splitPreserveAllTokens(input, separator);
        for (int i = 0; items != null && i < items.length; ++i) {
            items[i] = GrouperClientCommonUtils.trim(items[i]);
        }
        return items;
    }

    public static String escapeUrlEncode(String string) {
        String result = null;
        try {
            result = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 not supported", ex);
        }
        return result;
    }

    public static String escapeUrlDecode(String string) {
        String result = null;
        try {
            result = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 not supported", ex);
        }
        return result;
    }

    public static <T> List<T> nonNull(List<T> list) {
        return list == null ? new ArrayList() : list;
    }

    public static <T> Collection<T> nonNull(Collection<T> list) {
        return list == null ? new ArrayList() : list;
    }

    public static <T> Set<T> nonNull(Set<T> set) {
        return set == null ? new HashSet() : set;
    }

    public static <K, V> Map<K, V> nonNull(Map<K, V> map) {
        return map == null ? new HashMap() : map;
    }

    public static <T> List<T> toListFromCollection(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        if (collection instanceof List) {
            return (List)collection;
        }
        return new ArrayList<T>(collection);
    }

    public static <T> List<T> toList(T ... objects) {
        if (objects == null) {
            return null;
        }
        if (objects.length == 1 && objects[0] instanceof List) {
            return (List)objects[0];
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T object : objects) {
            result.add(object);
        }
        return result;
    }

    public static List<Class<?>> toListClasses(Class<?> ... classes) {
        return GrouperClientCommonUtils.toList(classes);
    }

    public static <T> Set<T> toSet(T ... objects) {
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        for (T object : objects) {
            result.add(object);
        }
        return result;
    }

    public static void assertion(boolean isTrue, String reason) {
        if (!isTrue) {
            throw new RuntimeException(reason);
        }
    }

    private static ExpirableCache<String, Set<Field>> fieldSetCache() {
        if (fieldSetCache == null) {
            fieldSetCache = new ExpirableCache(1440);
        }
        return fieldSetCache;
    }

    private static ExpirableCache<Class, Method[]> declaredMethodsCache() {
        if (declaredMethodsCache == null) {
            declaredMethodsCache = new ExpirableCache(1440);
        }
        return declaredMethodsCache;
    }

    private static ExpirableCache<String, Set<Method>> getterSetCache() {
        if (getterSetCache == null) {
            getterSetCache = new ExpirableCache(1440);
        }
        return getterSetCache;
    }

    private static ExpirableCache<String, Set<Method>> setterSetCache() {
        if (setterSetCache == null) {
            setterSetCache = new ExpirableCache(1440);
        }
        return setterSetCache;
    }

    public static void assignField(Class theClass, Object invokeOn, String fieldName, Object dataToAssign, boolean callOnSupers, boolean overrideSecurity, boolean typeCast, Class<? extends Annotation> annotationWithValueOverride) {
        if (theClass == null && invokeOn != null) {
            theClass = invokeOn.getClass();
        }
        Field field = GrouperClientCommonUtils.field(theClass, fieldName, callOnSupers, true);
        GrouperClientCommonUtils.assignField(field, invokeOn, dataToAssign, overrideSecurity, typeCast, annotationWithValueOverride);
    }

    public static void assignField(Class theClass, Object invokeOn, String fieldName, Object dataToAssign, Class<? extends Annotation> annotationWithValueOverride) {
        GrouperClientCommonUtils.assignField(theClass, invokeOn, fieldName, dataToAssign, true, true, true, annotationWithValueOverride);
    }

    public static void assignField(Field field, Object invokeOn, Object dataToAssign, boolean overrideSecurity, boolean typeCast) {
        try {
            Class<?> fieldType = field.getType();
            if (typeCast) {
                dataToAssign = GrouperClientCommonUtils.typeCast(dataToAssign, fieldType, true, true);
            }
            if (overrideSecurity) {
                field.setAccessible(true);
            }
            field.set(invokeOn, dataToAssign);
        }
        catch (Exception e) {
            throw new RuntimeException("Cant assign reflection field: " + (field == null ? null : field.getName()) + ", on: " + GrouperClientCommonUtils.className(invokeOn) + ", with args: " + GrouperClientCommonUtils.classNameCollection(dataToAssign), e);
        }
    }

    public static Iterator iterator(Object collection) {
        if (collection == null) {
            return null;
        }
        if (collection instanceof Collection && !(collection instanceof ArrayList)) {
            return ((Collection)collection).iterator();
        }
        return null;
    }

    public static int length(Object arrayOrCollection) {
        if (arrayOrCollection == null) {
            return 0;
        }
        if (arrayOrCollection.getClass().isArray()) {
            return Array.getLength(arrayOrCollection);
        }
        if (arrayOrCollection instanceof Collection) {
            return ((Collection)arrayOrCollection).size();
        }
        if (arrayOrCollection instanceof Map) {
            return ((Map)arrayOrCollection).size();
        }
        return 1;
    }

    public static Object next(Object arrayOrCollection, Iterator iterator, int index) {
        if (arrayOrCollection.getClass().isArray()) {
            return Array.get(arrayOrCollection, index);
        }
        if (arrayOrCollection instanceof ArrayList) {
            return ((ArrayList)arrayOrCollection).get(index);
        }
        if (arrayOrCollection instanceof Collection) {
            return iterator.next();
        }
        if (0 == index) {
            return arrayOrCollection;
        }
        throw new RuntimeException("Invalid class type: " + arrayOrCollection.getClass().getName());
    }

    public static Object remove(Object arrayOrCollection, int index) {
        return GrouperClientCommonUtils.remove(arrayOrCollection, null, index);
    }

    public static Object remove(Object arrayOrCollection, Iterator iterator, int index) {
        if (iterator != null) {
            iterator.remove();
            return arrayOrCollection;
        }
        if (arrayOrCollection.getClass().isArray()) {
            int newLength = Array.getLength(arrayOrCollection) - 1;
            Object newArray = Array.newInstance(arrayOrCollection.getClass().getComponentType(), newLength);
            if (newLength == 0) {
                return newArray;
            }
            if (index > 0) {
                System.arraycopy(arrayOrCollection, 0, newArray, 0, index);
            }
            if (index < newLength) {
                System.arraycopy(arrayOrCollection, index + 1, newArray, index, newLength - index);
            }
            return newArray;
        }
        if (arrayOrCollection instanceof List) {
            ((List)arrayOrCollection).remove(index);
            return arrayOrCollection;
        }
        if (arrayOrCollection instanceof Collection) {
            ((Collection)arrayOrCollection).remove(GrouperClientCommonUtils.get(arrayOrCollection, index));
            return arrayOrCollection;
        }
        throw new RuntimeException("Invalid class type: " + arrayOrCollection.getClass().getName());
    }

    public static String classesString(Object object) {
        StringBuilder result = new StringBuilder();
        if (object.getClass().isArray()) {
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                result.append(((Class)object).getSimpleName());
                if (i >= length - 1) continue;
                result.append(", ");
            }
            return result.toString();
        }
        throw new RuntimeException("Not implemented: " + GrouperClientCommonUtils.className(object));
    }

    public static String classNameCollection(Object object) {
        if (object == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        Iterator iterator = GrouperClientCommonUtils.iterator(object);
        int length = GrouperClientCommonUtils.length(object);
        for (int i = 0; i < length && i < 20; ++i) {
            result.append(GrouperClientCommonUtils.className(GrouperClientCommonUtils.next(object, iterator, i)));
            if (i == length - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public static String className(Object object) {
        return object == null ? null : object.getClass().getName();
    }

    public static void assignField(Field field, Object invokeOn, Object dataToAssign, boolean overrideSecurity, boolean typeCast, Class<? extends Annotation> annotationWithValueOverride) {
        Annotation annotation;
        if (annotationWithValueOverride != null && (annotation = field.getAnnotation(annotationWithValueOverride)) != null) {
            throw new RuntimeException("Not supported");
        }
        GrouperClientCommonUtils.assignField(field, invokeOn, dataToAssign, overrideSecurity, typeCast);
    }

    public static void assignField(Object invokeOn, String fieldName, Object dataToAssign) {
        GrouperClientCommonUtils.assignField(null, invokeOn, fieldName, dataToAssign, true, true, true, null);
    }

    public static Field field(Class theClass, String fieldName, boolean callOnSupers, boolean throwExceptionIfNotFound) {
        try {
            Field field = theClass.getDeclaredField(fieldName);
            return field;
        }
        catch (NoSuchFieldException e) {
            if (callOnSupers && !theClass.equals(Object.class)) {
                return GrouperClientCommonUtils.field(theClass.getSuperclass(), fieldName, callOnSupers, throwExceptionIfNotFound);
            }
            if (throwExceptionIfNotFound) {
                throw new RuntimeException("Cant find field: " + fieldName + ", in: " + theClass + ", callOnSupers: " + callOnSupers);
            }
            return null;
        }
    }

    public static Set<String> fieldNames(Class theClass, Class fieldType, boolean includeStaticFields) {
        return GrouperClientCommonUtils.fieldNamesHelper(theClass, theClass, fieldType, true, true, includeStaticFields, null, true);
    }

    public static Set<String> fieldNames(Class theClass, Class superclassToStopAt, Class<?> fieldType, boolean includeSuperclassToStopAt, boolean includeStaticFields, boolean includeFinalFields) {
        return GrouperClientCommonUtils.fieldNamesHelper(theClass, superclassToStopAt, fieldType, includeSuperclassToStopAt, includeStaticFields, includeFinalFields, null, true);
    }

    public static Set<String> fieldNames(Class theClass, Class superclassToStopAt, Class<?> fieldType, boolean includeSuperclassToStopAt, boolean includeStaticFields, boolean includeFinalFields, Class<? extends Annotation> markerAnnotationToIngore) {
        return GrouperClientCommonUtils.fieldNamesHelper(theClass, superclassToStopAt, fieldType, includeSuperclassToStopAt, includeStaticFields, includeFinalFields, markerAnnotationToIngore, false);
    }

    public static Set<String> fieldNames(Class theClass, Class superclassToStopAt, Class<? extends Annotation> markerAnnotationToIngore) {
        return GrouperClientCommonUtils.fieldNamesHelper(theClass, superclassToStopAt, null, true, false, false, markerAnnotationToIngore, false);
    }

    static Set<String> fieldNamesHelper(Class theClass, Class superclassToStopAt, Class<?> fieldType, boolean includeSuperclassToStopAt, boolean includeStaticFields, boolean includeFinalFields, Class<? extends Annotation> markerAnnotation, boolean includeAnnotation) {
        Set<Field> fieldSet = GrouperClientCommonUtils.fieldsHelper(theClass, superclassToStopAt, fieldType, includeSuperclassToStopAt, includeStaticFields, includeFinalFields, markerAnnotation, includeAnnotation);
        LinkedHashSet<String> fieldNameSet = new LinkedHashSet<String>();
        for (Field field : fieldSet) {
            fieldNameSet.add(field.getName());
        }
        return fieldNameSet;
    }

    public static Set<Field> fields(Class theClass, Class superclassToStopAt, Class fieldType, boolean includeSuperclassToStopAt, boolean includeStaticFields, boolean includeFinalFields, Class<? extends Annotation> markerAnnotation, boolean includeAnnotation) {
        return GrouperClientCommonUtils.fieldsHelper(theClass, superclassToStopAt, fieldType, includeSuperclassToStopAt, includeStaticFields, includeFinalFields, markerAnnotation, includeAnnotation);
    }

    public static Set<Field> fields(Class theClass, Class superclassToStopAt, Class<? extends Annotation> markerAnnotation, boolean includeAnnotation) {
        return GrouperClientCommonUtils.fieldsHelper(theClass, superclassToStopAt, null, true, false, false, markerAnnotation, includeAnnotation);
    }

    static Set<Field> fieldsHelper(Class theClass, Class superclassToStopAt, Class<?> fieldType, boolean includeSuperclassToStopAt, boolean includeStaticFields, boolean includeFinalFields, Class<? extends Annotation> markerAnnotation, boolean includeAnnotation) {
        Set<Field> fieldNameSet = null;
        String cacheKey = theClass + CACHE_SEPARATOR + superclassToStopAt + CACHE_SEPARATOR + fieldType + CACHE_SEPARATOR + includeSuperclassToStopAt + CACHE_SEPARATOR + includeStaticFields + CACHE_SEPARATOR + includeFinalFields + CACHE_SEPARATOR + markerAnnotation + CACHE_SEPARATOR + includeAnnotation;
        fieldNameSet = GrouperClientCommonUtils.fieldSetCache().get(cacheKey);
        if (fieldNameSet != null) {
            return fieldNameSet;
        }
        fieldNameSet = new LinkedHashSet<Field>();
        GrouperClientCommonUtils.fieldsHelper(theClass, superclassToStopAt, fieldType, includeSuperclassToStopAt, includeStaticFields, includeFinalFields, markerAnnotation, fieldNameSet, includeAnnotation);
        GrouperClientCommonUtils.fieldSetCache().put(cacheKey, fieldNameSet);
        return fieldNameSet;
    }

    public static Set<String> compareObjectFields(Object first, Object second, Set<String> fieldsToCompare, String mapPrefix) {
        LinkedHashSet<String> differentFields = new LinkedHashSet<String>();
        if (first == second) {
            return differentFields;
        }
        if (first == null || second == null) {
            differentFields.addAll(fieldsToCompare);
        }
        for (String fieldName : fieldsToCompare) {
            try {
                Object secondValue;
                Object firstValue = GrouperClientCommonUtils.fieldValue(first, fieldName);
                if (firstValue == (secondValue = GrouperClientCommonUtils.fieldValue(second, fieldName))) continue;
                if (firstValue instanceof Map || secondValue instanceof Map) {
                    GrouperClientCommonUtils.mapDifferences((Map)firstValue, (Map)secondValue, differentFields, mapPrefix);
                    continue;
                }
                if (firstValue instanceof String || secondValue instanceof String) {
                    if (GrouperClientCommonUtils.equals(GrouperClientCommonUtils.defaultString((String)firstValue), GrouperClientCommonUtils.defaultString((String)secondValue))) continue;
                    differentFields.add(fieldName);
                    continue;
                }
                if (firstValue == null || secondValue == null) {
                    differentFields.add(fieldName);
                    continue;
                }
                if (firstValue.equals(secondValue)) continue;
                differentFields.add(fieldName);
            }
            catch (RuntimeException re) {
                throw new RuntimeException("Problem comparing field " + fieldName + " on objects: " + GrouperClientCommonUtils.className(first) + ", " + GrouperClientCommonUtils.className(second));
            }
        }
        return differentFields;
    }

    public static <T> T clone(T object, Set<String> fieldsToClone) {
        Object result = GrouperClientCommonUtils.newInstance(object.getClass());
        GrouperClientCommonUtils.cloneFields(object, result, fieldsToClone);
        return (T)result;
    }

    public static <T> void cloneFields(T object, T result, Set<String> fieldsToClone) {
        if (object == result) {
            return;
        }
        if (object == null || result == null) {
            throw new RuntimeException("Cant copy from or to null: " + GrouperClientCommonUtils.className(object) + ", " + GrouperClientCommonUtils.className(result));
        }
        Class<?> fieldValueClass = null;
        for (String fieldName : GrouperClientCommonUtils.nonNull(fieldsToClone)) {
            try {
                Object fieldValue = GrouperClientCommonUtils.fieldValue(object, fieldName);
                fieldValueClass = fieldValue == null ? null : fieldValue.getClass();
                Object fieldValueToAssign = GrouperClientCommonUtils.cloneValue(fieldValue);
                GrouperClientCommonUtils.assignField(result, fieldName, fieldValueToAssign);
            }
            catch (RuntimeException re) {
                throw new RuntimeException("Problem cloning field: " + object.getClass() + ", " + fieldName + ", " + fieldValueClass, re);
            }
        }
    }

    public static <T> T cloneValue(T value) {
        Object clonedValue = value;
        if (!(value == null || value instanceof String || value.getClass().isPrimitive() || value instanceof Number || value instanceof Boolean || value instanceof Date)) {
            if (value instanceof Map) {
                clonedValue = new LinkedHashMap();
                Map mapValue = (Map)value;
                Map clonedMapValue = (Map)clonedValue;
                for (Object key : mapValue.keySet()) {
                    clonedMapValue.put(GrouperClientCommonUtils.cloneValue(key), GrouperClientCommonUtils.cloneValue(mapValue.get(key)));
                }
            } else if (value instanceof Set) {
                clonedValue = new LinkedHashSet();
                Set setValue = (Set)value;
                Set clonedSetValue = (Set)clonedValue;
                for (Object each : setValue) {
                    clonedSetValue.add(GrouperClientCommonUtils.cloneValue(each));
                }
            } else if (value instanceof List) {
                clonedValue = new ArrayList();
                List listValue = (List)value;
                List clonedListValue = (List)clonedValue;
                for (Object each : listValue) {
                    clonedListValue.add(GrouperClientCommonUtils.cloneValue(each));
                }
            } else if (value.getClass().isArray()) {
                clonedValue = Array.newInstance(value.getClass().getComponentType(), Array.getLength(value));
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Array.set(clonedValue, i, GrouperClientCommonUtils.cloneValue(Array.get(value, i)));
                }
            } else {
                throw new RuntimeException("Unexpected class in clone method: " + value.getClass());
            }
        }
        return clonedValue;
    }

    public static Set<String> methodNames(Class<?> theClass, Class<?> superclassToStopAt, boolean includeSuperclassToStopAt, boolean includeStaticMethods) {
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        GrouperClientCommonUtils.methodsHelper(theClass, superclassToStopAt, includeSuperclassToStopAt, includeStaticMethods, null, false, methods);
        HashSet<String> methodNames = new HashSet<String>();
        for (Method method : methods) {
            methodNames.add(method.getName());
        }
        return methodNames;
    }

    public static void methodsHelper(Class<?> theClass, Class<?> superclassToStopAt, boolean includeSuperclassToStopAt, boolean includeStaticMethods, Class<? extends Annotation> markerAnnotation, boolean includeAnnotation, Set<Method> methodSet) {
        Method[] methods = theClass.getDeclaredMethods();
        if (GrouperClientCommonUtils.length(methods) != 0) {
            for (Method method : methods) {
                if (!includeStaticMethods && Modifier.isStatic(method.getModifiers()) || markerAnnotation != null && includeAnnotation != method.isAnnotationPresent(markerAnnotation)) continue;
                methodSet.add(method);
            }
        }
        if (theClass.equals(superclassToStopAt) || theClass.equals(Object.class)) {
            return;
        }
        Class<?> superclass = theClass.getSuperclass();
        if (!includeSuperclassToStopAt && superclass.equals(superclassToStopAt)) {
            return;
        }
        GrouperClientCommonUtils.methodsHelper(superclass, superclassToStopAt, includeSuperclassToStopAt, includeStaticMethods, markerAnnotation, includeAnnotation, methodSet);
    }

    public static Method method(Class<?> theClass, String methodName, Object paramTypesOrArrayOrList, Class<?> superclassToStopAt, boolean includeSuperclassToStopAt, boolean isStaticOrInstance, Class<? extends Annotation> markerAnnotation, boolean includeAnnotation) {
        Class[] paramTypesArray = (Class[])GrouperClientCommonUtils.toArray(paramTypesOrArrayOrList);
        Method method = null;
        try {
            method = theClass.getDeclaredMethod(methodName, paramTypesArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception e) {
            throw new RuntimeException("Problem retrieving method: " + theClass.getSimpleName() + ", " + methodName, e);
        }
        if (method != null) {
            if (!isStaticOrInstance && Modifier.isStatic(method.getModifiers())) {
                return null;
            }
            if (markerAnnotation == null || includeAnnotation == method.isAnnotationPresent(markerAnnotation)) {
                return method;
            }
        }
        if (theClass.equals(superclassToStopAt) || theClass.equals(Object.class)) {
            return null;
        }
        Class<?> superclass = theClass.getSuperclass();
        if (!includeSuperclassToStopAt && superclass.equals(superclassToStopAt)) {
            return null;
        }
        return GrouperClientCommonUtils.method(superclass, methodName, paramTypesArray, superclassToStopAt, includeSuperclassToStopAt, isStaticOrInstance, markerAnnotation, includeAnnotation);
    }

    private static void fieldsHelper(Class theClass, Class superclassToStopAt, Class<?> fieldType, boolean includeSuperclassToStopAt, boolean includeStaticFields, boolean includeFinalFields, Class<? extends Annotation> markerAnnotation, Set<Field> fieldSet, boolean includeAnnotation) {
        Field[] fields = theClass.getDeclaredFields();
        if (GrouperClientCommonUtils.length(fields) != 0) {
            for (Field field : fields) {
                if (fieldType != null && !fieldType.isAssignableFrom(field.getType()) || !includeStaticFields && Modifier.isStatic(field.getModifiers()) || !includeFinalFields && Modifier.isFinal(field.getModifiers()) || markerAnnotation != null && includeAnnotation != field.isAnnotationPresent(markerAnnotation)) continue;
                fieldSet.add(field);
            }
        }
        if (theClass.equals(superclassToStopAt) || theClass.equals(Object.class)) {
            return;
        }
        Class superclass = theClass.getSuperclass();
        if (!includeSuperclassToStopAt && superclass.equals(superclassToStopAt)) {
            return;
        }
        GrouperClientCommonUtils.fieldsHelper(superclass, superclassToStopAt, fieldType, includeSuperclassToStopAt, includeStaticFields, includeFinalFields, markerAnnotation, fieldSet, includeAnnotation);
    }

    public static Object fieldValue(Class theClass, Object invokeOn, String fieldName, boolean callOnSupers, boolean overrideSecurity) {
        Field field = null;
        try {
            if (theClass == null) {
                theClass = invokeOn.getClass();
            }
            field = GrouperClientCommonUtils.field(theClass, fieldName, callOnSupers, true);
            return GrouperClientCommonUtils.fieldValue(field, invokeOn, overrideSecurity);
        }
        catch (Exception e) {
            throw new RuntimeException("Cant execute reflection field: " + fieldName + ", on: " + GrouperClientCommonUtils.className(invokeOn), e);
        }
    }

    public static Object fieldValue(Field field, Object invokeOn) {
        return GrouperClientCommonUtils.fieldValue(field, invokeOn, true);
    }

    public static Object fieldValue(Field field, Object invokeOn, boolean overrideSecurity) {
        if (overrideSecurity) {
            field.setAccessible(true);
        }
        try {
            return field.get(invokeOn);
        }
        catch (Exception e) {
            throw new RuntimeException("Cant execute reflection field: " + field.getName() + ", on: " + GrouperClientCommonUtils.className(invokeOn), e);
        }
    }

    public static Object fieldValue(Object invokeOn, String fieldName) {
        return GrouperClientCommonUtils.fieldValue(null, invokeOn, fieldName, true, true);
    }

    private static Method[] retrieveDeclaredMethods(Class theClass) {
        Method[] methods = GrouperClientCommonUtils.declaredMethodsCache().get(theClass);
        if (methods == null) {
            methods = theClass.getDeclaredMethods();
            GrouperClientCommonUtils.declaredMethodsCache().put(theClass, methods);
        }
        return methods;
    }

    public static Object callMethod(Class theClass, Object invokeOn, String methodName) {
        return GrouperClientCommonUtils.callMethod(theClass, invokeOn, methodName, null, null);
    }

    public static Object callMethod(Class theClass, Object invokeOn, String methodName, Object paramTypesOrArrayOrList, Object paramsOrListOrArray) {
        return GrouperClientCommonUtils.callMethod(theClass, invokeOn, methodName, paramTypesOrArrayOrList, paramsOrListOrArray, true);
    }

    public static Object callMethod(Class theClass, Object invokeOn, String methodName, Object paramTypesOrArrayOrList, Object paramsOrListOrArray, boolean callOnSupers) {
        return GrouperClientCommonUtils.callMethod(theClass, invokeOn, methodName, paramTypesOrArrayOrList, paramsOrListOrArray, callOnSupers, false);
    }

    public static <T> T construct(Class<T> theClass, Class[] types, Object[] args) {
        try {
            Constructor<T> constructor = theClass.getConstructor(types);
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException("Having trouble with constructor for class: " + theClass.getSimpleName() + " and args: " + GrouperClientCommonUtils.classesString(types), e);
        }
    }

    public static Object callMethod(Class theClass, Object invokeOn, String methodName, Object paramTypesOrArrayOrList, Object paramsOrListOrArray, boolean callOnSupers, boolean overrideSecurity) {
        Method method = null;
        Class[] paramTypesArray = (Class[])GrouperClientCommonUtils.toArray(paramTypesOrArrayOrList);
        try {
            method = theClass.getDeclaredMethod(methodName, paramTypesArray);
            if (overrideSecurity) {
                method.setAccessible(true);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchMethodException && callOnSupers && !theClass.equals(Object.class)) {
                return GrouperClientCommonUtils.callMethod(theClass.getSuperclass(), invokeOn, methodName, paramTypesOrArrayOrList, paramsOrListOrArray, callOnSupers, overrideSecurity);
            }
            throw new RuntimeException("Problem calling method " + methodName + " on " + theClass.getName(), e);
        }
        return GrouperClientCommonUtils.invokeMethod(method, invokeOn, paramsOrListOrArray);
    }

    public static Object invokeMethod(Method method, Object invokeOn) {
        return GrouperClientCommonUtils.invokeMethod(method, invokeOn, NO_PARAMS);
    }

    public static Object invokeMethod(Method method, Object invokeOn, Object paramsOrListOrArray) {
        Object[] args = paramsOrListOrArray == NO_PARAMS ? null : (Object[])GrouperClientCommonUtils.toArray(paramsOrListOrArray);
        method.setAccessible(true);
        Object result = null;
        Exception e = null;
        try {
            result = method.invoke(invokeOn, args);
        }
        catch (IllegalAccessException iae) {
            e = iae;
        }
        catch (IllegalArgumentException iae) {
            e = iae;
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ite.getCause();
            }
            e = ite;
        }
        if (e != null) {
            throw new RuntimeException("Cant execute reflection method: " + method.getName() + ", on: " + GrouperClientCommonUtils.className(invokeOn) + ", with args: " + GrouperClientCommonUtils.classNameCollection(args), e);
        }
        return result;
    }

    public static Object toArray(Object objectOrArrayOrCollection) {
        if (objectOrArrayOrCollection != null && objectOrArrayOrCollection.getClass().isArray()) {
            return objectOrArrayOrCollection;
        }
        int length = GrouperClientCommonUtils.length(objectOrArrayOrCollection);
        if (length == 0) {
            return null;
        }
        if (objectOrArrayOrCollection instanceof Collection) {
            Collection collection;
            Object first = (collection = (Collection)objectOrArrayOrCollection).iterator().next();
            return GrouperClientCommonUtils.toArray(collection, first == null ? Object.class : first.getClass());
        }
        Object array = Array.newInstance(objectOrArrayOrCollection.getClass(), 1);
        Array.set(array, 0, objectOrArrayOrCollection);
        return array;
    }

    public static <T> T[] toArray(Collection collection, Class<T> theClass) {
        if (collection == null || collection.size() == 0) {
            return null;
        }
        return collection.toArray((Object[])Array.newInstance(theClass, collection.size()));
    }

    public static Object callMethod(Class theClass, String methodName) {
        return GrouperClientCommonUtils.callMethod(theClass, null, methodName, null, null);
    }

    public static Object callMethod(Class theClass, String methodName, boolean callOnSupers) {
        return GrouperClientCommonUtils.callMethod(theClass, null, methodName, null, null, callOnSupers);
    }

    public static Object callMethod(Class theClass, String methodName, Object paramTypesOrArrayOrList, Object paramsOrListOrArray) {
        return GrouperClientCommonUtils.callMethod(theClass, null, methodName, paramTypesOrArrayOrList, paramsOrListOrArray);
    }

    public static Object callMethod(Object invokeOn, String methodName) {
        if (invokeOn == null) {
            throw new NullPointerException("invokeOn is null: " + methodName);
        }
        return GrouperClientCommonUtils.callMethod(invokeOn.getClass(), invokeOn, methodName, null, null, true, true);
    }

    public static String replace(String text, Object searchFor, Object replaceWith) {
        return GrouperClientCommonUtils.replace(null, null, text, searchFor, replaceWith, false, 0, false);
    }

    public static String replace(String text, Object searchFor, Object replaceWith, boolean recurse) {
        return GrouperClientCommonUtils.replace(null, null, text, searchFor, replaceWith, recurse, recurse ? GrouperClientCommonUtils.length(searchFor) : 0, false);
    }

    public static String replace(String text, Object searchFor, Object replaceWith, boolean recurse, boolean removeIfFound) {
        return GrouperClientCommonUtils.replace(null, null, text, searchFor, replaceWith, recurse, recurse ? GrouperClientCommonUtils.length(searchFor) : 0, removeIfFound);
    }

    public static String replace(String text, String repl, String with) {
        return GrouperClientCommonUtils.replace(text, repl, with, -1);
    }

    public static String replace(String text, String repl, String with, int max) {
        if (text == null || GrouperClientCommonUtils.isEmpty(repl) || with == null || max == 0) {
            return text;
        }
        StringBuffer buf = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max != 0) continue;
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static void replace(StringBuffer outBuffer, String text, Object searchFor, Object replaceWith) {
        GrouperClientCommonUtils.replace(outBuffer, null, text, searchFor, replaceWith, false, 0, false);
    }

    public static void replace(StringBuffer outBuffer, String text, Object searchFor, Object replaceWith, boolean recurse) {
        GrouperClientCommonUtils.replace(outBuffer, null, text, searchFor, replaceWith, recurse, recurse ? GrouperClientCommonUtils.length(searchFor) : 0, false);
    }

    private static String replace(StringBuffer outBuffer, Writer outWriter, String text, Object searchFor, Object replaceWith, boolean recurse, int timeToLive, boolean removeIfFound) {
        if (!recurse) {
            return GrouperClientCommonUtils.replaceHelper(outBuffer, outWriter, text, searchFor, replaceWith, recurse, timeToLive, removeIfFound);
        }
        String result = GrouperClientCommonUtils.replaceHelper(null, null, text, searchFor, replaceWith, recurse, timeToLive, removeIfFound);
        if (outBuffer != null) {
            outBuffer.append(result);
            return null;
        }
        if (outWriter != null) {
            try {
                outWriter.write(result);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return null;
        }
        return result;
    }

    public static void replace(Writer outWriter, String text, Object searchFor, Object replaceWith) {
        GrouperClientCommonUtils.replace(null, outWriter, text, searchFor, replaceWith, false, 0, false);
    }

    public static void replace(Writer outWriter, String text, Object searchFor, Object replaceWith, boolean recurse) {
        GrouperClientCommonUtils.replace(null, outWriter, text, searchFor, replaceWith, recurse, recurse ? GrouperClientCommonUtils.length(searchFor) : 0, false);
    }

    private static String replaceHelper(StringBuffer outBuffer, Writer outWriter, String text, Object searchFor, Object replaceWith, boolean recurse, int timeToLive, boolean removeIfFound) {
        try {
            boolean writeToWriter;
            if (timeToLive < 0) {
                throw new IllegalArgumentException("TimeToLive under 0: " + timeToLive + ", " + text);
            }
            int searchForLength = GrouperClientCommonUtils.length(searchFor);
            boolean done = false;
            if (GrouperClientCommonUtils.isEmpty(text)) {
                return text;
            }
            if (searchForLength == 0) {
                done = true;
            }
            boolean[] noMoreMatchesForReplIndex = null;
            int inputIndex = -1;
            int replaceIndex = -1;
            long resultPacked = -1L;
            if (!done) {
                if (searchForLength != GrouperClientCommonUtils.length(replaceWith)) {
                    throw new IndexOutOfBoundsException("Lengths dont match: " + searchForLength + ", " + GrouperClientCommonUtils.length(replaceWith));
                }
                noMoreMatchesForReplIndex = new boolean[searchForLength];
                resultPacked = GrouperClientCommonUtils.findNextIndexHelper(searchForLength, searchFor, replaceWith, noMoreMatchesForReplIndex, text, 0);
                inputIndex = GrouperClientCommonUtils.unpackInt(resultPacked, true);
                replaceIndex = GrouperClientCommonUtils.unpackInt(resultPacked, false);
            }
            boolean bl = writeToWriter = outWriter != null;
            if (done || inputIndex == -1) {
                if (writeToWriter) {
                    outWriter.write(text, 0, text.length());
                    return null;
                }
                if (outBuffer != null) {
                    GrouperClientCommonUtils.appendSubstring(outBuffer, text, 0, text.length());
                    return null;
                }
                return text;
            }
            StringBuffer bufferToWriteTo = outBuffer != null ? outBuffer : (writeToWriter ? null : new StringBuffer(text.length() + GrouperClientCommonUtils.replaceStringsBufferIncrease(text, searchFor, replaceWith)));
            String searchString = null;
            String replaceString = null;
            int start = 0;
            while (inputIndex != -1) {
                searchString = (String)GrouperClientCommonUtils.get(searchFor, replaceIndex);
                replaceString = (String)GrouperClientCommonUtils.get(replaceWith, replaceIndex);
                if (writeToWriter) {
                    outWriter.write(text, start, inputIndex - start);
                    outWriter.write(replaceString);
                } else {
                    GrouperClientCommonUtils.appendSubstring(bufferToWriteTo, text, start, inputIndex).append(replaceString);
                }
                if (removeIfFound) {
                    searchFor = GrouperClientCommonUtils.remove(searchFor, replaceIndex);
                    replaceWith = GrouperClientCommonUtils.remove(replaceWith, replaceIndex);
                    noMoreMatchesForReplIndex = (boolean[])GrouperClientCommonUtils.remove(noMoreMatchesForReplIndex, replaceIndex);
                    --searchForLength;
                }
                start = inputIndex + searchString.length();
                resultPacked = GrouperClientCommonUtils.findNextIndexHelper(searchForLength, searchFor, replaceWith, noMoreMatchesForReplIndex, text, start);
                inputIndex = GrouperClientCommonUtils.unpackInt(resultPacked, true);
                replaceIndex = GrouperClientCommonUtils.unpackInt(resultPacked, false);
            }
            if (writeToWriter) {
                outWriter.write(text, start, text.length() - start);
            } else {
                GrouperClientCommonUtils.appendSubstring(bufferToWriteTo, text, start, text.length());
            }
            if (writeToWriter || outBuffer != null) {
                if (recurse) {
                    throw new IllegalArgumentException("Cannot recurse and write to existing buffer or writer!");
                }
                return null;
            }
            String resultString = bufferToWriteTo.toString();
            if (recurse) {
                return GrouperClientCommonUtils.replaceHelper(outBuffer, outWriter, resultString, searchFor, replaceWith, recurse, timeToLive - 1, false);
            }
            return resultString;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    static int replaceStringsBufferIncrease(String text, Object repl, Object with) {
        int increase = 0;
        Iterator iteratorReplace = GrouperClientCommonUtils.iterator(repl);
        Iterator iteratorWith = GrouperClientCommonUtils.iterator(with);
        int replLength = GrouperClientCommonUtils.length(repl);
        String currentRepl = null;
        String currentWith = null;
        for (int i = 0; i < replLength; ++i) {
            currentRepl = (String)GrouperClientCommonUtils.next(repl, iteratorReplace, i);
            currentWith = (String)GrouperClientCommonUtils.next(with, iteratorWith, i);
            if (currentRepl == null || currentWith == null) {
                throw new NullPointerException("Replace string is null: " + text + ", " + currentRepl + ", " + currentWith);
            }
            int greater = currentWith.length() - currentRepl.length();
            increase += greater > 0 ? 3 * greater : 0;
        }
        increase = Math.min(increase, text.length() / 5);
        return increase;
    }

    private static long findNextIndexHelper(int searchForLength, Object searchFor, Object replaceWith, boolean[] noMoreMatchesForReplIndex, String input, int start) {
        int inputIndex = -1;
        int replaceIndex = -1;
        Iterator iteratorSearchFor = GrouperClientCommonUtils.iterator(searchFor);
        Iterator iteratorReplaceWith = GrouperClientCommonUtils.iterator(replaceWith);
        String currentSearchFor = null;
        String currentReplaceWith = null;
        int tempIndex = -1;
        for (int i = 0; i < searchForLength; ++i) {
            currentSearchFor = (String)GrouperClientCommonUtils.next(searchFor, iteratorSearchFor, i);
            currentReplaceWith = (String)GrouperClientCommonUtils.next(replaceWith, iteratorReplaceWith, i);
            if (noMoreMatchesForReplIndex[i] || GrouperClientCommonUtils.isEmpty(currentSearchFor) || currentReplaceWith == null) continue;
            tempIndex = input.indexOf(currentSearchFor, start);
            boolean bl = noMoreMatchesForReplIndex[i] = tempIndex == -1;
            if (tempIndex == -1 || inputIndex != -1 && tempIndex >= inputIndex) continue;
            inputIndex = tempIndex;
            replaceIndex = i;
        }
        long resultPacked = GrouperClientCommonUtils.packInts(inputIndex, replaceIndex);
        return resultPacked;
    }

    public static long packInts(int first, int second) {
        long result = first;
        result <<= 32;
        return result |= (long)second;
    }

    public static int unpackInt(long theLong, boolean isFirst) {
        int result = 0;
        if (isFirst) {
            theLong >>= 32;
        }
        result = (int)(theLong & 0xFFFFFFFFFFFFFFFFL);
        return result;
    }

    private static StringBuffer appendSubstring(StringBuffer buf, String string, int start, int end) {
        for (int i = start; i < end; ++i) {
            buf.append(string.charAt(i));
        }
        return buf;
    }

    public static Object get(Object arrayOrCollection, int index) {
        if (arrayOrCollection == null) {
            if (index == 0) {
                return null;
            }
            throw new RuntimeException("Trying to access index " + index + " of null");
        }
        if (arrayOrCollection instanceof List) {
            return ((List)arrayOrCollection).get(index);
        }
        if (arrayOrCollection instanceof Collection) {
            Iterator iterator = GrouperClientCommonUtils.iterator(arrayOrCollection);
            for (int i = 0; i < index; ++i) {
                GrouperClientCommonUtils.next(arrayOrCollection, iterator, i);
            }
            return GrouperClientCommonUtils.next(arrayOrCollection, iterator, index);
        }
        if (arrayOrCollection.getClass().isArray()) {
            return Array.get(arrayOrCollection, index);
        }
        if (index == 0) {
            return arrayOrCollection;
        }
        throw new RuntimeException("Trying to access index " + index + " of and object: " + arrayOrCollection);
    }

    public static String toStringSafe(Object object) {
        if (object == null) {
            return null;
        }
        try {
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                int collectionSize = collection.size();
                if (collectionSize == 0) {
                    return "Empty " + object.getClass().getSimpleName();
                }
                Object first = collection.iterator().next();
                return object.getClass().getSimpleName() + " of size " + collectionSize + " with first type: " + (first == null ? null : first.getClass());
            }
            return object.toString();
        }
        catch (Exception e) {
            return "<<exception>> " + object.getClass() + ":\n" + GrouperClientCommonUtils.getFullStackTrace(e) + "\n";
        }
    }

    public static boolean booleanValue(Object object) {
        if (GrouperClientCommonUtils.nullOrBlank(object)) {
            throw new RuntimeException("Expecting something which can be converted to boolean, but is null or blank: '" + object + "'");
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (GrouperClientCommonUtils.equalsIgnoreCase(string, "true") || GrouperClientCommonUtils.equalsIgnoreCase(string, "t") || GrouperClientCommonUtils.equalsIgnoreCase(string, "yes") || GrouperClientCommonUtils.equalsIgnoreCase(string, "y")) {
                return true;
            }
            if (GrouperClientCommonUtils.equalsIgnoreCase(string, "false") || GrouperClientCommonUtils.equalsIgnoreCase(string, "f") || GrouperClientCommonUtils.equalsIgnoreCase(string, "no") || GrouperClientCommonUtils.equalsIgnoreCase(string, "n")) {
                return false;
            }
            throw new RuntimeException("Invalid string to boolean conversion: '" + string + "' expecting true|false or t|f or yes|no or y|n case insensitive");
        }
        throw new RuntimeException("Cant convert object to boolean: " + object.getClass());
    }

    public static boolean booleanValue(Object object, boolean defaultBoolean) {
        if (GrouperClientCommonUtils.nullOrBlank(object)) {
            return defaultBoolean;
        }
        return GrouperClientCommonUtils.booleanValue(object);
    }

    public static Boolean booleanObjectValue(Object object) {
        if (GrouperClientCommonUtils.nullOrBlank(object)) {
            return null;
        }
        return GrouperClientCommonUtils.booleanValue(object);
    }

    public static boolean nullOrBlank(Object object) {
        if (object == null) {
            return true;
        }
        return object instanceof String && GrouperClientCommonUtils.isBlank((String)object);
    }

    public static Method getter(Class theClass, String fieldName, boolean callOnSupers, boolean throwExceptionIfNotFound) {
        String getterName = GrouperClientCommonUtils.getterNameFromPropertyName(fieldName);
        return GrouperClientCommonUtils.getterHelper(theClass, fieldName, getterName, callOnSupers, throwExceptionIfNotFound);
    }

    public static Method getterHelper(Class theClass, String fieldName, String getterName, boolean callOnSupers, boolean throwExceptionIfNotFound) {
        Method[] methods = GrouperClientCommonUtils.retrieveDeclaredMethods(theClass);
        if (methods != null) {
            for (Method method : methods) {
                if (!GrouperClientCommonUtils.equals(getterName, method.getName()) || !GrouperClientCommonUtils.isGetter(method)) continue;
                return method;
            }
        }
        if (callOnSupers && !theClass.equals(Object.class)) {
            return GrouperClientCommonUtils.getterHelper(theClass.getSuperclass(), fieldName, getterName, callOnSupers, throwExceptionIfNotFound);
        }
        if (throwExceptionIfNotFound) {
            throw new RuntimeException("Cant find getter: " + getterName + ", in: " + theClass + ", callOnSupers: " + callOnSupers);
        }
        return null;
    }

    public static String getterNameFromPropertyName(String propertyName) {
        return "get" + GrouperClientCommonUtils.capitalize(propertyName);
    }

    public static Set<Method> getters(Class theClass, Class superclassToStopAt, Class<? extends Annotation> markerAnnotation, Boolean includeAnnotation) {
        return GrouperClientCommonUtils.gettersHelper(theClass, superclassToStopAt, null, true, markerAnnotation, includeAnnotation);
    }

    static Set<Method> gettersHelper(Class theClass, Class superclassToStopAt, Class<?> fieldType, boolean includeSuperclassToStopAt, Class<? extends Annotation> markerAnnotation, Boolean includeAnnotation) {
        Set<Method> getterSet = null;
        String cacheKey = theClass + CACHE_SEPARATOR + superclassToStopAt + CACHE_SEPARATOR + fieldType + CACHE_SEPARATOR + includeSuperclassToStopAt + CACHE_SEPARATOR + markerAnnotation + CACHE_SEPARATOR + includeAnnotation;
        getterSet = GrouperClientCommonUtils.getterSetCache().get(cacheKey);
        if (getterSet != null) {
            return getterSet;
        }
        getterSet = new LinkedHashSet<Method>();
        GrouperClientCommonUtils.gettersHelper(theClass, superclassToStopAt, fieldType, includeSuperclassToStopAt, markerAnnotation, getterSet, includeAnnotation);
        GrouperClientCommonUtils.getterSetCache().put(cacheKey, getterSet);
        return getterSet;
    }

    private static void gettersHelper(Class theClass, Class superclassToStopAt, Class<?> propertyType, boolean includeSuperclassToStopAt, Class<? extends Annotation> markerAnnotation, Set<Method> getterSet, Boolean includeAnnotation) {
        Method[] methods = GrouperClientCommonUtils.retrieveDeclaredMethods(theClass);
        if (GrouperClientCommonUtils.length(methods) != 0) {
            for (Method method : methods) {
                if (!GrouperClientCommonUtils.isGetter(method) || markerAnnotation != null && includeAnnotation.booleanValue() != method.isAnnotationPresent(markerAnnotation) || propertyType != null && !propertyType.isAssignableFrom(method.getReturnType())) continue;
                getterSet.add(method);
            }
        }
        if (theClass.equals(superclassToStopAt) || theClass.equals(Object.class)) {
            return;
        }
        Class superclass = theClass.getSuperclass();
        if (!includeSuperclassToStopAt && superclass.equals(superclassToStopAt)) {
            return;
        }
        GrouperClientCommonUtils.gettersHelper(superclass, superclassToStopAt, propertyType, includeSuperclassToStopAt, markerAnnotation, getterSet, includeAnnotation);
    }

    public static boolean isGetter(Method method) {
        String methodName = method.getName();
        if (!methodName.startsWith("get") && !methodName.startsWith("is")) {
            return false;
        }
        if (method.getReturnType() == Void.TYPE) {
            return false;
        }
        if (GrouperClientCommonUtils.length(method.getParameterTypes()) != 0) {
            return false;
        }
        return !Modifier.isStatic(method.getModifiers());
    }

    public static void assignSetter(Object invokeOn, String fieldName, Object dataToAssign, boolean typeCast) {
        Class<?> invokeOnClass = invokeOn.getClass();
        try {
            Method setter = GrouperClientCommonUtils.setter(invokeOnClass, fieldName, true, true);
            setter.setAccessible(true);
            if (typeCast) {
                dataToAssign = GrouperClientCommonUtils.typeCast(dataToAssign, setter.getParameterTypes()[0]);
            }
            setter.invoke(invokeOn, dataToAssign);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem assigning setter: " + fieldName + " on class: " + invokeOnClass + ", type of data is: " + GrouperClientCommonUtils.className(dataToAssign), e);
        }
    }

    public static boolean isSetter(Method method) {
        if (!method.getName().startsWith("set")) {
            return false;
        }
        if (method.getReturnType() != Void.TYPE) {
            return false;
        }
        if (GrouperClientCommonUtils.length(method.getParameterTypes()) != 1) {
            return false;
        }
        return !Modifier.isStatic(method.getModifiers());
    }

    public static Method setter(Class theClass, String fieldName, boolean callOnSupers, boolean throwExceptionIfNotFound) {
        String setterName = GrouperClientCommonUtils.setterNameFromPropertyName(fieldName);
        return GrouperClientCommonUtils.setterHelper(theClass, fieldName, setterName, callOnSupers, throwExceptionIfNotFound);
    }

    public static Method setterHelper(Class theClass, String fieldName, String setterName, boolean callOnSupers, boolean throwExceptionIfNotFound) {
        Method[] methods = GrouperClientCommonUtils.retrieveDeclaredMethods(theClass);
        if (methods != null) {
            for (Method method : methods) {
                if (!GrouperClientCommonUtils.equals(setterName, method.getName()) || !GrouperClientCommonUtils.isSetter(method)) continue;
                return method;
            }
        }
        if (callOnSupers && !theClass.equals(Object.class)) {
            return GrouperClientCommonUtils.setterHelper(theClass.getSuperclass(), fieldName, setterName, callOnSupers, throwExceptionIfNotFound);
        }
        if (throwExceptionIfNotFound) {
            throw new RuntimeException("Cant find setter: " + setterName + ", in: " + theClass + ", callOnSupers: " + callOnSupers);
        }
        return null;
    }

    public static String setterNameFromPropertyName(String propertyName) {
        return "set" + GrouperClientCommonUtils.capitalize(propertyName);
    }

    public static Set<Method> setters(Class theClass, Class superclassToStopAt, Class<?> fieldType, boolean includeSuperclassToStopAt, Class<? extends Annotation> markerAnnotation, boolean includeAnnotation) {
        return GrouperClientCommonUtils.settersHelper(theClass, superclassToStopAt, fieldType, includeSuperclassToStopAt, markerAnnotation, includeAnnotation);
    }

    static Set<Method> settersHelper(Class theClass, Class superclassToStopAt, Class<?> fieldType, boolean includeSuperclassToStopAt, Class<? extends Annotation> markerAnnotation, boolean includeAnnotation) {
        Set<Method> setterSet = null;
        String cacheKey = theClass + CACHE_SEPARATOR + superclassToStopAt + CACHE_SEPARATOR + fieldType + CACHE_SEPARATOR + includeSuperclassToStopAt + CACHE_SEPARATOR + markerAnnotation + CACHE_SEPARATOR + includeAnnotation;
        setterSet = GrouperClientCommonUtils.setterSetCache().get(cacheKey);
        if (setterSet != null) {
            return setterSet;
        }
        setterSet = new LinkedHashSet<Method>();
        GrouperClientCommonUtils.settersHelper(theClass, superclassToStopAt, fieldType, includeSuperclassToStopAt, markerAnnotation, setterSet, includeAnnotation);
        GrouperClientCommonUtils.setterSetCache().put(cacheKey, setterSet);
        return setterSet;
    }

    private static void settersHelper(Class theClass, Class superclassToStopAt, Class<?> propertyType, boolean includeSuperclassToStopAt, Class<? extends Annotation> markerAnnotation, Set<Method> setterSet, Boolean includeAnnotation) {
        Method[] methods = GrouperClientCommonUtils.retrieveDeclaredMethods(theClass);
        if (GrouperClientCommonUtils.length(methods) != 0) {
            for (Method method : methods) {
                if (!GrouperClientCommonUtils.isSetter(method) || markerAnnotation != null && includeAnnotation.booleanValue() != method.isAnnotationPresent(markerAnnotation) || propertyType != null && !propertyType.isAssignableFrom(method.getParameterTypes()[0])) continue;
                setterSet.add(method);
            }
        }
        if (theClass.equals(superclassToStopAt) || theClass.equals(Object.class)) {
            return;
        }
        Class superclass = theClass.getSuperclass();
        if (!includeSuperclassToStopAt && superclass.equals(superclassToStopAt)) {
            return;
        }
        GrouperClientCommonUtils.settersHelper(superclass, superclassToStopAt, propertyType, includeSuperclassToStopAt, markerAnnotation, setterSet, includeAnnotation);
    }

    public static String propertyName(Method method) {
        String methodName = method.getName();
        boolean isGetter = methodName.startsWith("get");
        boolean isSetter = methodName.startsWith("set");
        boolean isIsser = methodName.startsWith("is");
        int expectedLength = isIsser ? 2 : 3;
        int length = methodName.length();
        if (!isGetter && !isSetter && !isIsser || length <= expectedLength) {
            throw new RuntimeException("Not a getter or setter: " + methodName);
        }
        char fourthCharLower = Character.toLowerCase(methodName.charAt(expectedLength));
        if (length == expectedLength + 1) {
            return Character.toString(fourthCharLower);
        }
        return fourthCharLower + methodName.substring(expectedLength + 1, length);
    }

    public static Class propertyType(Class theClass, String propertyName) {
        Method method = GrouperClientCommonUtils.getter(theClass, propertyName, true, false);
        if (method != null) {
            return method.getReturnType();
        }
        method = GrouperClientCommonUtils.setter(theClass, propertyName, true, false);
        if (method != null) {
            return method.getParameterTypes()[0];
        }
        Field field = GrouperClientCommonUtils.field(theClass, propertyName, true, true);
        return field.getType();
    }

    public static <T> T typeCast(Object value, Class<T> theClass) {
        return GrouperClientCommonUtils.typeCast(value, theClass, false, false);
    }

    public static void removeEnd(StringBuilder str, String remove) {
        if (str == null || str.length() == 0 || GrouperClientCommonUtils.isEmpty(remove)) {
            return;
        }
        if (GrouperClientCommonUtils.endsWith(str, remove)) {
            str.setLength(str.length() - remove.length());
        }
    }

    public static boolean endsWith(StringBuilder str, String end) {
        if (str == null || str.length() == 0 || GrouperClientCommonUtils.isEmpty(end) || str.length() < end.length()) {
            return false;
        }
        int endIndex = 0;
        for (int i = str.length() - end.length(); i < str.length(); ++i) {
            if (str.charAt(i) != end.charAt(endIndex)) {
                return false;
            }
            ++endIndex;
        }
        return true;
    }

    public static File newFileUniqueName(String parentDirName, String namePrefix, String nameSuffix, boolean createFile) {
        int i;
        SimpleDateFormat fileNameFormat = new SimpleDateFormat("yyyyMMdd_HH_mm_ss_SSS");
        if (!GrouperClientCommonUtils.isBlank(parentDirName)) {
            File parentDir;
            if (!parentDirName.endsWith("/") && !parentDirName.endsWith("\\")) {
                parentDirName = parentDirName + File.separator;
            }
            if (!(parentDir = new File(parentDirName)).exists()) {
                if (!parentDir.mkdirs()) {
                    throw new RuntimeException("Cant make dir: " + parentDir.getAbsolutePath());
                }
            } else if (!parentDir.isDirectory()) {
                throw new RuntimeException("Parent dir is not a directory: " + parentDir.getAbsolutePath());
            }
        } else {
            parentDirName = EMPTY;
        }
        if (!nameSuffix.contains(".")) {
            nameSuffix = "." + nameSuffix;
        }
        String fileName = parentDirName + namePrefix + "_" + fileNameFormat.format(new Date()) + nameSuffix;
        int dotLocation = fileName.lastIndexOf(46);
        String fileNamePre = fileName.substring(0, dotLocation);
        String fileNamePost = fileName.substring(dotLocation);
        File theFile = new File(fileName);
        for (i = 0; i < 1000 && theFile.exists(); ++i) {
            fileName = fileNamePre + "_" + i + fileNamePost;
            theFile = new File(fileName);
        }
        if (i >= 1000) {
            throw new RuntimeException("Cant find filename to create: " + fileName);
        }
        if (createFile) {
            try {
                if (!theFile.createNewFile()) {
                    throw new RuntimeException("Cant create file, it returned false");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Cant create file: " + fileName + ", make sure permissions and such are ok, or change file location in grouper.properties if applicable", e);
            }
        }
        return theFile;
    }

    public static Date dateValue(Object inputObject) {
        if (inputObject == null) {
            return null;
        }
        if (inputObject instanceof Date) {
            return (Date)inputObject;
        }
        if (inputObject instanceof String) {
            String input = (String)inputObject;
            if (GrouperClientCommonUtils.isBlank(input)) {
                return null;
            }
            try {
                if (input.length() == 8) {
                    return GrouperClientCommonUtils.dateFormat().parse(input);
                }
                if (!GrouperClientCommonUtils.contains(input, '.')) {
                    if (GrouperClientCommonUtils.contains(input, '/')) {
                        return dateMinutesSecondsFormat.parse(input);
                    }
                    return dateMinutesSecondsNoSlashFormat.parse(input);
                }
                if (GrouperClientCommonUtils.contains(input, '/')) {
                    int lastDotIndex = input.lastIndexOf(46);
                    if (lastDotIndex == input.length() - 7) {
                        String nonNanoInput = input.substring(0, input.length() - 3);
                        Date date = timestampFormat.parse(nonNanoInput);
                        String lastThree = input.substring(input.length() - 3, input.length());
                        int lastThreeInt = Integer.parseInt(lastThree);
                        Timestamp timestamp = new Timestamp(date.getTime());
                        timestamp.setNanos(timestamp.getNanos() + lastThreeInt * 1000);
                        return timestamp;
                    }
                    return timestampFormat.parse(input);
                }
                return timestampNoSlashFormat.parse(input);
            }
            catch (ParseException pe) {
                throw new RuntimeException(errorStart + GrouperClientCommonUtils.toStringForLog(input));
            }
        }
        throw new RuntimeException("Cannot convert Object to date : " + GrouperClientCommonUtils.toStringForLog(inputObject));
    }

    public static boolean isBlank(Object input) {
        if (null == input) {
            return true;
        }
        return input instanceof String && GrouperClientCommonUtils.isBlank((String)input);
    }

    public static <T> T typeCast(Object value, Class<T> theClass, boolean convertNullToDefaultPrimitive, boolean useNewInstanceHooks) {
        if (Object.class.equals(theClass)) {
            return (T)value;
        }
        if (value == null) {
            if (convertNullToDefaultPrimitive && theClass.isPrimitive()) {
                if (theClass == Boolean.TYPE) {
                    return (T)Boolean.FALSE;
                }
                if (theClass == Character.TYPE) {
                    return (T)Integer.valueOf(0);
                }
                return (T)GrouperClientCommonUtils.typeCast(0, theClass, false, false);
            }
            return null;
        }
        if (theClass.isInstance(value)) {
            return (T)value;
        }
        if (theClass.isArray() && theClass.getComponentType() != null) {
            theClass = theClass.getComponentType();
        }
        Object resultValue = null;
        if (theClass.equals(Date.class)) {
            resultValue = GrouperClientCommonUtils.dateValue(value);
        } else if (theClass.equals(String.class)) {
            resultValue = GrouperClientCommonUtils.stringValue(value);
        } else if (theClass.equals(Timestamp.class)) {
            resultValue = GrouperClientCommonUtils.toTimestamp(value);
        } else if (theClass.equals(Boolean.class) || theClass.equals(Boolean.TYPE)) {
            resultValue = GrouperClientCommonUtils.booleanObjectValue(value);
        } else if (theClass.equals(Integer.class) || theClass.equals(Integer.TYPE)) {
            resultValue = GrouperClientCommonUtils.intObjectValue(value, true);
        } else if (theClass.equals(Double.class) || theClass.equals(Double.TYPE)) {
            resultValue = GrouperClientCommonUtils.doubleObjectValue(value, true);
        } else if (theClass.equals(Float.class) || theClass.equals(Float.TYPE)) {
            resultValue = GrouperClientCommonUtils.floatObjectValue(value, true);
        } else if (theClass.equals(Long.class) || theClass.equals(Long.TYPE)) {
            resultValue = GrouperClientCommonUtils.longObjectValue(value, true);
        } else if (theClass.equals(Byte.class) || theClass.equals(Byte.TYPE)) {
            resultValue = GrouperClientCommonUtils.byteObjectValue(value);
        } else if (theClass.equals(Character.class) || theClass.equals(Character.TYPE)) {
            resultValue = GrouperClientCommonUtils.charObjectValue(value);
        } else if (theClass.equals(Short.class) || theClass.equals(Short.TYPE)) {
            resultValue = GrouperClientCommonUtils.shortObjectValue(value);
        } else if (theClass.isEnum() && value instanceof String) {
            resultValue = Enum.valueOf(theClass, (String)value);
        } else if (theClass.equals(Class.class) && value instanceof String) {
            resultValue = GrouperClientCommonUtils.forName((String)value);
        } else if (useNewInstanceHooks && value instanceof String) {
            String stringValue = (String)value;
            if (GrouperClientCommonUtils.equals("null", stringValue)) {
                resultValue = null;
            } else if (GrouperClientCommonUtils.equals("newInstance", stringValue)) {
                resultValue = GrouperClientCommonUtils.newInstance(theClass);
            } else {
                try {
                    Constructor<Object> constructor = theClass.getConstructor(String.class);
                    resultValue = constructor.newInstance(stringValue);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cant find constructor with string for class: " + theClass);
                }
            }
        } else {
            throw new RuntimeException("Cannot convert from type: " + value.getClass() + " to type: " + theClass);
        }
        return (T)resultValue;
    }

    public static boolean isScalar(Class<?> type) {
        if (type.isArray()) {
            return false;
        }
        if (type.isPrimitive()) {
            return true;
        }
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        if (Date.class.isAssignableFrom(type)) {
            return true;
        }
        if (Character.class.equals(type)) {
            return true;
        }
        if (CharSequence.class.equals(type) || CharSequence.class.isAssignableFrom(type)) {
            return true;
        }
        return Class.class == type || Boolean.class == type || type.isEnum();
    }

    public static Timestamp toTimestamp(Object input) {
        if (null == input) {
            return null;
        }
        if (input instanceof Timestamp) {
            return (Timestamp)input;
        }
        if (input instanceof String) {
            return GrouperClientCommonUtils.stringToTimestamp((String)input);
        }
        if (input instanceof Date) {
            return new Timestamp(((Date)input).getTime());
        }
        if (input instanceof java.sql.Date) {
            return new Timestamp(((java.sql.Date)input).getTime());
        }
        throw new RuntimeException("Cannot convert Object to timestamp : " + input);
    }

    public static String removeEnd(String str, String remove) {
        if (GrouperClientCommonUtils.isEmpty(str) || GrouperClientCommonUtils.isEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String stringValue(Object input) {
        if (input == null) {
            return (String)input;
        }
        if (input instanceof Timestamp) {
            return GrouperClientCommonUtils.timestampToString((Timestamp)input);
        }
        if (input instanceof Date) {
            return GrouperClientCommonUtils.stringValue((Date)input);
        }
        if (input instanceof Number) {
            DecimalFormat decimalFormat = new DecimalFormat("###################.###############");
            return decimalFormat.format(((Number)input).doubleValue());
        }
        return input.toString();
    }

    public static synchronized String timestampToString(Date timestamp) {
        if (timestamp == null) {
            return null;
        }
        return timestampFormat.format(timestamp);
    }

    static synchronized SimpleDateFormat dateFormat() {
        return dateFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringValue(Date date) {
        Class<GrouperClientCommonUtils> clazz = GrouperClientCommonUtils.class;
        synchronized (GrouperClientCommonUtils.class) {
            if (date == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            String theString = GrouperClientCommonUtils.dateFormat().format(date);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return theString;
        }
    }

    public static Timestamp stringToTimestamp(String input) {
        Date date = GrouperClientCommonUtils.stringToTimestampHelper(input);
        if (date == null) {
            return null;
        }
        if (date instanceof Timestamp) {
            return (Timestamp)date;
        }
        return new Timestamp(date.getTime());
    }

    static synchronized Date stringToTimestampHelper(String input) {
        if (GrouperClientCommonUtils.isBlank(input)) {
            return null;
        }
        try {
            if (GrouperClientCommonUtils.equals("99999999", input) || GrouperClientCommonUtils.equals("999999", input)) {
                input = "20991231";
            }
            if (input.length() == 8) {
                return GrouperClientCommonUtils.dateFormat().parse(input);
            }
            if (!GrouperClientCommonUtils.contains(input, '.')) {
                if (GrouperClientCommonUtils.contains(input, '/')) {
                    return dateMinutesSecondsFormat.parse(input);
                }
                return dateMinutesSecondsNoSlashFormat.parse(input);
            }
            if (GrouperClientCommonUtils.contains(input, '/')) {
                int lastDotIndex = input.lastIndexOf(46);
                if (lastDotIndex == input.length() - 7) {
                    String nonNanoInput = input.substring(0, input.length() - 3);
                    Date date = timestampFormat.parse(nonNanoInput);
                    String lastThree = input.substring(input.length() - 3, input.length());
                    int lastThreeInt = Integer.parseInt(lastThree);
                    Timestamp timestamp = new Timestamp(date.getTime());
                    timestamp.setNanos(timestamp.getNanos() + lastThreeInt * 1000);
                    return timestamp;
                }
                return timestampFormat.parse(input);
            }
            return timestampNoSlashFormat.parse(input);
        }
        catch (ParseException pe) {
            throw new RuntimeException(errorStart + input);
        }
    }

    public static BigDecimal bigDecimalObjectValue(Object input) {
        if (input instanceof BigDecimal) {
            return (BigDecimal)input;
        }
        if (GrouperClientCommonUtils.isBlank(input)) {
            return null;
        }
        return BigDecimal.valueOf(GrouperClientCommonUtils.doubleValue(input));
    }

    public static Byte byteObjectValue(Object input) {
        if (input instanceof Byte) {
            return (Byte)input;
        }
        if (GrouperClientCommonUtils.isBlank(input)) {
            return null;
        }
        return GrouperClientCommonUtils.byteValue(input);
    }

    public static byte byteValue(Object input) {
        if (input instanceof String) {
            String string = (String)input;
            return Byte.parseByte(string);
        }
        if (input instanceof Number) {
            return ((Number)input).byteValue();
        }
        throw new RuntimeException("Cannot convert to byte: " + GrouperClientCommonUtils.className(input));
    }

    public static Double doubleObjectValue(Object input, boolean allowNullBlank) {
        if (input instanceof Double) {
            return (Double)input;
        }
        if (allowNullBlank && GrouperClientCommonUtils.isBlank(input)) {
            return null;
        }
        return GrouperClientCommonUtils.doubleValue(input);
    }

    public static double doubleValue(Object input) {
        if (input instanceof String) {
            String string = (String)input;
            return Double.parseDouble(string);
        }
        if (input instanceof Number) {
            return ((Number)input).doubleValue();
        }
        throw new RuntimeException("Cannot convert to double: " + GrouperClientCommonUtils.className(input));
    }

    public static double doubleValueNoError(Object input) {
        if (input == null || input instanceof String && GrouperClientCommonUtils.isBlank((String)input)) {
            return -9.99999999E8;
        }
        try {
            return GrouperClientCommonUtils.doubleValue(input);
        }
        catch (Exception exception) {
            return -9.99999999E8;
        }
    }

    public static Float floatObjectValue(Object input, boolean allowNullBlank) {
        if (input instanceof Float) {
            return (Float)input;
        }
        if (allowNullBlank && GrouperClientCommonUtils.isBlank(input)) {
            return null;
        }
        return Float.valueOf(GrouperClientCommonUtils.floatValue(input));
    }

    public static float floatValue(Object input) {
        if (input instanceof String) {
            String string = (String)input;
            return Float.parseFloat(string);
        }
        if (input instanceof Number) {
            return ((Number)input).floatValue();
        }
        throw new RuntimeException("Cannot convert to float: " + GrouperClientCommonUtils.className(input));
    }

    public static float floatValueNoError(Object input) {
        if (input == null || input instanceof String && GrouperClientCommonUtils.isBlank((String)input)) {
            return -1.0E9f;
        }
        try {
            return GrouperClientCommonUtils.floatValue(input);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0E9f;
        }
    }

    public static Integer intObjectValue(Object input, boolean allowNullBlank) {
        if (input instanceof Integer) {
            return (Integer)input;
        }
        if (allowNullBlank && GrouperClientCommonUtils.isBlank(input)) {
            return null;
        }
        return GrouperClientCommonUtils.intValue(input);
    }

    public static int intValue(Object input) {
        if (input instanceof String) {
            String string = (String)input;
            return Integer.parseInt(string);
        }
        if (input instanceof Number) {
            return ((Number)input).intValue();
        }
        throw new RuntimeException("Cannot convert to int: " + GrouperClientCommonUtils.className(input));
    }

    public static int intValue(Object input, int valueIfNull) {
        if (input == null || EMPTY.equals(input)) {
            return valueIfNull;
        }
        return GrouperClientCommonUtils.intObjectValue(input, false);
    }

    public static int intValueNoError(Object input) {
        if (input == null || input instanceof String && GrouperClientCommonUtils.isBlank((String)input)) {
            return -999999999;
        }
        try {
            return GrouperClientCommonUtils.intValue(input);
        }
        catch (Exception exception) {
            return -999999999;
        }
    }

    public static Long longObjectValue(Object input, boolean allowNullBlank) {
        if (input instanceof Long) {
            return (Long)input;
        }
        if (allowNullBlank && GrouperClientCommonUtils.isBlank(input)) {
            return null;
        }
        return GrouperClientCommonUtils.longValue(input);
    }

    public static long longValue(Object input) {
        if (input instanceof String) {
            String string = (String)input;
            return Long.parseLong(string);
        }
        if (input instanceof Number) {
            return ((Number)input).longValue();
        }
        throw new RuntimeException("Cannot convert to long: " + GrouperClientCommonUtils.className(input));
    }

    public static long longValue(Object input, long valueIfNull) {
        if (input == null || EMPTY.equals(input)) {
            return valueIfNull;
        }
        return GrouperClientCommonUtils.longObjectValue(input, false);
    }

    public static long longValueNoError(Object input) {
        if (input == null || input instanceof String && GrouperClientCommonUtils.isBlank((String)input)) {
            return -999999999L;
        }
        try {
            return GrouperClientCommonUtils.longValue(input);
        }
        catch (Exception exception) {
            return -999999999L;
        }
    }

    public static Short shortObjectValue(Object input) {
        if (input instanceof Short) {
            return (Short)input;
        }
        if (GrouperClientCommonUtils.isBlank(input)) {
            return null;
        }
        return GrouperClientCommonUtils.shortValue(input);
    }

    public static short shortValue(Object input) {
        if (input instanceof String) {
            String string = (String)input;
            return Short.parseShort(string);
        }
        if (input instanceof Number) {
            return ((Number)input).shortValue();
        }
        throw new RuntimeException("Cannot convert to short: " + GrouperClientCommonUtils.className(input));
    }

    public static Character charObjectValue(Object input) {
        if (input instanceof Character) {
            return (Character)input;
        }
        if (GrouperClientCommonUtils.isBlank(input)) {
            return null;
        }
        return new Character(GrouperClientCommonUtils.charValue(input));
    }

    public static char charValue(Object input) {
        String inputString;
        if (input instanceof Character) {
            return ((Character)input).charValue();
        }
        if (input instanceof String && (inputString = (String)input).length() == 1) {
            return inputString.charAt(0);
        }
        throw new RuntimeException("Cannot convert to char: " + (input == null ? null : input.getClass() + ", " + input));
    }

    public static void createParentDirectories(File file) {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new RuntimeException("Could not create directory : " + file.getParentFile());
        }
    }

    public static void saveStringIntoFile(File file, String contents) {
        try {
            GrouperClientCommonUtils.writeStringToFile(file, contents, GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.default.fileEncoding"));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static boolean saveStringIntoFile(File file, String contents, boolean onlyIfDifferentContents, boolean ignoreWhitespace) {
        if (onlyIfDifferentContents && file.exists()) {
            String fileContents = GrouperClientCommonUtils.readFileIntoString(file);
            String compressedContents = contents;
            if (ignoreWhitespace) {
                compressedContents = GrouperClientCommonUtils.replaceWhitespaceWithSpace(compressedContents);
                fileContents = GrouperClientCommonUtils.replaceWhitespaceWithSpace(fileContents);
            }
            if (GrouperClientCommonUtils.equals(fileContents, compressedContents)) {
                return false;
            }
        }
        GrouperClientCommonUtils.saveStringIntoFile(file, contents);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String data, String encoding) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            ((OutputStream)out).write(data.getBytes(encoding));
        }
        finally {
            GrouperClientCommonUtils.closeQuietly(out);
        }
    }

    public static String readFileIntoString(File file) {
        if (file == null) {
            return null;
        }
        try {
            return GrouperClientCommonUtils.readFileToString(file, GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.default.fileEncoding"));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static String readResourceIntoString(String resourceName, boolean allowNull) {
        if (GrouperClientCommonUtils.isBlank(resourceName)) {
            if (allowNull) {
                return null;
            }
            throw new RuntimeException("Resource name is blank");
        }
        URL url = GrouperClientCommonUtils.computeUrl(resourceName, allowNull);
        if (url == null && allowNull) {
            return null;
        }
        InputStream inputStream = null;
        StringWriter stringWriter = new StringWriter();
        try {
            inputStream = url.openStream();
            GrouperClientCommonUtils.copy(inputStream, stringWriter, GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.default.fileEncoding"));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error reading resource: '" + resourceName + "'", ioe);
        }
        finally {
            GrouperClientCommonUtils.closeQuietly(inputStream);
            GrouperClientCommonUtils.closeQuietly(stringWriter);
        }
        return stringWriter.toString();
    }

    public static String readResourceIntoString(String resourceName, Class<?> classInJar) {
        try {
            return GrouperClientCommonUtils.readResourceIntoString(resourceName, false);
        }
        catch (Exception exception) {
            File jarFile = classInJar == null ? null : GrouperClientCommonUtils.jarFile(classInJar);
            File parentDir = jarFile == null ? null : jarFile.getParentFile();
            String fileName = parentDir == null ? null : GrouperClientCommonUtils.stripLastSlashIfExists(GrouperClientCommonUtils.fileCanonicalPath(parentDir)) + File.separator + resourceName;
            File configFile = fileName == null ? null : new File(fileName);
            return GrouperClientCommonUtils.readFileIntoString(configFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file, String encoding) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            String string = GrouperClientCommonUtils.toString(in, encoding);
            return string;
        }
        finally {
            GrouperClientCommonUtils.closeQuietly(in);
        }
    }

    public static String replaceWhitespaceWithSpace(String input) {
        if (input == null) {
            return input;
        }
        return input.replaceAll("\\s+", " ");
    }

    public static void closeQuietly(InputStream input) {
        if (input == null) {
            return;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream output) {
        if (output == null) {
            return;
        }
        try {
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Reader input) {
        if (input == null) {
            return;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String toString(InputStream input, String encoding) throws IOException {
        StringWriter sw = new StringWriter();
        GrouperClientCommonUtils.copy(input, sw, encoding);
        return sw.toString();
    }

    public static void copy(InputStream input, Writer output, String encoding) throws IOException {
        InputStreamReader in = new InputStreamReader(input, encoding);
        GrouperClientCommonUtils.copy(in, output);
    }

    public static int copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static String convertLongToChar(long theLong) {
        if (theLong < 0L || theLong >= 62L) {
            throw new RuntimeException("convertLongToChar()  invalid input (not >=0 && <62: " + theLong);
        }
        if (theLong < 26L) {
            return EMPTY + (char)(97L + theLong);
        }
        if (theLong < 52L) {
            return EMPTY + (char)(65L + (theLong - 26L));
        }
        return EMPTY + (char)(48L + (theLong - 52L));
    }

    public static String convertLongToCharSmall(long theLong) {
        if (theLong < 0L || theLong >= 36L) {
            throw new RuntimeException("convertLongToCharSmall()  invalid input (not >=0 && <36: " + theLong);
        }
        if (theLong < 26L) {
            return EMPTY + (char)(65L + theLong);
        }
        return EMPTY + (char)(48L + (theLong - 26L));
    }

    public static String convertLongToString(long theLong) {
        long quotient = theLong / 62L;
        long remainder = theLong % 62L;
        if (quotient == 0L) {
            return GrouperClientCommonUtils.convertLongToChar(remainder);
        }
        StringBuffer result = new StringBuffer();
        result.append(GrouperClientCommonUtils.convertLongToString(quotient));
        result.append(GrouperClientCommonUtils.convertLongToChar(remainder));
        return result.toString();
    }

    public static String convertLongToStringSmall(long theLong) {
        long quotient = theLong / 36L;
        long remainder = theLong % 36L;
        if (quotient == 0L) {
            return GrouperClientCommonUtils.convertLongToCharSmall(remainder);
        }
        StringBuffer result = new StringBuffer();
        result.append(GrouperClientCommonUtils.convertLongToStringSmall(quotient));
        result.append(GrouperClientCommonUtils.convertLongToCharSmall(remainder));
        return result.toString();
    }

    public static char incrementChar(char theChar) {
        if (theChar == 'Z') {
            return '0';
        }
        if (theChar == '9') {
            return 'A';
        }
        theChar = (char)(theChar + '\u0001');
        return theChar;
    }

    public static char[] incrementStringInt(char[] string) {
        if (string == null) {
            return string;
        }
        int i = 0;
        for (i = string.length - 1; i >= 0; --i) {
            char inc = string[i];
            string[i] = inc = GrouperClientCommonUtils.incrementChar(inc);
            if (inc != 'A') break;
        }
        if (i < 0) {
            return ("A" + new String(string)).toCharArray();
        }
        return string;
    }

    public static synchronized Properties propertiesFromResourceName(String resourceName) {
        return GrouperClientCommonUtils.propertiesFromResourceName(resourceName, true, true, null, null);
    }

    public static void propertiesCacheClear() {
        resourcePropertiesCache.clear();
    }

    public static Properties propertiesFromFile(File file) {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
        }
        catch (IOException ioe) {
            try {
                throw new RuntimeException("Problem reading file into properties: " + file.getAbsolutePath());
            }
            catch (Throwable throwable) {
                GrouperClientCommonUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        GrouperClientCommonUtils.closeQuietly(fileInputStream);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Properties propertiesFromResourceName(String resourceName, boolean useCache, boolean exceptionIfNotExist, Class<?> classInJar, StringBuilder callingLog) {
        Properties properties = resourcePropertiesCache.get(resourceName);
        if (!useCache || !resourcePropertiesCache.containsKey(resourceName)) {
            properties = new Properties();
            boolean success = false;
            URL url = GrouperClientCommonUtils.computeUrl(resourceName, true);
            InputStream inputStream = null;
            try {
                inputStream = url.openStream();
                properties.load(inputStream);
                success = true;
                String theLog = "Reading resource: " + resourceName + ", from: " + url.toURI();
                if (LOG != null) {
                    LOG.debug(theLog);
                }
                if (callingLog != null) {
                    callingLog.append(theLog);
                }
                if (GrouperClientLog.debugToConsoleByFlag()) {
                    System.err.println(theLog);
                }
            }
            catch (Exception e) {
                block19: {
                    properties.clear();
                    File jarFile = classInJar == null ? null : GrouperClientCommonUtils.jarFile(classInJar);
                    File parentDir = jarFile == null ? null : jarFile.getParentFile();
                    String fileName = parentDir == null ? null : GrouperClientCommonUtils.stripLastSlashIfExists(GrouperClientCommonUtils.fileCanonicalPath(parentDir)) + File.separator + resourceName;
                    File configFile = fileName == null ? null : new File(fileName);
                    try {
                        if (configFile != null && configFile.exists() && configFile.isFile()) {
                            inputStream = new FileInputStream(configFile);
                            properties.load(inputStream);
                            success = true;
                            String theLog = "Reading resource: " + resourceName + ", from: " + GrouperClientCommonUtils.fileCanonicalPath(configFile);
                            if (LOG != null) {
                                LOG.debug(theLog);
                            }
                            if (callingLog != null) {
                                callingLog.append(theLog);
                            }
                            if (GrouperClientLog.debugToConsoleByFlag()) {
                                System.err.println(theLog);
                            }
                        }
                    }
                    catch (Exception e2) {
                        if (LOG == null) break block19;
                        LOG.debug("Error reading from file for resource: " + resourceName + ", file: " + fileName, e2);
                    }
                }
                if (!success) {
                    properties = null;
                    if (exceptionIfNotExist) {
                        throw new RuntimeException("Problem with resource: '" + resourceName + "'", e);
                    }
                }
            }
            finally {
                GrouperClientCommonUtils.closeQuietly(inputStream);
                if (useCache && properties != null && properties.size() > 0) {
                    resourcePropertiesCache.put(resourceName, properties);
                }
            }
        }
        return properties;
    }

    public static <E extends Enum<?>> E enumValueOfIgnoreCase(Class<E> theEnumClass, String string, boolean exceptionOnNotFound) throws RuntimeException {
        if (!exceptionOnNotFound && GrouperClientCommonUtils.isBlank(string)) {
            return null;
        }
        for (Enum e : (Enum[])theEnumClass.getEnumConstants()) {
            if (!GrouperClientCommonUtils.equalsIgnoreCase(string, e.name())) continue;
            return (E)e;
        }
        StringBuilder error = new StringBuilder("Cant find " + theEnumClass.getSimpleName() + " from string: '").append(string);
        error.append("', expecting one of: ");
        for (Enum e : (Enum[])theEnumClass.getEnumConstants()) {
            error.append(e.name()).append(", ");
        }
        throw new RuntimeException(error.toString());
    }

    public static Object propertyValue(Object object, String property) {
        Method getter = GrouperClientCommonUtils.getter(object.getClass(), property, true, true);
        Object result = GrouperClientCommonUtils.invokeMethod(getter, object);
        return result;
    }

    public static String propertiesValue(Properties properties, String key) {
        return GrouperClientCommonUtils.propertiesValue(properties, null, key);
    }

    public static String propertiesValue(Properties properties, Map<String, String> overrideMap, String key) {
        return GrouperClientCommonUtils.propertiesValue(properties, overrideMap, null, key);
    }

    public static String propertiesValue(Properties properties, Map<String, String> overrideMap, Map<String, String> overrideMap2, String key) {
        String value;
        String string = value = overrideMap == null ? null : overrideMap.get(key);
        if (GrouperClientCommonUtils.isBlank(value)) {
            String string2 = value = overrideMap2 == null ? null : overrideMap2.get(key);
        }
        if (GrouperClientCommonUtils.isBlank(value)) {
            value = properties.getProperty(key);
        }
        value = GrouperClientCommonUtils.trim(value);
        value = GrouperClientCommonUtils.substituteCommonVars(value);
        return value;
    }

    public static String substituteCommonVars(String string) {
        if (string == null) {
            return string;
        }
        if (string.indexOf(36) < 0) {
            return string;
        }
        string = GrouperClientCommonUtils.replace(string, "$space$", " ");
        string = GrouperClientCommonUtils.replace(string, "$newline$", "\n");
        return string;
    }

    public static boolean propertiesValueBoolean(Properties properties, String propertyName, boolean defaultValue) {
        return GrouperClientCommonUtils.propertiesValueBoolean(properties, null, propertyName, defaultValue);
    }

    public static boolean propertiesValueBoolean(String resourceName, Properties properties, Map<String, String> overrideMap, String propertyName, boolean defaultValue, boolean required) {
        GrouperClientCommonUtils.propertyValidateValueBoolean(resourceName, properties, overrideMap, propertyName, required, true);
        Map<String, String> threadLocalMap = GrouperClientCommonUtils.propertiesThreadLocalOverrideMap(resourceName);
        return GrouperClientCommonUtils.propertiesValueBoolean(properties, threadLocalMap, overrideMap, propertyName, defaultValue);
    }

    public static int propertiesValueInt(String resourceName, Properties properties, Map<String, String> overrideMap, String propertyName, int defaultValue, boolean required) {
        GrouperClientCommonUtils.propertyValidateValueInt(resourceName, properties, overrideMap, propertyName, required, true);
        Map<String, String> threadLocalMap = GrouperClientCommonUtils.propertiesThreadLocalOverrideMap(resourceName);
        return GrouperClientCommonUtils.propertiesValueInt(properties, threadLocalMap, overrideMap, propertyName, defaultValue);
    }

    public static String propertiesValue(String resourceName, Properties properties, Map<String, String> overrideMap, String propertyName, boolean required) {
        if (required) {
            GrouperClientCommonUtils.propertyValidateValueRequired(resourceName, properties, overrideMap, propertyName, true);
        }
        Map<String, String> threadLocalMap = GrouperClientCommonUtils.propertiesThreadLocalOverrideMap(resourceName);
        return GrouperClientCommonUtils.propertiesValue(properties, threadLocalMap, overrideMap, propertyName);
    }

    public static int propertiesValueInt(Properties properties, Map<String, String> overrideMap, String propertyName, int defaultValue) {
        return GrouperClientCommonUtils.propertiesValueInt(properties, overrideMap, null, propertyName, defaultValue);
    }

    public static int propertiesValueInt(Properties properties, Map<String, String> overrideMap, Map<String, String> overrideMap2, String propertyName, int defaultValue) {
        String value = GrouperClientCommonUtils.propertiesValue(properties, overrideMap, overrideMap2, propertyName);
        if (GrouperClientCommonUtils.isBlank(value)) {
            return defaultValue;
        }
        try {
            return GrouperClientCommonUtils.intValue(value);
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid int value: '" + value + "' for property: " + propertyName + " in grouper.properties");
        }
    }

    public static boolean propertiesValueBoolean(Properties properties, Map<String, String> overrideMap, String propertyName, boolean defaultValue) {
        return GrouperClientCommonUtils.propertiesValueBoolean(properties, overrideMap, null, propertyName, defaultValue);
    }

    public static boolean propertiesValueBoolean(Properties properties, Map<String, String> overrideMap, Map<String, String> overrideMap2, String propertyName, boolean defaultValue) {
        String value = GrouperClientCommonUtils.propertiesValue(properties, overrideMap, overrideMap2, propertyName);
        if (GrouperClientCommonUtils.isBlank(value)) {
            return defaultValue;
        }
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        if ("t".equalsIgnoreCase(value)) {
            return true;
        }
        if ("f".equalsIgnoreCase(value)) {
            return false;
        }
        throw new RuntimeException("Invalid boolean value: '" + value + "' for property: " + propertyName + " in properties file");
    }

    public static Map<?, ?> toMap(Object ... keysAndValues) {
        if (keysAndValues == null) {
            return null;
        }
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        if (GrouperClientUtils.length(keysAndValues) > 0) {
            if (keysAndValues.length % 2 != 0) {
                throw new RuntimeException("Must have an even number of keys and values");
            }
            for (int i = 0; i < keysAndValues.length; i += 2) {
                result.put(keysAndValues[i], keysAndValues[i + 1]);
            }
        }
        return result;
    }

    public static void closeQuietly(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Cant close connection!");
            }
        }
    }

    public static void closeQuietly(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String hostname() {
        if (GrouperClientCommonUtils.isBlank(hostname)) {
            hostname = "unknown";
            try {
                InetAddress addr = InetAddress.getLocalHost();
                hostname = addr.getHostName();
            }
            catch (Exception e) {
                System.err.println("Cant find servers hostname: ");
                e.printStackTrace();
            }
        }
        return hostname;
    }

    public static boolean isAscii(char input) {
        return input < '\u0080';
    }

    public static int lengthAscii(String input) {
        if (input == null) {
            return 0;
        }
        int utfLength = input.length();
        int extras = 0;
        for (int i = 0; i < utfLength; ++i) {
            if (GrouperClientCommonUtils.isAscii(input.charAt(i))) continue;
            ++extras;
        }
        return utfLength + extras;
    }

    public static void rollbackQuietly(Connection connection) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String truncateAscii(String input, int requiredLength) {
        if (input == null) {
            return input;
        }
        int utfLength = input.length();
        if (utfLength * 2 < requiredLength) {
            return input;
        }
        int asciiLength = 0;
        for (int i = 0; i < utfLength; ++i) {
            ++asciiLength;
            if (!GrouperClientCommonUtils.isAscii(input.charAt(i))) {
                ++asciiLength;
            }
            if (asciiLength <= requiredLength) continue;
            return input.substring(0, i);
        }
        return input;
    }

    public static String readFromFileIfFile(String in, boolean disableExternalFileLookup) {
        String theIn = in;
        theIn = File.separatorChar == '/' ? GrouperClientCommonUtils.replace(theIn, "\\", "/") : GrouperClientCommonUtils.replace(theIn, "/", "\\");
        if (theIn.indexOf(File.separatorChar) != -1 && !disableExternalFileLookup) {
            theIn = GrouperClientCommonUtils.readFileIntoString(new File(theIn));
            return theIn;
        }
        return in;
    }

    public static String readFromFileIfFileExists(String in, boolean disableExternalFileLookup) {
        String theIn = in;
        theIn = File.separatorChar == '/' ? GrouperClientCommonUtils.replace(theIn, "\\", "/") : GrouperClientCommonUtils.replace(theIn, "/", "\\");
        if (theIn.indexOf(File.separatorChar) != -1 && !disableExternalFileLookup && new File(theIn).exists()) {
            theIn = GrouperClientCommonUtils.readFileIntoString(new File(theIn));
            return theIn;
        }
        return in;
    }

    public static void mkdirs(File dir) {
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new RuntimeException("Could not create directory : " + dir.getParentFile());
            }
            return;
        }
        if (!dir.isDirectory()) {
            throw new RuntimeException("Should be a directory but is not: " + dir);
        }
    }

    public static boolean equals(String first, String second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        return first.equals(second);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !GrouperClientCommonUtils.isBlank(str);
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static String trimToEmpty(String str) {
        return str == null ? EMPTY : str.trim();
    }

    public static String abbreviate(String str, int maxWidth) {
        return GrouperClientCommonUtils.abbreviate(str, 0, maxWidth);
    }

    public static String abbreviate(String str, int offset, int maxWidth) {
        if (str == null) {
            return null;
        }
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        if (offset > str.length()) {
            offset = str.length();
        }
        if (str.length() - offset < maxWidth - 3) {
            offset = str.length() - (maxWidth - 3);
        }
        if (offset <= 4) {
            return str.substring(0, maxWidth - 3) + "...";
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (offset + (maxWidth - 3) < str.length()) {
            return "..." + GrouperClientCommonUtils.abbreviate(str.substring(offset), maxWidth - 3);
        }
        return "..." + str.substring(str.length() - (maxWidth - 3));
    }

    public static String[] split(String str) {
        return GrouperClientCommonUtils.split(str, null, -1);
    }

    public static String[] split(String str, char separatorChar) {
        return GrouperClientCommonUtils.splitWorker(str, separatorChar, false);
    }

    public static String[] split(String str, String separatorChars) {
        return GrouperClientCommonUtils.splitWorker(str, separatorChars, -1, false);
    }

    public static String[] split(String str, String separatorChars, int max) {
        return GrouperClientCommonUtils.splitWorker(str, separatorChars, max, false);
    }

    public static String[] splitByWholeSeparator(String str, String separator) {
        return GrouperClientCommonUtils.splitByWholeSeparator(str, separator, -1);
    }

    public static String[] splitByWholeSeparator(String str, String separator, int max) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        if (separator == null || EMPTY.equals(separator)) {
            return GrouperClientCommonUtils.split(str, null, max);
        }
        int separatorLength = separator.length();
        ArrayList<String> substrings = new ArrayList<String>();
        int numberOfSubstrings = 0;
        int beg = 0;
        int end = 0;
        while (end < len) {
            end = str.indexOf(separator, beg);
            if (end > -1) {
                if (end > beg) {
                    if (++numberOfSubstrings == max) {
                        end = len;
                        substrings.add(str.substring(beg));
                        continue;
                    }
                    substrings.add(str.substring(beg, end));
                    beg = end + separatorLength;
                    continue;
                }
                beg = end + separatorLength;
                continue;
            }
            substrings.add(str.substring(beg));
            end = len;
        }
        return substrings.toArray(new String[substrings.size()]);
    }

    public static String[] splitPreserveAllTokens(String str) {
        return GrouperClientCommonUtils.splitWorker(str, null, -1, true);
    }

    public static String[] splitPreserveAllTokens(String str, char separatorChar) {
        return GrouperClientCommonUtils.splitWorker(str, separatorChar, true);
    }

    private static String[] splitWorker(String str, char separatorChar, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] splitPreserveAllTokens(String str, String separatorChars) {
        return GrouperClientCommonUtils.splitWorker(str, separatorChars, -1, true);
    }

    public static String[] splitPreserveAllTokens(String str, String separatorChars, int max) {
        return GrouperClientCommonUtils.splitWorker(str, separatorChars, max, true);
    }

    private static String[] splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String join(Object[] array) {
        return GrouperClientCommonUtils.join(array, null);
    }

    public static String join(Object[] array, char separator) {
        if (array == null) {
            return null;
        }
        int arraySize = array.length;
        int bufSize = arraySize == 0 ? 0 : ((array[0] == null ? 16 : array[0].toString().length()) + 1) * arraySize;
        StringBuffer buf = new StringBuffer(bufSize);
        for (int i = 0; i < arraySize; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String join(Object[] array, String separator) {
        int arraySize;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = EMPTY;
        }
        int bufSize = (arraySize = array.length) == 0 ? 0 : arraySize * ((array[0] == null ? 16 : array[0].toString().length()) + separator.length());
        StringBuffer buf = new StringBuffer(bufSize);
        for (int i = 0; i < arraySize; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String join(Iterator iterator, char separator) {
        if (iterator == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(256);
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj != null) {
                buf.append(obj);
            }
            if (!iterator.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static String join(Iterator iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(256);
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj != null) {
                buf.append(obj);
            }
            if (separator == null || !iterator.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static String defaultString(String str) {
        return str == null ? EMPTY : str;
    }

    public static String defaultString(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public static String defaultIfEmpty(String str, String defaultStr) {
        return GrouperClientCommonUtils.isEmpty(str) ? defaultStr : str;
    }

    public static String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuffer(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static boolean contains(String str, char searchChar) {
        if (GrouperClientCommonUtils.isEmpty(str)) {
            return false;
        }
        return str.indexOf(searchChar) >= 0;
    }

    public static boolean contains(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        return str.indexOf(searchStr) >= 0;
    }

    public static boolean equals(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        return object1.equals(object2);
    }

    public static String getFullStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        Throwable[] ts = GrouperClientCommonUtils.getThrowables(throwable);
        for (int i = 0; i < ts.length; ++i) {
            ts[i].printStackTrace(pw);
            if (GrouperClientCommonUtils.isNestedThrowable(ts[i])) break;
        }
        return sw.getBuffer().toString();
    }

    public static Throwable[] getThrowables(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null) {
            list.add(throwable);
            throwable = GrouperClientCommonUtils.getCause(throwable);
        }
        return list.toArray(new Throwable[list.size()]);
    }

    public static boolean isNestedThrowable(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof SQLException) {
            return true;
        }
        if (throwable instanceof InvocationTargetException) {
            return true;
        }
        if (GrouperClientCommonUtils.isThrowableNested()) {
            return true;
        }
        Class<?> cls = throwable.getClass();
        int isize = CAUSE_METHOD_NAMES.length;
        for (int i = 0; i < isize; ++i) {
            try {
                Method method = cls.getMethod(CAUSE_METHOD_NAMES[i], null);
                if (method == null || !Throwable.class.isAssignableFrom(method.getReturnType())) continue;
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        try {
            Field field = cls.getField("detail");
            if (field != null) {
                return true;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isThrowableNested() {
        return THROWABLE_CAUSE_METHOD != null;
    }

    public static Throwable getCause(Throwable throwable) {
        return GrouperClientCommonUtils.getCause(throwable, CAUSE_METHOD_NAMES);
    }

    public static Throwable getCause(Throwable throwable, String[] methodNames) {
        if (throwable == null) {
            return null;
        }
        Throwable cause = GrouperClientCommonUtils.getCauseUsingWellKnownTypes(throwable);
        if (cause == null) {
            String methodName;
            if (methodNames == null) {
                methodNames = CAUSE_METHOD_NAMES;
            }
            for (int i = 0; i < methodNames.length && ((methodName = methodNames[i]) == null || (cause = GrouperClientCommonUtils.getCauseUsingMethodName(throwable, methodName)) == null); ++i) {
            }
            if (cause == null) {
                cause = GrouperClientCommonUtils.getCauseUsingFieldName(throwable, "detail");
            }
        }
        return cause;
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable, String methodName) {
        Method method = null;
        try {
            method = throwable.getClass().getMethod(methodName, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (method != null && Throwable.class.isAssignableFrom(method.getReturnType())) {
            try {
                return (Throwable)method.invoke((Object)throwable, EMPTY_OBJECT_ARRAY);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Throwable getCauseUsingFieldName(Throwable throwable, String fieldName) {
        Field field = null;
        try {
            field = throwable.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (field != null && Throwable.class.isAssignableFrom(field.getType())) {
            try {
                return (Throwable)field.get(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Throwable getCauseUsingWellKnownTypes(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return ((SQLException)throwable).getNextException();
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        return null;
    }

    public static String argKey(String option) {
        int equalsIndex = option.indexOf("=");
        if (equalsIndex == -1) {
            throw new RuntimeException("Invalid option: " + option + ", it should look like: --someOption=someValue");
        }
        String key = option.substring(0, equalsIndex);
        if (!key.startsWith("--")) {
            throw new RuntimeException("Invalid option: " + option + ", it should look like: --someOption=someValue");
        }
        key = key.substring(2);
        return key;
    }

    public static String argValue(String option) {
        int equalsIndex = option.indexOf("=");
        if (equalsIndex == -1) {
            throw new RuntimeException("Invalid option: " + option + ", it should look like: --someOption=someValue");
        }
        String value = option.substring(equalsIndex + 1, option.length());
        return value;
    }

    public static Map<String, String> argMap(String[] args) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String arg : GrouperClientCommonUtils.nonNull(args, String.class)) {
            String key = GrouperClientCommonUtils.argKey(arg);
            String value = GrouperClientCommonUtils.argValue(arg);
            if (result.containsKey(key)) {
                throw new RuntimeException("Passing key twice: " + key);
            }
            result.put(key, value);
        }
        return result;
    }

    public static String argMapString(Map<String, String> argMap, Map<String, String> argMapNotUsed, String key, boolean required) {
        if (argMap.containsKey(key)) {
            argMapNotUsed.remove(key);
            return argMap.get(key);
        }
        if (required) {
            throw new RuntimeException("Argument '--" + key + "' is required, but not specified.  e.g. --" + key + "=value");
        }
        return null;
    }

    public static boolean argMapBoolean(Map<String, String> argMap, Map<String, String> argMapNotUsed, String key, boolean required, boolean defaultValue) {
        String argString = GrouperClientCommonUtils.argMapString(argMap, argMapNotUsed, key, required);
        if (GrouperClientCommonUtils.isBlank(argString) && required) {
            throw new RuntimeException("Argument '--" + key + "' is required, but not specified.  e.g. --" + key + "=true");
        }
        return GrouperClientCommonUtils.booleanValue(argString, defaultValue);
    }

    public static Timestamp argMapTimestamp(Map<String, String> argMap, Map<String, String> argMapNotUsed, String key) {
        String argString = GrouperClientCommonUtils.argMapString(argMap, argMapNotUsed, key, false);
        if (GrouperClientCommonUtils.isBlank(argString)) {
            return null;
        }
        Date date = GrouperClientCommonUtils.stringToDate2(argString);
        return new Timestamp(date.getTime());
    }

    public static Boolean argMapBoolean(Map<String, String> argMap, Map<String, String> argMapNotUsed, String key) {
        String argString = GrouperClientCommonUtils.argMapString(argMap, argMapNotUsed, key, false);
        return GrouperClientCommonUtils.booleanObjectValue(argString);
    }

    public static Set<String> argMapSet(Map<String, String> argMap, Map<String, String> argMapNotUsed, String key, boolean required) {
        List<String> list = GrouperClientCommonUtils.argMapList(argMap, argMapNotUsed, key, required);
        return list == null ? null : new LinkedHashSet<String>(list);
    }

    public static List<String> argMapList(Map<String, String> argMap, Map<String, String> argMapNotUsed, String key, boolean required) {
        String argString = GrouperClientCommonUtils.argMapString(argMap, argMapNotUsed, key, required);
        if (GrouperClientCommonUtils.isBlank(argString)) {
            return null;
        }
        return GrouperClientCommonUtils.splitTrimToList(argString, ",");
    }

    public static List<String> argMapFileList(Map<String, String> argMap, Map<String, String> argMapNotUsed, String key, boolean required) {
        String argString = GrouperClientCommonUtils.argMapString(argMap, argMapNotUsed, key, required);
        if (GrouperClientCommonUtils.isBlank(argString)) {
            return null;
        }
        File file = new File(argString);
        try {
            String listString = GrouperClientCommonUtils.readFileIntoString(file);
            String[] array = listString.split("\\s+");
            ArrayList<String> list = new ArrayList<String>();
            for (String string : array) {
                if (GrouperClientCommonUtils.isBlank(string)) continue;
                list.add(GrouperClientCommonUtils.trim(string));
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading file: '" + GrouperClientCommonUtils.fileCanonicalPath(file) + "' from command line arg: " + key, e);
        }
    }

    public static String responseBodyAsString(HttpMethodBase method) {
        String string;
        InputStream inputStream = null;
        try {
            StringWriter writer = new StringWriter();
            inputStream = method.getResponseBodyAsStream();
            GrouperClientCommonUtils.copy(inputStream, (Writer)writer);
            string = writer.toString();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                GrouperClientCommonUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        GrouperClientCommonUtils.closeQuietly(inputStream);
        return string;
    }

    public static void copy(InputStream input, Writer output) throws IOException {
        String charsetName = GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.default.fileEncoding");
        InputStreamReader in = new InputStreamReader(input, charsetName);
        GrouperClientCommonUtils.copy(in, output);
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = GrouperClientCommonUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static File jarFile(Class sampleClass) {
        try {
            CodeSource codeSource = sampleClass.getProtectionDomain().getCodeSource();
            if (codeSource != null && codeSource.getLocation() != null) {
                String fileName = URLDecoder.decode(codeSource.getLocation().getFile(), "UTF-8");
                return new File(fileName);
            }
            String resourcePath = sampleClass.getName();
            URL url = GrouperClientCommonUtils.computeUrl(resourcePath = resourcePath.replace('.', '/') + ".class", true);
            String urlPath = url.toString();
            if (urlPath.startsWith("jar:")) {
                urlPath = urlPath.substring(4);
            }
            if (urlPath.startsWith("file:")) {
                urlPath = urlPath.substring(5);
            }
            urlPath = GrouperClientCommonUtils.prefixOrSuffix(urlPath, "!", true);
            urlPath = URLDecoder.decode(urlPath, "UTF-8");
            File file = new File(urlPath);
            if (urlPath.endsWith(".jar") && file.exists() && file.isFile()) {
                return file;
            }
        }
        catch (Exception e) {
            LOG.warn("Cant find jar for class: " + sampleClass + ", " + e.getMessage(), e);
        }
        return null;
    }

    public static String stripLastSlashIfExists(String input) {
        if (input == null || input.length() == 0) {
            return null;
        }
        char lastChar = input.charAt(input.length() - 1);
        if (lastChar == '\\' || lastChar == '/') {
            return input.substring(0, input.length() - 1);
        }
        return input;
    }

    public static String retrievePasswordFromStdin(boolean dontMask, String prompt) {
        String passwordString = null;
        if (dontMask) {
            System.out.print(prompt);
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            try {
                passwordString = br.readLine();
            }
            catch (IOException ioe) {
                System.out.println("IO error! " + GrouperClientCommonUtils.getFullStackTrace(ioe));
                System.exit(1);
            }
        } else {
            char[] password = null;
            try {
                password = GrouperClientCommonUtils.retrievePasswordFromStdin(System.in, prompt);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            passwordString = String.valueOf(password);
        }
        return passwordString;
    }

    public static final char[] retrievePasswordFromStdin(InputStream in, String prompt) throws IOException {
        char[] lineBuffer;
        MaskingThread maskingthread = new MaskingThread(prompt);
        Thread thread = new Thread(maskingthread);
        thread.start();
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        maskingthread.stopMasking();
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }

    public static boolean propertyValidateValueRequired(String resourceName, Properties properties, Map<String, String> overrideMap, String key, boolean exceptionOnError) {
        Map<String, String> threadLocalMap = GrouperClientCommonUtils.propertiesThreadLocalOverrideMap(resourceName);
        String value = GrouperClientCommonUtils.propertiesValue(properties, threadLocalMap, overrideMap, key);
        if (!GrouperClientCommonUtils.isBlank(value)) {
            return true;
        }
        String error = "Cant find property " + key + " in resource: " + resourceName + ", it is required";
        if (exceptionOnError) {
            throw new RuntimeException(error);
        }
        System.err.println("Grouper error: " + error);
        LOG.error(error);
        return false;
    }

    public static String uuid() {
        String uuid = UUID.randomUUID().toString();
        char[] result = new char[32];
        int resultIndex = 0;
        for (int i = 0; i < uuid.length(); ++i) {
            char theChar = uuid.charAt(i);
            if (theChar == '-') continue;
            if (resultIndex >= result.length) {
                throw new RuntimeException("Why is resultIndex greater than result.length ???? " + resultIndex + " , " + result.length + ", " + uuid);
            }
            result[resultIndex++] = theChar;
        }
        return new String(result);
    }

    public static boolean propertyValidateValueBoolean(String resourceName, Properties properties, Map<String, String> overrideMap, String key, boolean required, boolean exceptionOnError) {
        if (required && !GrouperClientCommonUtils.propertyValidateValueRequired(resourceName, properties, overrideMap, key, exceptionOnError)) {
            return false;
        }
        Map<String, String> threadLocalMap = GrouperClientCommonUtils.propertiesThreadLocalOverrideMap(resourceName);
        String value = GrouperClientCommonUtils.propertiesValue(properties, threadLocalMap, overrideMap, key);
        if (!required && GrouperClientCommonUtils.isBlank(value)) {
            return true;
        }
        try {
            GrouperClientCommonUtils.booleanValue(value);
            return true;
        }
        catch (Exception exception) {
            String error = "Expecting true or false property " + key + " in resource: " + resourceName + ", but is '" + value + "'";
            if (exceptionOnError) {
                throw new RuntimeException(error);
            }
            System.err.println("Grouper error: " + error);
            LOG.error(error);
            return false;
        }
    }

    public static boolean propertyValidateValueInt(String resourceName, Properties properties, Map<String, String> overrideMap, String key, boolean required, boolean exceptionOnError) {
        if (required && !GrouperClientCommonUtils.propertyValidateValueRequired(resourceName, properties, overrideMap, key, exceptionOnError)) {
            return false;
        }
        Map<String, String> threadLocalMap = GrouperClientCommonUtils.propertiesThreadLocalOverrideMap(resourceName);
        String value = GrouperClientCommonUtils.propertiesValue(properties, threadLocalMap, overrideMap, key);
        if (!required && GrouperClientCommonUtils.isBlank(value)) {
            return true;
        }
        try {
            GrouperClientCommonUtils.intValue(value);
            return true;
        }
        catch (Exception exception) {
            String error = "Expecting integer property " + key + " in resource: " + resourceName + ", but is '" + value + "'";
            if (exceptionOnError) {
                throw new RuntimeException(error);
            }
            System.err.println("Grouper error: " + error);
            LOG.error(error);
            return false;
        }
    }

    public static boolean propertyValidateValueClass(String resourceName, Properties properties, Map<String, String> overrideMap, String key, Class<?> classType, boolean required, boolean exceptionOnError) {
        if (required && !GrouperClientCommonUtils.propertyValidateValueRequired(resourceName, properties, overrideMap, key, exceptionOnError)) {
            return false;
        }
        String value = GrouperClientCommonUtils.propertiesValue(properties, overrideMap, key);
        if (!required && GrouperClientCommonUtils.isBlank(value)) {
            return true;
        }
        String extraError = EMPTY;
        try {
            Class theClass = GrouperClientCommonUtils.forName(value);
            if (classType.isAssignableFrom(theClass)) {
                return true;
            }
            extraError = " does not derive from class: " + classType.getSimpleName();
        }
        catch (Exception e) {
            extraError = ", " + GrouperClientCommonUtils.getFullStackTrace(e);
        }
        String error = "Cant process property " + key + " in resource: " + resourceName + ", the current value is '" + value + "', which should be of type: " + classType.getName() + extraError;
        if (exceptionOnError) {
            throw new RuntimeException(error);
        }
        System.err.println("Grouper error: " + error);
        LOG.error(error);
        return false;
    }

    public static String stripStart(String str, String stripChars) {
        int start;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            for (start = 0; start != strLen && Character.isWhitespace(str.charAt(start)); ++start) {
            }
        } else {
            if (stripChars.length() == 0) {
                return str;
            }
            while (start != strLen && stripChars.indexOf(str.charAt(start)) != -1) {
                ++start;
            }
        }
        return str.substring(start);
    }

    public static String stripEnd(String str, String stripChars) {
        int end;
        if (str == null || (end = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.length() == 0) {
                return str;
            }
            while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return str.substring(0, end);
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return EMPTY;
        }
        int inputLength = str.length();
        if (repeat == 1 || inputLength == 0) {
            return str;
        }
        if (inputLength == 1 && repeat <= 8192) {
            return GrouperClientCommonUtils.padding(repeat, str.charAt(0));
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                char ch = str.charAt(0);
                char[] output1 = new char[outputLength];
                for (int i = repeat - 1; i >= 0; --i) {
                    output1[i] = ch;
                }
                return new String(output1);
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                for (int i = repeat * 2 - 2; i >= 0; --i) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                }
                return new String(output2);
            }
        }
        StringBuffer buf = new StringBuffer(outputLength);
        for (int i = 0; i < repeat; ++i) {
            buf.append(str);
        }
        return buf.toString();
    }

    private static String padding(int repeat, char padChar) {
        String pad = PADDING[padChar];
        if (pad == null) {
            pad = String.valueOf(padChar);
        }
        while (pad.length() < repeat) {
            pad = pad.concat(pad);
        }
        GrouperClientCommonUtils.PADDING[padChar] = pad;
        return pad.substring(0, repeat);
    }

    public static String rightPad(String str, int size) {
        return GrouperClientCommonUtils.rightPad(str, size, ' ');
    }

    public static String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return GrouperClientCommonUtils.rightPad(str, size, String.valueOf(padChar));
        }
        return str.concat(GrouperClientCommonUtils.padding(pads, padChar));
    }

    public static String rightPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (GrouperClientCommonUtils.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return GrouperClientCommonUtils.rightPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return str.concat(new String(padding));
    }

    public static String leftPad(String str, int size) {
        return GrouperClientCommonUtils.leftPad(str, size, ' ');
    }

    public static String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return GrouperClientCommonUtils.leftPad(str, size, String.valueOf(padChar));
        }
        return GrouperClientCommonUtils.padding(pads, padChar).concat(str);
    }

    public static String leftPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (GrouperClientCommonUtils.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return GrouperClientCommonUtils.leftPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str);
    }

    public static void convertToRuntimeException(Exception e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e.getMessage(), e);
    }

    public static String substringBefore(String str, String separator) {
        if (GrouperClientCommonUtils.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.length() == 0) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfter(String str, String separator) {
        if (GrouperClientCommonUtils.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static String substringBeforeLast(String str, String separator) {
        if (GrouperClientCommonUtils.isEmpty(str) || GrouperClientCommonUtils.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfterLast(String str, String separator) {
        if (GrouperClientCommonUtils.isEmpty(str)) {
            return str;
        }
        if (GrouperClientCommonUtils.isEmpty(separator)) {
            return EMPTY;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static Integer argMapInteger(Map<String, String> argMap, Map<String, String> argMapNotUsed, String key, boolean required, Integer defaultValue) {
        String argString = GrouperClientCommonUtils.argMapString(argMap, argMapNotUsed, key, required);
        if (GrouperClientCommonUtils.isBlank(argString) && required) {
            throw new RuntimeException("Argument '--" + key + "' is required, but not specified.  e.g. --" + key + "=5");
        }
        if (GrouperClientCommonUtils.isBlank(argString)) {
            if (defaultValue != null) {
                return defaultValue;
            }
            return null;
        }
        return GrouperClientCommonUtils.intValue(argString);
    }

    public static java.sql.Date toSqlDate(Date date) {
        if (date == null) {
            return null;
        }
        return new java.sql.Date(date.getTime());
    }

    public static int indexOf(Object[] array, Object objectToFind) {
        return GrouperClientCommonUtils.indexOf(array, objectToFind, 0);
    }

    public static boolean contains(Object[] array, Object objectToFind) {
        return GrouperClientCommonUtils.indexOf(array, objectToFind) != -1;
    }

    public static int indexOf(Object[] array, Object objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (objectToFind == null) {
            for (int i = startIndex; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i < array.length; ++i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static String dateToString(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        return simpleDateFormat.format(date);
    }

    public static Date stringToDate(String dateString) {
        if (GrouperClientCommonUtils.isBlank(dateString)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        try {
            return simpleDateFormat.parse(dateString);
        }
        catch (ParseException e) {
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(WS_DATE_FORMAT2);
            try {
                return simpleDateFormat2.parse(dateString);
            }
            catch (ParseException e2) {
                throw new RuntimeException("Cannot convert '" + dateString + "' to a date based on format: " + "yyyy/MM/dd HH:mm:ss.SSS", e);
            }
        }
    }

    public static Date stringToDate2(String input) {
        if (GrouperClientCommonUtils.isBlank(input)) {
            return null;
        }
        input = input.trim();
        Matcher matcher = null;
        int month = 0;
        int day = 0;
        int year = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int milli = 0;
        boolean foundMatch = false;
        if (!foundMatch && (matcher = datePattern_yyyy_mm_dd.matcher(input)).matches()) {
            year = GrouperClientCommonUtils.intValue(matcher.group(1));
            month = GrouperClientCommonUtils.intValue(matcher.group(2));
            day = GrouperClientCommonUtils.intValue(matcher.group(3));
            foundMatch = true;
        }
        if (!foundMatch && (matcher = datePattern_dd_mon_yyyy.matcher(input)).matches()) {
            day = GrouperClientCommonUtils.intValue(matcher.group(1));
            month = GrouperClientCommonUtils.monthInt(matcher.group(2));
            year = GrouperClientCommonUtils.intValue(matcher.group(3));
            foundMatch = true;
        }
        if (!foundMatch && (matcher = datePattern_yyyy_mm_dd_hhmmss.matcher(input)).matches()) {
            year = GrouperClientCommonUtils.intValue(matcher.group(1));
            month = GrouperClientCommonUtils.intValue(matcher.group(2));
            day = GrouperClientCommonUtils.intValue(matcher.group(3));
            hour = GrouperClientCommonUtils.intValue(matcher.group(4));
            minute = GrouperClientCommonUtils.intValue(matcher.group(5));
            second = GrouperClientCommonUtils.intValue(matcher.group(6));
            foundMatch = true;
        }
        if (!foundMatch && (matcher = datePattern_dd_mon_yyyy_hhmmss.matcher(input)).matches()) {
            day = GrouperClientCommonUtils.intValue(matcher.group(1));
            month = GrouperClientCommonUtils.monthInt(matcher.group(2));
            year = GrouperClientCommonUtils.intValue(matcher.group(3));
            hour = GrouperClientCommonUtils.intValue(matcher.group(4));
            minute = GrouperClientCommonUtils.intValue(matcher.group(5));
            second = GrouperClientCommonUtils.intValue(matcher.group(6));
            foundMatch = true;
        }
        if (!foundMatch && (matcher = datePattern_yyyy_mm_dd_hhmmss_SSS.matcher(input)).matches()) {
            year = GrouperClientCommonUtils.intValue(matcher.group(1));
            month = GrouperClientCommonUtils.intValue(matcher.group(2));
            day = GrouperClientCommonUtils.intValue(matcher.group(3));
            hour = GrouperClientCommonUtils.intValue(matcher.group(4));
            minute = GrouperClientCommonUtils.intValue(matcher.group(5));
            second = GrouperClientCommonUtils.intValue(matcher.group(6));
            milli = GrouperClientCommonUtils.intValue(matcher.group(7));
            foundMatch = true;
        }
        if (!foundMatch && (matcher = datePattern_dd_mon_yyyy_hhmmss_SSS.matcher(input)).matches()) {
            day = GrouperClientCommonUtils.intValue(matcher.group(1));
            month = GrouperClientCommonUtils.monthInt(matcher.group(2));
            year = GrouperClientCommonUtils.intValue(matcher.group(3));
            hour = GrouperClientCommonUtils.intValue(matcher.group(4));
            minute = GrouperClientCommonUtils.intValue(matcher.group(5));
            second = GrouperClientCommonUtils.intValue(matcher.group(6));
            milli = GrouperClientCommonUtils.intValue(matcher.group(7));
            foundMatch = true;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, milli);
        return calendar.getTime();
    }

    public static int monthInt(String mon) {
        if (!GrouperClientCommonUtils.isBlank(mon)) {
            if (GrouperClientCommonUtils.equals(mon = mon.toLowerCase(), "jan") || GrouperClientCommonUtils.equals(mon, "january")) {
                return 1;
            }
            if (GrouperClientCommonUtils.equals(mon, "feb") || GrouperClientCommonUtils.equals(mon, "february")) {
                return 2;
            }
            if (GrouperClientCommonUtils.equals(mon, "mar") || GrouperClientCommonUtils.equals(mon, "march")) {
                return 3;
            }
            if (GrouperClientCommonUtils.equals(mon, "apr") || GrouperClientCommonUtils.equals(mon, "april")) {
                return 4;
            }
            if (GrouperClientCommonUtils.equals(mon, "may")) {
                return 5;
            }
            if (GrouperClientCommonUtils.equals(mon, "jun") || GrouperClientCommonUtils.equals(mon, "june")) {
                return 6;
            }
            if (GrouperClientCommonUtils.equals(mon, "jul") || GrouperClientCommonUtils.equals(mon, "july")) {
                return 7;
            }
            if (GrouperClientCommonUtils.equals(mon, "aug") || GrouperClientCommonUtils.equals(mon, "august")) {
                return 8;
            }
            if (GrouperClientCommonUtils.equals(mon, "sep") || GrouperClientCommonUtils.equals(mon, "september")) {
                return 9;
            }
            if (GrouperClientCommonUtils.equals(mon, "oct") || GrouperClientCommonUtils.equals(mon, "october")) {
                return 10;
            }
            if (GrouperClientCommonUtils.equals(mon, "nov") || GrouperClientCommonUtils.equals(mon, "november")) {
                return 11;
            }
            if (GrouperClientCommonUtils.equals(mon, "dec") || GrouperClientCommonUtils.equals(mon, "december")) {
                return 12;
            }
        }
        throw new RuntimeException("Invalid month: " + mon);
    }

    public static Map<String, String> propertiesThreadLocalOverrideMap(String propertiesFileName) {
        Map<String, String> propertiesOverrideMap;
        Map<String, Map<String, String>> overrideMap = propertiesThreadLocalOverrideMap.get();
        if (overrideMap == null) {
            overrideMap = new HashMap<String, Map<String, String>>();
            propertiesThreadLocalOverrideMap.set(overrideMap);
        }
        if ((propertiesOverrideMap = overrideMap.get(propertiesFileName)) == null) {
            propertiesOverrideMap = new HashMap<String, String>();
            overrideMap.put(propertiesFileName, propertiesOverrideMap);
        }
        return propertiesOverrideMap;
    }

    public static void execCommand(String command) {
        String[] args = GrouperClientCommonUtils.splitTrim(command, " ");
        GrouperClientCommonUtils.execCommand(args);
    }

    public static CommandResult execCommand(String[] arguments) {
        return GrouperClientCommonUtils.execCommand(arguments, true);
    }

    public static ExecutorService retrieveExecutorService() {
        return executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommandResult execCommand(String[] arguments, boolean exceptionOnExitValueNeZero) {
        Process process = null;
        StringBuilder commandBuilder = new StringBuilder();
        for (int i = 0; i < arguments.length; ++i) {
            commandBuilder.append(arguments[i]).append(" ");
        }
        String command = commandBuilder.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running command: " + command);
        }
        StreamGobbler outputGobbler = null;
        StreamGobbler errorGobbler = null;
        try {
            process = Runtime.getRuntime().exec(arguments);
            outputGobbler = new StreamGobbler(process.getInputStream(), ".out", command);
            errorGobbler = new StreamGobbler(process.getErrorStream(), ".err", command);
            Future futureOutput = GrouperClientCommonUtils.retrieveExecutorService().submit(outputGobbler);
            Future futureError = GrouperClientCommonUtils.retrieveExecutorService().submit(errorGobbler);
            try {
                process.waitFor();
            }
            finally {
                futureOutput.get();
                futureError.get();
            }
        }
        catch (Exception e) {
            LOG.error("Error running command: " + command, e);
            throw new RuntimeException("Error running command", e);
        }
        finally {
            try {
                process.destroy();
            }
            catch (Exception exception) {}
        }
        if (process.exitValue() != 0 && exceptionOnExitValueNeZero) {
            String message = "Process exit status=" + process.exitValue() + ": out: " + (outputGobbler == null ? null : outputGobbler.getResultString()) + ", err: " + (errorGobbler == null ? null : errorGobbler.getResultString());
            LOG.error(message + ", on command: " + command);
            throw new RuntimeException(message);
        }
        int exitValue = process.exitValue();
        return new CommandResult(outputGobbler.getResultString(), errorGobbler.getResultString(), exitValue);
    }

    public static void serializeObjectToFile(Serializable object, File file) {
        GrouperClientCommonUtils.deleteCreateFile(file);
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(file);
            out = new ObjectOutputStream(fos);
            out.writeObject(object);
        }
        catch (IOException ex) {
            try {
                GrouperClientCommonUtils.closeQuietly(out);
                out = null;
                GrouperClientCommonUtils.deleteFile(file);
                throw new RuntimeException("Error writing file: " + GrouperClientCommonUtils.absolutePath(file) + ", " + GrouperClientCommonUtils.className(object), ex);
            }
            catch (Throwable throwable) {
                GrouperClientCommonUtils.closeQuietly(out);
                throw throwable;
            }
        }
        GrouperClientCommonUtils.closeQuietly(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable unserializeObjectFromFile(File file, boolean nullIfException, boolean deleteFileOnException) {
        Serializable serializable;
        if (!file.exists() || file.length() == 0L) {
            return null;
        }
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(file);
            ois = new ObjectInputStream(fis);
            serializable = (Serializable)ois.readObject();
        }
        catch (Exception ex) {
            Serializable serializable2;
            try {
                String error = "Error writing file: " + GrouperClientCommonUtils.absolutePath(file);
                if (!nullIfException) {
                    throw new RuntimeException(error, ex);
                }
                LOG.error(ex);
                if (deleteFileOnException) {
                    GrouperClientCommonUtils.closeQuietly(ois);
                    ois = null;
                    GrouperClientCommonUtils.deleteFile(file);
                }
                serializable2 = null;
            }
            catch (Throwable throwable) {
                GrouperClientCommonUtils.closeQuietly(ois);
                throw throwable;
            }
            GrouperClientCommonUtils.closeQuietly(ois);
            return serializable2;
        }
        GrouperClientCommonUtils.closeQuietly(ois);
        return serializable;
    }

    public static void deleteCreateFile(File file) {
        GrouperClientCommonUtils.deleteFile(file);
        GrouperClientCommonUtils.createParentDirectories(file);
        try {
            if (!file.createNewFile()) {
                throw new IOException("createNewFile returned false: ");
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Couldnt create new file: " + file.toString(), ioe);
        }
    }

    public static void deleteFile(File file) {
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                GrouperClientCommonUtils.deleteRecursiveDirectory(file.getAbsolutePath());
            } else if (!file.delete()) {
                throw new RuntimeException("Couldnt delete file: " + file.toString());
            }
        }
    }

    public static void copy(File fromFile, File toFile) {
        if (toFile.exists()) {
            GrouperClientCommonUtils.deleteFile(toFile);
        }
        FileInputStream fromFileStream = null;
        FileOutputStream toFileStream = null;
        try {
            fromFileStream = new FileInputStream(fromFile);
            toFileStream = new FileOutputStream(toFile);
            GrouperClientCommonUtils.copy((InputStream)fromFileStream, toFileStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem copying file: " + fromFile.getAbsolutePath() + " to file: " + toFile.getAbsolutePath());
        }
    }

    public static void renameTo(File fromFile, File toFile) {
        if (!fromFile.renameTo(toFile)) {
            throw new RuntimeException("Cannot rename file: '" + fromFile.getAbsolutePath() + "', to file: '" + toFile.getAbsolutePath() + "'");
        }
    }

    public static void deleteRecursiveDirectory(String dirName) {
        File dir = new File(dirName);
        if (!dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            throw new RuntimeException("The directory: " + dirName + " is not a directory");
        }
        File[] allFiles = dir.listFiles();
        for (int i = 0; i < allFiles.length; ++i) {
            if (-1 < allFiles[i].getName().indexOf("..")) continue;
            if (allFiles[i].isFile()) {
                if (allFiles[i].delete()) continue;
                throw new RuntimeException("Could not delete file: " + allFiles[i].getPath());
            }
            GrouperClientCommonUtils.deleteRecursiveDirectory(allFiles[i].getPath());
        }
        if (!dir.delete()) {
            throw new RuntimeException("Could not delete directory: " + dir.getPath());
        }
    }

    public static String absolutePath(File file) {
        return file == null ? null : file.getAbsolutePath();
    }

    public static InputStream fileOrClasspathInputstream(String typeAndLocation, String logHint) {
        Matcher matcher = fileLocationPattern.matcher(typeAndLocation);
        if (!matcher.matches()) {
            throw new RuntimeException(logHint + " must start with file: or classpath:");
        }
        String typeString = matcher.group(1);
        String location = GrouperClientCommonUtils.trim(matcher.group(2));
        if (GrouperClientCommonUtils.equals(typeString, "file")) {
            File file = new File(location);
            if (!file.exists() || !file.isFile()) {
                throw new RuntimeException(logHint + " File does not exist: " + file.getAbsolutePath());
            }
            try {
                return new FileInputStream(file);
            }
            catch (Exception e) {
                throw new RuntimeException(logHint + " Problem with file: " + file.getAbsolutePath());
            }
        }
        if (GrouperClientCommonUtils.equals(typeString, "classpath")) {
            if (!location.startsWith("/")) {
                location = "/" + location;
            }
            try {
                return GrouperClientCommonUtils.class.getResourceAsStream(location);
            }
            catch (Exception e) {
                throw new RuntimeException(logHint + " Problem with classpath location: " + location);
            }
        }
        throw new RuntimeException(logHint + " Not expecting type string: " + typeString);
    }

    public static String toString(Reader input) throws IOException {
        StringWriter sw = new StringWriter();
        GrouperClientCommonUtils.copy(input, (Writer)sw);
        return sw.toString();
    }

    static {
        Method getCauseMethod;
        propertiesThreadLocalOverrideMap = new ThreadLocal();
        EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
        dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateMinutesSecondsFormat = new SimpleDateFormat(DATE_MINUTES_SECONDS_FORMAT);
        dateMinutesSecondsNoSlashFormat = new SimpleDateFormat(DATE_MINUTES_SECONDS_NO_SLASH_FORMAT);
        timestampFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        timestampNoSlashFormat = new SimpleDateFormat(TIMESTAMP_NO_SLASH_FORMAT);
        fieldSetCache = null;
        declaredMethodsCache = null;
        getterSetCache = null;
        setterSetCache = null;
        lastId = GrouperClientCommonUtils.convertLongToStringSmall(new Date().getTime()).toCharArray();
        resourcePropertiesCache = new HashMap<String, Properties>();
        NO_PARAMS = new Object();
        LOG = GrouperClientUtils.retrieveLog(GrouperClientCommonUtils.class);
        hostname = null;
        EMPTY_STRING_ARRAY = new String[0];
        CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};
        try {
            getCauseMethod = Throwable.class.getMethod("getCause", null);
        }
        catch (Exception e) {
            getCauseMethod = null;
        }
        THROWABLE_CAUSE_METHOD = getCauseMethod;
        EMPTY_OBJECT_ARRAY = new Object[0];
        PADDING = new String[65535];
        GrouperClientCommonUtils.PADDING[32] = "                                                                ";
        datePattern_yyyy_mm_dd = Pattern.compile("^(\\d{4})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})$");
        datePattern_dd_mon_yyyy = Pattern.compile("^(\\d{1,2})[^\\d]+([a-zA-Z]{3,15})[^\\d]+(\\d{4})$");
        datePattern_yyyy_mm_dd_hhmmss = Pattern.compile("^(\\d{4})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})$");
        datePattern_dd_mon_yyyy_hhmmss = Pattern.compile("^(\\d{1,2})[^\\d]+([a-zA-Z]{3,15})[^\\d]+(\\d{4})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})$");
        datePattern_yyyy_mm_dd_hhmmss_SSS = Pattern.compile("^(\\d{4})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,3})$");
        datePattern_dd_mon_yyyy_hhmmss_SSS = Pattern.compile("^(\\d{1,2})[^\\d]+([a-zA-Z]{3,15})[^\\d]+(\\d{4})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,2})[^\\d]+(\\d{1,3})$");
        executorService = Executors.newCachedThreadPool(new DaemonThreadFactory());
        fileLocationPattern = Pattern.compile("^(file|classpath)\\s*:(.*)$");
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private ThreadFactory threadFactory = Executors.defaultThreadFactory();

        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.threadFactory.newThread(r);
            thread.setDaemon(true);
            return thread;
        }
    }

    public static class CommandResult {
        private String errorText;
        private String outputText;
        private int exitCode;

        public CommandResult(String _errorText, String _outputText, int _exitCode) {
            this.errorText = _errorText;
            this.outputText = _outputText;
            this.exitCode = _exitCode;
        }

        public String getErrorText() {
            return this.errorText;
        }

        public String getOutputText() {
            return this.outputText;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }

    private static class StreamGobbler<V>
    implements Callable<V> {
        InputStream inputStream;
        String resultString;
        String type;
        String command;

        StreamGobbler(InputStream is, String theType, String theCommand) {
            this.inputStream = is;
            this.type = theType;
            this.command = theCommand;
        }

        public String getResultString() {
            return this.resultString;
        }

        @Override
        public V call() throws Exception {
            try {
                StringWriter stringWriter = new StringWriter();
                GrouperClientCommonUtils.copy(this.inputStream, (Writer)stringWriter);
                this.resultString = stringWriter.toString();
            }
            catch (Exception e) {
                LOG.warn("Error saving output of executable: " + this.resultString + ", " + this.type + ", " + this.command, e);
                throw new RuntimeException(e);
            }
            return null;
        }
    }

    static class MaskingThread
    extends Thread {
        private volatile boolean stop;
        private char echochar = (char)32;

        public MaskingThread(String prompt) {
            System.out.print(prompt);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            int priority = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(10);
            try {
                this.stop = true;
                while (this.stop) {
                    System.out.print("\b" + this.echochar);
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException iex) {
                        Thread.currentThread().interrupt();
                        Thread.currentThread().setPriority(priority);
                        return;
                    }
                }
            }
            finally {
                Thread.currentThread().setPriority(priority);
            }
        }

        public void stopMasking() {
            this.stop = false;
        }
    }
}

