/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.xmpp;

import edu.internet2.middleware.grouperClient.encryption.GcEncryptionInterface;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.util.JsonUtils;
import edu.internet2.middleware.grouperClientExt.xmpp.EsbEvents;
import java.util.LinkedHashSet;
import java.util.Set;

public class GcDecodeEsbEvents {
    public static EsbEvents decodeEsbEvents(String json) {
        EsbEvents esbEvents = (EsbEvents)JsonUtils.jsonConvertFrom(json, EsbEvents.class);
        return esbEvents;
    }

    public static EsbEvents unencryptEsbEvents(EsbEvents esbEvents) {
        String key;
        if (!esbEvents.isEncrypted()) {
            return esbEvents;
        }
        String encryptionImplName = GrouperClientUtils.propertiesValue("esb.consumer.encryptionImplementation", true);
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < 100 && !GrouperClientUtils.isBlank(key = GrouperClientUtils.propertiesValue("esb.consumer.encryptionKey." + i, false)); ++i) {
            key = GrouperClientUtils.decryptFromFileIfFileExists(key, null);
            keys.add(key);
        }
        if (keys.size() == 0) {
            throw new RuntimeException("You need to specify at least one key in the grouper.client.properties file: esb.consumer.encryptionKey.n");
        }
        Class encryptionImplClass = GrouperClientUtils.forName(encryptionImplName);
        GcEncryptionInterface gcEncryptionInterface = (GcEncryptionInterface)GrouperClientUtils.newInstance(encryptionImplClass);
        return GcDecodeEsbEvents.unencryptEsbEvents(esbEvents, gcEncryptionInterface, keys);
    }

    public static EsbEvents unencryptEsbEvents(EsbEvents esbEvents, GcEncryptionInterface gcEncryptionInterface, Set<String> keys) {
        String encryptionKeySha1First4 = esbEvents.getEncryptionKeySha1First4();
        String key = keys.iterator().next();
        if (!GrouperClientUtils.isBlank(encryptionKeySha1First4)) {
            boolean foundKey = false;
            for (String iteratorKey : keys) {
                String sha1first4 = GrouperClientUtils.encryptSha(iteratorKey).substring(0, 4);
                if (!GrouperClientUtils.equals(sha1first4, sha1first4)) continue;
                foundKey = true;
                key = iteratorKey;
                break;
            }
            if (!foundKey) {
                throw new RuntimeException("Cant find key! " + encryptionKeySha1First4);
            }
        }
        String encryptedPayload = esbEvents.getEncryptedPayload();
        String decryptedPayload = gcEncryptionInterface.decrypt(key, encryptedPayload);
        esbEvents = GcDecodeEsbEvents.decodeEsbEvents(decryptedPayload);
        return esbEvents;
    }
}

