/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.xmpp;

import edu.internet2.middleware.grouperClient.util.GrouperClientConfig;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GrouperClientXmppJob {
    private boolean allowIncrementalNotInGroupNamesList = false;
    private static List<GrouperClientXmppJob> xmppJobs = null;
    private XmppJobEventAction eventAction = null;
    private List<String> subjectAttributeNames = null;
    private Set<String> groupNames = null;
    private String jobName = null;
    private String handlerClass = null;
    private String fullRefreshQuartzCronString;
    private String targetFile;
    private String filePrefix;
    private String iteratorEl;
    private String elfilter;
    private String fileSuffix;

    public boolean isAllowIncrementalNotInGroupNamesList() {
        return this.allowIncrementalNotInGroupNamesList;
    }

    public void setAllowIncrementalNotInGroupNamesList(boolean allowIncrementalNotInGroupNamesList1) {
        this.allowIncrementalNotInGroupNamesList = allowIncrementalNotInGroupNamesList1;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName1) {
        this.jobName = jobName1;
    }

    public XmppJobEventAction getEventAction() {
        return this.eventAction;
    }

    public void setEventAction(XmppJobEventAction eventAction1) {
        this.eventAction = eventAction1;
    }

    public static GrouperClientXmppJob retrieveJob(String name, boolean exceptionIfNotFound) {
        for (GrouperClientXmppJob grouperClientXmppJob : GrouperClientXmppJob.retrieveXmppJobs()) {
            if (!GrouperClientUtils.equals(name, grouperClientXmppJob.getJobName())) continue;
            return grouperClientXmppJob;
        }
        if (exceptionIfNotFound) {
            throw new RuntimeException("Cant find job with name: " + name);
        }
        return null;
    }

    public static List<GrouperClientXmppJob> retrieveXmppJobs() {
        if (xmppJobs == null) {
            ArrayList<GrouperClientXmppJob> theXmppJobs = new ArrayList<GrouperClientXmppJob>();
            Pattern pattern = Pattern.compile("^grouperClient\\.xmpp\\.job\\.(.+)\\.handlerClass$");
            Properties properties = GrouperClientConfig.retrieveConfig().properties();
            for (Object keyObject : properties.keySet()) {
                String elfilterString;
                String subjectAttributeNamesString;
                String key = (String)keyObject;
                Matcher matcher = pattern.matcher(key);
                if (!matcher.matches()) continue;
                String jobName = matcher.group(1);
                GrouperClientXmppJob xmppJob = new GrouperClientXmppJob();
                xmppJob.setJobName(jobName);
                String handlerClass = (String)properties.get(key);
                xmppJob.setHandlerClass(handlerClass);
                xmppJob.setAllowIncrementalNotInGroupNamesList(GrouperClientUtils.propertiesValueBoolean(properties, "grouperClient.xmpp.job." + jobName + ".allowIncrementalNotInGroupNamesList", false));
                String groupNamesString = (String)properties.get("grouperClient.xmpp.job." + jobName + ".groupNames");
                if (!GrouperClientUtils.isBlank(groupNamesString)) {
                    HashSet<String> groupNamesSet = new HashSet<String>(GrouperClientUtils.splitTrimToList(groupNamesString, ","));
                    xmppJob.setGroupNames(groupNamesSet);
                }
                if (!GrouperClientUtils.isBlank(subjectAttributeNamesString = (String)properties.get("grouperClient.xmpp.job." + jobName + ".subjectAttributeNames"))) {
                    List<String> subjectAttributeNamesList = GrouperClientUtils.splitTrimToList(subjectAttributeNamesString, ",");
                    xmppJob.setSubjectAttributeNames(subjectAttributeNamesList);
                }
                if (!GrouperClientUtils.isBlank(elfilterString = (String)properties.get("grouperClient.xmpp.job." + jobName + ".elfilter"))) {
                    xmppJob.setElfilter(elfilterString);
                }
                String eventActionString = (String)properties.get("grouperClient.xmpp.job." + jobName + ".eventAction");
                eventActionString = GrouperClientUtils.defaultIfBlank(eventActionString, XmppJobEventAction.incremental.name());
                xmppJob.setEventAction(XmppJobEventAction.valueOf(eventActionString));
                String fullRefreshQuartzCronString = (String)properties.get("grouperClient.xmpp.job." + jobName + ".fullRefreshQuartzCronString");
                int minutes = new Random().nextInt(60);
                int hours = 4 + new Random().nextInt(4);
                fullRefreshQuartzCronString = GrouperClientUtils.defaultIfBlank(fullRefreshQuartzCronString, "0 " + minutes + " " + hours + " * * ?");
                xmppJob.setFullRefreshQuartzCronString(fullRefreshQuartzCronString);
                String targetFile = (String)properties.get("grouperClient.xmpp.job." + jobName + ".fileHandler.targetFile");
                xmppJob.setTargetFile(targetFile);
                String filePrefix = (String)properties.get("grouperClient.xmpp.job." + jobName + ".fileHandler.filePrefix");
                xmppJob.setFilePrefix(filePrefix);
                String iteratorEl = (String)properties.get("grouperClient.xmpp.job." + jobName + ".fileHandler.iteratorEl");
                xmppJob.setIteratorEl(iteratorEl);
                String fileSuffix = (String)properties.get("grouperClient.xmpp.job." + jobName + ".fileHandler.fileSuffix");
                xmppJob.setFileSuffix(fileSuffix);
                theXmppJobs.add(xmppJob);
            }
            xmppJobs = theXmppJobs;
        }
        return xmppJobs;
    }

    public List<String> getSubjectAttributeNames() {
        return this.subjectAttributeNames;
    }

    public void setSubjectAttributeNames(List<String> subjectAttributeNames1) {
        this.subjectAttributeNames = subjectAttributeNames1;
    }

    public Set<String> getGroupNames() {
        return this.groupNames;
    }

    public void setGroupNames(Set<String> groupNames) {
        this.groupNames = groupNames;
    }

    public String getElfilter() {
        return this.elfilter;
    }

    public void setElfilter(String elfilter1) {
        this.elfilter = elfilter1;
    }

    public String getHandlerClass() {
        return this.handlerClass;
    }

    public void setHandlerClass(String handlerClass1) {
        this.handlerClass = handlerClass1;
    }

    public String getFullRefreshQuartzCronString() {
        return this.fullRefreshQuartzCronString;
    }

    public void setFullRefreshQuartzCronString(String fullRefreshQuartzCronString1) {
        this.fullRefreshQuartzCronString = fullRefreshQuartzCronString1;
    }

    public String getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(String targetFile1) {
        this.targetFile = targetFile1;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix1) {
        this.filePrefix = filePrefix1;
    }

    public String getIteratorEl() {
        return this.iteratorEl;
    }

    public void setIteratorEl(String iteratorEl1) {
        this.iteratorEl = iteratorEl1;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public void setFileSuffix(String fileSuffix1) {
        this.fileSuffix = fileSuffix1;
    }

    public static enum XmppJobEventAction {
        incremental,
        reload_group;

    }
}

