/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GcTransactionType;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsAssignGrouperPrivilegesResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestAssignGrouperPrivilegesRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import edu.internet2.middleware.morphString.Crypto;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcAssignGrouperPrivileges {
    private String wsEndpoint;
    private String wsUser;
    private String wsPass;
    private Boolean allowed = null;
    private WsGroupLookup wsGroupLookup;
    private String privilegeType;
    private Set<String> privilegeNames = new LinkedHashSet<String>();
    private WsStemLookup wsStemLookup;
    private Set<WsSubjectLookup> subjectLookups = new LinkedHashSet<WsSubjectLookup>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private Boolean includeGroupDetail;
    private Boolean includeSubjectDetail;
    private Set<String> subjectAttributeNames = new LinkedHashSet<String>();
    private String clientVersion;
    private GcTransactionType txType;
    private Boolean replaceAllExisting = null;

    public GcAssignGrouperPrivileges assignWsEndpoint(String theWsEndpoint) {
        this.wsEndpoint = theWsEndpoint;
        return this;
    }

    public GcAssignGrouperPrivileges assignWsUser(String theWsUser) {
        this.wsUser = theWsUser;
        return this;
    }

    public GcAssignGrouperPrivileges assignWsPass(String theWsPass) {
        this.wsPass = theWsPass;
        return this;
    }

    public GcAssignGrouperPrivileges assignWsPassEncrypted(String theWsPassEncrypted) {
        String encryptKey = GrouperClientUtils.encryptKey();
        return this.assignWsPass(new Crypto(encryptKey).decrypt(theWsPassEncrypted));
    }

    public GcAssignGrouperPrivileges assignWsPassFile(File theFile) {
        return this.assignWsPass(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcAssignGrouperPrivileges assignWsPassFileEncrypted(File theFile) {
        return this.assignWsPassEncrypted(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcAssignGrouperPrivileges assignAllowed(boolean isAllowed) {
        this.allowed = isAllowed;
        return this;
    }

    public GcAssignGrouperPrivileges assignPrivilegeType(String thePrivilegeType) {
        this.privilegeType = thePrivilegeType;
        return this;
    }

    public GcAssignGrouperPrivileges addPrivilegeName(String thePrivilegeName) {
        this.privilegeNames.add(thePrivilegeName);
        return this;
    }

    public GcAssignGrouperPrivileges assignGroupLookup(WsGroupLookup theWsGroupLookup) {
        this.wsGroupLookup = theWsGroupLookup;
        return this;
    }

    public GcAssignGrouperPrivileges assignStemLookup(WsStemLookup theStemLookup) {
        this.wsStemLookup = theStemLookup;
        return this;
    }

    public GcAssignGrouperPrivileges addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcAssignGrouperPrivileges addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcAssignGrouperPrivileges addSubjectLookup(WsSubjectLookup wsSubjectLookup) {
        this.subjectLookups.add(wsSubjectLookup);
        return this;
    }

    public GcAssignGrouperPrivileges assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.params) > 2) {
            throw new RuntimeException("Params can only be size 2 for this request");
        }
        if (this.allowed == null) {
            throw new RuntimeException("Specify true or false for is allowed");
        }
        if (this.privilegeNames.size() == 0) {
            throw new RuntimeException("Specify at least one privilege name");
        }
    }

    public GcAssignGrouperPrivileges addSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeNames.add(subjectAttributeName);
        return this;
    }

    public GcAssignGrouperPrivileges assignIncludeGroupDetail(Boolean theIncludeGroupDetail) {
        this.includeGroupDetail = theIncludeGroupDetail;
        return this;
    }

    public GcAssignGrouperPrivileges assignIncludeSubjectDetail(Boolean theIncludeSubjectDetail) {
        this.includeSubjectDetail = theIncludeSubjectDetail;
        return this;
    }

    public GcAssignGrouperPrivileges assignTxType(GcTransactionType gcTransactionType) {
        this.txType = gcTransactionType;
        return this;
    }

    public GcAssignGrouperPrivileges assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcAssignGrouperPrivileges assignReplaceAllExisting(Boolean isReplaceAllExisting) {
        this.replaceAllExisting = isReplaceAllExisting;
        return this;
    }

    public WsAssignGrouperPrivilegesResults execute() {
        this.validate();
        WsAssignGrouperPrivilegesResults wsAssignGrouperPrivilegesResults = null;
        try {
            WsRestAssignGrouperPrivilegesRequest wsAssignGrouperPrivileges = new WsRestAssignGrouperPrivilegesRequest();
            wsAssignGrouperPrivileges.setActAsSubjectLookup(this.actAsSubject);
            if (this.includeGroupDetail != null) {
                wsAssignGrouperPrivileges.setIncludeGroupDetail(this.includeGroupDetail != false ? "T" : "F");
            }
            if (this.includeSubjectDetail != null) {
                wsAssignGrouperPrivileges.setIncludeSubjectDetail(this.includeSubjectDetail != false ? "T" : "F");
            }
            wsAssignGrouperPrivileges.setWsGroupLookup(this.wsGroupLookup);
            wsAssignGrouperPrivileges.setWsStemLookup(this.wsStemLookup);
            if (this.replaceAllExisting != null) {
                wsAssignGrouperPrivileges.setReplaceAllExisting(this.replaceAllExisting != false ? "T" : "F");
            }
            wsAssignGrouperPrivileges.setPrivilegeType(this.privilegeType);
            wsAssignGrouperPrivileges.setTxType(this.txType == null ? null : this.txType.name());
            wsAssignGrouperPrivileges.setPrivilegeNames(GrouperClientUtils.toArray(this.privilegeNames, String.class));
            if (this.subjectAttributeNames.size() > 0) {
                wsAssignGrouperPrivileges.setSubjectAttributeNames(GrouperClientUtils.toArray(this.subjectAttributeNames, String.class));
            }
            if (this.subjectLookups.size() > 0) {
                wsAssignGrouperPrivileges.setWsSubjectLookups(GrouperClientUtils.toArray(this.subjectLookups, WsSubjectLookup.class));
            }
            if (this.params.size() > 0) {
                wsAssignGrouperPrivileges.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            if (this.allowed != null) {
                wsAssignGrouperPrivileges.setAllowed(this.allowed != false ? "T" : "F");
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            grouperClientWs.assignWsUser(this.wsUser);
            grouperClientWs.assignWsPass(this.wsPass);
            grouperClientWs.assignWsEndpoint(this.wsEndpoint);
            wsAssignGrouperPrivilegesResults = (WsAssignGrouperPrivilegesResults)grouperClientWs.executeService("grouperPrivileges", wsAssignGrouperPrivileges, "assignGrouperPrivileges", this.clientVersion, false);
            String resultMessage = wsAssignGrouperPrivilegesResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsAssignGrouperPrivilegesResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsAssignGrouperPrivilegesResults;
    }
}

