/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GcTransactionType;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsExternalSubjectDeleteResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsExternalSubjectLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestExternalSubjectDeleteRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import edu.internet2.middleware.morphString.Crypto;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class GcExternalSubjectDelete {
    private String wsEndpoint;
    private String wsUser;
    private String wsPass;
    private List<WsExternalSubjectLookup> externalSubjectLookups = new ArrayList<WsExternalSubjectLookup>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private GcTransactionType txType;
    private String clientVersion;

    public GcExternalSubjectDelete assignWsEndpoint(String theWsEndpoint) {
        this.wsEndpoint = theWsEndpoint;
        return this;
    }

    public GcExternalSubjectDelete assignWsUser(String theWsUser) {
        this.wsUser = theWsUser;
        return this;
    }

    public GcExternalSubjectDelete assignWsPass(String theWsPass) {
        this.wsPass = theWsPass;
        return this;
    }

    public GcExternalSubjectDelete assignWsPassEncrypted(String theWsPassEncrypted) {
        String encryptKey = GrouperClientUtils.encryptKey();
        return this.assignWsPass(new Crypto(encryptKey).decrypt(theWsPassEncrypted));
    }

    public GcExternalSubjectDelete assignWsPassFile(File theFile) {
        return this.assignWsPass(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcExternalSubjectDelete assignWsPassFileEncrypted(File theFile) {
        return this.assignWsPassEncrypted(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcExternalSubjectDelete addExternalSubjectLookup(WsExternalSubjectLookup wsExternalSubjectLookup) {
        this.externalSubjectLookups.add(wsExternalSubjectLookup);
        return this;
    }

    public GcExternalSubjectDelete addIdentifier(String theIdentifier) {
        this.externalSubjectLookups.add(new WsExternalSubjectLookup(theIdentifier));
        return this;
    }

    public GcExternalSubjectDelete addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcExternalSubjectDelete addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcExternalSubjectDelete assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.externalSubjectLookups) == 0) {
            throw new RuntimeException("Need at least one external subject to delete: " + this);
        }
    }

    public GcExternalSubjectDelete assignTxType(GcTransactionType gcTransactionType) {
        this.txType = gcTransactionType;
        return this;
    }

    public GcExternalSubjectDelete assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public WsExternalSubjectDeleteResults execute() {
        this.validate();
        WsExternalSubjectDeleteResults wsExternalSubjectDeleteResults = null;
        try {
            WsRestExternalSubjectDeleteRequest externalSubjectDelete = new WsRestExternalSubjectDeleteRequest();
            externalSubjectDelete.setActAsSubjectLookup(this.actAsSubject);
            externalSubjectDelete.setTxType(this.txType == null ? null : this.txType.name());
            externalSubjectDelete.setWsExternalSubjectLookups(GrouperClientUtils.toArray(this.externalSubjectLookups, WsExternalSubjectLookup.class));
            if (this.params.size() > 0) {
                externalSubjectDelete.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            grouperClientWs.assignWsUser(this.wsUser);
            grouperClientWs.assignWsPass(this.wsPass);
            grouperClientWs.assignWsEndpoint(this.wsEndpoint);
            wsExternalSubjectDeleteResults = (WsExternalSubjectDeleteResults)grouperClientWs.executeService("externalSubjects", externalSubjectDelete, "externalSubjectDelete", this.clientVersion, false);
            String resultMessage = wsExternalSubjectDeleteResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsExternalSubjectDeleteResults, wsExternalSubjectDeleteResults.getResults(), resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsExternalSubjectDeleteResults;
    }
}

